/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.monster.EntityPhantom;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.dimension.end.EnumDragonRespawn;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;

public class EntityEnderCrystal
extends Entity {
    private static final DataWatcherObject<Optional<BlockPosition>> c = DataWatcher.a(EntityEnderCrystal.class, DataWatcherRegistry.o);
    private static final DataWatcherObject<Boolean> d = DataWatcher.a(EntityEnderCrystal.class, DataWatcherRegistry.k);
    public int b;
    public boolean generatedByDragonFight = false;
    private EntityPhantom targetPhantom;
    private int phantomBeamTicks = 0;
    private int phantomDamageCooldown = 0;
    private int idleCooldown = 0;

    public EntityEnderCrystal(EntityTypes<? extends EntityEnderCrystal> type, World world) {
        super(type, world);
        this.I = true;
        this.b = this.ag.a(100000);
    }

    public EntityEnderCrystal(World world, double x2, double y2, double z2) {
        this((EntityTypes<? extends EntityEnderCrystal>)EntityTypes.C, world);
        this.a_(x2, y2, z2);
    }

    public boolean shouldExplode() {
        return this.s() ? this.dM().purpurConfig.basedEndCrystalExplode : this.dM().purpurConfig.baselessEndCrystalExplode;
    }

    public float getExplosionPower() {
        return (float)(this.s() ? this.dM().purpurConfig.basedEndCrystalExplosionPower : this.dM().purpurConfig.baselessEndCrystalExplosionPower);
    }

    public boolean hasExplosionFire() {
        return this.s() ? this.dM().purpurConfig.basedEndCrystalExplosionFire : this.dM().purpurConfig.baselessEndCrystalExplosionFire;
    }

    public World.a getExplosionEffect() {
        return this.s() ? this.dM().purpurConfig.basedEndCrystalExplosionEffect : this.dM().purpurConfig.baselessEndCrystalExplosionEffect;
    }

    @Override
    protected Entity.MovementEmission aW() {
        return Entity.MovementEmission.a;
    }

    @Override
    protected void c_() {
        this.an().a(c, Optional.empty());
        this.an().a(d, true);
    }

    @Override
    public void l() {
        ++this.b;
        if (this.dM() instanceof WorldServer) {
            BlockPosition blockposition = this.dm();
            if (((WorldServer)this.dM()).D() != null && this.dM().a_(blockposition).i() && !CraftEventFactory.callBlockIgniteEvent(this.dM(), blockposition, this).isCancelled()) {
                this.dM().b(blockposition, BlockFireAbstract.a(this.dM(), blockposition));
            }
            if (this.dM().paperConfig().unsupportedSettings.fixInvulnerableEndCrystalExploit && this.generatedByDragonFight && this.cr() && (!Objects.equals(((WorldServer)this.dM()).uuid, this.getOriginWorld()) || ((WorldServer)this.dM()).D() == null || ((WorldServer)this.dM()).D().z == null || ((WorldServer)this.dM()).D().z.ordinal() > EnumDragonRespawn.d.ordinal())) {
                this.m(false);
                this.a((BlockPosition)null);
            }
            if (this.dM().purpurConfig.endCrystalCramming > 0 && this.dM().a(EntityEnderCrystal.class, this.cH()).size() > this.dM().purpurConfig.endCrystalCramming) {
                this.a(this.dN().g(), 6.0f);
            }
        }
        if (this.dM().purpurConfig.phantomAttackedByCrystalRadius <= 0.0 || --this.idleCooldown > 0) {
            return;
        }
        if (this.targetPhantom == null) {
            for (EntityPhantom phantom : this.dM().a(EntityPhantom.class, this.cH().g(this.dM().purpurConfig.phantomAttackedByCrystalRadius))) {
                if (!phantom.E(this)) continue;
                this.attackPhantom(phantom);
                break;
            }
        } else {
            this.a(new BlockPosition(this.targetPhantom).b(0, -2, 0));
            if (--this.phantomBeamTicks > 0 && this.targetPhantom.bx()) {
                --this.phantomDamageCooldown;
                if (this.targetPhantom.E(this)) {
                    if (this.phantomDamageCooldown <= 0) {
                        this.phantomDamageCooldown = 20;
                        this.targetPhantom.a(this.targetPhantom.dN().c(this, this), this.dM().purpurConfig.phantomAttackedByCrystalDamage);
                    }
                } else {
                    this.forgetPhantom();
                }
            } else {
                this.forgetPhantom();
            }
        }
    }

    private void attackPhantom(EntityPhantom phantom) {
        this.phantomDamageCooldown = 0;
        this.phantomBeamTicks = 60;
        this.targetPhantom = phantom;
    }

    private void forgetPhantom() {
        this.targetPhantom = null;
        this.a((BlockPosition)null);
        this.phantomBeamTicks = 0;
        this.phantomDamageCooldown = 0;
        this.idleCooldown = 60;
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        if (this.q() != null) {
            nbt.a("BeamTarget", GameProfileSerializer.a(this.q()));
        }
        nbt.a("ShowBottom", this.s());
        if (this.generatedByDragonFight) {
            nbt.a("Paper.GeneratedByDragonFight", this.generatedByDragonFight);
        }
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        if (nbt.b("BeamTarget", 10)) {
            this.a(GameProfileSerializer.b(nbt.p("BeamTarget")));
        }
        if (nbt.b("ShowBottom", 1)) {
            this.a(nbt.q("ShowBottom"));
        }
        if (nbt.b("Paper.GeneratedByDragonFight", 1)) {
            this.generatedByDragonFight = nbt.q("Paper.GeneratedByDragonFight");
        }
    }

    @Override
    public boolean bt() {
        return true;
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.b(source)) {
            return false;
        }
        if (source.d() instanceof EntityEnderDragon) {
            return false;
        }
        if (!this.dH() && !this.dM().B) {
            if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, source, amount, false)) {
                return false;
            }
            if (!source.a(DamageTypeTags.m)) {
                if (this.shouldExplode()) {
                    DamageSource damagesource1 = source.d() != null ? this.dN().d(this, source.d()) : null;
                    ExplosionPrimeEvent event = CraftEventFactory.callExplosionPrimeEvent(this, this.getExplosionPower(), this.hasExplosionFire());
                    if (event.isCancelled()) {
                        return false;
                    }
                    this.remove(Entity.RemovalReason.a, EntityRemoveEvent.Cause.EXPLODE);
                    this.dM().a(this, damagesource1, null, this.dr(), this.dt(), this.dx(), event.getRadius(), event.getFire(), this.getExplosionEffect());
                } else {
                    this.dJ();
                }
            } else {
                this.remove(Entity.RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
            }
            this.a(source);
        }
        return true;
    }

    @Override
    public void al() {
        this.a(this.dN().n());
        super.al();
    }

    private void a(DamageSource source) {
        EnderDragonBattle enderdragonbattle;
        if (this.dM() instanceof WorldServer && (enderdragonbattle = ((WorldServer)this.dM()).D()) != null) {
            enderdragonbattle.a(this, source);
        }
    }

    public void a(@Nullable BlockPosition beamTarget) {
        this.an().b(c, Optional.ofNullable(beamTarget));
    }

    @Nullable
    public BlockPosition q() {
        return this.an().b(c).orElse(null);
    }

    public void a(boolean showBottom) {
        this.an().b(d, showBottom);
    }

    public boolean s() {
        return this.an().b(d);
    }

    @Override
    public boolean a(double distance) {
        return super.a(distance) || this.q() != null;
    }

    @Override
    public ItemStack dz() {
        return new ItemStack(Items.uY);
    }
}

