/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon;

import com.destroystokyo.paper.event.block.TNTPrimeEvent;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderCrystal;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerManager;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;
import net.minecraft.world.entity.boss.enderdragon.phases.IDragonController;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.WorldGenEndTrophy;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_20_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.joml.Vector3f;
import org.purpurmc.purpur.controller.FlyingMoveControllerWASD;
import org.purpurmc.purpur.controller.LookControllerWASD;
import org.slf4j.Logger;

public class EntityEnderDragon
extends EntityInsentient
implements IMonster {
    private static final Logger bY = LogUtils.getLogger();
    public static final DataWatcherObject<Integer> b = DataWatcher.a(EntityEnderDragon.class, DataWatcherRegistry.b);
    private static final PathfinderTargetCondition bZ = PathfinderTargetCondition.a().a(64.0);
    private static final int ca = 200;
    private static final int cb = 400;
    private static final float cc = 0.25f;
    private static final String cd = "DragonDeathTime";
    private static final String ce = "DragonPhase";
    public final double[][] c = new double[64][3];
    public int d = -1;
    public final EntityComplexPart[] cf;
    public final EntityComplexPart e;
    private final EntityComplexPart cg;
    private final EntityComplexPart ch;
    private final EntityComplexPart ci;
    private final EntityComplexPart cj;
    private final EntityComplexPart ck;
    private final EntityComplexPart cl;
    private final EntityComplexPart cm;
    public float bS;
    public float bT;
    public boolean bU;
    public int bV;
    public float bW;
    @Nullable
    public EntityEnderCrystal bX;
    @Nullable
    private EnderDragonBattle cn;
    private BlockPosition co = BlockPosition.b;
    private final DragonControllerManager cp;
    private int cq = 100;
    private float cr;
    private final PathPoint[] cs = new PathPoint[24];
    private final int[] ct = new int[24];
    private final Path cu = new Path();
    private final Explosion explosionSource;
    @Nullable
    private BlockPosition podium;
    private boolean hadRider;

    public EntityEnderDragon(EntityTypes<? extends EntityEnderDragon> entitytypes, World world) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.D, world);
        this.e = new EntityComplexPart(this, "head", 1.0f, 1.0f);
        this.cg = new EntityComplexPart(this, "neck", 3.0f, 3.0f);
        this.ch = new EntityComplexPart(this, "body", 5.0f, 3.0f);
        this.ci = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
        this.cj = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
        this.ck = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
        this.cl = new EntityComplexPart(this, "wing", 4.0f, 2.0f);
        this.cm = new EntityComplexPart(this, "wing", 4.0f, 2.0f);
        this.cf = new EntityComplexPart[]{this.e, this.cg, this.ch, this.ci, this.cj, this.ck, this.cl, this.cm};
        this.c(this.eM());
        this.af = true;
        this.at = true;
        this.cp = new DragonControllerManager(this);
        this.explosionSource = new Explosion(world, this, null, null, Double.NaN, Double.NaN, Double.NaN, Float.NaN, true, Explosion.Effect.b, Particles.x, Particles.w, SoundEffects.jA);
        this.bL = new FlyingMoveControllerWASD(this){

            @Override
            public void vanillaTick() {
            }
        };
        this.bK = new LookControllerWASD(this){

            @Override
            public void vanillaTick() {
            }

            @Override
            public void purpurTick(EntityHuman rider) {
                this.setYawPitch(rider.dC() - 180.0f, rider.O * 0.5f);
            }
        };
    }

    @Override
    public boolean isRidable() {
        return this.dM().purpurConfig.enderDragonRidable;
    }

    @Override
    public boolean bQ() {
        return this.dM().purpurConfig.useDismountsUnderwaterTag ? super.bQ() : !this.dM().purpurConfig.enderDragonRidableInWater;
    }

    public void a(EnderDragonBattle fight) {
        this.cn = fight;
    }

    public void h(BlockPosition fightOrigin) {
        this.co = fightOrigin;
    }

    public BlockPosition u() {
        return this.co;
    }

    @Override
    public boolean isControllable() {
        return this.dM().purpurConfig.enderDragonControllable;
    }

    @Override
    public double getMaxY() {
        return this.dM().purpurConfig.enderDragonMaxY;
    }

    @Override
    public void initAttributes() {
        this.a(GenericAttributes.l).a(this.dM().purpurConfig.enderDragonMaxHealth);
    }

    @Override
    public boolean fh() {
        return this.dM().purpurConfig.enderDragonTakeDamageFromWater;
    }

    public static AttributeProvider.Builder w() {
        return EntityInsentient.C().a(GenericAttributes.l, 200.0);
    }

    public BlockPosition getPodium() {
        if (this.podium == null) {
            return WorldGenEndTrophy.a(this.u());
        }
        return this.podium;
    }

    public void setPodium(@Nullable BlockPosition blockPos) {
        this.podium = blockPos;
    }

    @Override
    public boolean aT() {
        float f2 = MathHelper.b(this.bT * ((float)Math.PI * 2));
        float f1 = MathHelper.b(this.bS * ((float)Math.PI * 2));
        return f1 <= -0.3f && f2 >= -0.3f;
    }

    @Override
    public void aS() {
        if (this.dM().B && !this.aU()) {
            this.dM().a(this.dr(), this.dt(), this.dx(), SoundEffects.hz, this.db(), 5.0f, 0.8f + this.ag.i() * 0.3f, false);
        }
    }

    @Override
    protected void c_() {
        super.c_();
        this.an().a(b, DragonControllerPhase.k.b());
    }

    public double[] a(int segmentNumber, float tickDelta) {
        if (this.ew()) {
            tickDelta = 0.0f;
        }
        tickDelta = 1.0f - tickDelta;
        int j2 = this.d - segmentNumber & 0x3F;
        int k2 = this.d - segmentNumber - 1 & 0x3F;
        double[] adouble = new double[3];
        double d0 = this.c[j2][0];
        double d1 = MathHelper.d(this.c[k2][0] - d0);
        adouble[0] = d0 + d1 * (double)tickDelta;
        d0 = this.c[j2][1];
        d1 = this.c[k2][1] - d0;
        adouble[1] = d0 + d1 * (double)tickDelta;
        adouble[2] = MathHelper.d((double)tickDelta, this.c[j2][2], this.c[k2][2]);
        return adouble;
    }

    @Override
    public void d_() {
        WorldServer worldserver;
        EnderDragonBattle enderdragonbattle;
        World world;
        boolean hasRider;
        boolean bl = hasRider = this.getRider() != null && this.isControllable();
        if (hasRider) {
            if (!this.hadRider) {
                this.hadRider = true;
                this.af = false;
                ((Entity)this).bh = EntitySize.b(4.0f, 2.0f);
            }
            this.bL.a();
            this.bK.a();
            this.a((float)this.b(GenericAttributes.m) * 0.1f, new Vec3D(-this.getStrafeMot(), this.getVerticalMot(), -this.getForwardMot()));
            Vec3D mot = this.dp();
            this.g(mot);
            this.a(EnumMoveType.b, mot);
            mot = mot.d(0.9f, 0.9f, 0.9f);
            this.g(mot);
            this.cp.a(mot.a() * mot.a() + mot.c() * mot.c() < (double)0.005f ? DragonControllerPhase.k : DragonControllerPhase.a);
        } else if (this.hadRider) {
            this.hadRider = false;
            this.af = true;
            ((Entity)this).bh = EntitySize.b(16.0f, 8.0f);
            this.cp.a(DragonControllerPhase.a);
        }
        this.aG();
        if (this.dM().B) {
            this.c(this.ev());
            if (!this.aU() && !this.cp.a().a() && --this.cq < 0) {
                this.dM().a(this.dr(), this.dt(), this.dx(), SoundEffects.hA, this.db(), 2.5f, 0.8f + this.ag.i() * 0.3f, false);
                this.cq = 200 + this.ag.a(200);
            }
        }
        if (this.cn == null && (world = this.dM()) instanceof WorldServer && (enderdragonbattle = (worldserver = (WorldServer)world).D()) != null && this.cw().equals(enderdragonbattle.i())) {
            this.cn = enderdragonbattle;
        }
        this.bS = this.bT;
        if (this.ew()) {
            if (hasRider) {
                this.bB();
            }
            float f1 = (this.ag.i() - 0.5f) * 8.0f;
            float f2 = (this.ag.i() - 0.5f) * 4.0f;
            float f22 = (this.ag.i() - 0.5f) * 8.0f;
            this.dM().a(Particles.x, this.dr() + (double)f1, this.dt() + 2.0 + (double)f2, this.dx() + (double)f22, 0.0, 0.0, 0.0);
        } else {
            this.ge();
            Vec3D vec3d = this.dp();
            float f3 = 0.2f / ((float)vec3d.h() * 10.0f + 1.0f);
            this.bT = !hasRider && this.cp.a().a() ? (this.bT += 0.1f) : (!hasRider && this.bU ? (this.bT += f3 * 0.5f) : (this.bT += (f3 *= (float)Math.pow(2.0, vec3d.d))));
            this.r(MathHelper.g(this.dC()));
            if (this.fU()) {
                this.bT = 0.5f;
            } else {
                int k2;
                float f5;
                float f4;
                if (this.d < 0) {
                    for (int i2 = 0; i2 < this.c.length; ++i2) {
                        this.c[i2][0] = this.dC();
                        this.c[i2][1] = this.dt();
                    }
                }
                if (++this.d == this.c.length) {
                    this.d = 0;
                }
                this.c[this.d][0] = this.dC();
                this.c[this.d][1] = this.dt();
                if (this.dM().B) {
                    if (this.bn > 0) {
                        this.a(this.bn, this.bo, this.bp, this.bq, this.br, this.bs);
                        --this.bn;
                    }
                    this.cp.a().b();
                } else if (!hasRider) {
                    Vec3D vec3d1;
                    IDragonController idragoncontroller = this.cp.a();
                    idragoncontroller.c();
                    if (this.cp.a() != idragoncontroller) {
                        idragoncontroller = this.cp.a();
                        idragoncontroller.c();
                    }
                    if ((vec3d1 = idragoncontroller.g()) != null && idragoncontroller.i() != DragonControllerPhase.k) {
                        double d0 = vec3d1.c - this.dr();
                        double d1 = vec3d1.d - this.dt();
                        double d2 = vec3d1.e - this.dx();
                        double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                        float f6 = idragoncontroller.f();
                        double d4 = Math.sqrt(d0 * d0 + d2 * d2);
                        if (d4 > 0.0) {
                            d1 = MathHelper.a(d1 / d4, (double)(-f6), (double)f6);
                        }
                        this.g(this.dp().b(0.0, d1 * 0.01, 0.0));
                        this.r(MathHelper.g(this.dC()));
                        Vec3D vec3d2 = vec3d1.a(this.dr(), this.dt(), this.dx()).d();
                        Vec3D vec3d3 = new Vec3D(MathHelper.a(this.dC() * ((float)Math.PI / 180)), this.dp().d, -MathHelper.b(this.dC() * ((float)Math.PI / 180))).d();
                        float f32 = Math.max(((float)vec3d3.b(vec3d2) + 0.5f) / 1.5f, 0.0f);
                        if (Math.abs(d0) > (double)1.0E-5f || Math.abs(d2) > (double)1.0E-5f) {
                            f4 = MathHelper.a(MathHelper.g(180.0f - (float)MathHelper.d(d0, d2) * 57.295776f - this.dC()), -50.0f, 50.0f);
                            this.bW *= 0.8f;
                            this.bW += f4 * idragoncontroller.h();
                            this.r(this.dC() + this.bW * 0.1f);
                        }
                        f4 = (float)(2.0 / (d3 + 1.0));
                        f5 = 0.06f;
                        this.a(0.06f * (f32 * f4 + (1.0f - f4)), new Vec3D(0.0, 0.0, -1.0));
                        if (this.bU) {
                            this.a(EnumMoveType.a, this.dp().a((double)0.8f));
                        } else {
                            this.a(EnumMoveType.a, this.dp());
                        }
                        Vec3D vec3d4 = this.dp().d();
                        double d5 = 0.8 + 0.15 * (vec3d4.b(vec3d3) + 1.0) / 2.0;
                        this.g(this.dp().d(d5, 0.91f, d5));
                    }
                }
                this.aU = this.dC();
                Vec3D[] avec3d = new Vec3D[this.cf.length];
                for (int j2 = 0; j2 < this.cf.length; ++j2) {
                    avec3d[j2] = new Vec3D(this.cf[j2].dr(), this.cf[j2].dt(), this.cf[j2].dx());
                }
                float f7 = (float)(this.a(5, 1.0f)[1] - this.a(10, 1.0f)[1]) * 10.0f * ((float)Math.PI / 180);
                float f8 = MathHelper.b(f7);
                float f9 = MathHelper.a(f7);
                float f10 = this.dC() * ((float)Math.PI / 180);
                float f11 = MathHelper.a(f10);
                float f12 = MathHelper.b(f10);
                this.a(this.ch, (double)(f11 * 0.5f), 0.0, (double)(-f12 * 0.5f));
                this.a(this.cl, (double)(f12 * 4.5f), 2.0, (double)(f11 * 4.5f));
                this.a(this.cm, (double)(f12 * -4.5f), 2.0, (double)(f11 * -4.5f));
                if (!hasRider && !this.dM().B && this.aK == 0) {
                    this.a(this.dM().a((Entity)this, this.cl.cH().c(4.0, 2.0, 4.0).d(0.0, -2.0, 0.0), IEntitySelector.e));
                    this.a(this.dM().a((Entity)this, this.cm.cH().c(4.0, 2.0, 4.0).d(0.0, -2.0, 0.0), IEntitySelector.e));
                    this.c(this.dM().a((Entity)this, this.e.cH().g(1.0), IEntitySelector.e));
                    this.c(this.dM().a((Entity)this, this.cg.cH().g(1.0), IEntitySelector.e));
                }
                float f13 = MathHelper.a(this.dC() * ((float)Math.PI / 180) - this.bW * 0.01f);
                float f14 = MathHelper.b(this.dC() * ((float)Math.PI / 180) - this.bW * 0.01f);
                float f15 = this.gd();
                this.a(this.e, (double)(f13 * 6.5f * f8), (double)(f15 + f9 * 6.5f), (double)(-f14 * 6.5f * f8));
                this.a(this.cg, (double)(f13 * 5.5f * f8), (double)(f15 + f9 * 5.5f), (double)(-f14 * 5.5f * f8));
                double[] adouble = this.a(5, 1.0f);
                for (k2 = 0; k2 < 3; ++k2) {
                    EntityComplexPart entitycomplexpart = null;
                    if (k2 == 0) {
                        entitycomplexpart = this.ci;
                    }
                    if (k2 == 1) {
                        entitycomplexpart = this.cj;
                    }
                    if (k2 == 2) {
                        entitycomplexpart = this.ck;
                    }
                    double[] adouble1 = this.a(12 + k2 * 2, 1.0f);
                    float f16 = this.dC() * ((float)Math.PI / 180) + this.i(adouble1[0] - adouble[0]) * ((float)Math.PI / 180);
                    float f33 = MathHelper.a(f16);
                    f4 = MathHelper.b(f16);
                    f5 = 1.5f;
                    float f17 = (float)(k2 + 1) * 2.0f;
                    this.a(entitycomplexpart, (double)(-(f11 * 1.5f + f33 * f17) * f8), adouble1[1] - adouble[1] - (double)((f17 + 1.5f) * f9) + 1.5, (double)((f12 * 1.5f + f4 * f17) * f8));
                }
                if (!this.dM().B) {
                    boolean bl2 = this.bU = !hasRider && this.b(this.e.cH()) | this.b(this.cg.cH()) | this.b(this.ch.cH());
                    if (this.cn != null) {
                        this.cn.b(this);
                    }
                }
                for (k2 = 0; k2 < this.cf.length; ++k2) {
                    this.cf[k2].K = avec3d[k2].c;
                    this.cf[k2].L = avec3d[k2].d;
                    this.cf[k2].M = avec3d[k2].e;
                    this.cf[k2].ac = avec3d[k2].c;
                    this.cf[k2].ad = avec3d[k2].d;
                    this.cf[k2].ae = avec3d[k2].e;
                }
            }
        }
    }

    private void a(EntityComplexPart enderDragonPart, double dx, double dy, double dz) {
        enderDragonPart.a_(this.dr() + dx, this.dt() + dy, this.dx() + dz);
    }

    private float gd() {
        if (this.cp.a().a()) {
            return -1.0f;
        }
        double[] adouble = this.a(5, 1.0f);
        double[] adouble1 = this.a(0, 1.0f);
        return (float)(adouble[1] - adouble1[1]);
    }

    private void ge() {
        if (this.bX != null) {
            if (this.bX.dH()) {
                this.bX = null;
            } else if (this.ah % 10 == 0 && this.ev() < this.eM()) {
                EntityRegainHealthEvent event = new EntityRegainHealthEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), 1.0, EntityRegainHealthEvent.RegainReason.ENDER_CRYSTAL);
                this.dM().getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    this.c((float)((double)this.ev() + event.getAmount()));
                }
            }
        }
        if (this.ag.a(10) == 0) {
            List<EntityEnderCrystal> list = this.dM().a(EntityEnderCrystal.class, this.cH().g(32.0));
            EntityEnderCrystal entityendercrystal = null;
            double d0 = Double.MAX_VALUE;
            for (EntityEnderCrystal entityendercrystal1 : list) {
                double d1 = entityendercrystal1.f(this);
                if (!(d1 < d0)) continue;
                d0 = d1;
                entityendercrystal = entityendercrystal1;
            }
            this.bX = entityendercrystal;
        }
    }

    private void a(List<Entity> entities) {
        double d0 = (this.ch.cH().a + this.ch.cH().d) / 2.0;
        double d1 = (this.ch.cH().c + this.ch.cH().f) / 2.0;
        for (Entity entity : entities) {
            if (!(entity instanceof EntityLiving)) continue;
            double d2 = entity.dr() - d0;
            double d3 = entity.dx() - d1;
            double d4 = Math.max(d2 * d2 + d3 * d3, 0.1);
            entity.push(d2 / d4 * 4.0, 0.2f, d3 / d4 * 4.0, this);
            if (this.cp.a().a() || ((EntityLiving)entity).ei() >= entity.ah - 2) continue;
            entity.a(this.dN().b(this), 5.0f);
            this.a((EntityLiving)this, entity);
        }
    }

    private void c(List<Entity> entities) {
        for (Entity entity : entities) {
            if (!(entity instanceof EntityLiving)) continue;
            entity.a(this.dN().b(this), 10.0f);
            this.a((EntityLiving)this, entity);
        }
    }

    private float i(double yawDegrees) {
        return (float)MathHelper.d(yawDegrees);
    }

    private boolean b(AxisAlignedBB box) {
        int i2 = MathHelper.a(box.a);
        int j2 = MathHelper.a(box.b);
        int k2 = MathHelper.a(box.c);
        int l2 = MathHelper.a(box.d);
        int i1 = MathHelper.a(box.e);
        int j1 = MathHelper.a(box.f);
        boolean flag = false;
        boolean flag1 = false;
        ArrayList<CraftBlock> destroyedBlocks = new ArrayList<CraftBlock>();
        for (int k1 = i2; k1 <= l2; ++k1) {
            for (int l1 = j2; l1 <= i1; ++l1) {
                for (int i22 = k2; i22 <= j1; ++i22) {
                    BlockPosition blockposition = new BlockPosition(k1, l1, i22);
                    IBlockData iblockdata = this.dM().a_(blockposition);
                    if (iblockdata.i() || iblockdata.a(TagsBlock.aC)) continue;
                    if ((this.dM().purpurConfig.enderDragonBypassMobGriefing || this.dM().Z().b(GameRules.c)) && !iblockdata.a(TagsBlock.aB)) {
                        flag1 = true;
                        destroyedBlocks.add(CraftBlock.at(this.dM(), blockposition));
                        continue;
                    }
                    flag = true;
                }
            }
        }
        if (!flag1) {
            return flag;
        }
        CraftEntity bukkitEntity = this.getBukkitEntity();
        EntityExplodeEvent event = new EntityExplodeEvent((org.bukkit.entity.Entity)bukkitEntity, bukkitEntity.getLocation(), destroyedBlocks, 0.0f);
        bukkitEntity.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return flag;
        }
        if (event.getYield() == 0.0f) {
            for (org.bukkit.block.Block block : event.blockList()) {
                this.dM().a(new BlockPosition(block.getX(), block.getY(), block.getZ()), false);
            }
        } else {
            for (org.bukkit.block.Block block : event.blockList()) {
                CraftBlock tntBlock;
                Material blockId = block.getType();
                if (blockId.isAir()) continue;
                CraftBlock craftBlock = (CraftBlock)block;
                BlockPosition blockposition = craftBlock.getPosition();
                Block nmsBlock = craftBlock.getNMS().b();
                if (nmsBlock.a(this.explosionSource)) {
                    TileEntity tileentity = craftBlock.getNMS().t() ? this.dM().c_(blockposition) : null;
                    LootParams.a loottableinfo_builder = new LootParams.a((WorldServer)this.dM()).a(LootContextParameters.f, Vec3D.b(blockposition)).a(LootContextParameters.i, ItemStack.f).a(LootContextParameters.j, Float.valueOf(1.0f / event.getYield())).b(LootContextParameters.h, tileentity);
                    craftBlock.getNMS().a(loottableinfo_builder).forEach(itemstack -> Block.a(this.dM(), blockposition, itemstack));
                    craftBlock.getNMS().a((WorldServer)this.dM(), blockposition, ItemStack.f, false);
                }
                if (!new TNTPrimeEvent((org.bukkit.block.Block)(tntBlock = CraftBlock.at(this.dM(), blockposition)), TNTPrimeEvent.PrimeReason.EXPLOSION, (org.bukkit.entity.Entity)this.explosionSource.f().getBukkitEntity()).callEvent()) continue;
                nmsBlock.a(this.dM(), blockposition, this.explosionSource);
                this.dM().a(blockposition, false);
            }
        }
        if (flag1) {
            BlockPosition blockposition1 = new BlockPosition(i2 + this.ag.a(l2 - i2 + 1), j2 + this.ag.a(i1 - j2 + 1), k2 + this.ag.a(j1 - k2 + 1));
            this.dM().c(2008, blockposition1, 0);
        }
        return flag;
    }

    public boolean a(EntityComplexPart part, DamageSource source, float amount) {
        if (this.cp.a().i() == DragonControllerPhase.j) {
            return false;
        }
        amount = this.cp.a().a(source, amount);
        if (part != this.e) {
            amount = amount / 4.0f + Math.min(amount, 1.0f);
        }
        if (amount < 0.01f) {
            return false;
        }
        if (source.d() instanceof EntityHuman || source.a(DamageTypeTags.z)) {
            float f1 = this.ev();
            this.g(source, amount);
            if (this.ew() && !this.cp.a().a()) {
                this.c(1.0f);
                this.cp.a(DragonControllerPhase.j);
            }
            if (this.cp.a().a()) {
                this.cr = this.cr + f1 - this.ev();
                if (this.cr > 0.25f * this.eM()) {
                    this.cr = 0.0f;
                    this.cp.a(DragonControllerPhase.e);
                }
            }
        }
        return true;
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        return !this.dM().B ? this.a(this.ch, source, amount) : false;
    }

    protected boolean g(DamageSource source, float amount) {
        return super.a(source, amount);
    }

    @Override
    public void al() {
        this.silentDeath = true;
        EntityDeathEvent deathEvent = CraftEventFactory.callEntityDeathEvent(this);
        if (deathEvent.isCancelled()) {
            this.silentDeath = false;
            return;
        }
        this.remove(Entity.RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
        this.a(GameEvent.p);
        if (this.cn != null) {
            this.cn.b(this);
            this.cn.a(this);
        }
    }

    @Override
    public int getExpReward() {
        boolean flag = this.dM().Z().b(GameRules.f);
        int short0 = 500;
        if (this.cn != null && (this.dM().purpurConfig.enderDragonAlwaysDropsFullExp || !this.cn.f())) {
            short0 = 12000;
        }
        return flag ? short0 : 0;
    }

    @Override
    protected void eb() {
        if (this.cn != null) {
            this.cn.b(this);
        }
        ++this.bV;
        if (this.bV >= 180 && this.bV <= 200) {
            float f2 = (this.ag.i() - 0.5f) * 8.0f;
            float f1 = (this.ag.i() - 0.5f) * 4.0f;
            float f22 = (this.ag.i() - 0.5f) * 8.0f;
            this.dM().a(Particles.w, this.dr() + (double)f2, this.dt() + 2.0 + (double)f1, this.dx() + (double)f22, 0.0, 0.0, 0.0);
        }
        int short0 = this.expToDrop;
        if (this.dM() instanceof WorldServer) {
            if (this.bV > 150 && this.bV % 5 == 0) {
                EntityExperienceOrb.award((WorldServer)this.dM(), this.dk(), MathHelper.d((float)short0 * 0.08f), ExperienceOrb.SpawnReason.ENTITY_DEATH, this.aY, this);
            }
            if (this.bV == 1 && !this.aU()) {
                int viewDistance = ((WorldServer)this.dM()).getCraftServer().getViewDistance() * 16;
                for (EntityPlayer player : this.dM().getPlayersForGlobalSoundGamerule()) {
                    double deltaX = this.dr() - player.dr();
                    double deltaZ = this.dx() - player.dx();
                    double distanceSquared = deltaX * deltaX + deltaZ * deltaZ;
                    double soundRadiusSquared = this.dM().getGlobalSoundRangeSquared(config -> config.dragonDeathSoundRadius);
                    if (!this.dM().Z().b(GameRules.W) && distanceSquared > soundRadiusSquared) continue;
                    if (distanceSquared > (double)(viewDistance * viewDistance)) {
                        double deltaLength = Math.sqrt(distanceSquared);
                        double relativeX = player.dr() + deltaX / deltaLength * (double)viewDistance;
                        double relativeZ = player.dx() + deltaZ / deltaLength * (double)viewDistance;
                        player.c.b(new PacketPlayOutWorldEvent(1028, new BlockPosition((int)relativeX, (int)this.dt(), (int)relativeZ), 0, true));
                        continue;
                    }
                    player.c.b(new PacketPlayOutWorldEvent(1028, new BlockPosition((int)this.dr(), (int)this.dt(), (int)this.dx()), 0, true));
                }
            }
        }
        this.a(EnumMoveType.a, new Vec3D(0.0, 0.1f, 0.0));
        if (this.bV == 200 && this.dM() instanceof WorldServer) {
            EntityExperienceOrb.award((WorldServer)this.dM(), this.dk(), MathHelper.d((float)short0 * 0.2f), ExperienceOrb.SpawnReason.ENTITY_DEATH, this.aY, this);
            if (this.cn != null) {
                this.cn.a(this);
            }
            this.remove(Entity.RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
            this.a(GameEvent.p);
        }
    }

    public int A() {
        if (this.cs[0] == null) {
            for (int i2 = 0; i2 < 24; ++i2) {
                int l2;
                int k2;
                int j2 = 5;
                if (i2 < 12) {
                    k2 = MathHelper.d(60.0f * MathHelper.b(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i2)));
                    l2 = MathHelper.d(60.0f * MathHelper.a(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i2)));
                } else if (i2 < 20) {
                    i1 = i2 - 12;
                    k2 = MathHelper.d(40.0f * MathHelper.b(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)i1)));
                    l2 = MathHelper.d(40.0f * MathHelper.a(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)i1)));
                    j2 += 10;
                } else {
                    i1 = i2 - 20;
                    k2 = MathHelper.d(20.0f * MathHelper.b(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)i1)));
                    l2 = MathHelper.d(20.0f * MathHelper.a(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)i1)));
                }
                int j1 = Math.max(this.dM().A_() + 10, this.dM().a(HeightMap.Type.f, new BlockPosition(k2, 0, l2)).v() + j2);
                this.cs[i2] = new PathPoint(k2, j1, l2);
            }
            this.ct[0] = 6146;
            this.ct[1] = 8197;
            this.ct[2] = 8202;
            this.ct[3] = 16404;
            this.ct[4] = 32808;
            this.ct[5] = 32848;
            this.ct[6] = 65696;
            this.ct[7] = 131392;
            this.ct[8] = 131712;
            this.ct[9] = 263424;
            this.ct[10] = 526848;
            this.ct[11] = 525313;
            this.ct[12] = 1581057;
            this.ct[13] = 3166214;
            this.ct[14] = 2138120;
            this.ct[15] = 6373424;
            this.ct[16] = 4358208;
            this.ct[17] = 12910976;
            this.ct[18] = 9044480;
            this.ct[19] = 9706496;
            this.ct[20] = 15216640;
            this.ct[21] = 0xD0E000;
            this.ct[22] = 11763712;
            this.ct[23] = 0x7E0000;
        }
        return this.r(this.dr(), this.dt(), this.dx());
    }

    public int r(double x2, double y2, double z2) {
        float f2 = 10000.0f;
        int i2 = 0;
        PathPoint pathpoint = new PathPoint(MathHelper.a(x2), MathHelper.a(y2), MathHelper.a(z2));
        int b0 = 0;
        if (this.cn == null || this.cn.e() == 0) {
            b0 = 12;
        }
        for (int j2 = b0; j2 < 24; ++j2) {
            float f1;
            if (this.cs[j2] == null || !((f1 = this.cs[j2].c(pathpoint)) < f2)) continue;
            f2 = f1;
            i2 = j2;
        }
        return i2;
    }

    @Nullable
    public PathEntity a(int from, int to, @Nullable PathPoint pathNode) {
        PathPoint pathpoint1;
        for (int k2 = 0; k2 < 24; ++k2) {
            pathpoint1 = this.cs[k2];
            pathpoint1.i = false;
            pathpoint1.f = 0.0f;
            pathpoint1.g = 0.0f;
            pathpoint1.f = 0.0f;
            pathpoint1.h = null;
            pathpoint1.d = -1;
        }
        PathPoint pathpoint2 = this.cs[from];
        pathpoint1 = this.cs[to];
        pathpoint2.g = 0.0f;
        pathpoint2.f = pathpoint2.f = pathpoint2.a(pathpoint1);
        this.cu.a();
        this.cu.a(pathpoint2);
        PathPoint pathpoint3 = pathpoint2;
        int b0 = 0;
        if (this.cn == null || this.cn.e() == 0) {
            b0 = 12;
        }
        while (!this.cu.e()) {
            int i1;
            PathPoint pathpoint4 = this.cu.c();
            if (pathpoint4.equals(pathpoint1)) {
                if (pathNode != null) {
                    pathNode.h = pathpoint1;
                    pathpoint1 = pathNode;
                }
                return this.a(pathpoint2, pathpoint1);
            }
            if (pathpoint4.a(pathpoint1) < pathpoint3.a(pathpoint1)) {
                pathpoint3 = pathpoint4;
            }
            pathpoint4.i = true;
            int l2 = 0;
            for (i1 = 0; i1 < 24; ++i1) {
                if (this.cs[i1] != pathpoint4) {
                    continue;
                }
                l2 = i1;
                break;
            }
            for (i1 = b0; i1 < 24; ++i1) {
                if ((this.ct[l2] & 1 << i1) <= 0) continue;
                PathPoint pathpoint5 = this.cs[i1];
                if (pathpoint5.i) continue;
                float f2 = pathpoint4.g + pathpoint4.a(pathpoint5);
                if (pathpoint5.c() && !(f2 < pathpoint5.g)) continue;
                pathpoint5.h = pathpoint4;
                pathpoint5.g = f2;
                pathpoint5.f = pathpoint5.a(pathpoint1);
                if (pathpoint5.c()) {
                    this.cu.a(pathpoint5, pathpoint5.g + pathpoint5.f);
                    continue;
                }
                pathpoint5.f = pathpoint5.g + pathpoint5.f;
                this.cu.a(pathpoint5);
            }
        }
        if (pathpoint3 == pathpoint2) {
            return null;
        }
        bY.debug("Failed to find path from {} to {}", (Object)from, (Object)to);
        if (pathNode != null) {
            pathNode.h = pathpoint3;
            pathpoint3 = pathNode;
        }
        return this.a(pathpoint2, pathpoint3);
    }

    private PathEntity a(PathPoint unused, PathPoint node) {
        ArrayList list = Lists.newArrayList();
        PathPoint pathpoint2 = node;
        list.add(0, node);
        while (pathpoint2.h != null) {
            pathpoint2 = pathpoint2.h;
            list.add(0, pathpoint2);
        }
        return new PathEntity(list, new BlockPosition(node.a, node.b, node.c), true);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a(ce, this.cp.a().i().b());
        nbt.a(cd, this.bV);
        nbt.a("Bukkit.expToDrop", this.expToDrop);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        if (nbt.e(ce)) {
            this.cp.a(DragonControllerPhase.a(nbt.h(ce)));
        }
        if (nbt.e(cd)) {
            this.bV = nbt.h(cd);
        }
        if (nbt.e("Bukkit.expToDrop")) {
            this.expToDrop = nbt.h("Bukkit.expToDrop");
        }
    }

    @Override
    public void dy() {
    }

    public EntityComplexPart[] ga() {
        return this.cf;
    }

    @Override
    public boolean bt() {
        return false;
    }

    @Override
    public SoundCategory db() {
        return SoundCategory.f;
    }

    @Override
    protected SoundEffect y() {
        return SoundEffects.hw;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.hB;
    }

    @Override
    public float eW() {
        return 5.0f;
    }

    public float a(int segmentOffset, double[] segment1, double[] segment2) {
        double d0;
        IDragonController idragoncontroller = this.cp.a();
        DragonControllerPhase<? extends IDragonController> dragoncontrollerphase = idragoncontroller.i();
        if (dragoncontrollerphase != DragonControllerPhase.d && dragoncontrollerphase != DragonControllerPhase.e) {
            d0 = idragoncontroller.a() ? (double)segmentOffset : (segmentOffset == 6 ? 0.0 : segment2[1] - segment1[1]);
        } else {
            BlockPosition blockposition = this.dM().a(HeightMap.Type.f, this.getPodium());
            double d1 = Math.max(Math.sqrt(blockposition.b(this.dk())) / 4.0, 1.0);
            d0 = (double)segmentOffset / d1;
        }
        return (float)d0;
    }

    public Vec3D D(float tickDelta) {
        Vec3D vec3d;
        IDragonController idragoncontroller = this.cp.a();
        DragonControllerPhase<? extends IDragonController> dragoncontrollerphase = idragoncontroller.i();
        if (dragoncontrollerphase != DragonControllerPhase.d && dragoncontrollerphase != DragonControllerPhase.e) {
            if (idragoncontroller.a()) {
                float f2 = this.dE();
                float f1 = 1.5f;
                this.s(-45.0f);
                vec3d = this.f(tickDelta);
                this.s(f2);
            } else {
                vec3d = this.f(tickDelta);
            }
        } else {
            BlockPosition blockposition = this.dM().a(HeightMap.Type.f, this.getPodium());
            float f1 = Math.max((float)Math.sqrt(blockposition.b(this.dk())) / 4.0f, 1.0f);
            float f3 = 6.0f / f1;
            float f4 = this.dE();
            float f5 = 1.5f;
            this.s(-f3 * 1.5f * 5.0f);
            vec3d = this.f(tickDelta);
            this.s(f4);
        }
        return vec3d;
    }

    public void a(EntityEnderCrystal endCrystal, BlockPosition pos, DamageSource source) {
        EntityHuman entityhuman = source.d() instanceof EntityHuman ? (EntityHuman)source.d() : this.dM().a(bZ, (double)pos.u(), (double)pos.v(), (double)pos.w());
        if (endCrystal == this.bX) {
            this.a(this.e, this.dN().d(endCrystal, entityhuman), 10.0f);
        }
        this.cp.a().a(endCrystal, pos, source, entityhuman);
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (b.equals(data) && this.dM().B) {
            this.cp.a(DragonControllerPhase.a(this.an().b(b)));
        }
        super.a(data);
    }

    public DragonControllerManager gb() {
        return this.cp;
    }

    @Nullable
    public EnderDragonBattle gc() {
        return this.cn;
    }

    @Override
    public boolean b(MobEffect effect, @Nullable Entity source) {
        return false;
    }

    @Override
    protected boolean o(Entity entity) {
        if (this.dM().purpurConfig.enderDragonCanRideVehicles) {
            return this.J <= 0;
        }
        return false;
    }

    @Override
    public boolean ct() {
        return false;
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        EntityComplexPart[] aentitycomplexpart = this.ga();
        for (int i2 = 0; i2 < aentitycomplexpart.length; ++i2) {
            aentitycomplexpart[i2].e(i2 + packet.a());
        }
    }

    @Override
    public boolean c(EntityLiving target) {
        return target.eo();
    }

    @Override
    protected Vector3f a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        return new Vector3f(0.0f, this.ch.dh(), 0.0f);
    }
}

