/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.wither;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.BossBattleServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.BossBattle;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalArrowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomFly;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityWitherSkull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.purpurmc.purpur.controller.FlyingWithSpacebarMoveControllerWASD;
import org.purpurmc.purpur.entity.ai.HasRider;

public class EntityWither
extends EntityMonster
implements PowerableMob,
IRangedEntity {
    private static final DataWatcherObject<Integer> b = DataWatcher.a(EntityWither.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> c = DataWatcher.a(EntityWither.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> d = DataWatcher.a(EntityWither.class, DataWatcherRegistry.b);
    private static final List<DataWatcherObject<Integer>> e = ImmutableList.of(b, c, d);
    private static final DataWatcherObject<Integer> bT = DataWatcher.a(EntityWither.class, DataWatcherRegistry.b);
    private static final int bU = 220;
    private final float[] bV = new float[2];
    private final float[] bW = new float[2];
    private final float[] bX = new float[2];
    private final float[] bY = new float[2];
    private final int[] bZ = new int[2];
    private final int[] ca = new int[2];
    private int cb;
    public final BossBattleServer cc = (BossBattleServer)new BossBattleServer(this.Q_(), BossBattle.BarColor.f, BossBattle.BarStyle.a).a(true);
    private static final Predicate<EntityLiving> cd = entityliving -> entityliving.eS() != EnumMonsterType.b && entityliving.fz();
    private static final PathfinderTargetCondition ce = PathfinderTargetCondition.a().a(20.0).a(cd);
    @Nullable
    private UUID summoner;
    private int shootCooldown = 0;
    private boolean canPortal = false;
    private FlyingWithSpacebarMoveControllerWASD purpurController = new FlyingWithSpacebarMoveControllerWASD((EntityInsentient)this, 0.1f);

    public void setCanTravelThroughPortals(boolean canPortal) {
        this.canPortal = canPortal;
    }

    public EntityWither(EntityTypes<? extends EntityWither> type, World world) {
        super((EntityTypes<? extends EntityMonster>)type, world);
        this.bL = new ControllerMoveFlying(this, 10, false){

            @Override
            public void a() {
                if (this.d.getRider() != null && this.d.isControllable()) {
                    EntityWither.this.purpurController.purpurTick(this.d.getRider());
                } else {
                    super.a();
                }
            }
        };
        this.c(this.eM());
        this.bJ = 50;
    }

    @Override
    public void initAttributes() {
        this.a(GenericAttributes.l).a(this.dM().purpurConfig.witherMaxHealth);
    }

    @Override
    public boolean fh() {
        return this.dM().purpurConfig.witherTakeDamageFromWater;
    }

    @Nullable
    public UUID getSummoner() {
        return this.summoner;
    }

    public void setSummoner(@Nullable UUID summoner) {
        this.summoner = summoner;
    }

    @Override
    protected boolean ef() {
        return this.dM().purpurConfig.witherAlwaysDropExp;
    }

    @Override
    protected NavigationAbstract b(World world) {
        NavigationFlying navigationflying = new NavigationFlying(this, world);
        navigationflying.b(false);
        navigationflying.a(true);
        navigationflying.c(true);
        return navigationflying;
    }

    @Override
    public boolean isRidable() {
        return this.dM().purpurConfig.witherRidable;
    }

    @Override
    public boolean bQ() {
        return this.dM().purpurConfig.useDismountsUnderwaterTag ? super.bQ() : !this.dM().purpurConfig.witherRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.dM().purpurConfig.witherControllable;
    }

    @Override
    public double getMaxY() {
        return this.dM().purpurConfig.witherMaxY;
    }

    @Override
    public void a(Vec3D vec3) {
        super.a(vec3);
        if (this.getRider() != null && this.isControllable() && !((Entity)this).aJ) {
            float speed = (float)this.b(GenericAttributes.f) * 5.0f;
            this.w(speed);
            Vec3D mot = this.dp();
            this.a(EnumMoveType.a, mot.d(speed, 0.5, speed));
            this.g(mot.a(0.9));
        }
    }

    @Override
    public void onMount(EntityHuman rider) {
        super.onMount(rider);
        this.an.b(e.get(0), 0);
        this.an.b(e.get(1), 0);
        this.an.b(e.get(2), 0);
        this.N().n();
        this.shootCooldown = 20;
    }

    @Override
    public boolean onClick(EnumHand hand) {
        int[] nArray;
        EntityHuman entityHuman = this.getRider();
        if (hand == EnumHand.a) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 1;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 2;
        }
        return this.shoot(entityHuman, nArray);
    }

    public boolean shoot(@Nullable EntityHuman rider, int[] heads) {
        Vec3D loc;
        if (this.shootCooldown > 0) {
            return false;
        }
        this.shootCooldown = 20;
        if (rider == null) {
            return false;
        }
        CraftHumanEntity player = rider.getBukkitEntity();
        if (!player.hasPermission("allow.special.wither")) {
            return false;
        }
        MovingObjectPosition rayTrace = this.getRayTrace(120, RayTrace.FluidCollisionOption.a);
        if (rayTrace == null) {
            return false;
        }
        if (rayTrace.c() == MovingObjectPosition.EnumMovingObjectType.b) {
            BlockPosition pos = ((MovingObjectPositionBlock)rayTrace).a();
            loc = new Vec3D((double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5);
        } else if (rayTrace.c() == MovingObjectPosition.EnumMovingObjectType.c) {
            Entity target = ((MovingObjectPositionEntity)rayTrace).a();
            loc = new Vec3D(target.dr(), target.dt() + (double)(target.cI() / 2.0f), target.dx());
        } else {
            Block block = player.getTargetBlock(null, 120);
            loc = new Vec3D((double)block.getX() + 0.5, (double)block.getY() + 0.5, (double)block.getZ() + 0.5);
        }
        for (int head : heads) {
            this.shoot(head, loc.a(), loc.b(), loc.c(), rider);
        }
        return true;
    }

    public void shoot(int head, double x2, double y2, double z2, EntityHuman rider) {
        this.dM().a(null, 1024, this.dm(), 0);
        double headX = this.u(head);
        double headY = this.v(head);
        double headZ = this.w(head);
        EntityWitherSkull skull = new EntityWitherSkull(this.dM(), this, x2 - headX, y2 - headY, z2 - headZ);
        skull.p(headX, headY, headZ);
        this.dM().b(skull);
    }

    @Override
    protected void B() {
        this.bO.a(0, new HasRider(this));
        this.bO.a(0, new a());
        this.bO.a(2, new PathfinderGoalArrowAttack(this, 1.0, 40, 20.0f));
        this.bO.a(5, new PathfinderGoalRandomFly(this, 1.0));
        this.bO.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bO.a(7, new PathfinderGoalRandomLookaround(this));
        this.bP.a(0, new HasRider(this));
        this.bP.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.bP.a(2, new PathfinderGoalNearestAttackableTarget<EntityLiving>(this, EntityLiving.class, 0, false, false, cd));
    }

    @Override
    protected void c_() {
        super.c_();
        this.an.a(b, 0);
        this.an.a(c, 0);
        this.an.a(d, 0);
        this.an.a(bT, 0);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("Invul", this.A());
        if (this.getSummoner() != null) {
            nbt.a("Purpur.Summoner", this.getSummoner());
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.s(nbt.h("Invul"));
        if (this.ae()) {
            this.cc.a(this.Q_());
        }
        if (nbt.e("Purpur.Summoner")) {
            this.setSummoner(nbt.a("Purpur.Summoner"));
        }
    }

    @Override
    public void b(@Nullable IChatBaseComponent name) {
        super.b(name);
        this.cc.a(this.Q_());
    }

    @Override
    public boolean shouldCheckForSuffocation() {
        return true;
    }

    @Override
    protected SoundEffect y() {
        return SoundEffects.Bl;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.Bo;
    }

    @Override
    public SoundEffect n_() {
        return SoundEffects.Bn;
    }

    @Override
    public void d_() {
        int j2;
        int i2;
        Entity entity;
        Vec3D vec3d = this.dp().d(1.0, 0.6, 1.0);
        if (!this.dM().B && this.t(0) > 0 && (entity = this.dM().a(this.t(0))) != null) {
            double d0 = vec3d.d;
            if (this.dt() < entity.dt() || !this.a() && this.dt() < entity.dt() + 5.0) {
                d0 = Math.max(0.0, d0);
                d0 += 0.3 - d0 * (double)0.6f;
            }
            vec3d = new Vec3D(vec3d.c, d0, vec3d.e);
            Vec3D vec3d1 = new Vec3D(entity.dr() - this.dr(), 0.0, entity.dx() - this.dx());
            if (vec3d1.i() > 9.0) {
                Vec3D vec3d2 = vec3d1.d();
                vec3d = vec3d.b(vec3d2.c * 0.3 - vec3d.c * 0.6, 0.0, vec3d2.e * 0.3 - vec3d.e * 0.6);
            }
        }
        this.g(vec3d);
        if (vec3d.i() > 0.05) {
            this.r((float)MathHelper.d(vec3d.e, vec3d.c) * 57.295776f - 90.0f);
        }
        super.d_();
        for (i2 = 0; i2 < 2; ++i2) {
            this.bY[i2] = this.bW[i2];
            this.bX[i2] = this.bV[i2];
        }
        for (i2 = 0; i2 < 2; ++i2) {
            int j3 = this.t(i2 + 1);
            Entity entity1 = null;
            if (j3 > 0) {
                entity1 = this.dM().a(j3);
            }
            if (entity1 != null) {
                double d1 = this.u(i2 + 1);
                double d2 = this.v(i2 + 1);
                double d3 = this.w(i2 + 1);
                double d4 = entity1.dr() - d1;
                double d5 = entity1.dv() - d2;
                double d6 = entity1.dx() - d3;
                double d7 = Math.sqrt(d4 * d4 + d6 * d6);
                float f2 = (float)(MathHelper.d(d6, d4) * 57.2957763671875) - 90.0f;
                float f1 = (float)(-(MathHelper.d(d5, d7) * 57.2957763671875));
                this.bV[i2] = this.a(this.bV[i2], f1, 40.0f);
                this.bW[i2] = this.a(this.bW[i2], f2, 10.0f);
                continue;
            }
            this.bW[i2] = this.a(this.bW[i2], this.aU, 10.0f);
        }
        boolean flag = this.a();
        for (j2 = 0; j2 < 3; ++j2) {
            double d8 = this.u(j2);
            double d9 = this.v(j2);
            double d10 = this.w(j2);
            this.dM().a(Particles.ab, d8 + this.ag.k() * (double)0.3f, d9 + this.ag.k() * (double)0.3f, d10 + this.ag.k() * (double)0.3f, 0.0, 0.0, 0.0);
            if (!flag || this.dM().z.a(4) != 0) continue;
            this.dM().a(Particles.v, d8 + this.ag.k() * (double)0.3f, d9 + this.ag.k() * (double)0.3f, d10 + this.ag.k() * (double)0.3f, (double)0.7f, (double)0.7f, 0.5);
        }
        if (this.A() > 0) {
            for (j2 = 0; j2 < 3; ++j2) {
                this.dM().a(Particles.v, this.dr() + this.ag.k(), this.dt() + (double)(this.ag.i() * 3.3f), this.dx() + this.ag.k(), (double)0.7f, (double)0.7f, 0.9f);
            }
        }
    }

    @Override
    protected void Z() {
        if (this.getRider() != null && this.isControllable()) {
            Vec3D mot = this.dp();
            this.o(mot.a(), mot.b() + (this.getVerticalMot() > 0.0f ? 0.07 : 0.0), mot.c());
        }
        if (this.shootCooldown > 0) {
            --this.shootCooldown;
        }
        if (this.A() > 0) {
            int i2 = this.A() - 1;
            this.cc.a(1.0f - (float)i2 / 220.0f);
            if (i2 <= 0) {
                ExplosionPrimeEvent event = new ExplosionPrimeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), 7.0f, false);
                this.dM().getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    this.dM().a((Entity)this, this.dr(), this.dv(), this.dx(), event.getRadius(), event.getFire(), World.a.c);
                }
                if (!this.aU() && this.dM().purpurConfig.witherPlaySpawnSound) {
                    int viewDistance = ((WorldServer)this.dM()).getCraftServer().getViewDistance() * 16;
                    for (EntityPlayer player : this.dM().getPlayersForGlobalSoundGamerule()) {
                        double deltaX = this.dr() - player.dr();
                        double deltaZ = this.dx() - player.dx();
                        double distanceSquared = deltaX * deltaX + deltaZ * deltaZ;
                        double soundRadiusSquared = this.dM().getGlobalSoundRangeSquared(config -> config.witherSpawnSoundRadius);
                        if (!this.dM().Z().b(GameRules.W) && distanceSquared > soundRadiusSquared) continue;
                        if (distanceSquared > (double)(viewDistance * viewDistance)) {
                            double deltaLength = Math.sqrt(distanceSquared);
                            double relativeX = player.dr() + deltaX / deltaLength * (double)viewDistance;
                            double relativeZ = player.dx() + deltaZ / deltaLength * (double)viewDistance;
                            player.c.b(new PacketPlayOutWorldEvent(1023, new BlockPosition((int)relativeX, (int)this.dt(), (int)relativeZ), 0, true));
                            continue;
                        }
                        player.c.b(new PacketPlayOutWorldEvent(1023, this.dm(), 0, true));
                    }
                }
            }
            this.s(i2);
            if (this.ah % 10 == 0) {
                this.heal(this.eM() / 33.0f, EntityRegainHealthEvent.RegainReason.WITHER_SPAWN);
            }
        } else {
            int j2;
            int i3;
            super.Z();
            for (i3 = 1; i3 < 3; ++i3) {
                EntityLiving entityliving1;
                if (this.ah < this.bZ[i3 - 1]) continue;
                this.bZ[i3 - 1] = this.ah + 10 + this.ag.a(10);
                if (this.dM().ak() == EnumDifficulty.c || this.dM().ak() == EnumDifficulty.d) {
                    int k2 = i3 - 1;
                    int l2 = this.ca[i3 - 1];
                    this.ca[k2] = this.ca[i3 - 1] + 1;
                    if (l2 > 15) {
                        float f2 = 10.0f;
                        float f1 = 5.0f;
                        double d0 = MathHelper.a(this.ag, this.dr() - 10.0, this.dr() + 10.0);
                        double d1 = MathHelper.a(this.ag, this.dt() - 5.0, this.dt() + 5.0);
                        double d2 = MathHelper.a(this.ag, this.dx() - 10.0, this.dx() + 10.0);
                        this.a(i3 + 1, d0, d1, d2, true);
                        this.ca[i3 - 1] = 0;
                    }
                }
                if ((j2 = this.t(i3)) > 0) {
                    EntityLiving entityliving = (EntityLiving)this.dM().a(j2);
                    if (entityliving != null && this.c(entityliving) && this.f((Entity)entityliving) <= 900.0 && this.E(entityliving)) {
                        this.a(i3 + 1, entityliving);
                        this.bZ[i3 - 1] = this.ah + 40 + this.ag.a(20);
                        this.ca[i3 - 1] = 0;
                        continue;
                    }
                    this.a(i3, 0);
                    continue;
                }
                List<EntityLiving> list = this.dM().a(EntityLiving.class, ce, this, this.cH().c(20.0, 8.0, 20.0));
                if (list.isEmpty() || CraftEventFactory.callEntityTargetLivingEvent(this, entityliving1 = list.get(this.ag.a(list.size())), EntityTargetEvent.TargetReason.CLOSEST_ENTITY).isCancelled()) continue;
                this.a(i3, entityliving1.aj());
            }
            if (this.q() != null) {
                this.a(0, this.q().aj());
            } else {
                this.a(0, 0);
            }
            if (this.cb > 0) {
                --this.cb;
                if (this.cb == 0 && (this.dM().purpurConfig.witherBypassMobGriefing || this.dM().Z().b(GameRules.c))) {
                    i3 = MathHelper.a(this.dt());
                    j2 = MathHelper.a(this.dr());
                    int i1 = MathHelper.a(this.dx());
                    boolean flag = false;
                    for (int j1 = -1; j1 <= 1; ++j1) {
                        for (int k1 = -1; k1 <= 1; ++k1) {
                            for (int l1 = 0; l1 <= 3; ++l1) {
                                int i2 = j2 + j1;
                                int j22 = i3 + l1;
                                int k2 = i1 + k1;
                                BlockPosition blockposition = new BlockPosition(i2, j22, k2);
                                IBlockData iblockdata = this.dM().a_(blockposition);
                                if (!EntityWither.d(iblockdata) || !CraftEventFactory.callEntityChangeBlockEvent(this, blockposition, iblockdata.u().g())) continue;
                                flag = this.dM().a(blockposition, true, this) || flag;
                            }
                        }
                    }
                    if (flag) {
                        this.dM().a((EntityHuman)null, 1022, this.dm(), 0);
                    }
                }
            }
            if (this.ah % this.dM().purpurConfig.witherHealthRegenDelay == 0) {
                this.heal(this.dM().purpurConfig.witherHealthRegenAmount, EntityRegainHealthEvent.RegainReason.REGEN);
            }
            this.cc.a(this.ev() / this.eM());
        }
    }

    public static boolean d(IBlockData block) {
        return !block.i() && !block.a(TagsBlock.aD);
    }

    public void u() {
        this.s(220);
        this.cc.a(0.0f);
        this.c(this.eM() / 3.0f);
    }

    @Override
    public void a(IBlockData state, Vec3D multiplier) {
    }

    @Override
    public void c(EntityPlayer player) {
        super.c(player);
        this.cc.a(player);
    }

    @Override
    public void d(EntityPlayer player) {
        super.d(player);
        this.cc.b(player);
    }

    private double u(int headIndex) {
        if (headIndex <= 0) {
            return this.dr();
        }
        float f2 = (this.aU + (float)(180 * (headIndex - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.b(f2);
        return this.dr() + (double)f1 * 1.3;
    }

    private double v(int headIndex) {
        return headIndex <= 0 ? this.dt() + 3.0 : this.dt() + 2.2;
    }

    private double w(int headIndex) {
        if (headIndex <= 0) {
            return this.dx();
        }
        float f2 = (this.aU + (float)(180 * (headIndex - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.a(f2);
        return this.dx() + (double)f1 * 1.3;
    }

    private float a(float prevAngle, float desiredAngle, float maxDifference) {
        float f3 = MathHelper.g(desiredAngle - prevAngle);
        if (f3 > maxDifference) {
            f3 = maxDifference;
        }
        if (f3 < -maxDifference) {
            f3 = -maxDifference;
        }
        return prevAngle + f3;
    }

    private void a(int headIndex, EntityLiving target) {
        this.a(headIndex, target.dr(), target.dt() + (double)target.cI() * 0.5, target.dx(), headIndex == 0 && this.ag.i() < 0.001f);
    }

    private void a(int headIndex, double targetX, double targetY, double targetZ, boolean charged) {
        if (!this.aU()) {
            this.dM().a((EntityHuman)null, 1024, this.dm(), 0);
        }
        double d3 = this.u(headIndex);
        double d4 = this.v(headIndex);
        double d5 = this.w(headIndex);
        double d6 = targetX - d3;
        double d7 = targetY - d4;
        double d8 = targetZ - d5;
        EntityWitherSkull entitywitherskull = new EntityWitherSkull(this.dM(), this, d6, d7, d8);
        entitywitherskull.b((Entity)this);
        if (charged) {
            entitywitherskull.a(true);
        }
        entitywitherskull.p(d3, d4, d5);
        this.dM().b(entitywitherskull);
    }

    @Override
    public void a(EntityLiving target, float pullProgress) {
        this.a(0, target);
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.b(source)) {
            return false;
        }
        if (!source.a(DamageTypeTags.u) && !(source.d() instanceof EntityWither)) {
            Entity entity;
            if (this.A() > 0 && !source.a(DamageTypeTags.e)) {
                return false;
            }
            if (this.a() && (entity = source.c()) instanceof EntityArrow) {
                return false;
            }
            entity = source.d();
            if (entity != null && !(entity instanceof EntityHuman) && entity instanceof EntityLiving && ((EntityLiving)entity).eS() == this.eS()) {
                return false;
            }
            if (this.cb <= 0) {
                this.cb = 20;
            }
            int i2 = 0;
            while (i2 < this.ca.length) {
                int n2 = i2++;
                this.ca[n2] = this.ca[n2] + 3;
            }
            return super.a(source, amount);
        }
        return false;
    }

    @Override
    protected void a(DamageSource source, int lootingMultiplier, boolean allowDrops) {
        super.a(source, lootingMultiplier, allowDrops);
        EntityItem entityitem = this.spawnAtLocation(new ItemStack(Items.ul), 0.0f, EntityItem::B);
        if (entityitem != null) {
            entityitem.B();
        }
    }

    @Override
    public void dy() {
        if (this.dM().ak() == EnumDifficulty.a && this.X()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            this.bb = 0;
        }
    }

    @Override
    public boolean b(MobEffect effect, @Nullable Entity source) {
        return false;
    }

    public static AttributeProvider.Builder w() {
        return EntityMonster.gk().a(GenericAttributes.l, 300.0).a(GenericAttributes.m, 0.6f).a(GenericAttributes.f, 0.6f).a(GenericAttributes.g, 40.0).a(GenericAttributes.a, 4.0);
    }

    public float b(int headIndex) {
        return this.bW[headIndex];
    }

    public float c(int headIndex) {
        return this.bV[headIndex];
    }

    public int A() {
        return this.an.b(bT);
    }

    public void s(int ticks) {
        this.an.b(bT, ticks);
    }

    public int t(int headIndex) {
        return this.getRider() != null && this.isControllable() ? 0 : this.an.b(e.get(headIndex));
    }

    public void a(int headIndex, int id) {
        if (this.getRider() == null || !this.isControllable()) {
            this.an.b(e.get(headIndex), id);
        }
    }

    @Override
    public boolean a() {
        return this.ev() <= this.eM() / 2.0f;
    }

    @Override
    public EnumMonsterType eS() {
        return EnumMonsterType.b;
    }

    @Override
    protected boolean o(Entity entity) {
        if (this.dM().purpurConfig.witherCanRideVehicles) {
            return this.J <= 0;
        }
        return false;
    }

    @Override
    public boolean ct() {
        return super.ct() && this.canPortal;
    }

    @Override
    public boolean c(MobEffect effect) {
        return effect.c() == MobEffects.t && this.dM().paperConfig().entities.mobEffects.immuneToWitherEffect.wither ? false : super.c(effect);
    }

    private class a
    extends PathfinderGoal {
        public a() {
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.c, PathfinderGoal.Type.b));
        }

        @Override
        public boolean a() {
            return EntityWither.this.A() > 0;
        }
    }
}

