/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import com.mojang.logging.LogUtils;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContextDirectional;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockAnvil;
import net.minecraft.world.level.block.BlockConcretePowder;
import net.minecraft.world.level.block.BlockFalling;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.slf4j.Logger;

public class EntityFallingBlock
extends Entity {
    private static final Logger f = LogUtils.getLogger();
    public IBlockData g = Blocks.I.o();
    public int b;
    public boolean c = true;
    public boolean h;
    public boolean i;
    public int j = 40;
    public float k;
    @Nullable
    public NBTTagCompound d;
    protected static final DataWatcherObject<BlockPosition> e = DataWatcher.a(EntityFallingBlock.class, DataWatcherRegistry.n);
    public boolean autoExpire = true;

    public EntityFallingBlock(EntityTypes<? extends EntityFallingBlock> type, World world) {
        super(type, world);
    }

    public EntityFallingBlock(World world, double x2, double y2, double z2, IBlockData block) {
        this((EntityTypes<? extends EntityFallingBlock>)EntityTypes.M, world);
        this.g = block;
        this.I = true;
        this.a_(x2, y2, z2);
        this.g(Vec3D.b);
        this.K = x2;
        this.L = y2;
        this.M = z2;
        this.a(this.dm());
    }

    public static EntityFallingBlock a(World world, BlockPosition pos, IBlockData state) {
        return EntityFallingBlock.fall(world, pos, state, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public static EntityFallingBlock fall(World world, BlockPosition blockposition, IBlockData iblockdata, CreatureSpawnEvent.SpawnReason spawnReason) {
        EntityFallingBlock entityfallingblock = new EntityFallingBlock(world, (double)blockposition.u() + 0.5, blockposition.v(), (double)blockposition.w() + 0.5, iblockdata.b(BlockProperties.C) ? (IBlockData)iblockdata.a(BlockProperties.C, false) : iblockdata);
        if (!CraftEventFactory.callEntityChangeBlockEvent(entityfallingblock, blockposition, iblockdata.u().g())) {
            return entityfallingblock;
        }
        world.a(blockposition, iblockdata.u().g(), 3);
        world.addFreshEntity(entityfallingblock, spawnReason);
        return entityfallingblock;
    }

    @Override
    public boolean cq() {
        return false;
    }

    public void a(BlockPosition pos) {
        this.an.b(e, pos);
    }

    public BlockPosition q() {
        return this.an.b(e);
    }

    @Override
    protected Entity.MovementEmission aW() {
        return Entity.MovementEmission.a;
    }

    @Override
    protected void c_() {
        this.an.a(e, BlockPosition.b);
    }

    @Override
    public boolean bt() {
        return !this.dH();
    }

    @Override
    public void l() {
        if (this.g.i()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            Block block = this.g.b();
            ++this.b;
            if (!this.aV()) {
                this.g(this.dp().b(0.0, -0.04, 0.0));
            }
            this.a(EnumMoveType.a, this.dp());
            if (this.dM().paperConfig().fixes.fallingBlockHeightNerf.test(v2 -> this.dt() > (double)v2)) {
                if (this.c && this.dM().Z().b(GameRules.i)) {
                    this.a(block);
                }
                this.discard(EntityRemoveEvent.Cause.OUT_OF_WORLD);
                return;
            }
            if (!this.dM().B) {
                MovingObjectPositionBlock movingobjectpositionblock;
                BlockPosition blockposition = this.dm();
                boolean flag = this.g.b() instanceof BlockConcretePowder;
                boolean flag1 = flag && this.dM().b_(blockposition).a(TagsFluid.a);
                double d0 = this.dp().g();
                if (flag && d0 > 1.0 && (movingobjectpositionblock = this.dM().a(new RayTrace(new Vec3D(this.K, this.L, this.M), this.dk(), RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.b, this))).c() != MovingObjectPosition.EnumMovingObjectType.a && this.dM().b_(movingobjectpositionblock.a()).a(TagsFluid.a)) {
                    blockposition = movingobjectpositionblock.a();
                    flag1 = true;
                }
                if (!this.aC() && !flag1) {
                    if (!this.dM().B && (this.b > 100 && this.autoExpire && (blockposition.v() <= this.dM().J_() || blockposition.v() > this.dM().al()) || this.b > 600 && this.autoExpire)) {
                        if (this.c && this.dM().Z().b(GameRules.i)) {
                            this.a(block);
                        }
                        this.discard(EntityRemoveEvent.Cause.DROP);
                    }
                } else {
                    IBlockData iblockdata = this.dM().a_(blockposition);
                    this.g(this.dp().d(0.7, -0.5, 0.7));
                    if (!iblockdata.a(Blocks.bQ)) {
                        if (!this.h) {
                            boolean flag4;
                            boolean flag2 = iblockdata.a(new BlockActionContextDirectional(this.dM(), blockposition, EnumDirection.a, ItemStack.f, EnumDirection.b));
                            boolean flag3 = BlockFalling.h(this.dM().a_(blockposition.d())) && (!flag || !flag1);
                            boolean bl = flag4 = this.g.a((IWorldReader)this.dM(), blockposition) && !flag3;
                            if (flag2 && flag4) {
                                if (this.g.b(BlockProperties.C) && this.dM().b_(blockposition).a() == FluidTypes.c) {
                                    this.g = (IBlockData)this.g.a(BlockProperties.C, true);
                                }
                                if (!CraftEventFactory.callEntityChangeBlockEvent(this, blockposition, this.g)) {
                                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                    return;
                                }
                                if (this.dM().a(blockposition, this.g, 3)) {
                                    TileEntity tileentity;
                                    ((WorldServer)this.dM()).l().a.a(this, new PacketPlayOutBlockChange(blockposition, this.dM().a_(blockposition)));
                                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                    if (block instanceof Fallable) {
                                        ((Fallable)((Object)block)).a(this.dM(), blockposition, this.g, iblockdata, this);
                                    }
                                    if (this.d != null && this.g.t() && (tileentity = this.dM().c_(blockposition)) != null) {
                                        NBTTagCompound nbttagcompound = tileentity.q();
                                        for (String s2 : this.d.e()) {
                                            nbttagcompound.a(s2, this.d.c(s2).d());
                                        }
                                        try {
                                            tileentity.a(nbttagcompound);
                                        }
                                        catch (Exception exception) {
                                            f.error("Failed to load block entity from falling block", (Throwable)exception);
                                        }
                                        tileentity.e();
                                    }
                                } else if (this.c && this.dM().Z().b(GameRules.i)) {
                                    this.discard(EntityRemoveEvent.Cause.DROP);
                                    this.a(block, blockposition);
                                    this.a(block);
                                }
                            } else {
                                this.discard(EntityRemoveEvent.Cause.DROP);
                                if (this.c && this.dM().Z().b(GameRules.i)) {
                                    this.a(block, blockposition);
                                    this.a(block);
                                }
                            }
                        } else {
                            this.discard(EntityRemoveEvent.Cause.DESPAWN);
                            this.a(block, blockposition);
                        }
                    }
                }
            }
            this.g(this.dp().a(0.98));
        }
    }

    public void a(Block block, BlockPosition pos) {
        if (block instanceof Fallable) {
            ((Fallable)((Object)block)).a(this.dM(), pos, this);
        }
    }

    @Override
    public boolean a(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        DamageSource damagesource1;
        if (!this.i) {
            return false;
        }
        int i2 = MathHelper.f(fallDistance - 1.0f);
        if (i2 < 0) {
            return false;
        }
        Predicate<Entity> predicate = IEntitySelector.e.and(IEntitySelector.b);
        Block block = this.g.b();
        if (block instanceof Fallable) {
            Fallable fallable = (Fallable)((Object)block);
            damagesource1 = fallable.a(this);
        } else {
            damagesource1 = this.dN().a(this);
        }
        DamageSource damagesource2 = damagesource1;
        float f2 = Math.min(MathHelper.d((float)i2 * this.k), this.j);
        this.dM().a((Entity)this, this.cH(), predicate).forEach(entity -> entity.a(damagesource2, f2));
        boolean flag = this.g.a(TagsBlock.M);
        if (flag && f2 > 0.0f && this.ag.i() < 0.05f + (float)i2 * 0.05f) {
            IBlockData iblockdata = BlockAnvil.e(this.g);
            if (iblockdata == null) {
                this.h = true;
            } else {
                this.g = iblockdata;
            }
        }
        return false;
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        nbt.a("BlockState", GameProfileSerializer.a(this.g));
        nbt.a("Time", this.b);
        nbt.a("DropItem", this.c);
        nbt.a("HurtEntities", this.i);
        nbt.a("FallHurtAmount", this.k);
        nbt.a("FallHurtMax", this.j);
        if (this.d != null) {
            nbt.a("TileEntityData", this.d);
        }
        nbt.a("CancelDrop", this.h);
        if (!this.autoExpire) {
            nbt.a("Paper.AutoExpire", false);
        }
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        this.g = GameProfileSerializer.a(this.dM().a(Registries.f), nbt.p("BlockState"));
        this.b = nbt.h("Time");
        if (nbt.b("HurtEntities", 99)) {
            this.i = nbt.q("HurtEntities");
            this.k = nbt.j("FallHurtAmount");
            this.j = nbt.h("FallHurtMax");
        } else if (this.g.a(TagsBlock.M)) {
            this.i = true;
        }
        if (nbt.b("DropItem", 99)) {
            this.c = nbt.q("DropItem");
        }
        if (!(!nbt.b("TileEntityData", 10) || this.dM().paperConfig().entities.spawning.filterBadTileEntityNbtFromFallingBlocks && this.g.b() instanceof GameMasterBlock)) {
            this.d = nbt.p("TileEntityData").h();
        }
        this.h = nbt.q("CancelDrop");
        if (this.g.i()) {
            this.g = Blocks.I.o();
        }
        if (nbt.e("Paper.AutoExpire")) {
            this.autoExpire = nbt.q("Paper.AutoExpire");
        }
    }

    public void b(float fallHurtAmount, int fallHurtMax) {
        this.i = true;
        this.k = fallHurtAmount;
        this.j = fallHurtMax;
    }

    public void s() {
        this.h = true;
    }

    @Override
    public boolean cv() {
        return false;
    }

    @Override
    public void a(CrashReportSystemDetails section) {
        super.a(section);
        section.a("Immitating BlockState", this.g.toString());
    }

    public IBlockData u() {
        return this.g;
    }

    @Override
    protected IChatBaseComponent co() {
        return IChatBaseComponent.a("entity.minecraft.falling_block_type", this.g.b().f());
    }

    @Override
    public boolean cM() {
        return true;
    }

    @Override
    public Packet<PacketListenerPlayOut> dj() {
        return new PacketPlayOutSpawnEntity(this, Block.i(this.u()));
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        this.g = Block.a(packet.o());
        this.I = true;
        double d0 = packet.f();
        double d1 = packet.g();
        double d2 = packet.h();
        this.a_(d0, d1, d2);
        this.a(this.dm());
    }
}

