/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.kyori.adventure.util.TriState;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerAttemptPickupItemEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;

public class EntityItem
extends Entity
implements TraceableEntity {
    private static final DataWatcherObject<ItemStack> c = DataWatcher.a(EntityItem.class, DataWatcherRegistry.h);
    private static final int d = 6000;
    private static final int e = Short.MAX_VALUE;
    private static final int f = Short.MIN_VALUE;
    public int g;
    public int h;
    public int i = 5;
    @Nullable
    public UUID j;
    @Nullable
    private Entity k;
    @Nullable
    public UUID l;
    public final float b;
    private int lastTick = MinecraftServer.currentTick - 1;
    public boolean canMobPickup = true;
    private int despawnRate = -1;
    public TriState frictionState = TriState.NOT_SET;
    public boolean immuneToCactus = false;
    public boolean immuneToExplosion = false;
    public boolean immuneToFire = false;
    public boolean immuneToLightning = false;

    public EntityItem(EntityTypes<? extends EntityItem> type, World world) {
        super(type, world);
        this.b = this.ag.i() * (float)Math.PI * 2.0f;
        this.r(this.ag.i() * 360.0f);
    }

    public EntityItem(World world, double x2, double y2, double z2, ItemStack stack) {
        this((EntityTypes<? extends EntityItem>)EntityTypes.ae, world);
        this.a_(x2, y2, z2);
        this.o(this.ag.j() * 0.2 - 0.1, 0.2, this.ag.j() * 0.2 - 0.1);
        this.a(stack);
    }

    public EntityItem(World world, double x2, double y2, double z2, ItemStack stack, double velocityX, double velocityY, double velocityZ) {
        this((EntityTypes<? extends EntityItem>)EntityTypes.ae, world);
        this.a_(x2, y2, z2);
        this.o(velocityX, velocityY, velocityZ);
        this.a(stack);
    }

    private EntityItem(EntityItem entity) {
        super(entity.ai(), entity.dM());
        this.a(entity.q().p());
        this.v(entity);
        this.g = entity.g;
        this.b = entity.b;
    }

    @Override
    public boolean aX() {
        return this.q().a(TagsItem.aB);
    }

    @Override
    @Nullable
    public Entity w() {
        World world;
        if (this.k != null && !this.k.dH()) {
            return this.k;
        }
        if (this.j != null && (world = this.dM()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.k = worldserver.a(this.j);
            return this.k;
        }
        return null;
    }

    @Override
    public void w(Entity original) {
        super.w(original);
        if (original instanceof EntityItem) {
            EntityItem entityitem = (EntityItem)original;
            this.k = entityitem.k;
        }
    }

    @Override
    protected Entity.MovementEmission aW() {
        return Entity.MovementEmission.a;
    }

    @Override
    protected void c_() {
        this.an().a(c, ItemStack.f);
    }

    @Override
    public void l() {
        if (this.q().b()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            double d0;
            int i2;
            super.l();
            int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
            if (this.h != Short.MAX_VALUE) {
                this.h -= elapsedTicks;
            }
            this.h = Math.max(0, this.h);
            if (this.g != Short.MIN_VALUE) {
                this.g += elapsedTicks;
            }
            this.lastTick = MinecraftServer.currentTick;
            this.K = this.dr();
            this.L = this.dt();
            this.M = this.dx();
            Vec3D vec3d = this.dp();
            float f2 = this.cI() - 0.11111111f;
            if (this.aZ() && this.b(TagsFluid.a) > (double)f2) {
                this.E();
            } else if (this.bn() && this.b(TagsFluid.b) > (double)f2) {
                this.G();
            } else if (!this.aV()) {
                this.g(this.dp().b(0.0, -0.04, 0.0));
            }
            if (this.dM().B) {
                this.af = false;
            } else {
                boolean bl = this.af = !this.dM().a((Entity)this, this.cH().h(1.0E-7));
                if (this.af) {
                    this.m(this.dr(), (this.cH().b + this.cH().e) / 2.0, this.dx());
                }
            }
            if (!this.aC() || this.dp().i() > (double)1.0E-5f || (this.ah + this.aj()) % 4 == 0) {
                this.a(EnumMoveType.a, this.dp());
                float f1 = 0.98f;
                if (this.frictionState == TriState.FALSE) {
                    f1 = 1.0f;
                } else if (this.aC()) {
                    f1 = this.dM().a_(this.aI()).b().i() * 0.98f;
                }
                this.g(this.dp().d(f1, this.frictionState == TriState.FALSE ? 1.0 : 0.98, f1));
                if (this.aC()) {
                    Vec3D vec3d1 = this.dp();
                    if (vec3d1.d < 0.0) {
                        this.g(vec3d1.d(1.0, -0.5, 1.0));
                    }
                }
            }
            boolean flag = MathHelper.a(this.K) != MathHelper.a(this.dr()) || MathHelper.a(this.L) != MathHelper.a(this.dt()) || MathHelper.a(this.M) != MathHelper.a(this.dx());
            int n2 = i2 = flag ? 2 : 40;
            if (this.ah % i2 == 0 && !this.dM().B && this.I()) {
                this.H();
            }
            this.au |= this.bg();
            if (!this.dM().B && (d0 = this.dp().d(vec3d).g()) > 0.01) {
                this.au = true;
            }
            if (!this.dM().B && this.g >= this.despawnRate) {
                if (CraftEventFactory.callItemDespawnEvent(this).isCancelled()) {
                    this.g = 0;
                    return;
                }
                this.discard(EntityRemoveEvent.Cause.DESPAWN);
            }
        }
    }

    @Override
    public void inactiveTick() {
        int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
        if (this.h != Short.MAX_VALUE) {
            this.h -= elapsedTicks;
        }
        this.h = Math.max(0, this.h);
        if (this.g != Short.MIN_VALUE) {
            this.g += elapsedTicks;
        }
        this.lastTick = MinecraftServer.currentTick;
        if (!this.dM().B && this.g >= this.despawnRate) {
            if (CraftEventFactory.callItemDespawnEvent(this).isCancelled()) {
                this.g = 0;
                return;
            }
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    @Override
    protected BlockPosition aI() {
        return this.d(0.999999f);
    }

    private void E() {
        Vec3D vec3d = this.dp();
        this.o(vec3d.c * (double)0.99f, vec3d.d + (double)(vec3d.d < (double)0.06f ? 5.0E-4f : 0.0f), vec3d.e * (double)0.99f);
    }

    private void G() {
        Vec3D vec3d = this.dp();
        this.o(vec3d.c * (double)0.95f, vec3d.d + (double)(vec3d.d < (double)0.06f ? 5.0E-4f : 0.0f), vec3d.e * (double)0.95f);
    }

    private void H() {
        if (this.I()) {
            double radius = this.dM().spigotConfig.itemMerge;
            List<EntityItem> list = this.dM().a(EntityItem.class, this.cH().c(radius, radius - 0.5, radius), (? super T entityitem) -> entityitem != this && entityitem.I());
            for (EntityItem entityitem2 : list) {
                if (!entityitem2.I() || this.dM().paperConfig().fixes.fixItemsMergingThroughWalls && this.dM().clipDirect(this.dk(), entityitem2.dk(), VoxelShapeCollision.a(this)) == MovingObjectPosition.EnumMovingObjectType.b) continue;
                this.a(entityitem2);
                if (!this.dH()) continue;
                break;
            }
        }
    }

    private boolean I() {
        ItemStack itemstack = this.q();
        return this.bx() && this.h != Short.MAX_VALUE && this.g != Short.MIN_VALUE && this.g < this.despawnRate && itemstack.L() < itemstack.g();
    }

    private void a(EntityItem other) {
        ItemStack itemstack = this.q();
        ItemStack itemstack1 = other.q();
        if (Objects.equals(this.l, other.l) && EntityItem.a(itemstack, itemstack1)) {
            EntityItem.a(this, itemstack, other, itemstack1);
        }
    }

    public static boolean a(ItemStack stack1, ItemStack stack2) {
        return !stack2.a(stack1.d()) ? false : (stack2.L() + stack1.L() > stack2.g() ? false : (stack2.u() ^ stack1.u() ? false : !stack2.u() || stack2.v().equals(stack1.v())));
    }

    public static ItemStack a(ItemStack stack1, ItemStack stack2, int maxCount) {
        int j2 = Math.min(Math.min(stack1.g(), maxCount) - stack1.L(), stack2.L());
        ItemStack itemstack2 = stack1.c(stack1.L() + j2);
        stack2.h(j2);
        return itemstack2;
    }

    private static void a(EntityItem targetEntity, ItemStack stack1, ItemStack stack2) {
        ItemStack itemstack2 = EntityItem.a(stack1, stack2, 64);
        targetEntity.a(itemstack2);
    }

    private static void a(EntityItem targetEntity, ItemStack targetStack, EntityItem sourceEntity, ItemStack sourceStack) {
        if (!CraftEventFactory.callItemMergeEvent(sourceEntity, targetEntity)) {
            return;
        }
        EntityItem.a(targetEntity, targetStack, sourceStack);
        targetEntity.h = Math.max(targetEntity.h, sourceEntity.h);
        targetEntity.g = Math.min(targetEntity.g, sourceEntity.g);
        if (sourceStack.b()) {
            sourceEntity.discard(EntityRemoveEvent.Cause.MERGE);
        }
    }

    @Override
    public boolean aY() {
        return this.q().d().w() || super.aY();
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.immuneToCactus && source.a(DamageTypes.j) || this.immuneToFire && (source.a(DamageTypeTags.j) || source.a(DamageTypes.c) || source.a(DamageTypes.a)) || this.immuneToLightning && source.a(DamageTypes.b) || this.immuneToExplosion && source.a(DamageTypeTags.m)) {
            return false;
        }
        if (this.b(source)) {
            return false;
        }
        if (!this.q().b() && this.q().a(Items.ul) && source.a(DamageTypeTags.m)) {
            return false;
        }
        if (!this.q().d().a(source)) {
            return false;
        }
        if (this.dM().B) {
            return true;
        }
        if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, source, amount)) {
            return false;
        }
        this.bq();
        this.i = (int)((float)this.i - amount);
        this.a(GameEvent.o, source.d());
        if (this.i <= 0) {
            this.q().a(this);
            this.discard(EntityRemoveEvent.Cause.DEATH);
        }
        return true;
    }

    @Override
    public void b(NBTTagCompound nbt) {
        if (this.frictionState != TriState.NOT_SET) {
            nbt.a("Paper.FrictionState", this.frictionState.toString());
        }
        nbt.a("Health", (short)this.i);
        nbt.a("Age", (short)this.g);
        nbt.a("PickupDelay", (short)this.h);
        if (this.j != null) {
            nbt.a("Thrower", this.j);
        }
        if (this.l != null) {
            nbt.a("Owner", this.l);
        }
        if (!this.q().b()) {
            nbt.a("Item", this.q().b(new NBTTagCompound()));
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        this.i = nbt.g("Health");
        this.g = nbt.g("Age");
        if (nbt.e("PickupDelay")) {
            this.h = nbt.g("PickupDelay");
        }
        if (nbt.b("Owner")) {
            this.l = nbt.a("Owner");
        }
        if (nbt.b("Thrower")) {
            this.j = nbt.a("Thrower");
            this.k = null;
        }
        if (nbt.e("Paper.FrictionState")) {
            String fs = nbt.l("Paper.FrictionState");
            try {
                this.frictionState = TriState.valueOf((String)fs);
            }
            catch (Exception ignored) {
                LogUtils.getLogger().error("Unknown friction state " + fs + " for " + this);
            }
        }
        NBTTagCompound nbttagcompound1 = nbt.p("Item");
        this.a(ItemStack.a(nbttagcompound1));
        if (this.q().b()) {
            this.discard(null);
        }
    }

    @Override
    public void b_(EntityHuman player) {
        if (!this.dM().B) {
            ItemStack itemstack = this.q();
            Item item = itemstack.d();
            int i2 = itemstack.L();
            int canHold = player.fS().canHold(itemstack);
            int remaining = i2 - canHold;
            boolean flyAtPlayer = false;
            if (this.h <= 0) {
                PlayerAttemptPickupItemEvent attemptEvent = new PlayerAttemptPickupItemEvent((Player)player.getBukkitEntity(), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining);
                this.dM().getCraftServer().getPluginManager().callEvent((Event)attemptEvent);
                flyAtPlayer = attemptEvent.getFlyAtPlayer();
                if (attemptEvent.isCancelled()) {
                    if (flyAtPlayer) {
                        player.a((Entity)this, i2);
                    }
                    return;
                }
            }
            if (this.h <= 0 && canHold > 0) {
                EntityPickupItemEvent entityEvent;
                itemstack.f(canHold);
                PlayerPickupItemEvent playerEvent = new PlayerPickupItemEvent((Player)player.getBukkitEntity(), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining);
                playerEvent.setCancelled(!playerEvent.getPlayer().getCanPickupItems());
                this.dM().getCraftServer().getPluginManager().callEvent((Event)playerEvent);
                flyAtPlayer = playerEvent.getFlyAtPlayer();
                if (playerEvent.isCancelled()) {
                    itemstack.f(i2);
                    if (flyAtPlayer) {
                        player.a((Entity)this, i2);
                    }
                    return;
                }
                entityEvent.setCancelled(!(entityEvent = new EntityPickupItemEvent((LivingEntity)((Player)player.getBukkitEntity()), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining)).getEntity().getCanPickupItems());
                this.dM().getCraftServer().getPluginManager().callEvent((Event)entityEvent);
                if (entityEvent.isCancelled()) {
                    itemstack.f(i2);
                    return;
                }
                ItemStack current = this.q();
                if (!itemstack.equals(current)) {
                    itemstack = current;
                } else {
                    itemstack.f(canHold + remaining);
                }
                this.h = 0;
            } else if (this.h == 0) {
                this.h = -1;
            }
            if (this.h == 0 && (this.l == null || this.l.equals(player.cw())) && player.fS().e(itemstack)) {
                if (flyAtPlayer) {
                    player.a((Entity)this, i2);
                }
                if (itemstack.b()) {
                    this.discard(EntityRemoveEvent.Cause.PICKUP);
                    itemstack.f(i2);
                }
                player.a(StatisticList.e.b(item), i2);
                player.a(this);
            }
        }
    }

    @Override
    public IChatBaseComponent ad() {
        IChatBaseComponent ichatbasecomponent = this.af();
        return ichatbasecomponent != null ? ichatbasecomponent : IChatBaseComponent.c(this.q().q());
    }

    @Override
    public boolean cq() {
        return false;
    }

    @Override
    @Nullable
    public Entity b(WorldServer destination) {
        Entity entity = super.b(destination);
        if (!this.dM().B && entity instanceof EntityItem) {
            ((EntityItem)entity).H();
        }
        return entity;
    }

    public ItemStack q() {
        return this.an().b(c);
    }

    public void a(ItemStack stack) {
        this.an().b(c, stack);
        int n2 = this.despawnRate = this.dM().paperConfig().entities.spawning.altItemDespawnRate.enabled ? this.dM().paperConfig().entities.spawning.altItemDespawnRate.items.getOrDefault((Object)stack.d(), this.dM().spigotConfig.itemDespawnRate) : this.dM().spigotConfig.itemDespawnRate;
        if (this.dM().purpurConfig.itemImmuneToCactus.contains(stack.d())) {
            this.immuneToCactus = true;
        }
        if (this.dM().purpurConfig.itemImmuneToExplosion.contains(stack.d())) {
            this.immuneToExplosion = true;
        }
        if (this.dM().purpurConfig.itemImmuneToFire.contains(stack.d())) {
            this.immuneToFire = true;
        }
        if (this.dM().purpurConfig.itemImmuneToLightning.contains(stack.d())) {
            this.immuneToLightning = true;
        }
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        super.a(data);
        if (c.equals(data)) {
            this.q().a((Entity)this);
        }
    }

    public void b(@Nullable UUID owner) {
        this.l = owner;
    }

    public void a(Entity thrower) {
        this.j = thrower.cw();
        this.k = thrower;
    }

    public int s() {
        return this.g;
    }

    public void u() {
        this.h = 10;
    }

    public void x() {
        this.h = 0;
    }

    public void y() {
        this.h = Short.MAX_VALUE;
    }

    public void b(int pickupDelay) {
        this.h = pickupDelay;
    }

    public boolean z() {
        return this.h > 0;
    }

    public void A() {
        this.g = Short.MIN_VALUE;
    }

    public void B() {
        this.g = -6000;
    }

    public void C() {
        this.y();
        this.g = this.despawnRate - 1;
    }

    public float a(float tickDelta) {
        return ((float)this.s() + tickDelta) / 20.0f + this.b;
    }

    public EntityItem D() {
        return new EntityItem(this);
    }

    @Override
    public SoundCategory db() {
        return SoundCategory.i;
    }

    @Override
    public float dD() {
        return 180.0f - this.a(0.5f) / ((float)Math.PI * 2) * 360.0f;
    }
}

