/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveTowardsRestriction;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import org.purpurmc.purpur.entity.ai.HasRider;

public class EntityGiantZombie
extends EntityMonster {
    public EntityGiantZombie(EntityTypes<? extends EntityGiantZombie> type, World world) {
        super((EntityTypes<? extends EntityMonster>)type, world);
        this.safeFallDistance = 10.0f;
    }

    @Override
    public boolean isRidable() {
        return this.dM().purpurConfig.giantRidable;
    }

    @Override
    public boolean bQ() {
        return this.dM().purpurConfig.useDismountsUnderwaterTag ? super.bQ() : !this.dM().purpurConfig.giantRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.dM().purpurConfig.giantControllable;
    }

    @Override
    protected void B() {
        if (this.dM().purpurConfig.giantHaveAI) {
            this.bO.a(0, new PathfinderGoalFloat(this));
            this.bO.a(0, new HasRider(this));
            this.bO.a(7, new PathfinderGoalRandomStrollLand(this, 1.0));
            this.bO.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 16.0f));
            this.bO.a(8, new PathfinderGoalRandomLookaround(this));
            this.bO.a(5, new PathfinderGoalMoveTowardsRestriction(this, 1.0));
            if (this.dM().purpurConfig.giantHaveHostileAI) {
                this.bO.a(2, new PathfinderGoalMeleeAttack(this, 1.0, false));
                this.bP.a(0, new HasRider(this));
                this.bP.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]).a(EntityPigZombie.class));
                this.bP.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
                this.bP.a(3, new PathfinderGoalNearestAttackableTarget<EntityVillager>((EntityInsentient)this, EntityVillager.class, false));
                this.bP.a(4, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
                this.bP.a(5, new PathfinderGoalNearestAttackableTarget<EntityTurtle>((EntityInsentient)this, EntityTurtle.class, true));
            }
        }
    }

    @Override
    public boolean fh() {
        return this.dM().purpurConfig.giantTakeDamageFromWater;
    }

    @Override
    protected boolean ef() {
        return this.dM().purpurConfig.giantAlwaysDropExp;
    }

    @Override
    protected void initAttributes() {
        this.a(GenericAttributes.l).a(this.dM().purpurConfig.giantMaxHealth);
        this.a(GenericAttributes.m).a(this.dM().purpurConfig.giantMovementSpeed);
        this.a(GenericAttributes.c).a(this.dM().purpurConfig.giantAttackDamage);
    }

    @Override
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        GroupDataEntity groupData = super.a(world, difficulty, spawnReason, entityData, entityNbt);
        if (groupData == null) {
            this.a(this.ag, difficulty);
            this.b(this.ag, difficulty);
        }
        return groupData;
    }

    @Override
    protected void a(RandomSource random, DifficultyDamageScaler difficulty) {
        super.a(this.ag, difficulty);
        float f2 = random.i();
        float f3 = this.dM().ak() == EnumDifficulty.d ? 0.1f : 0.05f;
        if (f2 < f3) {
            this.a(EnumItemSlot.a, new ItemStack(Items.oX));
        }
    }

    @Override
    public float eZ() {
        return this.dM().purpurConfig.giantJumpHeight;
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return 10.440001f;
    }

    @Override
    protected float l(Entity vehicle) {
        return -3.75f;
    }

    public static AttributeProvider.Builder u() {
        return EntityMonster.gk().a(GenericAttributes.l, 100.0).a(GenericAttributes.m, 0.5).a(GenericAttributes.c, 50.0);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        return super.a(pos, world);
    }
}

