/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveTowardsRestriction;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationGuardian;
import net.minecraft.world.entity.animal.EntitySquid;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.monster.EntityGuardianElder;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.joml.Vector3f;
import org.purpurmc.purpur.controller.LookControllerWASD;
import org.purpurmc.purpur.controller.WaterMoveControllerWASD;
import org.purpurmc.purpur.entity.ai.HasRider;

public class EntityGuardian
extends EntityMonster {
    protected static final int c = 80;
    private static final DataWatcherObject<Boolean> b = DataWatcher.a(EntityGuardian.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> e = DataWatcher.a(EntityGuardian.class, DataWatcherRegistry.b);
    private float bT;
    private float bU;
    private float bV;
    private float bW;
    private float bX;
    @Nullable
    private EntityLiving bY;
    private int bZ;
    private boolean ca;
    @Nullable
    public PathfinderGoalRandomStroll d;
    public PathfinderGoalGuardianAttack guardianAttackGoal;

    public EntityGuardian(EntityTypes<? extends EntityGuardian> type, World world) {
        super((EntityTypes<? extends EntityMonster>)type, world);
        this.bJ = 10;
        this.a(PathType.j, 0.0f);
        this.bL = new ControllerMoveGuardian(this);
        this.bK = new LookControllerWASD(this){

            @Override
            public void setYawPitch(float yaw, float pitch) {
                super.setYawPitch(yaw, pitch * 0.35f);
            }
        };
        this.bU = this.bT = this.ag.i();
    }

    @Override
    public boolean isRidable() {
        return this.dM().purpurConfig.guardianRidable;
    }

    @Override
    public boolean isControllable() {
        return this.dM().purpurConfig.guardianControllable;
    }

    @Override
    public void initAttributes() {
        this.a(GenericAttributes.l).a(this.dM().purpurConfig.guardianMaxHealth);
    }

    @Override
    public boolean fh() {
        return this.dM().purpurConfig.guardianTakeDamageFromWater;
    }

    @Override
    protected boolean ef() {
        return this.dM().purpurConfig.guardianAlwaysDropExp;
    }

    @Override
    protected void B() {
        PathfinderGoalMoveTowardsRestriction pathfindergoalmovetowardsrestriction = new PathfinderGoalMoveTowardsRestriction(this, 1.0);
        this.d = new PathfinderGoalRandomStroll(this, 1.0, 80);
        this.bO.a(0, new HasRider(this));
        this.guardianAttackGoal = new PathfinderGoalGuardianAttack(this);
        this.bO.a(4, this.guardianAttackGoal);
        this.bO.a(5, pathfindergoalmovetowardsrestriction);
        this.bO.a(7, this.d);
        this.bO.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bO.a(8, new PathfinderGoalLookAtPlayer(this, EntityGuardian.class, 12.0f, 0.01f));
        this.bO.a(9, new PathfinderGoalRandomLookaround(this));
        this.d.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        pathfindergoalmovetowardsrestriction.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        this.bP.a(0, new HasRider(this));
        this.bP.a(1, new PathfinderGoalNearestAttackableTarget<EntityLiving>(this, EntityLiving.class, 10, true, false, new EntitySelectorGuardianTargetHumanSquid(this)));
    }

    public static AttributeProvider.Builder ge() {
        return EntityMonster.gk().a(GenericAttributes.c, 6.0).a(GenericAttributes.m, 0.5).a(GenericAttributes.g, 16.0).a(GenericAttributes.l, 30.0);
    }

    @Override
    protected NavigationAbstract b(World world) {
        return new NavigationGuardian(this, world);
    }

    @Override
    protected void c_() {
        super.c_();
        this.an.a(b, false);
        this.an.a(e, 0);
    }

    @Override
    public EnumMonsterType eS() {
        return EnumMonsterType.e;
    }

    public boolean gf() {
        return this.an.b(b);
    }

    void w(boolean retracted) {
        this.an.b(b, retracted);
    }

    public int w() {
        return 80;
    }

    public void b(int entityId) {
        this.an.b(e, entityId);
    }

    public boolean gg() {
        return this.an.b(e) != 0;
    }

    @Nullable
    public EntityLiving gh() {
        if (!this.gg()) {
            return null;
        }
        if (this.dM().B) {
            if (this.bY != null) {
                return this.bY;
            }
            Entity entity = this.dM().a(this.an.b(e));
            if (entity instanceof EntityLiving) {
                this.bY = (EntityLiving)entity;
                return this.bY;
            }
            return null;
        }
        return this.q();
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        super.a(data);
        if (e.equals(data)) {
            this.bZ = 0;
            this.bY = null;
        }
    }

    @Override
    public int Q() {
        return 160;
    }

    @Override
    protected SoundEffect y() {
        return this.bc() ? SoundEffects.kM : SoundEffects.kN;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return this.bc() ? SoundEffects.kS : SoundEffects.kT;
    }

    @Override
    public SoundEffect n_() {
        return this.bc() ? SoundEffects.kP : SoundEffects.kQ;
    }

    @Override
    protected Entity.MovementEmission aW() {
        return Entity.MovementEmission.c;
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return dimensions.b * 0.5f;
    }

    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        return world.b_(pos).a(TagsFluid.a) ? 10.0f + world.w(pos) : super.a(pos, world);
    }

    @Override
    public void d_() {
        if (this.bx()) {
            if (this.dM().B) {
                Vec3D vec3d;
                this.bU = this.bT;
                if (!this.aZ()) {
                    this.bV = 2.0f;
                    vec3d = this.dp();
                    if (vec3d.d > 0.0 && this.ca && !this.aU()) {
                        this.dM().a(this.dr(), this.dt(), this.dx(), this.A(), this.db(), 1.0f, 1.0f, false);
                    }
                    this.ca = vec3d.d < 0.0 && this.dM().a(this.dm().d(), (Entity)this);
                } else {
                    this.bV = this.gf() ? (this.bV < 0.5f ? 4.0f : (this.bV += (0.5f - this.bV) * 0.1f)) : (this.bV += (0.125f - this.bV) * 0.2f);
                }
                this.bT += this.bV;
                this.bX = this.bW;
                this.bW = !this.bc() ? this.ag.i() : (this.gf() ? (this.bW += (0.0f - this.bW) * 0.25f) : (this.bW += (1.0f - this.bW) * 0.06f));
                if (this.gf() && this.aZ()) {
                    vec3d = this.f(0.0f);
                    for (int i2 = 0; i2 < 2; ++i2) {
                        this.dM().a(Particles.e, this.d(0.5) - vec3d.c * 1.5, this.du() - vec3d.d * 1.5, this.g(0.5) - vec3d.e * 1.5, 0.0, 0.0, 0.0);
                    }
                }
                if (this.gg()) {
                    EntityLiving entityliving;
                    if (this.bZ < this.w()) {
                        ++this.bZ;
                    }
                    if ((entityliving = this.gh()) != null) {
                        this.I().a(entityliving, 90.0f, 90.0f);
                        this.I().a();
                        double d0 = this.G(0.0f);
                        double d1 = entityliving.dr() - this.dr();
                        double d2 = entityliving.e(0.5) - this.dv();
                        double d3 = entityliving.dx() - this.dx();
                        double d4 = Math.sqrt(d1 * d1 + d2 * d2 + d3 * d3);
                        d1 /= d4;
                        d2 /= d4;
                        d3 /= d4;
                        double d5 = this.ag.j();
                        while (d5 < d4) {
                            this.dM().a(Particles.e, this.dr() + d1 * (d5 += 1.8 - d0 + this.ag.j() * (1.7 - d0)), this.dv() + d2 * d5, this.dx() + d3 * d5, 0.0, 0.0, 0.0);
                        }
                    }
                }
            }
            if (this.bc()) {
                this.j(300);
            } else if (this.aC()) {
                this.g(this.dp().b((this.ag.i() * 2.0f - 1.0f) * 0.4f, 0.5, (this.ag.i() * 2.0f - 1.0f) * 0.4f));
                this.r(this.ag.i() * 360.0f);
                this.c(false);
                this.au = true;
            }
            if (this.gg()) {
                this.r(this.aW);
            }
        }
        super.d_();
    }

    protected SoundEffect A() {
        return SoundEffects.kR;
    }

    public float E(float tickDelta) {
        return MathHelper.i(tickDelta, this.bU, this.bT);
    }

    public float F(float tickDelta) {
        return MathHelper.i(tickDelta, this.bX, this.bW);
    }

    public float G(float tickDelta) {
        return ((float)this.bZ + tickDelta) / (float)this.w();
    }

    public float gi() {
        return this.bZ;
    }

    @Override
    public boolean a(IWorldReader world) {
        return world.f(this);
    }

    public static boolean b(EntityTypes<? extends EntityGuardian> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, RandomSource random) {
        return !(random.a(20) != 0 && world.v(pos) || world.ak() == EnumDifficulty.a || !EnumMobSpawn.a(spawnReason) && !world.b_(pos).a(TagsFluid.a) || !world.b_(pos.d()).a(TagsFluid.a));
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        Entity entity;
        if (this.dM().B) {
            return false;
        }
        if (!this.gf() && !source.a(DamageTypeTags.x) && !source.a(DamageTypes.L) && (entity = source.c()) instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            entityliving.a(this.dN().d(this), 2.0f);
        }
        if (this.d != null) {
            this.d.i();
        }
        return super.a(source, amount);
    }

    @Override
    public int aa() {
        return 180;
    }

    @Override
    public void a(Vec3D movementInput) {
        if (this.cX() && this.aZ()) {
            this.a(this.getRider() != null && this.isControllable() ? this.ff() : 0.1f, movementInput);
            this.a(EnumMoveType.a, this.dp());
            this.g(this.dp().a(0.9));
            if (!this.gf() && this.q() == null) {
                this.g(this.dp().b(0.0, -0.005, 0.0));
            }
        } else {
            super.a(movementInput);
        }
    }

    @Override
    protected Vector3f a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        return new Vector3f(0.0f, dimensions.b + 0.125f * scaleFactor, 0.0f);
    }

    private static class ControllerMoveGuardian
    extends WaterMoveControllerWASD {
        private final EntityGuardian l;

        public ControllerMoveGuardian(EntityGuardian guardian) {
            super(guardian);
            this.l = guardian;
        }

        @Override
        public void purpurTick(EntityHuman rider) {
            super.purpurTick(rider);
            this.l.g(this.l.dp().b(0.0, 0.005, 0.0));
            this.l.w(this.l.getForwardMot() > 0.0f);
        }

        @Override
        public void vanillaTick() {
            if (this.k == ControllerMove.Operation.b && !this.l.N().l()) {
                Vec3D vec3d = new Vec3D(this.e - this.l.dr(), this.f - this.l.dt(), this.g - this.l.dx());
                double d0 = vec3d.f();
                double d1 = vec3d.c / d0;
                double d2 = vec3d.d / d0;
                double d3 = vec3d.e / d0;
                float f2 = (float)(MathHelper.d(vec3d.e, vec3d.c) * 57.2957763671875) - 90.0f;
                this.l.r(this.a(this.l.dC(), f2, 90.0f));
                this.l.aU = this.l.dC();
                float f1 = (float)(this.c() * this.l.b(GenericAttributes.m));
                float f22 = MathHelper.i(0.125f, this.l.ff(), f1);
                this.l.w(f22);
                double d4 = Math.sin((double)(this.l.ah + this.l.aj()) * 0.5) * 0.05;
                double d5 = Math.cos(this.l.dC() * ((float)Math.PI / 180));
                double d6 = Math.sin(this.l.dC() * ((float)Math.PI / 180));
                double d7 = Math.sin((double)(this.l.ah + this.l.aj()) * 0.75) * 0.05;
                this.l.g(this.l.dp().b(d4 * d5, d7 * (d6 + d5) * 0.25 + (double)f22 * d2 * 0.1, d4 * d6));
                ControllerLook controllerlook = this.l.I();
                double d8 = this.l.dr() + d1 * 2.0;
                double d9 = this.l.dv() + d2 / d0;
                double d10 = this.l.dx() + d3 * 2.0;
                double d11 = controllerlook.e();
                double d12 = controllerlook.f();
                double d13 = controllerlook.g();
                if (!controllerlook.d()) {
                    d11 = d8;
                    d12 = d9;
                    d13 = d10;
                }
                this.l.I().a(MathHelper.d(0.125, d11, d8), MathHelper.d(0.125, d12, d9), MathHelper.d(0.125, d13, d10), 10.0f, 40.0f);
                this.l.w(true);
            } else {
                this.l.w(0.0f);
                this.l.w(false);
            }
        }
    }

    public static class PathfinderGoalGuardianAttack
    extends PathfinderGoal {
        private final EntityGuardian a;
        public int b;
        private final boolean c;

        public PathfinderGoalGuardianAttack(EntityGuardian guardian) {
            this.a = guardian;
            this.c = guardian instanceof EntityGuardianElder;
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean a() {
            EntityLiving entityliving = this.a.q();
            return entityliving != null && entityliving.bx();
        }

        @Override
        public boolean b() {
            return super.b() && (this.c || this.a.q() != null && this.a.f((Entity)this.a.q()) > 9.0);
        }

        @Override
        public void c() {
            this.b = -10;
            this.a.N().n();
            EntityLiving entityliving = this.a.q();
            if (entityliving != null) {
                this.a.I().a(entityliving, 90.0f, 90.0f);
            }
            this.a.au = true;
        }

        @Override
        public void d() {
            this.a.b(0);
            this.a.h((EntityLiving)null);
            this.a.d.i();
        }

        @Override
        public boolean T_() {
            return true;
        }

        @Override
        public void e() {
            EntityLiving entityliving = this.a.q();
            if (entityliving != null) {
                this.a.N().n();
                this.a.I().a(entityliving, 90.0f, 90.0f);
                if (!this.a.E(entityliving)) {
                    this.a.h((EntityLiving)null);
                } else {
                    ++this.b;
                    if (this.b == 0) {
                        this.a.b(entityliving.aj());
                        if (!this.a.aU()) {
                            this.a.dM().a((Entity)this.a, (byte)21);
                        }
                    } else if (this.b >= this.a.w()) {
                        float f2 = 1.0f;
                        if (this.a.dM().ak() == EnumDifficulty.d) {
                            f2 += 2.0f;
                        }
                        if (this.c) {
                            f2 += 2.0f;
                        }
                        entityliving.a(this.a.dN().c(this.a, this.a), f2);
                        entityliving.a(this.a.dN().b(this.a), (float)this.a.b(GenericAttributes.c));
                        this.a.h((EntityLiving)null);
                    }
                    super.e();
                }
            }
        }
    }

    private static class EntitySelectorGuardianTargetHumanSquid
    implements Predicate<EntityLiving> {
        private final EntityGuardian a;

        public EntitySelectorGuardianTargetHumanSquid(EntityGuardian owner) {
            this.a = owner;
        }

        public boolean a(@Nullable EntityLiving entityliving) {
            return (entityliving instanceof EntityHuman || entityliving instanceof EntitySquid || entityliving instanceof Axolotl) && entityliving.f((Entity)this.a) > 9.0;
        }
    }
}

