/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntitySlime;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.phys.Vec3D;

public class EntityMagmaCube
extends EntitySlime {
    public EntityMagmaCube(EntityTypes<? extends EntityMagmaCube> type, World world) {
        super((EntityTypes<? extends EntitySlime>)type, world);
    }

    @Override
    public boolean isRidable() {
        return this.dM().purpurConfig.magmaCubeRidable;
    }

    @Override
    public boolean bQ() {
        return this.dM().purpurConfig.useDismountsUnderwaterTag ? super.bQ() : !this.dM().purpurConfig.magmaCubeRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.dM().purpurConfig.magmaCubeControllable;
    }

    @Override
    public float eZ() {
        return 0.42f * this.aK();
    }

    @Override
    protected String getMaxHealthEquation() {
        return this.dM().purpurConfig.magmaCubeMaxHealth;
    }

    @Override
    protected String getAttackDamageEquation() {
        return this.dM().purpurConfig.magmaCubeAttackDamage;
    }

    @Override
    protected Map<Integer, Double> getMaxHealthCache() {
        return this.dM().purpurConfig.magmaCubeMaxHealthCache;
    }

    @Override
    protected Map<Integer, Double> getAttackDamageCache() {
        return this.dM().purpurConfig.magmaCubeAttackDamageCache;
    }

    @Override
    public boolean fh() {
        return this.dM().purpurConfig.magmaCubeTakeDamageFromWater;
    }

    @Override
    protected boolean ef() {
        return this.dM().purpurConfig.magmaCubeAlwaysDropExp;
    }

    public static AttributeProvider.Builder u() {
        return EntityMonster.gk().a(GenericAttributes.m, 0.2f);
    }

    public static boolean b(EntityTypes<EntityMagmaCube> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, RandomSource random) {
        return world.ak() != EnumDifficulty.a;
    }

    @Override
    public boolean a(IWorldReader world) {
        return world.f(this) && !world.d(this.cH());
    }

    @Override
    public void a(int size, boolean heal) {
        super.a(size, heal);
        this.a(GenericAttributes.a).a(size * 3);
    }

    @Override
    public float bo() {
        return 1.0f;
    }

    @Override
    protected ParticleParam w() {
        return Particles.E;
    }

    @Override
    public boolean bN() {
        return false;
    }

    @Override
    protected int A() {
        return super.A() * 4;
    }

    @Override
    protected void ga() {
        this.d *= 0.9f;
    }

    @Override
    public void fb() {
        Vec3D vec3 = this.dp();
        float f2 = (float)this.gf() * 0.1f;
        this.o(vec3.c, this.eZ() + f2, vec3.e);
        this.au = true;
        this.actualJump = false;
    }

    @Override
    protected void c(TagKey<FluidType> fluid) {
        if (fluid == TagsFluid.b) {
            Vec3D vec3 = this.dp();
            this.o(vec3.c, 0.22f + (float)this.gf() * 0.05f, vec3.e);
            this.au = true;
        } else {
            super.c(fluid);
        }
    }

    @Override
    protected boolean gb() {
        return this.cY();
    }

    @Override
    protected float gc() {
        return super.gc() + 2.0f;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return this.gg() ? SoundEffects.nC : SoundEffects.nB;
    }

    @Override
    public SoundEffect n_() {
        return this.gg() ? SoundEffects.nt : SoundEffects.nA;
    }

    @Override
    protected SoundEffect gd() {
        return this.gg() ? SoundEffects.nF : SoundEffects.nE;
    }

    @Override
    protected SoundEffect ge() {
        return SoundEffects.nD;
    }
}

