/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalZombieAttack;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.entity.PigZombie;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.PigZombieAngerEvent;
import org.joml.Vector3f;

public class EntityPigZombie
extends EntityZombie
implements IEntityAngerable {
    private static final UUID c = UUID.fromString("49455A49-7EC5-45BA-B886-3B90B23A1718");
    private static final AttributeModifier d = new AttributeModifier(c, "Attacking speed boost", 0.05, AttributeModifier.Operation.a);
    private static final UniformInt bX = TimeRange.a(0, 1);
    private int bY;
    private static final UniformInt bZ = TimeRange.a(20, 39);
    private int ca;
    @Nullable
    private UUID cb;
    private static final int cc = 10;
    private static final UniformInt cd = TimeRange.a(4, 6);
    private int ce;
    private static final float cf = 1.79f;
    private static final float cg = 0.82f;
    private PathfinderGoalHurtByTarget pathfinderGoalHurtByTarget;

    public EntityPigZombie(EntityTypes<? extends EntityPigZombie> type, World world) {
        super((EntityTypes<? extends EntityZombie>)type, world);
        this.a(PathType.i, 8.0f);
    }

    @Override
    public boolean isRidable() {
        return this.dM().purpurConfig.zombifiedPiglinRidable;
    }

    @Override
    public boolean bQ() {
        return this.dM().purpurConfig.useDismountsUnderwaterTag ? super.bQ() : !this.dM().purpurConfig.zombifiedPiglinRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.dM().purpurConfig.zombifiedPiglinControllable;
    }

    @Override
    public void initAttributes() {
        this.a(GenericAttributes.l).a(this.dM().purpurConfig.zombifiedPiglinMaxHealth);
    }

    @Override
    public boolean fh() {
        return this.dM().purpurConfig.zombifiedPiglinTakeDamageFromWater;
    }

    @Override
    public boolean jockeyOnlyBaby() {
        return this.dM().purpurConfig.zombifiedPiglinJockeyOnlyBaby;
    }

    @Override
    public double jockeyChance() {
        return this.dM().purpurConfig.zombifiedPiglinJockeyChance;
    }

    @Override
    public boolean jockeyTryExistingChickens() {
        return this.dM().purpurConfig.zombifiedPiglinJockeyTryExistingChickens;
    }

    @Override
    protected boolean ef() {
        return this.dM().purpurConfig.zombifiedPiglinAlwaysDropExp;
    }

    @Override
    public void a(@Nullable UUID angryAt) {
        this.cb = angryAt;
    }

    @Override
    protected void u() {
        this.bO.a(2, new PathfinderGoalZombieAttack(this, 1.0, false));
        this.bO.a(7, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.pathfinderGoalHurtByTarget = new PathfinderGoalHurtByTarget(this, new Class[0]).a(new Class[0]);
        this.bP.a(1, this.pathfinderGoalHurtByTarget);
        this.bP.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, this::a_));
        this.bP.a(3, new PathfinderGoalUniversalAngerReset<EntityPigZombie>(this, true));
    }

    public static AttributeProvider.Builder go() {
        return EntityZombie.gi().a(GenericAttributes.n, 0.0).a(GenericAttributes.m, 0.23f).a(GenericAttributes.c, 5.0);
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return this.o_() ? 0.96999997f : 1.79f;
    }

    @Override
    protected boolean gf() {
        return false;
    }

    @Override
    protected void Z() {
        AttributeModifiable attributemodifiable = this.a(GenericAttributes.m);
        if (this.aa_()) {
            if (!this.o_() && !attributemodifiable.a(d)) {
                attributemodifiable.b(d);
            }
            this.gp();
        } else if (attributemodifiable.a(d)) {
            attributemodifiable.b(d.a());
        }
        this.a((WorldServer)this.dM(), true);
        if (this.q() != null) {
            this.gq();
        }
        if (this.aa_() && this.dM().purpurConfig.zombifiedPiglinCountAsPlayerKillWhenAngry) {
            this.aZ = this.ah;
        }
        super.Z();
    }

    private void gp() {
        if (this.bY > 0) {
            --this.bY;
            if (this.bY == 0) {
                this.gs();
            }
        }
    }

    private void gq() {
        if (this.ce > 0) {
            --this.ce;
        } else {
            if (this.O().a(this.q())) {
                this.gr();
            }
            this.ce = cd.a(this.ag);
        }
    }

    private void gr() {
        double d0 = this.b(GenericAttributes.g);
        AxisAlignedBB axisalignedbb = AxisAlignedBB.a(this.dk()).c(d0, 10.0, d0);
        this.dM().a(EntityPigZombie.class, axisalignedbb, IEntitySelector.f).stream().filter(entitypigzombie -> entitypigzombie != this).filter(entitypigzombie -> entitypigzombie.q() == null).filter(entitypigzombie -> !entitypigzombie.s(this.q())).forEach(entitypigzombie -> entitypigzombie.setTarget(this.q(), EntityTargetEvent.TargetReason.TARGET_ATTACKED_NEARBY_ENTITY, true));
    }

    private void gs() {
        this.a(SoundEffects.Cp, this.eW() * 2.0f, this.eX() * 1.8f);
    }

    @Override
    public boolean setTarget(@Nullable EntityLiving entityliving, EntityTargetEvent.TargetReason reason, boolean fireEvent) {
        if (this.q() == null && entityliving != null) {
            this.bY = bX.a(this.ag);
            this.ce = cd.a(this.ag);
        }
        if (entityliving instanceof EntityHuman && this.dM().purpurConfig.zombifiedPiglinCountAsPlayerKillWhenAngry) {
            this.c((EntityHuman)entityliving);
        }
        return super.setTarget(entityliving, reason, fireEvent);
    }

    @Override
    public void c() {
        Entity entity = ((WorldServer)this.dM()).a(this.b());
        PigZombieAngerEvent event = new PigZombieAngerEvent((PigZombie)this.getBukkitEntity(), (org.bukkit.entity.Entity)(entity == null ? null : entity.getBukkitEntity()), bZ.a(this.ag));
        this.dM().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            this.a((UUID)null);
            this.pathfinderGoalHurtByTarget.d();
            return;
        }
        this.a(event.getNewAnger());
    }

    public static boolean b(EntityTypes<EntityPigZombie> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, RandomSource random) {
        return world.ak() != EnumDifficulty.a && !world.a_(pos.d()).a(Blocks.kK);
    }

    @Override
    public boolean a(IWorldReader world) {
        return world.f(this) && !world.d(this.cH());
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        this.c(nbt);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.a(this.dM(), nbt);
    }

    @Override
    public void a(int angerTime) {
        this.ca = angerTime;
    }

    @Override
    public int a() {
        return this.ca;
    }

    @Override
    protected SoundEffect y() {
        return this.aa_() ? SoundEffects.Cp : SoundEffects.Co;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.Cr;
    }

    @Override
    public SoundEffect n_() {
        return SoundEffects.Cq;
    }

    @Override
    protected void a(RandomSource random, DifficultyDamageScaler localDifficulty) {
        this.a(EnumItemSlot.a, new ItemStack(Items.oS));
    }

    @Override
    protected ItemStack ge() {
        return ItemStack.f;
    }

    @Override
    protected void gn() {
        this.a(GenericAttributes.n).a(this.ag.j() * this.dM().purpurConfig.zombifiedPiglinSpawnReinforcements);
    }

    @Override
    @Nullable
    public UUID b() {
        return this.cb;
    }

    @Override
    public boolean f(EntityHuman player) {
        return this.a_((EntityLiving)player);
    }

    @Override
    public boolean k(ItemStack stack) {
        return this.j(stack);
    }

    @Override
    protected Vector3f a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        return new Vector3f(0.0f, dimensions.b + 0.05f * scaleFactor, 0.0f);
    }
}

