/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import io.papermc.paper.event.entity.ShulkerDuplicateEvent;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.script.ScriptException;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityGolem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityShulkerBullet;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftLocation;
import org.bukkit.entity.Shulker;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.purpurmc.purpur.controller.LookControllerWASD;
import org.purpurmc.purpur.entity.ai.HasRider;

public class EntityShulker
extends EntityGolem
implements VariantHolder<Optional<EnumColor>>,
IMonster {
    private static final UUID e = UUID.fromString("7E0292F2-9434-48D5-A29F-9583AF7DF27F");
    private static final AttributeModifier bT = new AttributeModifier(e, "Covered armor bonus", 20.0, AttributeModifier.Operation.a);
    protected static final DataWatcherObject<EnumDirection> b = DataWatcher.a(EntityShulker.class, DataWatcherRegistry.p);
    protected static final DataWatcherObject<Byte> c = DataWatcher.a(EntityShulker.class, DataWatcherRegistry.a);
    public static final DataWatcherObject<Byte> d = DataWatcher.a(EntityShulker.class, DataWatcherRegistry.a);
    private static final int bU = 6;
    private static final byte bV = 16;
    private static final byte bW = 16;
    private static final int bX = 8;
    private static final int bY = 8;
    private static final int bZ = 5;
    private static final float ca = 0.05f;
    static final Vector3f cb = SystemUtils.a(() -> {
        BaseBlockPosition baseblockposition = EnumDirection.d.q();
        return new Vector3f((float)baseblockposition.u(), (float)baseblockposition.v(), (float)baseblockposition.w());
    });
    private float cc;
    private float cd;
    @Nullable
    private BlockPosition ce;
    private int cf;
    private static final float cg = 1.0f;

    public EntityShulker(EntityTypes<? extends EntityShulker> type, World world) {
        super((EntityTypes<? extends EntityGolem>)type, world);
        this.bJ = 5;
        this.bK = new d(this);
    }

    @Override
    public boolean isRidable() {
        return this.dM().purpurConfig.shulkerRidable;
    }

    @Override
    public boolean bQ() {
        return this.dM().purpurConfig.useDismountsUnderwaterTag ? super.bQ() : !this.dM().purpurConfig.shulkerRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.dM().purpurConfig.shulkerControllable;
    }

    @Override
    public void initAttributes() {
        this.a(GenericAttributes.l).a(this.dM().purpurConfig.shulkerMaxHealth);
    }

    @Override
    public boolean fh() {
        return this.dM().purpurConfig.shulkerTakeDamageFromWater;
    }

    @Override
    protected EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemDye dye;
        Item item;
        ItemStack itemstack = player.b(hand);
        if (player.dM().purpurConfig.shulkerChangeColorWithDye && (item = itemstack.d()) instanceof ItemDye && (dye = (ItemDye)item).d() != this.gf()) {
            this.a(Optional.of(dye.d()));
            if (!player.fT().d) {
                itemstack.h(1);
            }
            return EnumInteractionResult.a;
        }
        return super.b(player, hand);
    }

    @Override
    protected boolean ef() {
        return this.dM().purpurConfig.shulkerAlwaysDropExp;
    }

    @Override
    protected void B() {
        this.bO.a(0, new HasRider(this));
        this.bO.a(1, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f, 0.02f, true));
        this.bO.a(4, new a());
        this.bO.a(7, new f());
        this.bO.a(8, new PathfinderGoalRandomLookaround(this));
        this.bP.a(0, new HasRider(this));
        this.bP.a(1, new PathfinderGoalHurtByTarget(this, this.getClass()).a(new Class[0]));
        this.bP.a(2, new e(this));
        this.bP.a(3, new c(this));
    }

    @Override
    protected Entity.MovementEmission aW() {
        return Entity.MovementEmission.a;
    }

    @Override
    public SoundCategory db() {
        return SoundCategory.f;
    }

    @Override
    protected SoundEffect y() {
        return SoundEffects.vO;
    }

    @Override
    public void R() {
        if (!this.gj()) {
            super.R();
        }
    }

    @Override
    public SoundEffect n_() {
        return SoundEffects.vU;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return this.gj() ? SoundEffects.vW : SoundEffects.vV;
    }

    @Override
    protected void c_() {
        super.c_();
        this.an.a(b, EnumDirection.a);
        this.an.a(c, (byte)0);
        this.an.a(d, (byte)16);
    }

    public static AttributeProvider.Builder u() {
        return EntityInsentient.C().a(GenericAttributes.l, 30.0);
    }

    @Override
    protected EntityAIBodyControl H() {
        return new b(this);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.a(EnumDirection.a(nbt.f("AttachFace")));
        this.an.b(c, nbt.f("Peek"));
        if (nbt.b("Color", 99)) {
            this.an.b(d, nbt.f("Color"));
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("AttachFace", (byte)this.A().d());
        nbt.a("Peek", this.an.b(c));
        nbt.a("Color", this.an.b(d));
    }

    @Override
    public void l() {
        super.l();
        if (!(this.dM().B || this.bO() || this.a(this.dm(), this.A()))) {
            this.gg();
        }
        if (this.gh()) {
            this.gi();
        }
        if (this.dM().B) {
            if (this.cf > 0) {
                --this.cf;
            } else {
                this.ce = null;
            }
        }
    }

    private void gg() {
        EnumDirection enumdirection = this.i(this.dm());
        if (enumdirection != null) {
            this.a(enumdirection);
        } else {
            this.w();
        }
    }

    @Override
    protected AxisAlignedBB aq() {
        float f2 = EntityShulker.G(this.cd);
        EnumDirection enumdirection = this.A().g();
        float f1 = this.ai().k() / 2.0f;
        return EntityShulker.a(enumdirection, f2).d(this.dr() - (double)f1, this.dt(), this.dx() - (double)f1);
    }

    private static float G(float openProgress) {
        return 0.5f - MathHelper.a((0.5f + openProgress) * (float)Math.PI) * 0.5f;
    }

    private boolean gh() {
        this.cc = this.cd;
        float f2 = (float)this.gl() * 0.01f;
        if (this.cd == f2) {
            return false;
        }
        this.cd = this.cd > f2 ? MathHelper.a(this.cd - 0.05f, f2, 1.0f) : MathHelper.a(this.cd + 0.05f, 0.0f, f2);
        return true;
    }

    private void gi() {
        this.ar();
        float f2 = EntityShulker.G(this.cd);
        float f1 = EntityShulker.G(this.cc);
        EnumDirection enumdirection = this.A().g();
        float f22 = f2 - f1;
        if (f22 > 0.0f) {
            List<Entity> list = this.dM().a((Entity)this, EntityShulker.a(enumdirection, f1, f2).d(this.dr() - 0.5, this.dt(), this.dx() - 0.5), IEntitySelector.f.and(entity -> !entity.y(this)));
            for (Entity entity2 : list) {
                if (entity2 instanceof EntityShulker || entity2.af) continue;
                entity2.a(EnumMoveType.e, new Vec3D(f22 * (float)enumdirection.j(), f22 * (float)enumdirection.k(), f22 * (float)enumdirection.l()));
            }
        }
    }

    public static AxisAlignedBB a(EnumDirection direction, float extraLength) {
        return EntityShulker.a(direction, -1.0f, extraLength);
    }

    public static AxisAlignedBB a(EnumDirection direction, float prevExtraLength, float extraLength) {
        double d0 = Math.max(prevExtraLength, extraLength);
        double d1 = Math.min(prevExtraLength, extraLength);
        return new AxisAlignedBB(BlockPosition.b).b((double)direction.j() * d0, (double)direction.k() * d0, (double)direction.l() * d0).a((double)(-direction.j()) * (1.0 + d1), (double)(-direction.k()) * (1.0 + d1), (double)(-direction.l()) * (1.0 + d1));
    }

    @Override
    public boolean a(Entity entity, boolean force) {
        if (this.dM().y_()) {
            this.ce = null;
            this.cf = 0;
        }
        this.a(EnumDirection.a);
        return super.a(entity, force);
    }

    @Override
    public void ac() {
        super.ac();
        if (this.dM().B) {
            this.ce = this.dm();
        }
        this.aV = 0.0f;
        this.aU = 0.0f;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        this.r(0.0f);
        this.aW = this.dC();
        this.bp();
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    public void a(EnumMoveType movementType, Vec3D movement) {
        if (movementType == EnumMoveType.d) {
            this.w();
        } else {
            super.a(movementType, movement);
        }
    }

    @Override
    public Vec3D dp() {
        return Vec3D.b;
    }

    @Override
    public void g(Vec3D velocity) {
    }

    @Override
    public void a_(double x2, double y2, double z2) {
        BlockPosition blockposition1;
        BlockPosition blockposition = this.dm();
        if (this.bO()) {
            super.a_(x2, y2, z2);
        } else {
            super.a_((double)MathHelper.a(x2) + 0.5, MathHelper.a(y2 + 0.5), (double)MathHelper.a(z2) + 0.5);
        }
        if (this.ah != 0 && !(blockposition1 = this.dm()).equals(blockposition)) {
            this.an.b(c, (byte)0);
            this.au = true;
            if (this.dM().B && !this.bO() && !blockposition1.equals(this.ce)) {
                this.ce = blockposition;
                this.cf = 6;
                this.ac = this.dr();
                this.ad = this.dt();
                this.ae = this.dx();
            }
        }
    }

    @Nullable
    protected EnumDirection i(BlockPosition pos) {
        for (EnumDirection enumdirection : EnumDirection.values()) {
            if (!this.a(pos, enumdirection)) continue;
            return enumdirection;
        }
        return null;
    }

    boolean a(BlockPosition pos, EnumDirection direction) {
        if (this.j(pos)) {
            return false;
        }
        EnumDirection enumdirection1 = direction.g();
        if (!this.dM().a(pos.a(direction), (Entity)this, enumdirection1)) {
            return false;
        }
        AxisAlignedBB axisalignedbb = EntityShulker.a(enumdirection1, 1.0f).a(pos).h(1.0E-6);
        return this.dM().a((Entity)this, axisalignedbb);
    }

    private boolean j(BlockPosition pos) {
        IBlockData iblockdata = this.dM().a_(pos);
        if (iblockdata.i()) {
            return false;
        }
        boolean flag = iblockdata.a(Blocks.bQ) && pos.equals(this.dm());
        return !flag;
    }

    protected boolean w() {
        if (!this.fU() && this.bx()) {
            BlockPosition blockposition = this.dm();
            for (int i2 = 0; i2 < 5; ++i2) {
                EnumDirection enumdirection;
                BlockPosition blockposition1 = blockposition.b(MathHelper.b(this.ag, -8, 8), MathHelper.b(this.ag, -8, 8), MathHelper.b(this.ag, -8, 8));
                if (blockposition1.v() <= this.dM().J_() || !this.dM().u(blockposition1) || !this.dM().D_().a(blockposition1) || !this.dM().a((Entity)this, new AxisAlignedBB(blockposition1).h(1.0E-6)) || (enumdirection = this.i(blockposition1)) == null) continue;
                EntityTeleportEvent teleportEvent = CraftEventFactory.callEntityTeleportEvent(this, blockposition1.u(), blockposition1.v(), blockposition1.w());
                if (teleportEvent.isCancelled() || teleportEvent.getTo() == null) {
                    return false;
                }
                blockposition1 = CraftLocation.toBlockPosition(teleportEvent.getTo());
                this.ag();
                this.a(enumdirection);
                this.a(SoundEffects.vZ, 1.0f, 1.0f);
                this.a_((double)blockposition1.u() + 0.5, blockposition1.v(), (double)blockposition1.w() + 0.5);
                this.dM().a(GameEvent.R, blockposition, GameEvent.a.a(this));
                this.an.b(c, (byte)0);
                this.h((EntityLiving)null);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void a(double x2, double y2, double z2, float yaw, float pitch, int interpolationSteps) {
        this.bn = 0;
        this.a_(x2, y2, z2);
        this.a(yaw, pitch);
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        Entity entity;
        if (this.gj() && (entity = source.c()) instanceof EntityArrow) {
            return false;
        }
        if (!super.a(source, amount)) {
            return false;
        }
        if ((double)this.ev() < (double)this.eM() * 0.5 && this.ag.a(4) == 0) {
            this.w();
        } else if (source.a(DamageTypeTags.k) && (entity = source.c()) != null && entity.ai() == EntityTypes.aI) {
            this.gk();
        }
        return true;
    }

    private boolean gj() {
        return this.gl() == 0;
    }

    private void gk() {
        Vec3D vec3d = this.dk();
        AxisAlignedBB axisalignedbb = this.cH();
        if (!(this.dM().purpurConfig.shulkerSpawnFromBulletRequireOpenLid && this.gj() || !this.w())) {
            EntityShulker entityshulker;
            float chance = this.dM().purpurConfig.shulkerSpawnFromBulletBaseChance;
            if (!this.dM().purpurConfig.shulkerSpawnFromBulletNearbyEquation.isBlank()) {
                int nearby = this.dM().a(EntityTypes.aH, axisalignedbb.g(this.dM().purpurConfig.shulkerSpawnFromBulletNearbyRange), Entity::bx).size();
                try {
                    chance -= ((Number)Entity.scriptEngine.eval("let nearby = " + nearby + "; " + this.dM().purpurConfig.shulkerSpawnFromBulletNearbyEquation)).floatValue();
                }
                catch (ScriptException e2) {
                    e2.printStackTrace();
                    chance -= (float)(nearby - 1) / 5.0f;
                }
            }
            if (this.dM().z.i() <= chance && (entityshulker = EntityTypes.aH.a(this.dM())) != null) {
                entityshulker.a(this.ge());
                entityshulker.e(vec3d);
                if (!new ShulkerDuplicateEvent((Shulker)entityshulker.getBukkitEntity(), (Shulker)this.getBukkitEntity()).callEvent()) {
                    return;
                }
                this.dM().addFreshEntity(entityshulker, CreatureSpawnEvent.SpawnReason.BREEDING);
            }
        }
    }

    @Override
    public boolean bz() {
        return this.bx();
    }

    public EnumDirection A() {
        return this.an.b(b);
    }

    @Override
    public void a(EnumDirection face) {
        this.an.b(b, face);
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (b.equals(data)) {
            this.a(this.aq());
        }
        super.a(data);
    }

    public int gl() {
        return this.an.b(c).byteValue();
    }

    public void b(int peekAmount) {
        if (!this.dM().B) {
            this.a(GenericAttributes.a).b(bT.a());
            if (peekAmount == 0) {
                this.a(GenericAttributes.a).c(bT);
                this.a(SoundEffects.vT, 1.0f, 1.0f);
                this.a(GameEvent.j);
            } else {
                this.a(SoundEffects.vX, 1.0f, 1.0f);
                this.a(GameEvent.k);
            }
        }
        this.an.b(c, (byte)peekAmount);
    }

    public float E(float delta) {
        return MathHelper.i(delta, this.cc, this.cd);
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return 0.5f;
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        this.aU = 0.0f;
        this.aV = 0.0f;
    }

    @Override
    public int aa() {
        return 180;
    }

    @Override
    public int ab() {
        return 180;
    }

    @Override
    public void g(Entity entity) {
    }

    public Optional<Vec3D> F(float tickDelta) {
        if (this.ce != null && this.cf > 0) {
            double d0 = (double)((float)this.cf - tickDelta) / 6.0;
            d0 *= d0;
            BlockPosition blockposition = this.dm();
            double d1 = (double)(blockposition.u() - this.ce.u()) * d0;
            double d2 = (double)(blockposition.v() - this.ce.v()) * d0;
            double d3 = (double)(blockposition.w() - this.ce.w()) * d0;
            return Optional.of(new Vec3D(-d1, -d2, -d3));
        }
        return Optional.empty();
    }

    @Override
    public void a(Optional<EnumColor> variant) {
        this.an.b(d, variant.map(enumcolor -> (byte)enumcolor.a()).orElse((byte)16));
    }

    public Optional<EnumColor> ge() {
        return Optional.ofNullable(this.dM().purpurConfig.shulkerSpawnFromBulletRandomColor ? EnumColor.random(this.dM().z) : this.gf());
    }

    @Nullable
    public EnumColor gf() {
        byte b0 = this.an.b(d);
        return b0 != 16 && b0 <= 15 ? EnumColor.a(b0) : null;
    }

    private class d
    extends LookControllerWASD {
        public d(EntityInsentient entity) {
            super(entity);
        }

        @Override
        protected void b() {
        }

        @Override
        protected Optional<Float> i() {
            EnumDirection enumdirection = EntityShulker.this.A().g();
            Vector3f vector3f = enumdirection.b().transform(new Vector3f((Vector3fc)cb));
            BaseBlockPosition baseblockposition = enumdirection.q();
            Vector3f vector3f1 = new Vector3f((float)baseblockposition.u(), (float)baseblockposition.v(), (float)baseblockposition.w());
            vector3f1.cross((Vector3fc)vector3f);
            double d0 = this.e - this.a.dr();
            double d1 = this.f - this.a.dv();
            double d2 = this.g - this.a.dx();
            Vector3f vector3f2 = new Vector3f((float)d0, (float)d1, (float)d2);
            float f2 = vector3f1.dot((Vector3fc)vector3f2);
            float f1 = vector3f.dot((Vector3fc)vector3f2);
            return Math.abs(f2) <= 1.0E-5f && Math.abs(f1) <= 1.0E-5f ? Optional.empty() : Optional.of(Float.valueOf((float)(MathHelper.d((double)(-f2), (double)f1) * 57.2957763671875)));
        }

        @Override
        protected Optional<Float> h() {
            return Optional.of(Float.valueOf(0.0f));
        }
    }

    private class a
    extends PathfinderGoal {
        private int b;

        public a() {
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean a() {
            EntityLiving entityliving = EntityShulker.this.q();
            return entityliving != null && entityliving.bx() ? EntityShulker.this.dM().ak() != EnumDifficulty.a : false;
        }

        @Override
        public void c() {
            this.b = 20;
            EntityShulker.this.b(100);
        }

        @Override
        public void d() {
            EntityShulker.this.b(0);
        }

        @Override
        public boolean T_() {
            return true;
        }

        @Override
        public void e() {
            if (EntityShulker.this.dM().ak() != EnumDifficulty.a) {
                --this.b;
                EntityLiving entityliving = EntityShulker.this.q();
                if (entityliving != null) {
                    EntityShulker.this.I().a(entityliving, 180.0f, 180.0f);
                    double d0 = EntityShulker.this.f((Entity)entityliving);
                    if (d0 < 400.0) {
                        if (this.b <= 0) {
                            this.b = 20 + EntityShulker.this.ag.a(10) * 20 / 2;
                            EntityShulker.this.dM().b(new EntityShulkerBullet(EntityShulker.this.dM(), EntityShulker.this, entityliving, EntityShulker.this.A().o()));
                            EntityShulker.this.a(SoundEffects.vY, 2.0f, (EntityShulker.this.ag.i() - EntityShulker.this.ag.i()) * 0.2f + 1.0f);
                        }
                    } else {
                        EntityShulker.this.h((EntityLiving)null);
                    }
                    super.e();
                }
            }
        }
    }

    private class f
    extends PathfinderGoal {
        private int b;

        f() {
        }

        @Override
        public boolean a() {
            return EntityShulker.this.q() == null && EntityShulker.this.ag.a(net.minecraft.world.entity.monster.EntityShulker$f.b(40)) == 0 && EntityShulker.this.a(EntityShulker.this.dm(), EntityShulker.this.A());
        }

        @Override
        public boolean b() {
            return EntityShulker.this.q() == null && this.b > 0;
        }

        @Override
        public void c() {
            this.b = this.a(20 * (1 + EntityShulker.this.ag.a(3)));
            EntityShulker.this.b(30);
        }

        @Override
        public void d() {
            if (EntityShulker.this.q() == null) {
                EntityShulker.this.b(0);
            }
        }

        @Override
        public void e() {
            --this.b;
        }
    }

    private class e
    extends PathfinderGoalNearestAttackableTarget<EntityHuman> {
        public e(EntityShulker entityshulker) {
            super((EntityInsentient)entityshulker, EntityHuman.class, true);
        }

        @Override
        public boolean a() {
            return EntityShulker.this.dM().ak() == EnumDifficulty.a ? false : super.a();
        }

        @Override
        protected AxisAlignedBB a(double distance) {
            EnumDirection enumdirection = ((EntityShulker)this.e).A();
            return enumdirection.o() == EnumDirection.EnumAxis.a ? this.e.cH().c(4.0, distance, distance) : (enumdirection.o() == EnumDirection.EnumAxis.c ? this.e.cH().c(distance, distance, 4.0) : this.e.cH().c(distance, 4.0, distance));
        }
    }

    private static class c
    extends PathfinderGoalNearestAttackableTarget<EntityLiving> {
        public c(EntityShulker shulker) {
            super(shulker, EntityLiving.class, 10, true, false, entityliving -> entityliving instanceof IMonster);
        }

        @Override
        public boolean a() {
            return this.e.cg() == null ? false : super.a();
        }

        @Override
        protected AxisAlignedBB a(double distance) {
            EnumDirection enumdirection = ((EntityShulker)this.e).A();
            return enumdirection.o() == EnumDirection.EnumAxis.a ? this.e.cH().c(4.0, distance, distance) : (enumdirection.o() == EnumDirection.EnumAxis.c ? this.e.cH().c(distance, distance, 4.0) : this.e.cH().c(distance, 4.0, distance));
        }
    }

    private static class b
    extends EntityAIBodyControl {
        public b(EntityInsentient entity) {
            super(entity);
        }

        @Override
        public void a() {
        }
    }
}

