/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockMonsterEggs;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.joml.Vector3f;
import org.purpurmc.purpur.entity.ai.HasRider;

public class EntitySilverfish
extends EntityMonster {
    @Nullable
    private PathfinderGoalSilverfishWakeOthers b;

    public EntitySilverfish(EntityTypes<? extends EntitySilverfish> type, World world) {
        super((EntityTypes<? extends EntityMonster>)type, world);
    }

    @Override
    public boolean isRidable() {
        return this.dM().purpurConfig.silverfishRidable;
    }

    @Override
    public boolean bQ() {
        return this.dM().purpurConfig.useDismountsUnderwaterTag ? super.bQ() : !this.dM().purpurConfig.silverfishRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.dM().purpurConfig.silverfishControllable;
    }

    @Override
    public void initAttributes() {
        this.a(GenericAttributes.l).a(this.dM().purpurConfig.silverfishMaxHealth);
    }

    @Override
    public boolean fh() {
        return this.dM().purpurConfig.silverfishTakeDamageFromWater;
    }

    @Override
    protected boolean ef() {
        return this.dM().purpurConfig.silverfishAlwaysDropExp;
    }

    @Override
    protected void B() {
        this.b = new PathfinderGoalSilverfishWakeOthers(this);
        this.bO.a(1, new PathfinderGoalFloat(this));
        this.bO.a(1, new HasRider(this));
        this.bO.a(1, new ClimbOnTopOfPowderSnowGoal(this, this.dM()));
        this.bO.a(3, this.b);
        this.bO.a(4, new PathfinderGoalMeleeAttack(this, 1.0, false));
        this.bO.a(5, new PathfinderGoalSilverfishHideInBlock(this));
        this.bP.a(0, new HasRider(this));
        this.bP.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]).a(new Class[0]));
        this.bP.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return 0.13f;
    }

    public static AttributeProvider.Builder u() {
        return EntityMonster.gk().a(GenericAttributes.l, 8.0).a(GenericAttributes.m, 0.25).a(GenericAttributes.c, 1.0);
    }

    @Override
    protected Entity.MovementEmission aW() {
        return Entity.MovementEmission.c;
    }

    @Override
    protected SoundEffect y() {
        return SoundEffects.wa;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.wc;
    }

    @Override
    public SoundEffect n_() {
        return SoundEffects.wb;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.wd, 0.15f, 1.0f);
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.b(source)) {
            return false;
        }
        if ((source.d() != null || source.a(DamageTypeTags.y)) && this.b != null) {
            this.b.h();
        }
        return super.a(source, amount);
    }

    @Override
    public void l() {
        this.aU = this.dC();
        super.l();
    }

    @Override
    public void o(float bodyYaw) {
        this.r(bodyYaw);
        super.o(bodyYaw);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        return BlockMonsterEggs.h(world.a_(pos.d())) ? 10.0f : super.a(pos, world);
    }

    public static boolean b(EntityTypes<EntitySilverfish> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, RandomSource random) {
        if (EntitySilverfish.c(type, world, spawnReason, pos, random)) {
            EntityHuman entityhuman = world.a((double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, 5.0, true);
            return (entityhuman == null || entityhuman.affectsSpawning) && entityhuman == null;
        }
        return false;
    }

    @Override
    public EnumMonsterType eS() {
        return EnumMonsterType.c;
    }

    @Override
    protected Vector3f a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        return new Vector3f(0.0f, dimensions.b - 0.0625f * scaleFactor, 0.0f);
    }

    private static class PathfinderGoalSilverfishWakeOthers
    extends PathfinderGoal {
        private final EntitySilverfish a;
        private int b;

        public PathfinderGoalSilverfishWakeOthers(EntitySilverfish silverfish) {
            this.a = silverfish;
        }

        public void h() {
            if (this.b == 0) {
                this.b = this.a(20);
            }
        }

        @Override
        public boolean a() {
            return this.b > 0;
        }

        @Override
        public void e() {
            --this.b;
            if (this.b <= 0) {
                World world = this.a.dM();
                RandomSource randomsource = this.a.eg();
                BlockPosition blockposition = this.a.dm();
                int i2 = 0;
                while (i2 <= 5 && i2 >= -5) {
                    int j2 = 0;
                    while (j2 <= 10 && j2 >= -10) {
                        int k2 = 0;
                        while (k2 <= 10 && k2 >= -10) {
                            BlockPosition blockposition1 = blockposition.b(j2, i2, k2);
                            IBlockData iblockdata = world.a_(blockposition1);
                            Block block = iblockdata.b();
                            if (block instanceof BlockMonsterEggs) {
                                IBlockData afterState;
                                IBlockData iBlockData = afterState = world.Z().b(GameRules.c) ? iblockdata.u().g() : ((BlockMonsterEggs)block).o(world.a_(blockposition1));
                                if (CraftEventFactory.callEntityChangeBlockEvent(this.a, blockposition1, afterState)) {
                                    if (world.purpurConfig.silverfishBypassMobGriefing || world.Z().b(GameRules.c)) {
                                        world.a(blockposition1, true, this.a);
                                    } else {
                                        world.a(blockposition1, ((BlockMonsterEggs)block).o(world.a_(blockposition1)), 3);
                                    }
                                    if (randomsource.h()) {
                                        return;
                                    }
                                }
                            }
                            k2 = (k2 <= 0 ? 1 : 0) - k2;
                        }
                        j2 = (j2 <= 0 ? 1 : 0) - j2;
                    }
                    i2 = (i2 <= 0 ? 1 : 0) - i2;
                }
            }
        }
    }

    private static class PathfinderGoalSilverfishHideInBlock
    extends PathfinderGoalRandomStroll {
        @Nullable
        private EnumDirection i;
        private boolean j;

        public PathfinderGoalSilverfishHideInBlock(EntitySilverfish silverfish) {
            super(silverfish, 1.0, 10);
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean a() {
            if (this.b.q() != null) {
                return false;
            }
            if (!this.b.N().l()) {
                return false;
            }
            RandomSource randomsource = this.b.eg();
            if ((this.b.dM().purpurConfig.silverfishBypassMobGriefing || this.b.dM().Z().b(GameRules.c)) && randomsource.a(PathfinderGoalSilverfishHideInBlock.b(10)) == 0) {
                this.i = EnumDirection.b(randomsource);
                BlockPosition blockposition = BlockPosition.a(this.b.dr(), this.b.dt() + 0.5, this.b.dx()).a(this.i);
                IBlockData iblockdata = this.b.dM().a_(blockposition);
                if (BlockMonsterEggs.h(iblockdata)) {
                    this.j = true;
                    return true;
                }
            }
            this.j = false;
            return super.a();
        }

        @Override
        public boolean b() {
            return this.j ? false : super.b();
        }

        @Override
        public void c() {
            if (!this.j) {
                super.c();
            } else {
                BlockPosition blockposition;
                World world = this.b.dM();
                IBlockData iblockdata = world.a_(blockposition = BlockPosition.a(this.b.dr(), this.b.dt() + 0.5, this.b.dx()).a(this.i));
                if (BlockMonsterEggs.h(iblockdata)) {
                    if (!CraftEventFactory.callEntityChangeBlockEvent(this.b, blockposition, BlockMonsterEggs.n(iblockdata))) {
                        return;
                    }
                    world.a(blockposition, BlockMonsterEggs.n(iblockdata), 3);
                    this.b.S();
                    this.b.discard(EntityRemoveEvent.Cause.ENTER_BLOCK);
                }
            }
        }
    }
}

