/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.destroystokyo.paper.event.entity.EntityTransformedEvent;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntitySkeletonAbstract;
import net.minecraft.world.entity.monster.EntitySkeletonStray;
import net.minecraft.world.entity.monster.EntitySkeletonWither;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTransformEvent;

public class EntitySkeleton
extends EntitySkeletonAbstract {
    private static final int c = 300;
    public static final DataWatcherObject<Boolean> d = DataWatcher.a(EntitySkeleton.class, DataWatcherRegistry.k);
    public static final String b = "StrayConversionTime";
    public int e;
    public int bT;
    private int witherRosesFed = 0;

    public EntitySkeleton(EntityTypes<? extends EntitySkeleton> type, World world) {
        super((EntityTypes<? extends EntitySkeletonAbstract>)type, world);
    }

    @Override
    public boolean isRidable() {
        return this.dM().purpurConfig.skeletonRidable;
    }

    @Override
    public boolean bQ() {
        return this.dM().purpurConfig.useDismountsUnderwaterTag ? super.bQ() : !this.dM().purpurConfig.skeletonRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.dM().purpurConfig.skeletonControllable;
    }

    @Override
    public void initAttributes() {
        this.a(GenericAttributes.l).a(this.dM().purpurConfig.skeletonMaxHealth);
    }

    @Override
    public boolean fh() {
        return this.dM().purpurConfig.skeletonTakeDamageFromWater;
    }

    @Override
    protected boolean ef() {
        return this.dM().purpurConfig.skeletonAlwaysDropExp;
    }

    @Override
    protected void c_() {
        super.c_();
        this.an().a(d, false);
    }

    public boolean gf() {
        return this.an().b(d);
    }

    public void w(boolean converting) {
        this.an.b(d, converting);
    }

    @Override
    public boolean ge() {
        return this.gf();
    }

    @Override
    public void l() {
        if (!this.dM().B && this.bx() && !this.fU()) {
            if (this.aA) {
                if (this.gf()) {
                    --this.bT;
                    if (this.bT < 0) {
                        this.gg();
                    }
                } else {
                    ++this.e;
                    if (this.e >= 140) {
                        this.b(300);
                    }
                }
            } else {
                this.e = -1;
                this.w(false);
            }
        }
        super.l();
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a(b, this.gf() ? this.bT : -1);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        if (nbt.b(b, 99) && nbt.h(b) > -1) {
            this.b(nbt.h(b));
        }
    }

    public void b(int time) {
        this.bT = time;
        this.w(true);
    }

    protected void gg() {
        EntitySkeletonStray stray = this.convertTo(EntityTypes.aV, true, EntityTransformEvent.TransformReason.FROZEN, CreatureSpawnEvent.SpawnReason.FROZEN);
        if (!this.aU()) {
            this.dM().a((EntityHuman)null, 1048, this.dm(), 0);
        }
        if (stray == null) {
            this.bT = 300;
        }
    }

    @Override
    public boolean dA() {
        return false;
    }

    @Override
    protected SoundEffect y() {
        return SoundEffects.we;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.wp;
    }

    @Override
    public SoundEffect n_() {
        return SoundEffects.wg;
    }

    @Override
    SoundEffect w() {
        return SoundEffects.wr;
    }

    @Override
    protected void a(DamageSource source, int lootingMultiplier, boolean allowDrops) {
        EntityCreeper entitycreeper;
        super.a(source, lootingMultiplier, allowDrops);
        Entity entity = source.d();
        if (entity instanceof EntityCreeper && (entitycreeper = (EntityCreeper)entity).gf()) {
            entitycreeper.gg();
            this.a((IMaterial)Items.ue);
        }
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack stack = player.b(hand);
        if (this.dM().purpurConfig.skeletonFeedWitherRoses > 0 && this.ai() != EntityTypes.bn && stack.d() == Blocks.cd.k()) {
            return this.feedWitherRose(player, stack);
        }
        return super.b(player, hand);
    }

    private EnumInteractionResult feedWitherRose(EntityHuman player, ItemStack stack) {
        if (++this.witherRosesFed < this.dM().purpurConfig.skeletonFeedWitherRoses) {
            if (!player.fT().d) {
                stack.h(1);
            }
            return EnumInteractionResult.b;
        }
        EntitySkeletonWither skeleton = EntityTypes.bn.a(this.dM());
        if (skeleton == null) {
            return EnumInteractionResult.d;
        }
        skeleton.b(this.dr(), this.dt(), this.dx(), this.dC(), this.dE());
        skeleton.c(this.ev());
        skeleton.v(this.fW());
        skeleton.v(this);
        skeleton.o(this.aU);
        skeleton.n(this.cp());
        skeleton.N = this.N;
        skeleton.O = this.O;
        if (this.ae()) {
            skeleton.b(this.af());
        }
        if (CraftEventFactory.callEntityTransformEvent((EntityLiving)this, skeleton, EntityTransformEvent.TransformReason.INFECTION).isCancelled()) {
            return EnumInteractionResult.d;
        }
        if (!new EntityTransformedEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)skeleton.getBukkitEntity(), EntityTransformedEvent.TransformedReason.INFECTED).callEvent()) {
            return EnumInteractionResult.d;
        }
        this.dM().b(skeleton);
        this.remove(Entity.RemovalReason.b, EntityRemoveEvent.Cause.DISCARD);
        if (!player.fT().d) {
            stack.h(1);
        }
        for (int i2 = 0; i2 < 15; ++i2) {
            ((WorldServer)this.dM()).sendParticles(((WorldServer)this.dM()).x(), null, Particles.M, this.dr() + (double)this.ag.i(), this.dt() + (double)(this.ag.i() * 2.0f), this.dx() + (double)this.ag.i(), 1, this.ag.k() * 0.05, this.ag.k() * 0.05, this.ag.k() * 0.05, 0.0, true);
        }
        return EnumInteractionResult.a;
    }
}

