/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import net.minecraft.core.BlockPosition;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.monster.EntitySkeletonAbstract;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityTippedArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;

public class EntitySkeletonStray
extends EntitySkeletonAbstract {
    public EntitySkeletonStray(EntityTypes<? extends EntitySkeletonStray> type, World world) {
        super((EntityTypes<? extends EntitySkeletonAbstract>)type, world);
    }

    @Override
    public boolean isRidable() {
        return this.dM().purpurConfig.strayRidable;
    }

    @Override
    public boolean bQ() {
        return this.dM().purpurConfig.useDismountsUnderwaterTag ? super.bQ() : !this.dM().purpurConfig.strayRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.dM().purpurConfig.strayControllable;
    }

    @Override
    public void initAttributes() {
        this.a(GenericAttributes.l).a(this.dM().purpurConfig.strayMaxHealth);
    }

    @Override
    public boolean fh() {
        return this.dM().purpurConfig.strayTakeDamageFromWater;
    }

    @Override
    protected boolean ef() {
        return this.dM().purpurConfig.strayAlwaysDropExp;
    }

    public static boolean a(EntityTypes<EntitySkeletonStray> type, WorldAccess world, EnumMobSpawn spawnReason, BlockPosition pos, RandomSource random) {
        BlockPosition blockPos = pos;
        while (world.a_(blockPos = blockPos.c()).a(Blocks.qP)) {
        }
        return EntitySkeletonStray.b(type, world, spawnReason, pos, random) && (EnumMobSpawn.a(spawnReason) || world.h(blockPos.d()));
    }

    @Override
    protected SoundEffect y() {
        return SoundEffects.yp;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.yr;
    }

    @Override
    public SoundEffect n_() {
        return SoundEffects.yq;
    }

    @Override
    SoundEffect w() {
        return SoundEffects.ys;
    }

    @Override
    protected EntityArrow b(ItemStack arrow, float damageModifier) {
        EntityArrow abstractArrow = super.b(arrow, damageModifier);
        if (abstractArrow instanceof EntityTippedArrow) {
            ((EntityTippedArrow)abstractArrow).a(new MobEffect(MobEffects.b, 600));
        }
        return abstractArrow;
    }
}

