/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.destroystokyo.paper.event.entity.SlimeChangeDirectionEvent;
import com.destroystokyo.paper.event.entity.SlimeSwimEvent;
import com.destroystokyo.paper.event.entity.SlimeTargetLivingEntityEvent;
import com.destroystokyo.paper.event.entity.SlimeWanderEvent;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.script.ScriptException;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Slime;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.SlimeSplitEvent;
import org.joml.Vector3f;
import org.purpurmc.purpur.controller.MoveControllerWASD;
import org.purpurmc.purpur.entity.ai.HasRider;

public class EntitySlime
extends EntityInsentient
implements IMonster {
    private static final DataWatcherObject<Integer> bT = DataWatcher.a(EntitySlime.class, DataWatcherRegistry.b);
    public static final int b = 1;
    public static final int c = 127;
    public float d;
    public float e;
    public float bS;
    private boolean bU;
    protected boolean actualJump;
    private boolean canWander = true;

    public EntitySlime(EntityTypes<? extends EntitySlime> type, World world) {
        super((EntityTypes<? extends EntityInsentient>)type, world);
        this.cD();
        this.bL = new ControllerMoveSlime(this);
    }

    @Override
    public boolean isRidable() {
        return this.dM().purpurConfig.slimeRidable;
    }

    @Override
    public boolean fh() {
        return this.dM().purpurConfig.slimeTakeDamageFromWater;
    }

    @Override
    protected boolean ef() {
        return this.dM().purpurConfig.slimeAlwaysDropExp;
    }

    @Override
    public boolean bQ() {
        return this.dM().purpurConfig.useDismountsUnderwaterTag ? super.bQ() : !this.dM().purpurConfig.slimeRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.dM().purpurConfig.slimeControllable;
    }

    @Override
    public float eZ() {
        float height = super.eZ();
        return this.getRider() != null && this.isControllable() && this.actualJump ? height * 1.5f : height;
    }

    @Override
    public boolean onSpacebar() {
        if (((Entity)this).aJ && this.getRider() != null && this.isControllable()) {
            this.actualJump = true;
            if (this.getRider().getForwardMot() == 0.0f || this.getRider().getStrafeMot() == 0.0f) {
                this.fb();
            }
        }
        return true;
    }

    protected String getMaxHealthEquation() {
        return this.dM().purpurConfig.slimeMaxHealth;
    }

    protected String getAttackDamageEquation() {
        return this.dM().purpurConfig.slimeAttackDamage;
    }

    protected Map<Integer, Double> getMaxHealthCache() {
        return this.dM().purpurConfig.slimeMaxHealthCache;
    }

    protected Map<Integer, Double> getAttackDamageCache() {
        return this.dM().purpurConfig.slimeAttackDamageCache;
    }

    protected double getFromCache(Supplier<String> equation, Supplier<Map<Integer, Double>> cache, Supplier<Double> defaultValue) {
        int size = this.gf();
        Double value = cache.get().get(size);
        if (value == null) {
            try {
                value = ((Number)Entity.scriptEngine.eval("let size = " + size + "; " + equation.get())).doubleValue();
            }
            catch (ScriptException e2) {
                e2.printStackTrace();
                value = defaultValue.get();
            }
            cache.get().put(size, value);
        }
        return value;
    }

    @Override
    protected void B() {
        this.bO.a(0, new HasRider(this));
        this.bO.a(1, new PathfinderGoalSlimeRandomJump(this));
        this.bO.a(2, new PathfinderGoalSlimeNearestPlayer(this));
        this.bO.a(3, new PathfinderGoalSlimeRandomDirection(this));
        this.bO.a(5, new PathfinderGoalSlimeIdle(this));
        this.bP.a(0, new HasRider(this));
        this.bP.a(1, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, entityliving -> Math.abs(entityliving.dt() - this.dt()) <= 4.0));
        this.bP.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
    }

    @Override
    public SoundCategory db() {
        return SoundCategory.f;
    }

    @Override
    protected void c_() {
        super.c_();
        this.an.a(bT, 1);
    }

    @VisibleForTesting
    public void a(int size, boolean heal) {
        int j2 = MathHelper.a(size, 1, 127);
        this.an.b(bT, j2);
        this.ar();
        this.k_();
        this.a(GenericAttributes.l).a(this.getFromCache(this::getMaxHealthEquation, this::getMaxHealthCache, () -> (double)size * (double)size));
        this.a(GenericAttributes.m).a(0.2f + 0.1f * (float)j2);
        this.a(GenericAttributes.c).a(this.getFromCache(this::getAttackDamageEquation, this::getAttackDamageCache, () -> j2));
        if (heal) {
            this.c(this.eM());
        }
        this.bJ = j2;
    }

    public int gf() {
        return this.an.b(bT);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("Paper.canWander", this.canWander);
        nbt.a("Size", this.gf() - 1);
        nbt.a("wasOnGround", this.bU);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        this.a(nbt.h("Size") + 1, false);
        super.a(nbt);
        if (nbt.e("Paper.canWander")) {
            this.canWander = nbt.q("Paper.canWander");
        }
        this.bU = nbt.q("wasOnGround");
    }

    public boolean gg() {
        return this.gf() <= 1;
    }

    protected ParticleParam w() {
        return Particles.S;
    }

    @Override
    protected boolean X() {
        return this.gf() > 0;
    }

    @Override
    public void l() {
        this.e += (this.d - this.e) * 0.5f;
        this.bS = this.e;
        super.l();
        if (this.aC() && !this.bU) {
            int i2 = this.gf();
            for (int j2 = 0; j2 < i2 * 8; ++j2) {
                float f2 = this.ag.i() * ((float)Math.PI * 2);
                float f1 = this.ag.i() * 0.5f + 0.5f;
                float f22 = MathHelper.a(f2) * (float)i2 * 0.5f * f1;
                float f3 = MathHelper.b(f2) * (float)i2 * 0.5f * f1;
                this.dM().a(this.w(), this.dr() + (double)f22, this.dt(), this.dx() + (double)f3, 0.0, 0.0, 0.0);
            }
            this.a(this.gd(), this.eW(), ((this.ag.i() - this.ag.i()) * 0.2f + 1.0f) / 0.8f);
            this.d = -0.5f;
        } else if (!this.aC() && this.bU) {
            this.d = 1.0f;
        }
        this.bU = this.aC();
        this.ga();
    }

    protected void ga() {
        this.d *= 0.6f;
    }

    protected int A() {
        return this.ag.a(20) + 10;
    }

    @Override
    public void k_() {
        double d0 = this.dr();
        double d1 = this.dt();
        double d2 = this.dx();
        super.k_();
        this.a_(d0, d1, d2);
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (bT.equals(data)) {
            this.k_();
            this.r(this.aW);
            this.aU = this.aW;
            if (this.aZ() && this.ag.a(20) == 0) {
                this.bi();
            }
        }
        super.a(data);
    }

    public EntityTypes<? extends EntitySlime> ai() {
        return super.ai();
    }

    @Override
    public void a(Entity.RemovalReason reason) {
        this.remove(reason, null);
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        int i2 = this.gf();
        if (!this.dM().B && i2 > 1 && this.ew()) {
            IChatBaseComponent ichatbasecomponent = this.af();
            boolean flag = this.fU();
            float f2 = (float)i2 / 4.0f;
            int j2 = i2 / 2;
            int k2 = 2 + this.ag.a(3);
            SlimeSplitEvent event = new SlimeSplitEvent((Slime)this.getBukkitEntity(), k2);
            this.dM().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled() || event.getCount() <= 0) {
                super.remove(entity_removalreason, cause);
                return;
            }
            k2 = event.getCount();
            ArrayList<EntityLiving> slimes = new ArrayList<EntityLiving>(j2);
            for (int l2 = 0; l2 < k2; ++l2) {
                float f1 = ((float)(l2 % 2) - 0.5f) * f2;
                float f22 = ((float)(l2 / 2) - 0.5f) * f2;
                EntitySlime entityslime = this.ai().a(this.dM());
                if (entityslime == null) continue;
                if (this.fL()) {
                    entityslime.fJ();
                }
                entityslime.aware = this.aware;
                entityslime.b(ichatbasecomponent);
                entityslime.t(flag);
                entityslime.m(this.cr());
                entityslime.a(j2, true);
                entityslime.b(this.dr() + (double)f1, this.dt() + 0.5, this.dx() + (double)f22, this.ag.i() * 360.0f, 0.0f);
                slimes.add(entityslime);
            }
            if (CraftEventFactory.callEntityTransformEvent((EntityLiving)this, slimes, EntityTransformEvent.TransformReason.SPLIT).isCancelled()) {
                super.remove(entity_removalreason, cause);
                return;
            }
            for (EntityLiving living : slimes) {
                this.dM().addFreshEntity(living, CreatureSpawnEvent.SpawnReason.SLIME_SPLIT);
            }
        }
        super.remove(entity_removalreason, cause);
    }

    @Override
    public void g(Entity entity) {
        super.g(entity);
        if (entity instanceof EntityIronGolem && this.gb()) {
            this.j((EntityLiving)entity);
        }
    }

    @Override
    public void b_(EntityHuman player) {
        if (this.gb()) {
            this.j(player);
        }
    }

    protected void j(EntityLiving target) {
        if (this.bx()) {
            int i2 = this.gf();
            if (this.f((Entity)target) < 0.6 * (double)i2 * 0.6 * (double)i2 && this.E(target) && target.a(this.dN().b(this), this.gc())) {
                this.a(SoundEffects.ws, 1.0f, (this.ag.i() - this.ag.i()) * 0.2f + 1.0f);
                this.a((EntityLiving)this, (Entity)target);
            }
        }
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return 0.625f * dimensions.b;
    }

    @Override
    protected Vector3f a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        return new Vector3f(0.0f, dimensions.b - 0.015625f * (float)this.gf() * scaleFactor, 0.0f);
    }

    protected boolean gb() {
        return !this.gg() && this.cY();
    }

    protected float gc() {
        return (float)this.b(GenericAttributes.c);
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return this.gg() ? SoundEffects.xj : SoundEffects.wu;
    }

    @Override
    public SoundEffect n_() {
        return this.gg() ? SoundEffects.xi : SoundEffects.wt;
    }

    protected SoundEffect gd() {
        return this.gg() ? SoundEffects.xl : SoundEffects.ww;
    }

    public static boolean c(EntityTypes<EntitySlime> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, RandomSource random) {
        if (EnumMobSpawn.a(spawnReason)) {
            return EntitySlime.a(type, world, spawnReason, pos, random);
        }
        if (world.ak() != EnumDifficulty.a) {
            if (spawnReason == EnumMobSpawn.c) {
                return EntitySlime.a(type, world, spawnReason, pos, random);
            }
            double maxHeightSwamp = world.getMinecraftWorld().paperConfig().entities.spawning.slimeSpawnHeight.surfaceBiome.maximum;
            double minHeightSwamp = world.getMinecraftWorld().paperConfig().entities.spawning.slimeSpawnHeight.surfaceBiome.minimum;
            if (world.t(pos).a(BiomeTags.aq) && (double)pos.v() > minHeightSwamp && (double)pos.v() < maxHeightSwamp && random.i() < 0.5f && random.i() < world.ap() && world.A(pos) <= random.a(8)) {
                return EntitySlime.a(type, world, spawnReason, pos, random);
            }
            if (!(world instanceof GeneratorAccessSeed)) {
                return false;
            }
            ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(pos);
            boolean flag = world.getMinecraftWorld().paperConfig().entities.spawning.allChunksAreSlimeChunks || SeededRandom.a(chunkcoordintpair.e, chunkcoordintpair.f, ((GeneratorAccessSeed)world).C(), world.getMinecraftWorld().spigotConfig.slimeSeed).a(10) == 0;
            double maxHeightSlimeChunk = world.getMinecraftWorld().paperConfig().entities.spawning.slimeSpawnHeight.slimeChunk.maximum;
            if (random.a(10) == 0 && flag && (double)pos.v() < maxHeightSlimeChunk) {
                return EntitySlime.a(type, world, spawnReason, pos, random);
            }
        }
        return false;
    }

    @Override
    public float eW() {
        return 0.4f * (float)this.gf();
    }

    @Override
    public int aa() {
        return 0;
    }

    protected boolean gh() {
        return this.gf() > 0;
    }

    @Override
    public void fb() {
        Vec3D vec3d = this.dp();
        this.o(vec3d.c, this.eZ(), vec3d.e);
        this.au = true;
        this.actualJump = false;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        RandomSource randomsource = world.F_();
        int i2 = randomsource.a(3);
        if (i2 < 2 && randomsource.i() < 0.5f * difficulty.d()) {
            ++i2;
        }
        int j2 = 1 << i2;
        this.a(j2, true);
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    float u() {
        float f2 = this.gg() ? 1.4f : 0.8f;
        return ((this.ag.i() - this.ag.i()) * 0.2f + 1.0f) * f2;
    }

    protected SoundEffect ge() {
        return this.gg() ? SoundEffects.xk : SoundEffects.wv;
    }

    @Override
    public EntitySize a(EntityPose pose) {
        return super.a(pose).a(0.255f * (float)this.gf());
    }

    public boolean canWander() {
        return this.canWander;
    }

    public void setWander(boolean canWander) {
        this.canWander = canWander;
    }

    private static class ControllerMoveSlime
    extends MoveControllerWASD {
        private float l;
        private int m;
        private final EntitySlime n;
        private boolean o;

        public ControllerMoveSlime(EntitySlime slime) {
            super(slime);
            this.n = slime;
            this.l = 180.0f * slime.dC() / (float)Math.PI;
        }

        public void a(float targetYaw, boolean jumpOften) {
            this.l = targetYaw;
            this.o = jumpOften;
        }

        public void a(double speed) {
            this.setSpeedModifier(speed);
            this.k = ControllerMove.Operation.b;
        }

        @Override
        public void a() {
            if (this.n.getRider() != null && this.n.isControllable()) {
                this.purpurTick(this.n.getRider());
                if (this.n.getForwardMot() != 0.0f || this.n.getStrafeMot() != 0.0f) {
                    if (this.m > 10) {
                        this.m = 6;
                    }
                } else {
                    this.m = 20;
                }
            } else {
                this.d.r(this.a(this.d.dC(), this.l, 90.0f));
                this.d.aW = this.d.dC();
                this.d.aU = this.d.dC();
            }
            if (!(this.n.getRider() != null && this.n.isControllable() || this.k == ControllerMove.Operation.b)) {
                this.d.A(0.0f);
            } else {
                this.k = ControllerMove.Operation.a;
                if (this.d.aC()) {
                    this.d.w((float)(this.c() * this.d.b(GenericAttributes.m) * (this.n.getRider() != null && this.n.isControllable() && (this.n.getRider().getForwardMot() != 0.0f || this.n.getRider().getStrafeMot() != 0.0f) ? 2.0 : 1.0)));
                    if (this.m-- <= 0) {
                        this.m = this.n.A();
                        if (this.o) {
                            this.m /= 3;
                        }
                        this.n.M().a();
                        if (this.n.gh()) {
                            this.n.a(this.n.ge(), this.n.eW(), this.n.u());
                        }
                    } else {
                        this.n.bk = 0.0f;
                        this.n.bm = 0.0f;
                        this.d.w(0.0f);
                    }
                } else {
                    this.d.w((float)(this.c() * this.d.b(GenericAttributes.m) * (this.n.getRider() != null && this.n.isControllable() && (this.n.getRider().getForwardMot() != 0.0f || this.n.getRider().getStrafeMot() != 0.0f) ? 2.0 : 1.0)));
                }
            }
        }
    }

    private static class PathfinderGoalSlimeRandomJump
    extends PathfinderGoal {
        private final EntitySlime a;

        public PathfinderGoalSlimeRandomJump(EntitySlime slime) {
            this.a = slime;
            this.a(EnumSet.of(PathfinderGoal.Type.c, PathfinderGoal.Type.a));
            slime.N().a(true);
        }

        @Override
        public boolean a() {
            return (this.a.aZ() || this.a.bn()) && this.a.K() instanceof ControllerMoveSlime && this.a.canWander && new SlimeSwimEvent((Slime)this.a.getBukkitEntity()).callEvent();
        }

        @Override
        public boolean T_() {
            return true;
        }

        @Override
        public void e() {
            ControllerMove controllermove;
            if (this.a.eg().i() < 0.8f) {
                this.a.M().a();
            }
            if ((controllermove = this.a.K()) instanceof ControllerMoveSlime) {
                ControllerMoveSlime entityslime_controllermoveslime = (ControllerMoveSlime)controllermove;
                entityslime_controllermoveslime.a(1.2);
            }
        }
    }

    private static class PathfinderGoalSlimeNearestPlayer
    extends PathfinderGoal {
        private final EntitySlime a;
        private int b;

        public PathfinderGoalSlimeNearestPlayer(EntitySlime slime) {
            this.a = slime;
            this.a(EnumSet.of(PathfinderGoal.Type.b));
        }

        @Override
        public boolean a() {
            EntityLiving entityliving = this.a.q();
            if (entityliving == null || !entityliving.bx()) {
                return false;
            }
            if (!this.a.c(entityliving)) {
                return false;
            }
            return this.a.K() instanceof ControllerMoveSlime && this.a.canWander && new SlimeTargetLivingEntityEvent((Slime)this.a.getBukkitEntity(), (LivingEntity)entityliving.getBukkitEntity()).callEvent();
        }

        @Override
        public void c() {
            this.b = PathfinderGoalSlimeNearestPlayer.b(300);
            super.c();
        }

        @Override
        public boolean b() {
            EntityLiving entityliving = this.a.q();
            if (entityliving == null || !entityliving.bx()) {
                return false;
            }
            if (!this.a.c(entityliving)) {
                return false;
            }
            return --this.b > 0 && this.a.canWander && new SlimeTargetLivingEntityEvent((Slime)this.a.getBukkitEntity(), (LivingEntity)entityliving.getBukkitEntity()).callEvent();
        }

        @Override
        public boolean T_() {
            return true;
        }

        @Override
        public void e() {
            ControllerMove controllermove;
            EntityLiving entityliving = this.a.q();
            if (entityliving != null) {
                this.a.a((Entity)entityliving, 10.0f, 10.0f);
            }
            if ((controllermove = this.a.K()) instanceof ControllerMoveSlime) {
                ControllerMoveSlime entityslime_controllermoveslime = (ControllerMoveSlime)controllermove;
                entityslime_controllermoveslime.a(this.a.dC(), this.a.gb());
            }
        }

        @Override
        public void d() {
            this.b = 0;
            this.a.h((EntityLiving)null);
        }
    }

    private static class PathfinderGoalSlimeRandomDirection
    extends PathfinderGoal {
        private final EntitySlime a;
        private float b;
        private int c;

        public PathfinderGoalSlimeRandomDirection(EntitySlime slime) {
            this.a = slime;
            this.a(EnumSet.of(PathfinderGoal.Type.b));
        }

        @Override
        public boolean a() {
            return this.a.q() == null && (this.a.aC() || this.a.aZ() || this.a.bn() || this.a.a(MobEffects.y)) && this.a.K() instanceof ControllerMoveSlime && this.a.canWander;
        }

        @Override
        public void e() {
            ControllerMove controllermove;
            if (--this.c <= 0) {
                this.c = this.a(40 + this.a.eg().a(60));
                this.b = this.a.eg().a(360);
                SlimeChangeDirectionEvent event = new SlimeChangeDirectionEvent((Slime)this.a.getBukkitEntity(), this.b);
                if (!this.a.canWander || !event.callEvent()) {
                    return;
                }
                this.b = event.getNewYaw();
            }
            if ((controllermove = this.a.K()) instanceof ControllerMoveSlime) {
                ControllerMoveSlime entityslime_controllermoveslime = (ControllerMoveSlime)controllermove;
                entityslime_controllermoveslime.a(this.b, false);
            }
        }
    }

    private static class PathfinderGoalSlimeIdle
    extends PathfinderGoal {
        private final EntitySlime a;

        public PathfinderGoalSlimeIdle(EntitySlime slime) {
            this.a = slime;
            this.a(EnumSet.of(PathfinderGoal.Type.c, PathfinderGoal.Type.a));
        }

        @Override
        public boolean a() {
            return !this.a.bO() && this.a.canWander && new SlimeWanderEvent((Slime)this.a.getBukkitEntity()).callEvent();
        }

        @Override
        public void e() {
            ControllerMove controllermove = this.a.K();
            if (controllermove instanceof ControllerMoveSlime) {
                ControllerMoveSlime entityslime_controllermoveslime = (ControllerMoveSlime)controllermove;
                entityslime_controllermoveslime.a(1.0);
            }
        }
    }
}

