/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import io.papermc.paper.util.CollisionUtil;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationSpider;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntitySkeleton;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.joml.Vector3f;
import org.purpurmc.purpur.entity.ai.HasRider;

public class EntitySpider
extends EntityMonster {
    private static final DataWatcherObject<Byte> b = DataWatcher.a(EntitySpider.class, DataWatcherRegistry.a);
    private static final float c = 0.1f;

    public EntitySpider(EntityTypes<? extends EntitySpider> type, World world) {
        super((EntityTypes<? extends EntityMonster>)type, world);
    }

    @Override
    public boolean isRidable() {
        return this.dM().purpurConfig.spiderRidable;
    }

    @Override
    public boolean bQ() {
        return this.dM().purpurConfig.useDismountsUnderwaterTag ? super.bQ() : !this.dM().purpurConfig.spiderRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.dM().purpurConfig.spiderControllable;
    }

    @Override
    public void initAttributes() {
        this.a(GenericAttributes.l).a(this.dM().purpurConfig.spiderMaxHealth);
    }

    @Override
    public boolean fh() {
        return this.dM().purpurConfig.spiderTakeDamageFromWater;
    }

    @Override
    protected boolean ef() {
        return this.dM().purpurConfig.spiderAlwaysDropExp;
    }

    @Override
    protected void B() {
        this.bO.a(1, new PathfinderGoalFloat(this));
        this.bO.a(1, new HasRider(this));
        this.bO.a(3, new PathfinderGoalLeapAtTarget(this, 0.4f));
        this.bO.a(4, new PathfinderGoalSpiderMeleeAttack(this));
        this.bO.a(5, new PathfinderGoalRandomStrollLand(this, 0.8));
        this.bO.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bO.a(6, new PathfinderGoalRandomLookaround(this));
        this.bP.a(0, new HasRider(this));
        this.bP.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.bP.a(2, new PathfinderGoalSpiderNearestAttackableTarget<EntityHuman>(this, EntityHuman.class));
        this.bP.a(3, new PathfinderGoalSpiderNearestAttackableTarget<EntityIronGolem>(this, EntityIronGolem.class));
    }

    @Override
    protected Vector3f a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        return new Vector3f(0.0f, dimensions.b * 0.85f, 0.0f);
    }

    @Override
    protected NavigationAbstract b(World world) {
        return new NavigationSpider(this, world);
    }

    @Override
    protected void c_() {
        super.c_();
        this.an.a(b, (byte)0);
    }

    @Override
    public void l() {
        super.l();
        if (!this.dM().B) {
            this.w(this.P && (this.dM().paperConfig().entities.behavior.allowSpiderWorldBorderClimbing || !CollisionUtil.isCollidingWithBorder(this.dM().D_(), this.cH().g(1.0E-7))));
        }
    }

    public static AttributeProvider.Builder w() {
        return EntityMonster.gk().a(GenericAttributes.l, 16.0).a(GenericAttributes.m, 0.3f);
    }

    @Override
    protected SoundEffect y() {
        return SoundEffects.xO;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.xQ;
    }

    @Override
    public SoundEffect n_() {
        return SoundEffects.xP;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.xR, 0.15f, 1.0f);
    }

    @Override
    public boolean e_() {
        return this.A();
    }

    @Override
    public void a(IBlockData state, Vec3D multiplier) {
        if (!state.a(Blocks.bs)) {
            super.a(state, multiplier);
        }
    }

    @Override
    public EnumMonsterType eS() {
        return EnumMonsterType.c;
    }

    @Override
    public boolean c(MobEffect effect) {
        return effect.c() == MobEffects.s && this.dM().paperConfig().entities.mobEffects.spidersImmuneToPoisonEffect ? false : super.c(effect);
    }

    public boolean A() {
        return (this.an.b(b) & 1) != 0;
    }

    public void w(boolean climbing) {
        byte b0 = this.an.b(b);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.an.b(b, b0);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        EntitySkeleton entityskeleton;
        GroupDataEntity object = super.a(world, difficulty, spawnReason, entityData, entityNbt);
        RandomSource randomsource = world.F_();
        if (randomsource.a(100) == 0 && (entityskeleton = EntityTypes.aK.a(this.dM())) != null) {
            entityskeleton.b(this.dr(), this.dt(), this.dx(), this.dC(), 0.0f);
            entityskeleton.a(world, difficulty, spawnReason, (GroupDataEntity)null, null);
            entityskeleton.n(this);
        }
        if (object == null) {
            object = new GroupDataSpider();
            if (world.ak() == EnumDifficulty.d && randomsource.i() < 0.1f * difficulty.d()) {
                ((GroupDataSpider)object).a(randomsource);
            }
        }
        if (object instanceof GroupDataSpider) {
            GroupDataSpider entityspider_groupdataspider = (GroupDataSpider)object;
            MobEffectList mobeffectlist = entityspider_groupdataspider.a;
            if (mobeffectlist != null) {
                this.addEffect(new MobEffect(mobeffectlist, -1), null, EntityPotionEffectEvent.Cause.SPIDER_SPAWN, world instanceof WorldServer);
            }
        }
        return object;
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return 0.65f;
    }

    @Override
    protected float l(Entity vehicle) {
        return vehicle.dg() <= this.dg() ? -0.3125f : 0.0f;
    }

    private static class PathfinderGoalSpiderMeleeAttack
    extends PathfinderGoalMeleeAttack {
        public PathfinderGoalSpiderMeleeAttack(EntitySpider spider) {
            super(spider, 1.0, true);
        }

        @Override
        public boolean a() {
            return super.a() && !this.a.bP();
        }

        @Override
        public boolean b() {
            float f2 = this.a.bo();
            if (f2 >= 0.5f && this.a.eg().a(100) == 0) {
                this.a.h((EntityLiving)null);
                return false;
            }
            return super.b();
        }
    }

    private static class PathfinderGoalSpiderNearestAttackableTarget<T extends EntityLiving>
    extends PathfinderGoalNearestAttackableTarget<T> {
        public PathfinderGoalSpiderNearestAttackableTarget(EntitySpider spider, Class<T> targetEntityClass) {
            super((EntityInsentient)spider, targetEntityClass, true);
        }

        @Override
        public boolean a() {
            float f2 = this.e.bo();
            return f2 >= 0.5f ? false : super.a();
        }
    }

    public static class GroupDataSpider
    implements GroupDataEntity {
        @Nullable
        public MobEffectList a;

        public void a(RandomSource random) {
            int i2 = random.a(5);
            if (i2 <= 1) {
                this.a = MobEffects.a;
            } else if (i2 <= 2) {
                this.a = MobEffects.e;
            } else if (i2 <= 3) {
                this.a = MobEffects.j;
            } else if (i2 <= 4) {
                this.a = MobEffects.n;
            }
        }
    }
}

