/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.base.Predicates;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreakDoor;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveThroughVillage;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRemoveBlock;
import net.minecraft.world.entity.ai.goal.PathfinderGoalZombieAttack;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.util.PathfinderGoalUtil;
import net.minecraft.world.entity.ambient.EntityBat;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.monster.EntityZombieVillager;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.entity.Zombie;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.joml.Vector3f;
import org.purpurmc.purpur.entity.ai.HasRider;

public class EntityZombie
extends EntityMonster {
    private static final UUID b = UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D836");
    private static final AttributeModifier c = new AttributeModifier(b, "Baby speed boost", 0.5, AttributeModifier.Operation.b);
    private final AttributeModifier babyModifier;
    private static final DataWatcherObject<Boolean> d = DataWatcher.a(EntityZombie.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> bX = DataWatcher.a(EntityZombie.class, DataWatcherRegistry.b);
    public static final DataWatcherObject<Boolean> bY = DataWatcher.a(EntityZombie.class, DataWatcherRegistry.k);
    public static final float e = 0.05f;
    public static final int bT = 50;
    public static final int bU = 40;
    public static final int bV = 7;
    protected static final float bW = 0.81f;
    private static final float bZ = 0.1f;
    public static final Predicate<EnumDifficulty> ca = enumdifficulty -> enumdifficulty == EnumDifficulty.d;
    private final PathfinderGoalBreakDoor cb;
    private boolean cc;
    private int cd;
    public int ce;
    private int lastTick;

    public EntityZombie(EntityTypes<? extends EntityZombie> type, World world) {
        super((EntityTypes<? extends EntityMonster>)type, world);
        this.babyModifier = new AttributeModifier(c.a(), EntityZombie.c.e, this.dM().paperConfig().entities.behavior.babyZombieMovementModifier, c.b());
        this.lastTick = MinecraftServer.currentTick;
        this.cb = new PathfinderGoalBreakDoor(this, (Predicate<EnumDifficulty>)Predicates.in((Collection)world.paperConfig().entities.behavior.doorBreakingDifficulty.getOrDefault(type, world.paperConfig().entities.behavior.doorBreakingDifficulty.get(EntityTypes.br))));
        this.setShouldBurnInDay(true);
    }

    public EntityZombie(World world) {
        this((EntityTypes<? extends EntityZombie>)EntityTypes.br, world);
    }

    @Override
    public boolean isRidable() {
        return this.dM().purpurConfig.zombieRidable;
    }

    @Override
    public boolean bQ() {
        return this.dM().purpurConfig.useDismountsUnderwaterTag ? super.bQ() : !this.dM().purpurConfig.zombieRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.dM().purpurConfig.zombieControllable;
    }

    @Override
    public void initAttributes() {
        this.a(GenericAttributes.l).a(this.dM().purpurConfig.zombieMaxHealth);
    }

    public boolean jockeyOnlyBaby() {
        return this.dM().purpurConfig.zombieJockeyOnlyBaby;
    }

    public double jockeyChance() {
        return this.dM().purpurConfig.zombieJockeyChance;
    }

    public boolean jockeyTryExistingChickens() {
        return this.dM().purpurConfig.zombieJockeyTryExistingChickens;
    }

    @Override
    public boolean fh() {
        return this.dM().purpurConfig.zombieTakeDamageFromWater;
    }

    @Override
    protected boolean ef() {
        return this.dM().purpurConfig.zombieAlwaysDropExp;
    }

    @Override
    protected void B() {
        this.bO.a(0, new HasRider(this));
        if (this.dM().paperConfig().entities.behavior.zombiesTargetTurtleEggs) {
            this.bO.a(4, new a((EntityCreature)this, 1.0, 3));
        }
        this.bO.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bO.a(8, new PathfinderGoalRandomLookaround(this));
        this.bP.a(0, new HasRider(this));
        this.u();
    }

    protected void u() {
        this.bO.a(2, new PathfinderGoalZombieAttack(this, 1.0, false));
        this.bO.a(6, new PathfinderGoalMoveThroughVillage(this, 1.0, true, 4, this::gm));
        this.bO.a(7, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bP.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]).a(EntityPigZombie.class));
        this.bP.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        if (this.dM().spigotConfig.zombieAggressiveTowardsVillager) {
            this.bP.a(3, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, false){

                @Override
                public boolean a() {
                    return (EntityZombie.this.dM().purpurConfig.zombieAggressiveTowardsVillagerWhenLagging || !EntityZombie.this.dM().o().server.isLagging()) && super.a();
                }

                @Override
                public boolean b() {
                    return (EntityZombie.this.dM().purpurConfig.zombieAggressiveTowardsVillagerWhenLagging || !EntityZombie.this.dM().o().server.isLagging()) && super.b();
                }
            });
        }
        this.bP.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
        this.bP.a(5, new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, true, false, EntityTurtle.bU));
    }

    public static AttributeProvider.Builder gi() {
        return EntityMonster.gk().a(GenericAttributes.g, 35.0).a(GenericAttributes.m, 0.23f).a(GenericAttributes.c, 3.0).a(GenericAttributes.a, 2.0).a(GenericAttributes.n);
    }

    @Override
    protected void c_() {
        super.c_();
        this.an().a(d, false);
        this.an().a(bX, 0);
        this.an().a(bY, false);
    }

    public boolean gl() {
        return this.an().b(bY);
    }

    public boolean gm() {
        return this.cc;
    }

    public void x(boolean canBreakDoors) {
        if (this.w() && PathfinderGoalUtil.a(this)) {
            if (this.cc != canBreakDoors) {
                this.cc = canBreakDoors;
                ((Navigation)this.N()).b(canBreakDoors);
                if (canBreakDoors) {
                    this.bO.a(1, this.cb);
                } else {
                    this.bO.a(this.cb);
                }
            }
        } else if (this.cc) {
            this.bO.a(this.cb);
            this.cc = false;
        }
    }

    public boolean w() {
        return true;
    }

    @Override
    public boolean o_() {
        return this.an().b(d);
    }

    @Override
    public int ee() {
        int previousReward = this.bJ;
        if (this.o_()) {
            this.bJ = (int)((double)this.bJ * 2.5);
        }
        int reward = super.ee();
        this.bJ = previousReward;
        return reward;
    }

    @Override
    public void a(boolean baby) {
        this.an().b(d, baby);
        if (this.dM() != null && !this.dM().B) {
            AttributeModifiable attributemodifiable = this.a(GenericAttributes.m);
            attributemodifiable.b(this.babyModifier.a());
            if (baby) {
                attributemodifiable.b(this.babyModifier);
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (d.equals(data)) {
            this.k_();
        }
        super.a(data);
    }

    protected boolean gf() {
        return true;
    }

    @Override
    public void l() {
        if (!this.dM().B && this.bx() && !this.fU()) {
            if (this.gl()) {
                int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
                this.ce -= elapsedTicks;
                if (this.ce < 0) {
                    this.gh();
                }
            } else if (this.gf()) {
                if (((Entity)this).a(TagsFluid.a)) {
                    ++this.cd;
                    if (this.cd >= 600) {
                        this.b(300);
                    }
                } else {
                    this.cd = -1;
                }
            }
        }
        super.l();
        this.lastTick = MinecraftServer.currentTick;
    }

    @Override
    public void d_() {
        super.d_();
    }

    public void stopDrowning() {
        this.ce = -1;
        this.an().b(bY, false);
    }

    public void b(int ticksUntilWaterConversion) {
        this.lastTick = MinecraftServer.currentTick;
        this.ce = ticksUntilWaterConversion;
        this.an().b(bY, true);
    }

    protected void gh() {
        this.b(EntityTypes.z);
        if (!this.aU()) {
            this.dM().a((EntityHuman)null, 1040, this.dm(), 0);
        }
    }

    protected void b(EntityTypes<? extends EntityZombie> entityType) {
        EntityZombie entityzombie = this.convertTo(entityType, true, EntityTransformEvent.TransformReason.DROWNED, CreatureSpawnEvent.SpawnReason.DROWNED);
        if (entityzombie != null) {
            entityzombie.E(entityzombie.dM().d_(entityzombie.dm()).d());
            entityzombie.x(entityzombie.w() && this.gm());
        } else {
            ((Zombie)this.getBukkitEntity()).setConversionTime(-1);
        }
    }

    @Override
    public boolean shouldBurnInDay() {
        return this.ae_();
    }

    public boolean ae_() {
        return this.shouldBurnInDay;
    }

    @Override
    public void setShouldBurnInDay(boolean shouldBurnInDay) {
        this.shouldBurnInDay = shouldBurnInDay;
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (!super.a(source, amount)) {
            return false;
        }
        if (!(this.dM() instanceof WorldServer)) {
            return false;
        }
        WorldServer worldserver = (WorldServer)this.dM();
        EntityLiving entityliving = this.q();
        if (entityliving == null && source.d() instanceof EntityLiving) {
            entityliving = (EntityLiving)source.d();
        }
        if (entityliving != null && this.dM().ak() == EnumDifficulty.d && (double)this.ag.i() < this.b(GenericAttributes.n) && this.dM().Z().b(GameRules.e)) {
            int i2 = MathHelper.a(this.dr());
            int j2 = MathHelper.a(this.dt());
            int k2 = MathHelper.a(this.dx());
            EntityZombie entityzombie = new EntityZombie(this.dM());
            for (int l2 = 0; l2 < 50; ++l2) {
                int i1 = i2 + MathHelper.a(this.ag, 7, 40) * MathHelper.a(this.ag, -1, 1);
                int j1 = j2 + MathHelper.a(this.ag, 7, 40) * MathHelper.a(this.ag, -1, 1);
                int k1 = k2 + MathHelper.a(this.ag, 7, 40) * MathHelper.a(this.ag, -1, 1);
                BlockPosition blockposition = new BlockPosition(i1, j1, k1);
                EntityTypes<?> entitytypes = entityzombie.ai();
                EntityPositionTypes.Surface entitypositiontypes_surface = EntityPositionTypes.a(entitytypes);
                if (!SpawnerCreature.a(entitypositiontypes_surface, this.dM(), blockposition, entitytypes) || !EntityPositionTypes.a(entitytypes, worldserver, EnumMobSpawn.j, blockposition, this.dM().z)) continue;
                entityzombie.a_(i1, j1, k1);
                if (this.dM().hasNearbyAlivePlayerThatAffectsSpawning(i1, j1, k1, 7.0) || !this.dM().f(entityzombie) || !this.dM().g(entityzombie) || this.dM().d(entityzombie.cH())) continue;
                entityzombie.setTarget(entityliving, EntityTargetEvent.TargetReason.REINFORCEMENT_TARGET, true);
                entityzombie.a(worldserver, this.dM().d_(entityzombie.dm()), EnumMobSpawn.j, (GroupDataEntity)null, null);
                worldserver.addFreshEntityWithPassengers(entityzombie, CreatureSpawnEvent.SpawnReason.REINFORCEMENTS);
                this.a(GenericAttributes.n).c(new AttributeModifier("Zombie reinforcement caller charge", -0.05f, AttributeModifier.Operation.a));
                entityzombie.a(GenericAttributes.n).c(new AttributeModifier("Zombie reinforcement callee charge", -0.05f, AttributeModifier.Operation.a));
                break;
            }
        }
        return true;
    }

    @Override
    public boolean C(Entity target) {
        boolean flag = super.C(target);
        if (flag) {
            float f2 = this.dM().d_(this.dm()).b();
            if (this.eT().b() && this.bN() && this.ag.i() < f2 * 0.3f) {
                EntityCombustByEntityEvent event = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)target.getBukkitEntity(), 2 * (int)f2);
                this.dM().getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    target.setSecondsOnFire(event.getDuration(), false);
                }
            }
        }
        return flag;
    }

    @Override
    protected SoundEffect y() {
        return SoundEffects.Cc;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.Cm;
    }

    @Override
    public SoundEffect n_() {
        return SoundEffects.Ch;
    }

    protected SoundEffect A() {
        return SoundEffects.Cs;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(this.A(), 0.15f, 1.0f);
    }

    @Override
    public EnumMonsterType eS() {
        return EnumMonsterType.b;
    }

    @Override
    protected void a(RandomSource random, DifficultyDamageScaler localDifficulty) {
        super.a(random, localDifficulty);
        float f2 = random.i();
        float f3 = this.dM().ak() == EnumDifficulty.d ? 0.05f : 0.01f;
        if (f2 < f3) {
            int i2 = random.a(3);
            if (i2 == 0) {
                this.a(EnumItemSlot.a, new ItemStack(Items.oX));
            } else {
                this.a(EnumItemSlot.a, new ItemStack(Items.oY));
            }
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("IsBaby", this.o_());
        nbt.a("CanBreakDoors", this.gm());
        nbt.a("InWaterTime", this.aZ() ? this.cd : -1);
        nbt.a("DrownedConversionTime", this.gl() ? this.ce : -1);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.a(nbt.q("IsBaby"));
        this.x(nbt.q("CanBreakDoors"));
        this.cd = nbt.h("InWaterTime");
        if (nbt.b("DrownedConversionTime", 99) && nbt.h("DrownedConversionTime") > -1) {
            this.b(nbt.h("DrownedConversionTime"));
        }
        if (nbt.e("Paper.ShouldBurnInDay")) {
            // empty if block
        }
    }

    @Override
    public boolean a(WorldServer world, EntityLiving other) {
        double fallbackChance;
        boolean flag = super.a(world, other);
        double d2 = world.ak() == EnumDifficulty.d ? 100.0 : (fallbackChance = world.ak() == EnumDifficulty.c ? 50.0 : 0.0);
        if (this.ag.j() * 100.0 < world.paperConfig().entities.behavior.zombieVillagerInfectionChance.or(fallbackChance) && other instanceof EntityVillager) {
            EntityVillager entityvillager = (EntityVillager)other;
            flag = EntityZombie.zombifyVillager(world, entityvillager, this.dm(), this.aU(), CreatureSpawnEvent.SpawnReason.INFECTION) == null;
        }
        return flag;
    }

    public static EntityZombieVillager zombifyVillager(WorldServer worldserver, EntityVillager entityvillager, BlockPosition blockPosition, boolean silent, CreatureSpawnEvent.SpawnReason spawnReason) {
        EntityZombieVillager entityzombievillager = entityvillager.convertTo(EntityTypes.bt, false, EntityTransformEvent.TransformReason.INFECTION, spawnReason);
        if (entityzombievillager != null) {
            entityzombievillager.a(worldserver, worldserver.d_(entityzombievillager.dm()), EnumMobSpawn.i, new GroupDataZombie(false, true), null);
            entityzombievillager.a(entityvillager.gp());
            entityzombievillager.a(entityvillager.gz().a(DynamicOpsNBT.a));
            entityzombievillager.c(entityvillager.gg().a());
            entityzombievillager.b(entityvillager.w());
            if (!silent) {
                worldserver.a((EntityHuman)null, 1026, blockPosition, 0);
            }
        }
        return entityzombievillager;
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return this.o_() ? 0.93f : 1.74f;
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(Items.qO) && this.o_() && this.bO() ? false : super.j(stack);
    }

    @Override
    public boolean k(ItemStack stack) {
        return stack.a(Items.rd) ? false : super.k(stack);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        RandomSource randomsource = world.F_();
        GroupDataEntity object = super.a(world, difficulty, spawnReason, entityData, entityNbt);
        float f2 = difficulty.d();
        this.s(this.dM().paperConfig().entities.behavior.mobsCanAlwaysPickUpLoot.zombies || randomsource.i() < 0.55f * f2);
        if (object == null) {
            object = new GroupDataZombie(EntityZombie.a(randomsource), true);
        }
        if (object instanceof GroupDataZombie) {
            GroupDataZombie entityzombie_groupdatazombie = (GroupDataZombie)object;
            if (!this.jockeyOnlyBaby() || entityzombie_groupdatazombie.a) {
                this.a(entityzombie_groupdatazombie.a);
                if (entityzombie_groupdatazombie.b && (double)randomsource.i() < this.jockeyChance()) {
                    List list;
                    List<Object> list2 = list = this.jockeyTryExistingChickens() ? world.a(EntityChicken.class, this.cH().c(5.0, 3.0, 5.0), IEntitySelector.c) : Collections.emptyList();
                    if (!list.isEmpty()) {
                        EntityChicken entitychicken = (EntityChicken)list.get(0);
                        entitychicken.w(true);
                        this.n(entitychicken);
                    } else {
                        EntityChicken entitychicken1 = EntityTypes.r.a(this.dM());
                        if (entitychicken1 != null) {
                            entitychicken1.b(this.dr(), this.dt(), this.dx(), this.dC(), 0.0f);
                            entitychicken1.a(world, difficulty, EnumMobSpawn.g, (GroupDataEntity)null, null);
                            entitychicken1.w(true);
                            this.n(entitychicken1);
                            world.addFreshEntity(entitychicken1, CreatureSpawnEvent.SpawnReason.MOUNT);
                        }
                    }
                }
            }
            this.x(this.w() && randomsource.i() < f2 * 0.1f);
            this.a(randomsource, difficulty);
            this.b(randomsource, difficulty);
        }
        if (this.c(EnumItemSlot.f).b() && EntityBat.isHalloweenSeason(world.getMinecraftWorld()) && this.ag.i() < this.dM().purpurConfig.chanceHeadHalloweenOnEntity) {
            this.a(EnumItemSlot.f, new ItemStack(randomsource.i() < 0.1f ? Blocks.ef : Blocks.ee));
            this.bR[EnumItemSlot.f.b()] = 0.0f;
        }
        this.E(f2);
        return object;
    }

    public static boolean a(RandomSource random) {
        return random.i() < 0.05f;
    }

    protected void E(float chanceMultiplier) {
        this.gn();
        this.a(GenericAttributes.i).c(new AttributeModifier("Random spawn bonus", this.ag.j() * (double)0.05f, AttributeModifier.Operation.a));
        double d0 = this.ag.j() * 1.5 * (double)chanceMultiplier;
        if (d0 > 1.0) {
            this.a(GenericAttributes.g).c(new AttributeModifier("Random zombie-spawn bonus", d0, AttributeModifier.Operation.c));
        }
        if (this.ag.i() < chanceMultiplier * 0.05f) {
            this.a(GenericAttributes.n).c(new AttributeModifier("Leader zombie bonus", this.ag.j() * 0.25 + 0.5, AttributeModifier.Operation.a));
            this.a(GenericAttributes.l).c(new AttributeModifier("Leader zombie bonus", this.ag.j() * 3.0 + 1.0, AttributeModifier.Operation.c));
            this.x(this.w());
        }
    }

    protected void gn() {
        this.a(GenericAttributes.n).a(this.ag.j() * this.dM().purpurConfig.zombieSpawnReinforcements);
    }

    @Override
    protected Vector3f a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        return new Vector3f(0.0f, dimensions.b + 0.0625f * scaleFactor, 0.0f);
    }

    @Override
    protected float l(Entity vehicle) {
        return -0.7f;
    }

    @Override
    protected void a(DamageSource source, int lootingMultiplier, boolean allowDrops) {
        ItemStack itemstack;
        EntityCreeper entitycreeper;
        super.a(source, lootingMultiplier, allowDrops);
        Entity entity = source.d();
        if (entity instanceof EntityCreeper && (entitycreeper = (EntityCreeper)entity).gf() && !(itemstack = this.ge()).b()) {
            entitycreeper.gg();
            this.b(itemstack);
        }
    }

    protected ItemStack ge() {
        return new ItemStack(Items.uh);
    }

    private class a
    extends PathfinderGoalRemoveBlock {
        a(EntityCreature mob, double speed, int range) {
            super(Blocks.mf, mob, speed, range);
        }

        @Override
        public void a(GeneratorAccess world, BlockPosition pos) {
            world.a((EntityHuman)null, pos, SoundEffects.Ci, SoundCategory.f, 0.5f, 0.9f + EntityZombie.this.ag.i() * 0.2f);
        }

        @Override
        public void a(World world, BlockPosition pos) {
            world.a((EntityHuman)null, pos, SoundEffects.zl, SoundCategory.e, 0.7f, 0.9f + world.z.i() * 0.2f);
        }

        @Override
        public double i() {
            return 1.14;
        }
    }

    public static class GroupDataZombie
    implements GroupDataEntity {
        public final boolean a;
        public final boolean b;

        public GroupDataZombie(boolean baby, boolean tryChickenJockey) {
            this.a = baby;
            this.b = tryChickenJockey;
        }
    }
}

