/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import net.minecraft.core.BlockPosition;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.joml.Vector3f;

public class EntityZombieHusk
extends EntityZombie {
    public EntityZombieHusk(EntityTypes<? extends EntityZombieHusk> type, World world) {
        super((EntityTypes<? extends EntityZombie>)type, world);
        this.setShouldBurnInDay(false);
    }

    @Override
    public boolean isRidable() {
        return this.dM().purpurConfig.huskRidable;
    }

    @Override
    public boolean bQ() {
        return this.dM().purpurConfig.useDismountsUnderwaterTag ? super.bQ() : !this.dM().purpurConfig.huskRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.dM().purpurConfig.huskControllable;
    }

    @Override
    public void initAttributes() {
        this.a(GenericAttributes.l).a(this.dM().purpurConfig.huskMaxHealth);
    }

    @Override
    protected void gn() {
        this.a(GenericAttributes.n).a(this.ag.j() * this.dM().purpurConfig.huskSpawnReinforcements);
    }

    @Override
    public boolean jockeyOnlyBaby() {
        return this.dM().purpurConfig.huskJockeyOnlyBaby;
    }

    @Override
    public double jockeyChance() {
        return this.dM().purpurConfig.huskJockeyChance;
    }

    @Override
    public boolean jockeyTryExistingChickens() {
        return this.dM().purpurConfig.huskJockeyTryExistingChickens;
    }

    @Override
    public boolean fh() {
        return this.dM().purpurConfig.huskTakeDamageFromWater;
    }

    @Override
    protected boolean ef() {
        return this.dM().purpurConfig.huskAlwaysDropExp;
    }

    public static boolean a(EntityTypes<EntityZombieHusk> type, WorldAccess world, EnumMobSpawn spawnReason, BlockPosition pos, RandomSource random) {
        return EntityZombieHusk.b(type, world, spawnReason, pos, random) && (EnumMobSpawn.a(spawnReason) || world.h(pos));
    }

    @Override
    public boolean ae_() {
        return this.shouldBurnInDay;
    }

    @Override
    protected SoundEffect y() {
        return SoundEffects.ml;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.mo;
    }

    @Override
    public SoundEffect n_() {
        return SoundEffects.mn;
    }

    @Override
    protected SoundEffect A() {
        return SoundEffects.mp;
    }

    @Override
    public boolean C(Entity target) {
        boolean flag = super.C(target);
        if (flag && this.eT().b() && target instanceof EntityLiving) {
            float f2 = this.dM().d_(this.dm()).b();
            ((EntityLiving)target).addEffect(new MobEffect(MobEffects.q, 140 * (int)f2), this, EntityPotionEffectEvent.Cause.ATTACK);
        }
        return flag;
    }

    @Override
    protected boolean gf() {
        return true;
    }

    @Override
    protected void gh() {
        this.b(EntityTypes.br);
        if (!this.aU()) {
            this.dM().a((EntityHuman)null, 1041, this.dm(), 0);
        }
    }

    @Override
    protected ItemStack ge() {
        return ItemStack.f;
    }

    @Override
    protected Vector3f a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        return new Vector3f(0.0f, dimensions.b + 0.125f * scaleFactor, 0.0f);
    }
}

