/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.joml.Vector3f;
import org.slf4j.Logger;

public class EntityZombieVillager
extends EntityZombie
implements VillagerDataHolder {
    private static final Logger b = LogUtils.getLogger();
    public static final DataWatcherObject<Boolean> c = DataWatcher.a(EntityZombieVillager.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<VillagerData> d = DataWatcher.a(EntityZombieVillager.class, DataWatcherRegistry.t);
    private static final int bX = 3600;
    private static final int bY = 6000;
    private static final int bZ = 14;
    private static final int ca = 4;
    public int cb;
    @Nullable
    public UUID cc;
    @Nullable
    private NBTBase cd;
    @Nullable
    private NBTTagCompound ce;
    private int cf;
    private int lastTick = MinecraftServer.currentTick;

    public EntityZombieVillager(EntityTypes<? extends EntityZombieVillager> type, World world) {
        super((EntityTypes<? extends EntityZombie>)type, world);
        BuiltInRegistries.z.a(this.ag).ifPresent(holder_c -> this.a(this.gp().a((VillagerProfession)holder_c.a())));
    }

    @Override
    public boolean isRidable() {
        return this.dM().purpurConfig.zombieVillagerRidable;
    }

    @Override
    public boolean bQ() {
        return this.dM().purpurConfig.useDismountsUnderwaterTag ? super.bQ() : !this.dM().purpurConfig.zombieVillagerRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.dM().purpurConfig.zombieVillagerControllable;
    }

    @Override
    public void initAttributes() {
        this.a(GenericAttributes.l).a(this.dM().purpurConfig.zombieVillagerMaxHealth);
    }

    @Override
    protected void gn() {
        this.a(GenericAttributes.n).a(this.ag.j() * this.dM().purpurConfig.zombieVillagerSpawnReinforcements);
    }

    @Override
    public boolean fh() {
        return this.dM().purpurConfig.zombieVillagerTakeDamageFromWater;
    }

    @Override
    public boolean jockeyOnlyBaby() {
        return this.dM().purpurConfig.zombieVillagerJockeyOnlyBaby;
    }

    @Override
    public double jockeyChance() {
        return this.dM().purpurConfig.zombieVillagerJockeyChance;
    }

    @Override
    public boolean jockeyTryExistingChickens() {
        return this.dM().purpurConfig.zombieVillagerJockeyTryExistingChickens;
    }

    @Override
    protected boolean ef() {
        return this.dM().purpurConfig.zombieVillagerAlwaysDropExp;
    }

    @Override
    protected void c_() {
        super.c_();
        this.an.a(c, false);
        this.an.a(d, new VillagerData(VillagerType.c, VillagerProfession.b, 1));
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        DataResult dataresult = VillagerData.c.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.gp());
        Logger logger = b;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.a("VillagerData", (NBTBase)nbtbase));
        if (this.ce != null) {
            nbt.a("Offers", this.ce);
        }
        if (this.cd != null) {
            nbt.a("Gossips", this.cd);
        }
        nbt.a("ConversionTime", this.go() ? this.cb : -1);
        if (this.cc != null) {
            nbt.a("ConversionPlayer", this.cc);
        }
        nbt.a("Xp", this.cf);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        if (nbt.b("VillagerData", 10)) {
            DataResult dataresult = VillagerData.c.parse(new Dynamic<NBTBase>(DynamicOpsNBT.a, nbt.c("VillagerData")));
            Logger logger = b;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(this::a);
        }
        if (nbt.b("Offers", 10)) {
            this.ce = nbt.p("Offers");
        }
        if (nbt.b("Gossips", 9)) {
            this.cd = nbt.c("Gossips", 10);
        }
        if (nbt.b("ConversionTime", 99) && nbt.h("ConversionTime") > -1) {
            this.a(nbt.b("ConversionPlayer") ? nbt.a("ConversionPlayer") : null, nbt.h("ConversionTime"));
        }
        if (nbt.b("Xp", 3)) {
            this.cf = nbt.h("Xp");
        }
    }

    @Override
    public void l() {
        if (!this.dM().B && this.bx() && this.go()) {
            int i2 = this.gr();
            int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
            this.cb -= (i2 *= elapsedTicks);
            if (this.cb <= 0) {
                this.c((WorldServer)this.dM());
            }
        }
        super.l();
        this.lastTick = MinecraftServer.currentTick;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (itemstack.a(Items.pX)) {
            if (this.a(MobEffects.r) && this.dM().purpurConfig.zombieVillagerCureEnabled) {
                if (!player.fT().d) {
                    itemstack.h(1);
                }
                if (!this.dM().B) {
                    this.a(player.cw(), this.ag.a(this.dM().purpurConfig.zombieVillagerCuringTimeMax - this.dM().purpurConfig.zombieVillagerCuringTimeMin + 1) + this.dM().purpurConfig.zombieVillagerCuringTimeMin);
                }
                return EnumInteractionResult.a;
            }
            return EnumInteractionResult.b;
        }
        return super.b(player, hand);
    }

    @Override
    protected boolean gf() {
        return false;
    }

    @Override
    public boolean h(double distanceSquared) {
        return !this.go() && this.cf == 0;
    }

    public boolean go() {
        return this.an().b(c);
    }

    public void a(@Nullable UUID uuid, int delay) {
        this.startConverting(uuid, delay, true);
    }

    public void startConverting(@Nullable UUID uuid, int delay, boolean broadcastEntityEvent) {
        this.cc = uuid;
        this.cb = delay;
        this.an().b(c, true);
        this.removeEffect(MobEffects.r, EntityPotionEffectEvent.Cause.CONVERSION);
        this.addEffect(new MobEffect(MobEffects.e, delay, Math.min(this.dM().ak().a() - 1, 0)), EntityPotionEffectEvent.Cause.CONVERSION);
        if (broadcastEntityEvent) {
            this.dM().a((Entity)this, (byte)16);
        }
    }

    @Override
    public void b(byte status) {
        if (status == 16) {
            if (!this.aU()) {
                this.dM().a(this.dr(), this.dv(), this.dx(), SoundEffects.Cv, this.db(), 1.0f + this.ag.i(), this.ag.i() * 0.7f + 0.3f, false);
            }
        } else {
            super.b(status);
        }
    }

    private void c(WorldServer world) {
        EntityHuman entityhuman;
        EntityVillager entityvillager = this.convertTo(EntityTypes.bg, false, EntityTransformEvent.TransformReason.CURED, CreatureSpawnEvent.SpawnReason.CURED);
        if (entityvillager == null) {
            ((ZombieVillager)this.getBukkitEntity()).setConversionTime(-1);
            return;
        }
        for (EnumItemSlot enumitemslot : EnumItemSlot.values()) {
            ItemStack itemstack = this.c(enumitemslot);
            if (itemstack.b()) continue;
            if (EnchantmentManager.d(itemstack)) {
                entityvillager.a_(enumitemslot.b() + 300).a(itemstack);
                continue;
            }
            double d0 = this.f(enumitemslot);
            if (!(d0 > 1.0)) continue;
            this.forceDrops = true;
            this.b(itemstack);
            this.forceDrops = false;
        }
        entityvillager.a(this.gp());
        if (this.cd != null) {
            entityvillager.a(this.cd);
        }
        if (this.ce != null) {
            entityvillager.b(new MerchantRecipeList(this.ce));
        }
        entityvillager.u(this.cf);
        entityvillager.a(world, world.d_(entityvillager.dm()), EnumMobSpawn.i, (GroupDataEntity)null, null);
        entityvillager.c(world);
        if (this.cc != null && (entityhuman = world.getGlobalPlayerByUUID(this.cc)) instanceof EntityPlayer) {
            CriterionTriggers.s.a((EntityPlayer)entityhuman, this, entityvillager);
            world.a(ReputationEvent.a, (Entity)entityhuman, entityvillager);
        }
        entityvillager.addEffect(new MobEffect(MobEffects.i, 200, 0), EntityPotionEffectEvent.Cause.CONVERSION);
        if (!this.aU()) {
            world.a((EntityHuman)null, 1027, this.dm(), 0);
        }
    }

    private int gr() {
        int i2 = 1;
        if (this.ag.i() < 0.01f) {
            int j2 = 0;
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            for (int k2 = (int)this.dr() - 4; k2 < (int)this.dr() + 4 && j2 < 14; ++k2) {
                for (int l2 = (int)this.dt() - 4; l2 < (int)this.dt() + 4 && j2 < 14; ++l2) {
                    for (int i1 = (int)this.dx() - 4; i1 < (int)this.dx() + 4 && j2 < 14; ++i1) {
                        IBlockData iblockdata = this.dM().a_(blockposition_mutableblockposition.d(k2, l2, i1));
                        if (!iblockdata.a(Blocks.eW) && !(iblockdata.b() instanceof BlockBed)) continue;
                        if (this.ag.i() < 0.3f) {
                            ++i2;
                        }
                        ++j2;
                    }
                }
            }
        }
        return i2;
    }

    @Override
    public float eX() {
        return this.o_() ? (this.ag.i() - this.ag.i()) * 0.2f + 2.0f : (this.ag.i() - this.ag.i()) * 0.2f + 1.0f;
    }

    @Override
    public SoundEffect y() {
        return SoundEffects.Ct;
    }

    @Override
    public SoundEffect d(DamageSource source) {
        return SoundEffects.Cx;
    }

    @Override
    public SoundEffect n_() {
        return SoundEffects.Cw;
    }

    @Override
    public SoundEffect A() {
        return SoundEffects.Cy;
    }

    @Override
    protected ItemStack ge() {
        return ItemStack.f;
    }

    public void c(NBTTagCompound offerData) {
        this.ce = offerData;
    }

    @Override
    public void a(NBTBase gossipData) {
        this.cd = gossipData;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        this.a(this.gp().a(VillagerType.a(world.t(this.dm()))));
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    public void a(VillagerData villagerData) {
        VillagerData villagerdata1 = this.gp();
        if (villagerdata1.b() != villagerData.b()) {
            this.ce = null;
        }
        this.an.b(d, villagerData);
    }

    @Override
    public VillagerData gp() {
        return this.an.b(d);
    }

    public int gq() {
        return this.cf;
    }

    @Override
    public void b(int xp) {
        this.cf = xp;
    }

    @Override
    protected Vector3f a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        return new Vector3f(0.0f, dimensions.b + 0.175f * scaleFactor, 0.0f);
    }
}

