/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.breeze;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.LongJumpUtil;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.breeze.Breeze;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;

public class LongJump
extends Behavior<Breeze> {
    private static final int c = 4;
    private static final double d = 50.0;
    private static final int e = 10;
    private static final int f = 2;
    private static final int g = Math.round(10.0f);
    private static final float h = 1.4f;
    private static final ObjectArrayList<Integer> i = new ObjectArrayList((Collection)Lists.newArrayList((Object[])new Integer[]{40, 55, 60, 75, 80}));

    @VisibleForTesting
    public LongJump() {
        super(Map.of(MemoryModuleType.o, MemoryStatus.a, MemoryModuleType.aT, MemoryStatus.b, MemoryModuleType.aY, MemoryStatus.c, MemoryModuleType.aZ, MemoryStatus.c, MemoryModuleType.aU, MemoryStatus.b, MemoryModuleType.m, MemoryStatus.b), 200);
    }

    @Override
    @Override
    protected boolean a(WorldServer world, Breeze entity) {
        if (!entity.aC() && !entity.aZ()) {
            return false;
        }
        if (entity.dO().a(MemoryModuleType.aZ, MemoryStatus.a)) {
            return true;
        }
        EntityLiving livingEntity = entity.dO().c(MemoryModuleType.o).orElse(null);
        if (livingEntity == null) {
            return false;
        }
        if (LongJump.a(entity, livingEntity)) {
            entity.dO().b(MemoryModuleType.o);
            return false;
        }
        if (LongJump.b(entity, livingEntity)) {
            return false;
        }
        if (!LongJump.b(world, entity)) {
            return false;
        }
        BlockPosition blockPos = LongJump.a((EntityLiving)entity, LongJump.a(livingEntity, entity.eg()));
        if (blockPos == null) {
            return false;
        }
        if (!LongJump.a(entity, blockPos.b()) && !LongJump.a(entity, blockPos.b(4).b())) {
            return false;
        }
        entity.dO().a(MemoryModuleType.aZ, blockPos);
        return true;
    }

    @Override
    @Override
    protected boolean a(WorldServer world, Breeze entity, long time) {
        return entity.ap() != EntityPose.a && !entity.dO().a(MemoryModuleType.aT);
    }

    @Override
    @Override
    protected void b(WorldServer serverLevel, Breeze breeze, long l2) {
        if (breeze.dO().a(MemoryModuleType.aY, MemoryStatus.b)) {
            breeze.dO().a(MemoryModuleType.aY, Unit.a, g);
        }
        breeze.b(EntityPose.r);
        breeze.dO().c(MemoryModuleType.aZ).ifPresent(jumpTarget -> breeze.a(ArgumentAnchor.Anchor.b, jumpTarget.b()));
    }

    @Override
    @Override
    protected void c(WorldServer world, Breeze entity, long time) {
        if (LongJump.a(entity)) {
            Vec3D vec3 = entity.dO().c(MemoryModuleType.aZ).flatMap(jumpTarget -> LongJump.a(entity, entity.eg(), Vec3D.c(jumpTarget))).orElse(null);
            if (vec3 == null) {
                entity.b(EntityPose.a);
                return;
            }
            entity.a(SoundEffects.co, 1.0f, 1.0f);
            entity.b(EntityPose.g);
            entity.r(entity.aU);
            entity.p(true);
            entity.g(vec3);
        } else if (LongJump.b(entity)) {
            entity.a(SoundEffects.cp, 1.0f, 1.0f);
            entity.b(EntityPose.a);
            entity.p(false);
            boolean bl = entity.dO().a(MemoryModuleType.x);
            entity.dO().a(MemoryModuleType.aT, Unit.a, bl ? 2L : 10L);
            entity.dO().a(MemoryModuleType.aU, Unit.a, 100L);
        }
    }

    @Override
    @Override
    protected void d(WorldServer serverLevel, Breeze breeze, long l2) {
        if (breeze.ap() == EntityPose.g || breeze.ap() == EntityPose.r) {
            breeze.b(EntityPose.a);
        }
        breeze.dO().b(MemoryModuleType.aZ);
        breeze.dO().b(MemoryModuleType.aY);
    }

    private static boolean a(Breeze breeze) {
        return breeze.dO().c(MemoryModuleType.aY).isEmpty() && breeze.ap() == EntityPose.r;
    }

    private static boolean b(Breeze breeze) {
        return breeze.ap() == EntityPose.g && breeze.aC();
    }

    private static Vec3D a(EntityLiving target, RandomSource random) {
        int i2 = 90;
        float f2 = target.aW + 180.0f + (float)random.k() * 90.0f / 2.0f;
        float g2 = MathHelper.i(random.i(), 4.0f, 8.0f);
        Vec3D vec3 = Vec3D.a(0.0f, f2).a((double)g2);
        return target.dk().e(vec3);
    }

    @Nullable
    private static BlockPosition a(EntityLiving breeze, Vec3D pos) {
        RayTrace clipContext = new RayTrace(pos, pos.a(EnumDirection.a, 10.0), RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, breeze);
        MovingObjectPositionBlock hitResult = breeze.dM().a(clipContext);
        if (((MovingObjectPosition)hitResult).c() == MovingObjectPosition.EnumMovingObjectType.b) {
            return BlockPosition.a(hitResult.e()).c();
        }
        RayTrace clipContext2 = new RayTrace(pos, pos.a(EnumDirection.b, 10.0), RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, breeze);
        MovingObjectPositionBlock hitResult2 = breeze.dM().a(clipContext2);
        if (((MovingObjectPosition)hitResult2).c() == MovingObjectPosition.EnumMovingObjectType.b) {
            return BlockPosition.a(hitResult.e()).c();
        }
        return null;
    }

    @VisibleForTesting
    public static boolean a(Breeze breeze, Vec3D jumpPos) {
        Vec3D vec3 = new Vec3D(breeze.dr(), breeze.dt(), breeze.dx());
        if (jumpPos.f(vec3) > 50.0) {
            return false;
        }
        return breeze.dM().a(new RayTrace(vec3, jumpPos, RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, breeze)).c() == MovingObjectPosition.EnumMovingObjectType.a;
    }

    private static boolean a(Breeze breeze, EntityLiving target) {
        return !target.a((Entity)breeze, 24.0);
    }

    private static boolean b(Breeze breeze, EntityLiving target) {
        return target.e((Entity)breeze) - 4.0f <= 0.0f;
    }

    private static boolean b(WorldServer world, Breeze breeze) {
        BlockPosition blockPos = breeze.dm();
        for (int i2 = 1; i2 <= 4; ++i2) {
            BlockPosition blockPos2 = blockPos.a(EnumDirection.b, i2);
            if (world.a_(blockPos2).i() || world.b_(blockPos2).a(TagsFluid.a)) continue;
            return false;
        }
        return true;
    }

    private static Optional<Vec3D> a(Breeze breeze, RandomSource random, Vec3D jumpTarget) {
        List<Integer> list = SystemUtils.a(i, random);
        for (int i2 : list) {
            Optional<Vec3D> optional = LongJumpUtil.a(breeze, jumpTarget, 1.4f, i2, false);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    @Override
    protected /* synthetic */ void b(WorldServer world, EntityLiving entity, long time) {
        this.d(world, (Breeze)entity, time);
    }

    @Override
    protected /* synthetic */ void d(WorldServer world, EntityLiving entity, long time) {
        this.b(world, (Breeze)entity, time);
    }
}

