/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalInteract;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtTradingPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveTowardsRestriction;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTradeWithPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalUseItem;
import net.minecraft.world.entity.monster.EntityEvoker;
import net.minecraft.world.entity.monster.EntityIllagerIllusioner;
import net.minecraft.world.entity.monster.EntityPillager;
import net.minecraft.world.entity.monster.EntityVex;
import net.minecraft.world.entity.monster.EntityVindicator;
import net.minecraft.world.entity.monster.EntityZoglin;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.trading.MerchantRecipe;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftMerchantRecipe;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.VillagerAcquireTradeEvent;

public class EntityVillagerTrader
extends EntityVillagerAbstract {
    private static final int bV = 5;
    @Nullable
    private BlockPosition bW;
    private int bX;
    public boolean canDrinkPotion = true;
    public boolean canDrinkMilk = true;

    public EntityVillagerTrader(EntityTypes<? extends EntityVillagerTrader> type, World world) {
        super((EntityTypes<? extends EntityVillagerAbstract>)type, world);
    }

    @Override
    public boolean isRidable() {
        return this.dM().purpurConfig.wanderingTraderRidable;
    }

    @Override
    public boolean bQ() {
        return this.dM().purpurConfig.useDismountsUnderwaterTag ? super.bQ() : !this.dM().purpurConfig.wanderingTraderRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.dM().purpurConfig.wanderingTraderControllable;
    }

    @Override
    public void initAttributes() {
        this.a(GenericAttributes.l).a(this.dM().purpurConfig.wanderingTraderMaxHealth);
    }

    @Override
    public boolean a(EntityHuman player) {
        return this.dM().purpurConfig.wanderingTraderCanBeLeashed && !this.fS();
    }

    @Override
    public boolean fh() {
        return this.dM().purpurConfig.wanderingTraderTakeDamageFromWater;
    }

    @Override
    protected boolean ef() {
        return this.dM().purpurConfig.wanderingTraderAlwaysDropExp;
    }

    @Override
    protected void B() {
        this.bO.a(0, new PathfinderGoalFloat(this));
        this.bO.a(0, new PathfinderGoalUseItem<EntityVillagerTrader>(this, PotionUtil.a(new ItemStack(Items.sh), Potions.i), SoundEffects.An, entityvillagertrader -> this.canDrinkPotion && this.dM().Q() && !entityvillagertrader.ce()));
        this.bO.a(0, new PathfinderGoalUseItem<EntityVillagerTrader>(this, new ItemStack(Items.qB), SoundEffects.As, entityvillagertrader -> this.dM().purpurConfig.milkClearsBeneficialEffects && this.canDrinkMilk && this.dM().P() && entityvillagertrader.ce()));
        this.bO.a(1, new PathfinderGoalTradeWithPlayer(this));
        this.bO.a(1, new PathfinderGoalAvoidTarget<EntityZombie>(this, EntityZombie.class, 8.0f, 0.5, 0.5));
        this.bO.a(1, new PathfinderGoalAvoidTarget<EntityEvoker>(this, EntityEvoker.class, 12.0f, 0.5, 0.5));
        this.bO.a(1, new PathfinderGoalAvoidTarget<EntityVindicator>(this, EntityVindicator.class, 8.0f, 0.5, 0.5));
        this.bO.a(1, new PathfinderGoalAvoidTarget<EntityVex>(this, EntityVex.class, 8.0f, 0.5, 0.5));
        this.bO.a(1, new PathfinderGoalAvoidTarget<EntityPillager>(this, EntityPillager.class, 15.0f, 0.5, 0.5));
        this.bO.a(1, new PathfinderGoalAvoidTarget<EntityIllagerIllusioner>(this, EntityIllagerIllusioner.class, 12.0f, 0.5, 0.5));
        this.bO.a(1, new PathfinderGoalAvoidTarget<EntityZoglin>(this, EntityZoglin.class, 10.0f, 0.5, 0.5));
        this.bO.a(1, new PathfinderGoalPanic(this, 0.5));
        this.bO.a(1, new PathfinderGoalLookAtTradingPlayer(this));
        this.bO.a(2, new a(this, 2.0, 0.35));
        if (this.dM().purpurConfig.wanderingTraderFollowEmeraldBlock) {
            this.bO.a(3, new PathfinderGoalTempt(this, 1.0, EntityVillagerAbstract.TEMPT_ITEMS, false));
        }
        this.bO.a(4, new PathfinderGoalMoveTowardsRestriction(this, 0.35));
        this.bO.a(8, new PathfinderGoalRandomStrollLand(this, 0.35));
        this.bO.a(9, new PathfinderGoalInteract(this, EntityHuman.class, 3.0f, 1.0f));
        this.bO.a(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 8.0f));
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer world, EntityAgeable entity) {
        return null;
    }

    @Override
    public boolean gh() {
        return false;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (!itemstack.a(Items.tE) && this.bx() && !this.gf() && !this.o_()) {
            if (hand == EnumHand.a) {
                player.a(StatisticList.S);
            }
            if (this.gg().isEmpty()) {
                return this.tryRide(player, hand, EnumInteractionResult.a(this.dM().B));
            }
            if (this.dM().purpurConfig.wanderingTraderRidable && itemstack.b()) {
                return this.tryRide(player, hand);
            }
            if (this.dM().purpurConfig.wanderingTraderAllowTrading) {
                this.f(player);
                this.a(player, this.Q_(), 1);
            }
            return EnumInteractionResult.a(this.dM().B);
        }
        return super.b(player, hand);
    }

    @Override
    protected void gl() {
        if (this.dM().I().b(FeatureFlags.d)) {
            this.go();
        } else {
            VillagerTrades.IMerchantRecipeOption[] avillagertrades_imerchantrecipeoption = (VillagerTrades.IMerchantRecipeOption[])VillagerTrades.b.get(1);
            VillagerTrades.IMerchantRecipeOption[] avillagertrades_imerchantrecipeoption1 = (VillagerTrades.IMerchantRecipeOption[])VillagerTrades.b.get(2);
            if (avillagertrades_imerchantrecipeoption != null && avillagertrades_imerchantrecipeoption1 != null) {
                MerchantRecipeList merchantrecipelist = this.gg();
                this.a(merchantrecipelist, avillagertrades_imerchantrecipeoption, 5);
                int i2 = this.ag.a(avillagertrades_imerchantrecipeoption1.length);
                VillagerTrades.IMerchantRecipeOption villagertrades_imerchantrecipeoption = avillagertrades_imerchantrecipeoption1[i2];
                MerchantRecipe merchantrecipe = villagertrades_imerchantrecipeoption.a(this, this.ag);
                if (merchantrecipe != null) {
                    VillagerAcquireTradeEvent event = new VillagerAcquireTradeEvent((AbstractVillager)this.getBukkitEntity(), (org.bukkit.inventory.MerchantRecipe)merchantrecipe.asBukkit());
                    if (this.valid) {
                        Bukkit.getPluginManager().callEvent((Event)event);
                    }
                    if (!event.isCancelled()) {
                        merchantrecipelist.add(CraftMerchantRecipe.fromBukkit(event.getRecipe()).toMinecraft());
                    }
                }
            }
        }
    }

    private void go() {
        MerchantRecipeList merchantrecipelist = this.gg();
        for (Pair<VillagerTrades.IMerchantRecipeOption[], Integer> pair : VillagerTrades.d) {
            VillagerTrades.IMerchantRecipeOption[] avillagertrades_imerchantrecipeoption = (VillagerTrades.IMerchantRecipeOption[])pair.getLeft();
            this.a(merchantrecipelist, avillagertrades_imerchantrecipeoption, (int)((Integer)pair.getRight()));
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("DespawnDelay", this.bX);
        if (this.bW != null) {
            nbt.a("WanderTarget", GameProfileSerializer.a(this.bW));
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        if (nbt.b("DespawnDelay", 99)) {
            this.bX = nbt.h("DespawnDelay");
        }
        if (nbt.e("WanderTarget")) {
            this.bW = GameProfileSerializer.b(nbt.p("WanderTarget"));
        }
        this.c_(Math.max(0, this.h()));
    }

    @Override
    public boolean h(double distanceSquared) {
        return false;
    }

    @Override
    protected void b(MerchantRecipe offer) {
        if (offer.s()) {
            int i2 = 3 + this.ag.a(4);
            this.dM().b(new EntityExperienceOrb(this.dM(), this.dr(), this.dt() + 0.5, this.dx(), i2, ExperienceOrb.SpawnReason.VILLAGER_TRADE, this.ge(), this));
        }
    }

    @Override
    protected SoundEffect y() {
        return this.gf() ? SoundEffects.At : SoundEffects.Al;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.Aq;
    }

    @Override
    public SoundEffect n_() {
        return SoundEffects.Am;
    }

    @Override
    protected SoundEffect c(ItemStack stack) {
        return stack.a(Items.qB) ? SoundEffects.Ao : SoundEffects.Ap;
    }

    @Override
    protected SoundEffect w(boolean sold) {
        return sold ? SoundEffects.Au : SoundEffects.Ar;
    }

    @Override
    public SoundEffect gi() {
        return SoundEffects.Au;
    }

    public void u(int despawnDelay) {
        this.bX = despawnDelay;
    }

    public int gn() {
        return this.bX;
    }

    @Override
    public void d_() {
        super.d_();
        if (!this.dM().B) {
            this.gp();
        }
    }

    private void gp() {
        if (this.bX > 0 && !this.gf() && --this.bX == 0) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    public void i(@Nullable BlockPosition wanderTarget) {
        this.bW = wanderTarget;
    }

    @Nullable
    public BlockPosition gr() {
        return this.bW;
    }

    private class a
    extends PathfinderGoal {
        final EntityVillagerTrader a;
        final double b;
        final double c;

        a(EntityVillagerTrader entityvillagertrader, double d0, double d1) {
            this.a = entityvillagertrader;
            this.b = d0;
            this.c = d1;
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public void d() {
            this.a.i((BlockPosition)null);
            EntityVillagerTrader.this.bN.n();
        }

        @Override
        public boolean a() {
            BlockPosition blockposition = this.a.gr();
            return blockposition != null && this.a(blockposition, this.b);
        }

        @Override
        public void e() {
            BlockPosition blockposition = this.a.gr();
            if (blockposition != null && EntityVillagerTrader.this.bN.l()) {
                if (this.a(blockposition, 10.0)) {
                    Vec3D vec3d = new Vec3D((double)blockposition.u() - this.a.dr(), (double)blockposition.v() - this.a.dt(), (double)blockposition.w() - this.a.dx()).d();
                    Vec3D vec3d1 = vec3d.a(10.0).b(this.a.dr(), this.a.dt(), this.a.dx());
                    EntityVillagerTrader.this.bN.a(vec3d1.c, vec3d1.d, vec3d1.e, this.c);
                } else {
                    EntityVillagerTrader.this.bN.a((double)blockposition.u(), (double)blockposition.v(), (double)blockposition.w(), this.c);
                }
            }
        }

        private boolean a(BlockPosition pos, double proximityDistance) {
            return !pos.a(this.a.dk(), proximityDistance);
        }
    }
}

