/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.player.AutoRecipeStackManager;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArmor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftHumanEntity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryHolder;

public class PlayerInventory
implements IInventory,
INamableTileEntity {
    public static final int c = 5;
    public static final int d = 36;
    private static final int n = 9;
    public static final int e = 40;
    public static final int f = -1;
    public static final int[] g = new int[]{0, 1, 2, 3};
    public static final int[] h = new int[]{3};
    public final NonNullList<ItemStack> i;
    public final NonNullList<ItemStack> j;
    public final NonNullList<ItemStack> k;
    public final List<NonNullList<ItemStack>> o;
    public int l;
    public final EntityHuman m;
    private int p;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 64;

    @Override
    public List<ItemStack> getContents() {
        ArrayList<ItemStack> combined = new ArrayList<ItemStack>(this.i.size() + this.j.size() + this.k.size());
        for (List list : this.o) {
            combined.addAll(list);
        }
        return combined;
    }

    public List<ItemStack> getArmorContents() {
        return this.j;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public InventoryHolder getOwner() {
        return this.m.getBukkitEntity();
    }

    @Override
    public int ak_() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    @Override
    public Location getLocation() {
        return this.m.getBukkitEntity().getLocation();
    }

    public PlayerInventory(EntityHuman player) {
        this.i = NonNullList.a(36, ItemStack.f);
        this.j = NonNullList.a(4, ItemStack.f);
        this.k = NonNullList.a(1, ItemStack.f);
        this.o = ImmutableList.of(this.i, this.j, this.k);
        this.m = player;
    }

    public ItemStack f() {
        return PlayerInventory.d(this.l) ? this.i.get(this.l) : ItemStack.f;
    }

    public static int g() {
        return 9;
    }

    private boolean a(ItemStack existingStack, ItemStack stack) {
        return !existingStack.b() && existingStack.h() && existingStack.L() < existingStack.g() && existingStack.L() < this.ak_() && ItemStack.c(existingStack, stack);
    }

    public int canHold(ItemStack itemstack) {
        int remains = itemstack.L();
        for (int i2 = 0; i2 < this.i.size(); ++i2) {
            ItemStack itemstack1 = this.a(i2);
            if (itemstack1.b()) {
                return itemstack.L();
            }
            if (this.a(itemstack1, itemstack)) {
                remains -= (itemstack1.g() < this.ak_() ? itemstack1.g() : this.ak_()) - itemstack1.L();
            }
            if (remains > 0) continue;
            return itemstack.L();
        }
        ItemStack offhandItemStack = this.a(this.i.size() + this.j.size());
        if (this.a(offhandItemStack, itemstack)) {
            remains -= (offhandItemStack.g() < this.ak_() ? offhandItemStack.g() : this.ak_()) - offhandItemStack.L();
        }
        if (remains <= 0) {
            return itemstack.L();
        }
        return itemstack.L() - remains;
    }

    public int h() {
        for (int i2 = 0; i2 < this.i.size(); ++i2) {
            if (!this.i.get(i2).b()) continue;
            return i2;
        }
        return -1;
    }

    public void a(ItemStack stack) {
        int i2 = this.b(stack);
        if (PlayerInventory.d(i2)) {
            this.l = i2;
        } else if (i2 == -1) {
            int j2;
            this.l = this.i();
            if (!this.i.get(this.l).b() && (j2 = this.h()) != -1) {
                this.i.set(j2, this.i.get(this.l));
            }
            this.i.set(this.l, stack);
        } else {
            this.c(i2);
        }
    }

    public void c(int slot) {
        this.pickSlot(slot, this.i());
    }

    public void pickSlot(int slot, int targetSlot) {
        this.l = targetSlot;
        ItemStack itemstack = this.i.get(this.l);
        this.i.set(this.l, this.i.get(slot));
        this.i.set(slot, itemstack);
    }

    public static boolean d(int slot) {
        return slot >= 0 && slot < 9;
    }

    public int b(ItemStack stack) {
        for (int i2 = 0; i2 < this.i.size(); ++i2) {
            if (this.i.get(i2).b() || !ItemStack.c(stack, this.i.get(i2))) continue;
            return i2;
        }
        return -1;
    }

    public int c(ItemStack stack) {
        for (int i2 = 0; i2 < this.i.size(); ++i2) {
            ItemStack itemstack1 = this.i.get(i2);
            if (this.i.get(i2).b() || !ItemStack.c(stack, this.i.get(i2)) || this.i.get(i2).j() || itemstack1.E() || itemstack1.A()) continue;
            return i2;
        }
        return -1;
    }

    public int i() {
        int i2;
        int j2;
        for (j2 = 0; j2 < 9; ++j2) {
            i2 = (this.l + j2) % 9;
            if (!this.i.get(i2).b()) continue;
            return i2;
        }
        for (j2 = 0; j2 < 9; ++j2) {
            i2 = (this.l + j2) % 9;
            if (this.i.get(i2).E()) continue;
            return i2;
        }
        return this.l;
    }

    public void a(double scrollAmount) {
        int i2 = (int)Math.signum(scrollAmount);
        this.l -= i2;
        while (this.l < 0) {
            this.l += 9;
        }
        while (this.l >= 9) {
            this.l -= 9;
        }
    }

    public int a(Predicate<ItemStack> shouldRemove, int maxCount, IInventory craftingInventory) {
        int b0 = 0;
        boolean flag = maxCount == 0;
        int j2 = b0 + ContainerUtil.a(this, shouldRemove, maxCount - b0, flag);
        j2 += ContainerUtil.a(craftingInventory, shouldRemove, maxCount - j2, flag);
        ItemStack itemstack = this.m.bS.g();
        j2 += ContainerUtil.a(itemstack, shouldRemove, maxCount - j2, flag);
        if (itemstack.b()) {
            this.m.bS.b(ItemStack.f);
        }
        return j2;
    }

    private int i(ItemStack stack) {
        int i2 = this.d(stack);
        if (i2 == -1) {
            i2 = this.h();
        }
        return i2 == -1 ? stack.L() : this.d(i2, stack);
    }

    private int d(int slot, ItemStack stack) {
        Item item = stack.d();
        int j2 = stack.L();
        ItemStack itemstack1 = this.a(slot);
        if (itemstack1.b()) {
            itemstack1 = new ItemStack(item, 0);
            if (stack.u()) {
                itemstack1.c(stack.v().h());
            }
            this.a(slot, itemstack1);
        }
        int k2 = j2;
        if (j2 > itemstack1.g() - itemstack1.L()) {
            k2 = itemstack1.g() - itemstack1.L();
        }
        if (k2 > this.ak_() - itemstack1.L()) {
            k2 = this.ak_() - itemstack1.L();
        }
        if (k2 == 0) {
            return j2;
        }
        itemstack1.g(k2);
        itemstack1.e(5);
        return j2 -= k2;
    }

    public int d(ItemStack stack) {
        if (this.a(this.a(this.l), stack)) {
            return this.l;
        }
        if (this.a(this.a(40), stack)) {
            return 40;
        }
        for (int i2 = 0; i2 < this.i.size(); ++i2) {
            if (!this.a(this.i.get(i2), stack)) continue;
            return i2;
        }
        return -1;
    }

    public void j() {
        for (NonNullList<ItemStack> nonnulllist : this.o) {
            for (int i2 = 0; i2 < nonnulllist.size(); ++i2) {
                if (nonnulllist.get(i2).b()) continue;
                nonnulllist.get(i2).a(this.m.dM(), this.m, i2, this.l == i2);
            }
        }
    }

    public boolean e(ItemStack stack) {
        return this.c(-1, stack);
    }

    public boolean c(int slot, ItemStack stack) {
        if (stack.b()) {
            return false;
        }
        try {
            int j2;
            if (stack.j()) {
                if (slot == -1) {
                    slot = this.h();
                }
                if (slot >= 0) {
                    this.i.set(slot, stack.c());
                    this.i.get(slot).e(5);
                    return true;
                }
                if (this.m.fT().d) {
                    stack.f(0);
                    return true;
                }
                return false;
            }
            do {
                j2 = stack.L();
                if (slot == -1) {
                    stack.f(this.i(stack));
                    continue;
                }
                stack.f(this.d(slot, stack));
            } while (!stack.b() && stack.L() < j2);
            if (stack.L() == j2 && this.m.fT().d) {
                stack.f(0);
                return true;
            }
            return stack.L() < j2;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Adding item to inventory");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Item being added");
            crashreportsystemdetails.a("Item ID", Item.a(stack.d()));
            crashreportsystemdetails.a("Item data", stack.k());
            crashreportsystemdetails.a("Item name", () -> stack.y().getString());
            throw new ReportedException(crashreport);
        }
    }

    public void f(ItemStack stack) {
        this.a(stack, true);
    }

    public void a(ItemStack stack, boolean notifiesClient) {
        while (!stack.b()) {
            int i2 = this.d(stack);
            if (i2 == -1) {
                i2 = this.h();
            }
            if (i2 != -1) {
                int j2 = stack.g() - this.a(i2).L();
                if (!this.c(i2, stack.a(j2)) || !notifiesClient || !(this.m instanceof EntityPlayer)) continue;
                ((EntityPlayer)this.m).c.b(new PacketPlayOutSetSlot(-2, 0, i2, this.a(i2)));
                continue;
            }
            this.m.a(stack, false);
            break;
        }
    }

    @Override
    public ItemStack a(int slot, int amount) {
        NonNullList<ItemStack> list = null;
        for (NonNullList<ItemStack> nonnulllist : this.o) {
            if (slot < nonnulllist.size()) {
                list = nonnulllist;
                break;
            }
            slot -= nonnulllist.size();
        }
        return list != null && !((ItemStack)list.get(slot)).b() ? ContainerUtil.a(list, slot, amount) : ItemStack.f;
    }

    public void g(ItemStack stack) {
        block0: for (NonNullList<ItemStack> nonnulllist : this.o) {
            for (int i2 = 0; i2 < nonnulllist.size(); ++i2) {
                if (nonnulllist.get(i2) != stack) continue;
                nonnulllist.set(i2, ItemStack.f);
                continue block0;
            }
        }
    }

    @Override
    public ItemStack b(int slot) {
        NonNullList<ItemStack> nonnulllist = null;
        for (NonNullList<ItemStack> nonnulllist1 : this.o) {
            if (slot < nonnulllist1.size()) {
                nonnulllist = nonnulllist1;
                break;
            }
            slot -= nonnulllist1.size();
        }
        if (nonnulllist != null && !((ItemStack)nonnulllist.get(slot)).b()) {
            ItemStack itemstack = nonnulllist.get(slot);
            nonnulllist.set(slot, ItemStack.f);
            return itemstack;
        }
        return ItemStack.f;
    }

    @Override
    public void a(int slot, ItemStack stack) {
        NonNullList<ItemStack> nonnulllist = null;
        for (NonNullList<ItemStack> nonnulllist1 : this.o) {
            if (slot < nonnulllist1.size()) {
                nonnulllist = nonnulllist1;
                break;
            }
            slot -= nonnulllist1.size();
        }
        if (nonnulllist != null) {
            nonnulllist.set(slot, stack);
        }
    }

    public float a(IBlockData block) {
        return this.i.get(this.l).a(block);
    }

    public NBTTagList a(NBTTagList nbtList) {
        NBTTagCompound nbttagcompound;
        int i2;
        for (i2 = 0; i2 < this.i.size(); ++i2) {
            if (this.i.get(i2).b()) continue;
            nbttagcompound = new NBTTagCompound();
            nbttagcompound.a("Slot", (byte)i2);
            this.i.get(i2).b(nbttagcompound);
            nbtList.add(nbttagcompound);
        }
        for (i2 = 0; i2 < this.j.size(); ++i2) {
            if (this.j.get(i2).b()) continue;
            nbttagcompound = new NBTTagCompound();
            nbttagcompound.a("Slot", (byte)(i2 + 100));
            this.j.get(i2).b(nbttagcompound);
            nbtList.add(nbttagcompound);
        }
        for (i2 = 0; i2 < this.k.size(); ++i2) {
            if (this.k.get(i2).b()) continue;
            nbttagcompound = new NBTTagCompound();
            nbttagcompound.a("Slot", (byte)(i2 + 150));
            this.k.get(i2).b(nbttagcompound);
            nbtList.add(nbttagcompound);
        }
        return nbtList;
    }

    public void b(NBTTagList nbtList) {
        this.i.clear();
        this.j.clear();
        this.k.clear();
        for (int i2 = 0; i2 < nbtList.size(); ++i2) {
            NBTTagCompound nbttagcompound = nbtList.a(i2);
            int j2 = nbttagcompound.f("Slot") & 0xFF;
            ItemStack itemstack = ItemStack.a(nbttagcompound);
            if (itemstack.b()) continue;
            if (j2 >= 0 && j2 < this.i.size()) {
                this.i.set(j2, itemstack);
                continue;
            }
            if (j2 >= 100 && j2 < this.j.size() + 100) {
                this.j.set(j2 - 100, itemstack);
                continue;
            }
            if (j2 < 150 || j2 >= this.k.size() + 150) continue;
            this.k.set(j2 - 150, itemstack);
        }
    }

    @Override
    public int b() {
        return this.i.size() + this.j.size() + this.k.size();
    }

    @Override
    public boolean ai_() {
        ItemStack itemstack;
        Iterator iterator = this.i.iterator();
        do {
            if (iterator.hasNext()) continue;
            iterator = this.j.iterator();
            do {
                if (iterator.hasNext()) continue;
                iterator = this.k.iterator();
                do {
                    if (iterator.hasNext()) continue;
                    return true;
                } while ((itemstack = (ItemStack)iterator.next()).b());
                return false;
            } while ((itemstack = (ItemStack)iterator.next()).b());
            return false;
        } while ((itemstack = (ItemStack)iterator.next()).b());
        return false;
    }

    @Override
    public ItemStack a(int slot) {
        NonNullList<ItemStack> list = null;
        for (NonNullList<ItemStack> nonnulllist : this.o) {
            if (slot < nonnulllist.size()) {
                list = nonnulllist;
                break;
            }
            slot -= nonnulllist.size();
        }
        return list == null ? ItemStack.f : (ItemStack)list.get(slot);
    }

    @Override
    public IChatBaseComponent ad() {
        return IChatBaseComponent.c("container.inventory");
    }

    public ItemStack e(int slot) {
        return this.j.get(slot);
    }

    public void a(DamageSource damageSource, float amount, int[] slots) {
        if (amount > 0.0f) {
            if ((amount /= 4.0f) < 1.0f) {
                amount = 1.0f;
            }
            int[] aint1 = slots;
            int i2 = slots.length;
            for (int j2 = 0; j2 < i2; ++j2) {
                int k2 = aint1[j2];
                ItemStack itemstack = this.j.get(k2);
                if (damageSource.a(DamageTypeTags.j) && itemstack.d().w() || !(itemstack.d() instanceof ItemArmor)) continue;
                itemstack.a((int)amount, this.m, (T entityhuman) -> entityhuman.d(EnumItemSlot.a(EnumItemSlot.Function.b, k2)));
            }
        }
    }

    public void k() {
        for (List list : this.o) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                ItemStack itemstack = (ItemStack)list.get(i2);
                if (itemstack.b()) continue;
                this.m.a(itemstack, true, false);
                list.set(i2, ItemStack.f);
            }
        }
    }

    @Override
    public void e() {
        ++this.p;
    }

    public int l() {
        return this.p;
    }

    @Override
    public boolean a(EntityHuman player) {
        return this.m.dH() ? false : player.f((Entity)this.m) <= 64.0;
    }

    public boolean h(ItemStack stack) {
        for (int i2 = 0; i2 < this.o.size(); ++i2) {
            List list = this.o.get(i2);
            for (int j2 = 0; j2 < list.size(); ++j2) {
                ItemStack itemstack1 = (ItemStack)list.get(j2);
                if (itemstack1.b() || !ItemStack.c(itemstack1, stack)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean a(TagKey<Item> tag) {
        for (List list : this.o) {
            for (ItemStack itemstack : list) {
                if (itemstack.b() || !itemstack.a(tag)) continue;
                return true;
            }
        }
        return false;
    }

    public void a(PlayerInventory other) {
        for (int i2 = 0; i2 < this.b(); ++i2) {
            this.a(i2, other.a(i2));
        }
        this.l = other.l;
    }

    @Override
    public void a() {
        for (List list : this.o) {
            list.clear();
        }
    }

    public void a(AutoRecipeStackManager finder) {
        for (ItemStack itemstack : this.i) {
            finder.a(itemstack);
        }
    }

    public ItemStack a(boolean entireStack) {
        ItemStack itemstack = this.f();
        return itemstack.b() ? ItemStack.f : this.a(this.l, entireStack ? itemstack.L() : 1);
    }
}

