/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import javax.annotation.Nullable;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.monster.EntityEndermite;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityProjectileThrowable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class EntityEnderPearl
extends EntityProjectileThrowable {
    public EntityEnderPearl(EntityTypes<? extends EntityEnderPearl> type, World world) {
        super((EntityTypes<? extends EntityProjectileThrowable>)type, world);
    }

    public EntityEnderPearl(World world, EntityLiving owner) {
        super((EntityTypes<? extends EntityProjectileThrowable>)EntityTypes.E, owner, world);
    }

    @Override
    protected Item s() {
        return Items.sc;
    }

    @Override
    protected void a(MovingObjectPositionEntity entityHitResult) {
        super.a(entityHitResult);
        entityHitResult.a().a(this.dN().b(this, this.w()), 0.0f);
    }

    @Override
    protected void a(MovingObjectPosition hitResult) {
        super.a(hitResult);
        for (int i2 = 0; i2 < 32; ++i2) {
            this.dM().a(Particles.Z, this.dr(), this.dt() + this.ag.j() * 2.0, this.dx(), this.ag.k(), 0.0, this.ag.k());
        }
        if (!this.dM().B && !this.dH()) {
            Entity entity = this.w();
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                if (entityplayer.c.c() && entityplayer.dM() == this.dM() && !entityplayer.fD()) {
                    CraftPlayer player = entityplayer.getBukkitEntity();
                    Location location = this.getBukkitEntity().getLocation();
                    location.setPitch(player.getLocation().getPitch());
                    location.setYaw(player.getLocation().getYaw());
                    PlayerTeleportEvent teleEvent = new PlayerTeleportEvent((Player)player, player.getLocation(), location, PlayerTeleportEvent.TeleportCause.ENDER_PEARL);
                    Bukkit.getPluginManager().callEvent((Event)teleEvent);
                    if (!teleEvent.isCancelled() && entityplayer.c.c()) {
                        EntityEndermite entityendermite;
                        if (this.ag.i() < this.dM().purpurConfig.enderPearlEndermiteChance && this.dM().Z().b(GameRules.e) && (entityendermite = EntityTypes.G.a(this.dM())) != null) {
                            entityendermite.setPlayerSpawned(true);
                            entityendermite.b(entity.dr(), entity.dt(), entity.dx(), entity.dC(), entity.dE());
                            this.dM().addFreshEntity(entityendermite, CreatureSpawnEvent.SpawnReason.ENDER_PEARL);
                        }
                        if (entity.bO()) {
                            entity.ac();
                        }
                        entityplayer.c.teleport(teleEvent.getTo());
                        entity.n();
                        entity.a(this.dN().k().customEventDamager(this), this.dM().purpurConfig.enderPearlDamage);
                    }
                    this.dM().a((EntityHuman)null, this.dr(), this.dt(), this.dx(), SoundEffects.ty, SoundCategory.h);
                }
            } else if (entity != null) {
                entity.c(this.dr(), this.dt(), this.dx());
                entity.n();
            }
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }

    @Override
    public void l() {
        Entity entity = this.w();
        if (entity instanceof EntityPlayer && !entity.bx() && this.dM().Z().b(GameRules.Y)) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            super.l();
        }
    }

    @Override
    @Nullable
    public Entity b(WorldServer destination) {
        Entity entity = this.w();
        if (entity != null && destination != null && entity.dM().ae() != destination.ae()) {
            this.b((Entity)null);
        }
        return super.b(destination);
    }
}

