/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.mojang.logging.LogUtils;
import io.papermc.paper.annotation.DoNotUse;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R3.CraftEquipmentSlot;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.slf4j.Logger;

public class EntityFishingHook
extends IProjectile {
    private static final Logger b = LogUtils.getLogger();
    private final RandomSource c = RandomSource.a();
    private boolean d;
    public int e;
    private static final int f = 10;
    public static final DataWatcherObject<Integer> g = DataWatcher.a(EntityFishingHook.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> h = DataWatcher.a(EntityFishingHook.class, DataWatcherRegistry.k);
    private int i;
    private int j;
    public int k;
    private int l;
    private float m;
    private boolean n = true;
    @Nullable
    public Entity o;
    public HookState p = HookState.a;
    private final int q;
    private final int r;
    public int minWaitTime = 100;
    public int maxWaitTime = 600;
    public int minLureTime = 20;
    public int maxLureTime = 80;
    public float minLureAngle = 0.0f;
    public float maxLureAngle = 360.0f;
    public boolean applyLure = true;
    public boolean rainInfluenced = true;
    public boolean skyInfluenced = true;

    private EntityFishingHook(EntityTypes<? extends EntityFishingHook> type, World world, int luckOfTheSeaLevel, int lureLevel) {
        super((EntityTypes<? extends IProjectile>)type, world);
        this.at = true;
        this.q = Math.max(0, luckOfTheSeaLevel);
        this.r = Math.max(0, lureLevel);
        this.minWaitTime = world.paperConfig().fishingTimeRange.minimum;
        this.maxWaitTime = world.paperConfig().fishingTimeRange.maximum;
    }

    public EntityFishingHook(EntityTypes<? extends EntityFishingHook> type, World world) {
        this(type, world, 0, 0);
    }

    public EntityFishingHook(EntityHuman thrower, World world, int luckOfTheSeaLevel, int lureLevel) {
        this(EntityTypes.bw, world, luckOfTheSeaLevel, lureLevel);
        this.b((Entity)thrower);
        float f2 = thrower.dE();
        float f1 = thrower.dC();
        float f22 = MathHelper.b(-f1 * ((float)Math.PI / 180) - (float)Math.PI);
        float f3 = MathHelper.a(-f1 * ((float)Math.PI / 180) - (float)Math.PI);
        float f4 = -MathHelper.b(-f2 * ((float)Math.PI / 180));
        float f5 = MathHelper.a(-f2 * ((float)Math.PI / 180));
        double d0 = thrower.dr() - (double)f3 * 0.3;
        double d1 = thrower.dv();
        double d2 = thrower.dx() - (double)f22 * 0.3;
        this.b(d0, d1, d2, f1, f2);
        Vec3D vec3d = new Vec3D(-f3, MathHelper.a(-(f5 / f4), -5.0f, 5.0f), -f22);
        double d3 = vec3d.f();
        vec3d = vec3d.d(0.6 / d3 + this.ag.a(0.5, 0.0103365), 0.6 / d3 + this.ag.a(0.5, 0.0103365), 0.6 / d3 + this.ag.a(0.5, 0.0103365));
        this.g(vec3d);
        this.r((float)(MathHelper.d(vec3d.c, vec3d.e) * 57.2957763671875));
        this.s((float)(MathHelper.d(vec3d.d, vec3d.h()) * 57.2957763671875));
        this.N = this.dC();
        this.O = this.dE();
    }

    @Override
    protected void c_() {
        this.an().a(g, 0);
        this.an().a(h, false);
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (g.equals(data)) {
            int i2 = this.an().b(g);
            Entity entity = this.o = i2 > 0 ? this.dM().a(i2 - 1) : null;
        }
        if (h.equals(data)) {
            this.d = this.an().b(h);
            if (this.d) {
                this.o(this.dp().c, -0.4f * MathHelper.a(this.c, 0.6f, 1.0f), this.dp().e);
            }
        }
        super.a(data);
    }

    @Override
    public boolean a(double distance) {
        double d1 = 64.0;
        return distance < 4096.0;
    }

    @Override
    public void a(double x2, double y2, double z2, float yaw, float pitch, int interpolationSteps) {
    }

    @Override
    public void l() {
        this.c.b(this.cw().getLeastSignificantBits() ^ this.dM().X());
        super.l();
        EntityHuman entityhuman = this.s();
        if (entityhuman == null) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else if (this.dM().B || !this.a(entityhuman)) {
            boolean flag;
            if (this.aC()) {
                ++this.i;
                if (this.i >= 1200) {
                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                    return;
                }
            } else {
                this.i = 0;
            }
            float f2 = 0.0f;
            BlockPosition blockposition = this.dm();
            Fluid fluid = this.dM().b_(blockposition);
            if (fluid.a(TagsFluid.a)) {
                f2 = fluid.a((IBlockAccess)this.dM(), blockposition);
            }
            boolean bl = flag = f2 > 0.0f;
            if (this.p == HookState.a) {
                if (this.o != null) {
                    this.g(Vec3D.b);
                    this.p = HookState.b;
                    return;
                }
                if (flag) {
                    this.g(this.dp().d(0.3, 0.2, 0.3));
                    this.p = HookState.c;
                    return;
                }
                this.x();
            } else {
                if (this.p == HookState.b) {
                    if (this.o != null) {
                        if (!this.o.dH() && this.o.dM().ae() == this.dM().ae()) {
                            this.a_(this.o.dr(), this.o.e(0.8), this.o.dx());
                        } else {
                            this.A(null);
                            this.p = HookState.a;
                        }
                    }
                    return;
                }
                if (this.p == HookState.c) {
                    Vec3D vec3d = this.dp();
                    double d0 = this.dt() + vec3d.d - (double)blockposition.v() - (double)f2;
                    if (Math.abs(d0) < 0.01) {
                        d0 += Math.signum(d0) * 0.1;
                    }
                    this.o(vec3d.c * 0.9, vec3d.d - d0 * (double)this.ag.i() * 0.2, vec3d.e * 0.9);
                    if (this.j <= 0 && this.l <= 0) {
                        this.n = true;
                    } else {
                        boolean bl2 = this.n = this.n && this.e < 10 && this.b(blockposition);
                    }
                    if (flag) {
                        this.e = Math.max(0, this.e - 1);
                        if (this.d) {
                            this.g(this.dp().b(0.0, -0.1 * (double)this.c.i() * (double)this.c.i(), 0.0));
                        }
                        if (!this.dM().B) {
                            this.a(blockposition);
                        }
                    } else {
                        this.e = Math.min(10, this.e + 1);
                    }
                }
            }
            if (!fluid.a(TagsFluid.a)) {
                this.g(this.dp().b(0.0, -0.03, 0.0));
            }
            this.a(EnumMoveType.a, this.dp());
            this.K();
            if (this.p == HookState.a && (this.aC() || this.P)) {
                this.g(Vec3D.b);
            }
            double d1 = 0.92;
            this.g(this.dp().a(0.92));
            this.ar();
        }
    }

    private boolean a(EntityHuman player) {
        ItemStack itemstack = player.eT();
        ItemStack itemstack1 = player.eU();
        boolean flag = itemstack.a(Items.qS);
        boolean flag1 = itemstack1.a(Items.qS);
        if (!player.dH() && player.bx() && (flag || flag1) && this.f(player) <= 1024.0) {
            return false;
        }
        this.discard(EntityRemoveEvent.Cause.DESPAWN);
        return true;
    }

    private void x() {
        MovingObjectPosition movingobjectposition = ProjectileHelper.a((Entity)this, this::a);
        this.preOnHit(movingobjectposition);
    }

    @Override
    public boolean a(Entity entity) {
        return super.a(entity) || entity.bx() && entity instanceof EntityItem;
    }

    @Override
    protected void a(MovingObjectPositionEntity entityHitResult) {
        super.a(entityHitResult);
        if (!this.dM().B) {
            this.A(entityHitResult.a());
        }
    }

    @Override
    protected void a(MovingObjectPositionBlock blockHitResult) {
        super.a(blockHitResult);
        this.g(this.dp().d().a(blockHitResult.a(this)));
    }

    public void A(@Nullable Entity entity) {
        this.o = entity;
        this.an().b(g, entity == null ? 0 : entity.aj() + 1);
    }

    private void a(BlockPosition pos) {
        WorldServer worldserver = (WorldServer)this.dM();
        int i2 = 1;
        BlockPosition blockposition1 = pos.c();
        if (this.rainInfluenced && this.ag.i() < 0.25f && this.dM().r(blockposition1)) {
            ++i2;
        }
        if (this.skyInfluenced && this.ag.i() < 0.5f && !this.dM().h(blockposition1)) {
            --i2;
        }
        if (this.j > 0) {
            --this.j;
            if (this.j <= 0) {
                this.k = 0;
                this.l = 0;
                this.an().b(h, false);
                PlayerFishEvent playerFishEvent = new PlayerFishEvent((Player)this.s().getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.FAILED_ATTEMPT);
                this.dM().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
            }
        } else if (this.l > 0) {
            this.l -= i2;
            if (this.l > 0) {
                double d2;
                double d1;
                this.m += (float)this.ag.a(0.0, 9.188);
                float f2 = this.m * ((float)Math.PI / 180);
                float f1 = MathHelper.a(f2);
                float f22 = MathHelper.b(f2);
                double d0 = this.dr() + (double)(f1 * (float)this.l * 0.1f);
                IBlockData iblockdata = worldserver.a_(BlockPosition.a(d0, (d1 = (double)((float)MathHelper.a(this.dt()) + 1.0f)) - 1.0, d2 = this.dx() + (double)(f22 * (float)this.l * 0.1f)));
                if (iblockdata.a(Blocks.G)) {
                    if (this.ag.i() < 0.15f) {
                        worldserver.a(Particles.e, d0, d1 - (double)0.1f, d2, 1, (double)f1, 0.1, (double)f22, 0.0);
                    }
                    float f3 = f1 * 0.04f;
                    float f4 = f22 * 0.04f;
                    worldserver.a(Particles.D, d0, d1, d2, 0, (double)f4, 0.01, (double)(-f3), 1.0);
                    worldserver.a(Particles.D, d0, d1, d2, 0, (double)(-f4), 0.01, (double)f3, 1.0);
                }
            } else {
                PlayerFishEvent playerFishEvent = new PlayerFishEvent((Player)this.s().getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.BITE);
                this.dM().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
                if (playerFishEvent.isCancelled()) {
                    return;
                }
                this.a(SoundEffects.it, 0.25f, 1.0f + (this.ag.i() - this.ag.i()) * 0.4f);
                double d3 = this.dt() + 0.5;
                worldserver.a(Particles.e, this.dr(), d3, this.dx(), (int)(1.0f + this.dg() * 20.0f), (double)this.dg(), 0.0, (double)this.dg(), 0.2f);
                worldserver.a(Particles.D, this.dr(), d3, this.dx(), (int)(1.0f + this.dg() * 20.0f), (double)this.dg(), 0.0, (double)this.dg(), 0.2f);
                this.j = MathHelper.a(this.ag, 20, 40);
                this.an().b(h, true);
            }
        } else if (this.k > 0) {
            this.k -= i2;
            float f3 = 0.15f;
            if (this.k < 20) {
                f3 += (float)(20 - this.k) * 0.05f;
            } else if (this.k < 40) {
                f3 += (float)(40 - this.k) * 0.02f;
            } else if (this.k < 60) {
                f3 += (float)(60 - this.k) * 0.01f;
            }
            if (this.ag.i() < f3) {
                double d2;
                double d1;
                float f1 = MathHelper.a(this.ag, 0.0f, 360.0f) * ((float)Math.PI / 180);
                float f2 = MathHelper.a(this.ag, 25.0f, 60.0f);
                double d0 = this.dr() + (double)(MathHelper.a(f1) * f2) * 0.1;
                IBlockData iblockdata = worldserver.a_(BlockPosition.a(d0, (d1 = (double)((float)MathHelper.a(this.dt()) + 1.0f)) - 1.0, d2 = this.dx() + (double)(MathHelper.b(f1) * f2) * 0.1));
                if (iblockdata.a(Blocks.G)) {
                    worldserver.a(Particles.aj, d0, d1, d2, 2 + this.ag.a(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                }
            }
            if (this.k <= 0) {
                this.m = MathHelper.a(this.ag, this.minLureAngle, this.maxLureAngle);
                this.l = MathHelper.a(this.ag, this.minLureTime, this.maxLureTime);
            }
        } else {
            this.k = MathHelper.a(this.ag, this.minWaitTime, this.maxWaitTime);
            this.k -= this.applyLure ? (this.r * 20 * 5 >= this.maxWaitTime ? this.k - 1 : this.r * 20 * 5) : 0;
        }
    }

    public boolean b(BlockPosition pos) {
        WaterPosition entityfishinghook_waterposition = WaterPosition.c;
        for (int i2 = -1; i2 <= 2; ++i2) {
            WaterPosition entityfishinghook_waterposition1 = this.a(pos.b(-2, i2, -2), pos.b(2, i2, 2));
            switch (entityfishinghook_waterposition1) {
                case c: {
                    return false;
                }
                case a: {
                    if (entityfishinghook_waterposition != WaterPosition.c) break;
                    return false;
                }
                case b: {
                    if (entityfishinghook_waterposition != WaterPosition.a) break;
                    return false;
                }
            }
            entityfishinghook_waterposition = entityfishinghook_waterposition1;
        }
        return true;
    }

    private WaterPosition a(BlockPosition start, BlockPosition end) {
        return BlockPosition.b(start, end).map(this::c).reduce((entityfishinghook_waterposition, entityfishinghook_waterposition1) -> entityfishinghook_waterposition == entityfishinghook_waterposition1 ? entityfishinghook_waterposition : WaterPosition.c).orElse(WaterPosition.c);
    }

    private WaterPosition c(BlockPosition pos) {
        IBlockData iblockdata = this.dM().a_(pos);
        if (!iblockdata.i() && !iblockdata.a(Blocks.fm)) {
            Fluid fluid = iblockdata.u();
            return fluid.a(TagsFluid.a) && fluid.b() && iblockdata.k(this.dM(), pos).c() ? WaterPosition.b : WaterPosition.c;
        }
        return WaterPosition.a;
    }

    public boolean q() {
        return this.n;
    }

    @Override
    public void b(NBTTagCompound nbt) {
    }

    @Override
    public void a(NBTTagCompound nbt) {
    }

    @Deprecated
    @DoNotUse
    public int a(ItemStack usedItem) {
        return this.retrieve(EnumHand.a, usedItem);
    }

    public int retrieve(EnumHand hand, ItemStack usedItem) {
        EntityHuman entityhuman = this.s();
        if (!this.dM().B && entityhuman != null && !this.a(entityhuman)) {
            PlayerFishEvent playerFishEvent;
            int i2 = 0;
            if (this.o != null) {
                playerFishEvent = new PlayerFishEvent((Player)entityhuman.getBukkitEntity(), (org.bukkit.entity.Entity)this.o.getBukkitEntity(), (FishHook)this.getBukkitEntity(), CraftEquipmentSlot.getHand(hand), PlayerFishEvent.State.CAUGHT_ENTITY);
                this.dM().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
                if (playerFishEvent.isCancelled()) {
                    return 0;
                }
                this.c(this.o);
                CriterionTriggers.E.a((EntityPlayer)entityhuman, usedItem, this, Collections.emptyList());
                this.dM().a((Entity)this, (byte)31);
                i2 = this.o instanceof EntityItem ? 3 : 5;
            } else if (this.j > 0) {
                LootParams lootparams = new LootParams.a((WorldServer)this.dM()).a(LootContextParameters.f, this.dk()).a(LootContextParameters.i, usedItem).a(LootContextParameters.a, this).a((float)this.q + entityhuman.go()).a(LootContextParameterSets.f);
                LootTable loottable = this.dM().o().aJ().getLootTable(LootTables.as);
                ObjectArrayList<ItemStack> list = loottable.a(lootparams);
                CriterionTriggers.E.a((EntityPlayer)entityhuman, usedItem, this, (Collection<ItemStack>)list);
                for (ItemStack itemstack1 : list) {
                    Entity entityitem = null;
                    if (!itemstack1.b()) {
                        entityitem = new EntityItem(this.dM(), this.dr(), this.dt(), this.dx(), itemstack1);
                    }
                    PlayerFishEvent playerFishEvent2 = new PlayerFishEvent((Player)entityhuman.getBukkitEntity(), (org.bukkit.entity.Entity)(entityitem != null ? entityitem.getBukkitEntity() : null), (FishHook)this.getBukkitEntity(), CraftEquipmentSlot.getHand(hand), PlayerFishEvent.State.CAUGHT_FISH);
                    playerFishEvent2.setExpToDrop(this.ag.a(6) + 1);
                    this.dM().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent2);
                    if (playerFishEvent2.isCancelled()) {
                        return 0;
                    }
                    double d0 = entityhuman.dr() - this.dr();
                    double d1 = entityhuman.dt() - this.dt();
                    double d2 = entityhuman.dx() - this.dx();
                    double d3 = 0.1;
                    if (entityitem != null) {
                        entityitem.o(d0 * 0.1, d1 * 0.1 + Math.sqrt(Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2)) * 0.08, d2 * 0.1);
                        this.dM().b(entityitem);
                    }
                    if (playerFishEvent2.getExpToDrop() > 0) {
                        entityhuman.dM().b(new EntityExperienceOrb(entityhuman.dM(), entityhuman.dr(), entityhuman.dt() + 0.5, entityhuman.dx() + 0.5, playerFishEvent2.getExpToDrop(), ExperienceOrb.SpawnReason.FISHING, this.s(), this));
                    }
                    if (!itemstack1.a(TagsItem.ao)) continue;
                    entityhuman.a(StatisticList.R, 1);
                }
                i2 = 1;
            }
            if (this.aC()) {
                playerFishEvent = new PlayerFishEvent((Player)entityhuman.getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), CraftEquipmentSlot.getHand(hand), PlayerFishEvent.State.IN_GROUND);
                this.dM().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
                if (playerFishEvent.isCancelled()) {
                    return 0;
                }
                i2 = 2;
            }
            if (i2 == 0) {
                playerFishEvent = new PlayerFishEvent((Player)entityhuman.getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), CraftEquipmentSlot.getHand(hand), PlayerFishEvent.State.REEL_IN);
                this.dM().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
                if (playerFishEvent.isCancelled()) {
                    return 0;
                }
            }
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
            return i2;
        }
        return 0;
    }

    @Override
    public void b(byte status) {
        if (status == 31 && this.dM().B && this.o instanceof EntityHuman && ((EntityHuman)this.o).g()) {
            this.c(this.o);
        }
        super.b(status);
    }

    public void c(Entity entity) {
        Entity entity1 = this.w();
        if (entity1 != null) {
            Vec3D vec3d = new Vec3D(entity1.dr() - this.dr(), entity1.dt() - this.dt(), entity1.dx() - this.dx()).a(0.1);
            entity.g(entity.dp().e(vec3d));
        }
    }

    @Override
    protected Entity.MovementEmission aW() {
        return Entity.MovementEmission.a;
    }

    @Override
    public void a(Entity.RemovalReason reason) {
        this.remove(reason, null);
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        this.a((EntityFishingHook)null);
        super.remove(entity_removalreason, cause);
    }

    @Override
    public void ao() {
        this.a((EntityFishingHook)null);
    }

    @Override
    public void b(@Nullable Entity entity) {
        super.b(entity);
        this.a(this);
    }

    private void a(@Nullable EntityFishingHook fishingBobber) {
        EntityHuman entityhuman = this.s();
        if (entityhuman != null) {
            entityhuman.ck = fishingBobber;
        }
    }

    @Nullable
    public EntityHuman s() {
        Entity entity = this.w();
        return entity instanceof EntityHuman ? (EntityHuman)entity : null;
    }

    @Nullable
    public Entity u() {
        return this.o;
    }

    @Override
    public boolean ct() {
        return false;
    }

    @Override
    public Packet<PacketListenerPlayOut> dj() {
        Entity entity = this.w();
        return new PacketPlayOutSpawnEntity(this, entity == null ? this.aj() : entity.aj());
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        if (this.s() == null) {
            int i2 = packet.o();
            b.error("Failed to recreate fishing hook on client. {} (id: {}) is not a valid owner.", (Object)this.dM().a(i2), (Object)i2);
            this.al();
        }
    }

    public static enum HookState {
        a,
        b,
        c;

    }

    private static enum WaterPosition {
        a,
        b,
        c;

    }
}

