/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.base.MoreObjects;
import gg.pufferfish.pufferfish.PufferfishConfig;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityEnderPearl;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.projectiles.ProjectileSource;

public abstract class IProjectile
extends Entity
implements TraceableEntity {
    @Nullable
    public UUID b;
    @Nullable
    public Entity c;
    public boolean d;
    public boolean e;
    protected boolean hitCancelled = false;
    private static int loadedThisTick = 0;
    private static int loadedTick;
    private int loadedLifetime = 0;

    IProjectile(EntityTypes<? extends IProjectile> type, World world) {
        super(type, world);
    }

    @Override
    public void a_(double x2, double y2, double z2) {
        int currentTick = MinecraftServer.currentTick;
        if (loadedTick != currentTick) {
            loadedTick = currentTick;
            loadedThisTick = 0;
        }
        int previousX = MathHelper.a(this.dr()) >> 4;
        int previousZ = MathHelper.a(this.dx()) >> 4;
        int newX = MathHelper.a(x2) >> 4;
        int newZ = MathHelper.a(z2) >> 4;
        if (previousX != newX || previousZ != newZ) {
            boolean isLoaded;
            boolean bl = isLoaded = ((ChunkProviderServer)this.dM().L()).getChunkAtIfLoadedMainThread(newX, newZ) != null;
            if (!isLoaded) {
                if (loadedThisTick > PufferfishConfig.maxProjectileLoadsPerTick) {
                    if (++this.loadedLifetime > PufferfishConfig.maxProjectileLoadsPerProjectile) {
                        this.discard(EntityRemoveEvent.Cause.DISCARD);
                    }
                    return;
                }
                ++loadedThisTick;
            }
        }
        super.a_(x2, y2, z2);
    }

    public void b(@Nullable Entity entity) {
        if (entity != null) {
            this.b = entity.cw();
            this.c = entity;
        } else {
            this.b = null;
            this.c = null;
            this.projectileSource = null;
        }
        this.refreshProjectileSource(false);
    }

    public void refreshProjectileSource(boolean fillCache) {
        CraftEntity craftEntity;
        if (fillCache) {
            this.w();
        }
        if (this.c != null && !this.c.dH() && this.projectileSource == null && (craftEntity = this.c.getBukkitEntity()) instanceof ProjectileSource) {
            ProjectileSource projSource;
            this.projectileSource = projSource = (ProjectileSource)craftEntity;
        }
    }

    @Override
    @Nullable
    public Entity w() {
        World world;
        if (this.c != null && !this.c.dH()) {
            this.refreshProjectileSource(false);
            return this.c;
        }
        if (this.b != null && (world = this.dM()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.c = worldserver.a(this.b);
            this.refreshProjectileSource(false);
            return this.c;
        }
        return null;
    }

    public Entity J() {
        return (Entity)MoreObjects.firstNonNull((Object)this.w(), (Object)this);
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        if (this.b != null) {
            nbt.a("Owner", this.b);
        }
        if (this.d) {
            nbt.a("LeftOwner", true);
        }
        nbt.a("HasBeenShot", this.e);
    }

    protected boolean d(Entity entity) {
        return entity.cw().equals(this.b);
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        if (nbt.b("Owner")) {
            this.b = nbt.a("Owner");
            this.c = null;
            if (this instanceof EntityEnderPearl && this.dM() != null && this.dM().paperConfig().fixes.disableUnloadedChunkEnderpearlExploit) {
                this.b = null;
            }
        }
        this.d = nbt.q("LeftOwner");
        this.e = nbt.q("HasBeenShot");
    }

    @Override
    public void w(Entity original) {
        super.w(original);
        if (original instanceof IProjectile) {
            IProjectile iprojectile = (IProjectile)original;
            this.c = iprojectile.c;
        }
    }

    @Override
    public void l() {
        if (!this.e) {
            this.a(GameEvent.K, this.w());
            this.e = true;
        }
        if (!this.d) {
            this.d = this.s();
        }
        super.l();
    }

    private boolean s() {
        Entity entity = this.w();
        if (entity != null) {
            for (Entity entity12 : this.dM().a((Entity)this, this.cH().b(this.dp()).g(1.0), (? super Entity entity1) -> !entity1.P_() && entity1.bt())) {
                if (entity12.cW() != entity.cW()) continue;
                return false;
            }
        }
        return true;
    }

    public void c(double x2, double y2, double z2, float speed, float divergence) {
        Vec3D vec3d = new Vec3D(x2, y2, z2).d().b(this.ag.a(0.0, 0.0172275 * (double)divergence), this.ag.a(0.0, 0.0172275 * (double)divergence), this.ag.a(0.0, 0.0172275 * (double)divergence)).a((double)speed);
        this.g(vec3d);
        double d3 = vec3d.h();
        this.r((float)(MathHelper.d(vec3d.c, vec3d.e) * 57.2957763671875));
        this.s((float)(MathHelper.d(vec3d.d, d3) * 57.2957763671875));
        this.N = this.dC();
        this.O = this.dE();
    }

    public void a(Entity shooter, float pitch, float yaw, float roll, float speed, float divergence) {
        float f5 = -MathHelper.a(yaw * ((float)Math.PI / 180)) * MathHelper.b(pitch * ((float)Math.PI / 180));
        float f6 = -MathHelper.a((pitch + roll) * ((float)Math.PI / 180));
        float f7 = MathHelper.b(yaw * ((float)Math.PI / 180)) * MathHelper.b(pitch * ((float)Math.PI / 180));
        this.c(f5, f6, f7, speed, divergence);
        Vec3D vec3d = shooter.dp();
        if (!shooter.dM().paperConfig().misc.disableRelativeProjectileVelocity) {
            this.g(this.dp().b(vec3d.c, shooter.aC() ? 0.0 : vec3d.d, vec3d.e));
        }
    }

    public void preOnHit(MovingObjectPosition movingobjectposition) {
        ProjectileHitEvent event = CraftEventFactory.callProjectileHitEvent(this, movingobjectposition);
        boolean bl = this.hitCancelled = event != null && event.isCancelled();
        if (movingobjectposition.c() == MovingObjectPosition.EnumMovingObjectType.b || !this.hitCancelled) {
            this.a(movingobjectposition);
        }
    }

    protected void a(MovingObjectPosition hitResult) {
        MovingObjectPosition.EnumMovingObjectType movingobjectposition_enummovingobjecttype = hitResult.c();
        if (movingobjectposition_enummovingobjecttype == MovingObjectPosition.EnumMovingObjectType.c) {
            this.a((MovingObjectPositionEntity)hitResult);
            this.dM().a(GameEvent.J, hitResult.e(), GameEvent.a.a(this, null));
        } else if (movingobjectposition_enummovingobjecttype == MovingObjectPosition.EnumMovingObjectType.b) {
            MovingObjectPositionBlock movingobjectpositionblock = (MovingObjectPositionBlock)hitResult;
            this.a(movingobjectpositionblock);
            BlockPosition blockposition = movingobjectpositionblock.a();
            this.dM().a(GameEvent.J, blockposition, GameEvent.a.a(this, this.dM().a_(blockposition)));
        }
    }

    protected void a(MovingObjectPositionEntity entityHitResult) {
    }

    protected void a(MovingObjectPositionBlock blockHitResult) {
        if (this.hitCancelled) {
            return;
        }
        IBlockData iblockdata = this.dM().a_(blockHitResult.a());
        iblockdata.a(this.dM(), iblockdata, blockHitResult, this);
    }

    @Override
    public void l(double x2, double y2, double z2) {
        this.o(x2, y2, z2);
        if (this.O == 0.0f && this.N == 0.0f) {
            double d3 = Math.sqrt(x2 * x2 + z2 * z2);
            this.s((float)(MathHelper.d(y2, d3) * 57.2957763671875));
            this.r((float)(MathHelper.d(x2, z2) * 57.2957763671875));
            this.O = this.dE();
            this.N = this.dC();
            this.b(this.dr(), this.dt(), this.dx(), this.dC(), this.dE());
        }
    }

    public boolean a(Entity entity) {
        if (!entity.bs()) {
            return false;
        }
        Entity entity1 = this.w();
        if (entity1 instanceof EntityPlayer && entity instanceof EntityPlayer) {
            Player collided = (Player)entity.getBukkitEntity();
            Player shooter = (Player)entity1.getBukkitEntity();
            if (!shooter.canSee(collided)) {
                return false;
            }
        }
        return entity1 == null || this.d || !entity1.y(entity);
    }

    protected void K() {
        Vec3D vec3d = this.dp();
        double d0 = vec3d.h();
        this.s(IProjectile.d(this.O, (float)(MathHelper.d(vec3d.d, d0) * 57.2957763671875)));
        this.r(IProjectile.d(this.N, (float)(MathHelper.d(vec3d.c, vec3d.e) * 57.2957763671875)));
    }

    protected static float d(float prevRot, float newRot) {
        prevRot += (float)Math.round((newRot - prevRot) / 360.0f) * 360.0f;
        return MathHelper.i(0.2f, prevRot, newRot);
    }

    @Override
    public Packet<PacketListenerPlayOut> dj() {
        Entity entity = this.w();
        return new PacketPlayOutSpawnEntity(this, entity == null ? 0 : entity.aj());
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        Entity entity = this.dM().a(packet.o());
        if (entity != null) {
            this.b(entity);
        }
    }

    @Override
    public boolean a(World world, BlockPosition pos) {
        Entity entity = this.w();
        return entity instanceof EntityHuman ? entity.a(world, pos) : entity == null || world.purpurConfig.projectilesBypassMobGriefing || world.Z().b(GameRules.c);
    }

    public boolean b(World world) {
        return this.ai().a(TagsEntity.g) && world.Z().b(GameRules.g);
    }
}

