/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import com.destroystokyo.paper.loottable.PaperLootableInventoryData;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.IPosition;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.Vec3D;

public interface ContainerEntity
extends IInventory,
ITileInventory {
    public Vec3D dk();

    @Nullable
    public MinecraftKey C();

    public void a(@Nullable MinecraftKey var1);

    public long D();

    public void a(long var1);

    public NonNullList<ItemStack> E();

    public void G();

    public World dM();

    public boolean dH();

    @Override
    default public boolean ai_() {
        return this.g();
    }

    default public void c(NBTTagCompound nbt) {
        if (this.C() != null) {
            nbt.a("LootTable", this.C().toString());
            if (this.D() != 0L) {
                nbt.a("LootTableSeed", this.D());
            }
        }
        ContainerUtil.a(nbt, this.E());
    }

    default public void b_(NBTTagCompound nbt) {
        this.G();
        if (nbt.b("LootTable", 8)) {
            this.a(MinecraftKey.a(nbt.l("LootTable")));
            this.a(nbt.i("LootTableSeed"));
        }
        ContainerUtil.b(nbt, this.E());
    }

    default public void a(DamageSource source, World world, Entity vehicle) {
        if (world.Z().b(GameRules.i)) {
            Entity entity;
            InventoryUtils.a(world, vehicle, (IInventory)this);
            if (!world.B && (entity = source.c()) != null && entity.ai() == EntityTypes.bv) {
                PiglinAI.a((EntityHuman)entity, true);
            }
        }
    }

    default public EnumInteractionResult c_(EntityHuman player) {
        player.a(this);
        return !player.dM().B ? EnumInteractionResult.b : EnumInteractionResult.a;
    }

    default public void f(@Nullable EntityHuman player) {
        MinecraftServer minecraftServer = this.dM().o();
        if (this.getLootableData().shouldReplenish(player) && minecraftServer != null) {
            LootTable lootTable = minecraftServer.aJ().getLootTable(this.C());
            if (player != null) {
                CriterionTriggers.O.a((EntityPlayer)player, this.C());
            }
            this.getLootableData().processRefill(player);
            LootParams.a builder = new LootParams.a((WorldServer)this.dM()).a(LootContextParameters.f, this.dk());
            if (player != null) {
                builder.a(player.go()).a(LootContextParameters.a, player);
            }
            lootTable.a(this, builder.a(LootContextParameterSets.c), this.D());
        }
    }

    default public void f() {
        this.f(null);
        this.E().clear();
    }

    default public boolean g() {
        for (ItemStack itemStack : this.E()) {
            if (itemStack.b()) continue;
            return false;
        }
        return true;
    }

    default public ItemStack e_(int slot) {
        this.f(null);
        ItemStack itemStack = this.E().get(slot);
        if (itemStack.b()) {
            return ItemStack.f;
        }
        this.E().set(slot, ItemStack.f);
        return itemStack;
    }

    default public ItemStack f_(int slot) {
        this.f(null);
        return this.E().get(slot);
    }

    default public ItemStack b(int slot, int amount) {
        this.f(null);
        return ContainerUtil.a(this.E(), slot, amount);
    }

    default public void c(int slot, ItemStack stack) {
        this.f(null);
        this.E().set(slot, stack);
        if (!stack.b() && stack.L() > this.ak_()) {
            stack.f(this.ak_());
        }
    }

    default public SlotAccess g_(final int slot) {
        return slot >= 0 && slot < this.b() ? new SlotAccess(){

            @Override
            public ItemStack a() {
                return ContainerEntity.this.f_(slot);
            }

            @Override
            public boolean a(ItemStack stack) {
                ContainerEntity.this.c(slot, stack);
                return true;
            }
        } : SlotAccess.b;
    }

    default public boolean g(EntityHuman player) {
        return !this.dH() && this.dk().a((IPosition)player.dk(), 8.0);
    }

    default public Entity getEntity() {
        throw new UnsupportedOperationException();
    }

    default public PaperLootableInventoryData getLootableData() {
        throw new UnsupportedOperationException();
    }
}

