/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayInBoatMove;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityWaterAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockWaterLily;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R3.CraftServer;
import org.bukkit.craftbukkit.v1_20_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftLocation;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.event.vehicle.VehicleUpdateEvent;
import org.joml.Vector3f;

public class EntityBoat
extends VehicleEntity
implements VariantHolder<EnumBoatType> {
    private static final DataWatcherObject<Integer> i = DataWatcher.a(EntityBoat.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> j = DataWatcher.a(EntityBoat.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> k = DataWatcher.a(EntityBoat.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> l = DataWatcher.a(EntityBoat.class, DataWatcherRegistry.b);
    public static final int b = 0;
    public static final int c = 1;
    private static final int m = 60;
    private static final float n = 0.3926991f;
    public static final double d = 0.7853981852531433;
    public static final int e = 60;
    private final float[] o = new float[2];
    private float p;
    private float q;
    private float r;
    private int s;
    private double t;
    private double u;
    private double v;
    private double aE;
    private double aF;
    private boolean aG;
    private boolean aH;
    private boolean aI;
    private boolean aJ;
    private double aK;
    private float aL;
    public EnumStatus aM;
    private EnumStatus aN;
    private double aO;
    private boolean aP;
    private boolean aQ;
    private float aR;
    private float aS;
    private float aT;
    public double maxSpeed = 0.4;
    public double occupiedDeceleration = 0.2;
    public double unoccupiedDeceleration = -1.0;
    public boolean landBoats = false;
    private Location lastLocation;

    public EntityBoat(EntityTypes<? extends EntityBoat> type, World world) {
        super(type, world);
        this.I = true;
    }

    public EntityBoat(World world, double x2, double y2, double z2) {
        this((EntityTypes<? extends EntityBoat>)EntityTypes.k, world);
        this.a_(x2, y2, z2);
        this.K = x2;
        this.L = y2;
        this.M = z2;
    }

    @Override
    protected float a(EntityPose pose, EntitySize dimensions) {
        return dimensions.b;
    }

    @Override
    protected Entity.MovementEmission aW() {
        return Entity.MovementEmission.c;
    }

    @Override
    protected void c_() {
        super.c_();
        this.an.a(i, EnumBoatType.a.ordinal());
        this.an.a(j, false);
        this.an.a(k, false);
        this.an.a(l, 0);
    }

    @Override
    public boolean h(Entity other) {
        return EntityBoat.a(this, other);
    }

    public static boolean a(Entity entity, Entity other) {
        return (other.bz() || other.bu()) && !entity.y(other);
    }

    @Override
    public boolean bz() {
        return true;
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return true;
    }

    @Override
    protected Vec3D a(EnumDirection.EnumAxis portalAxis, BlockUtil.Rectangle portalRect) {
        return EntityLiving.i(super.a(portalAxis, portalRect));
    }

    @Override
    protected Vector3f a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        float f1 = this.x();
        if (this.cP().size() > 1) {
            int i2 = this.cP().indexOf(passenger);
            f1 = i2 == 0 ? 0.2f : -0.6f;
            if (passenger instanceof EntityAnimal) {
                f1 += 0.2f;
            }
        }
        return new Vector3f(0.0f, this.y() == EnumBoatType.i ? dimensions.b * 0.8888889f : dimensions.b / 3.0f, f1);
    }

    @Override
    public void k(boolean drag) {
        if (!this.dM().B) {
            this.aP = true;
            this.aQ = drag;
            if (this.I() == 0) {
                this.b(60);
            }
        }
        this.dM().a(Particles.aj, this.dr() + (double)this.ag.i(), this.dt() + 0.7, this.dx() + (double)this.ag.i(), 0.0, 0.0, 0.0);
        if (this.ag.a(20) == 0) {
            this.dM().a(this.dr(), this.dt(), this.dx(), this.aO(), this.db(), 1.0f, 0.8f + 0.4f * this.ag.i(), false);
            this.a(GameEvent.O, (Entity)this.cN());
        }
    }

    @Override
    public void g(Entity entity) {
        if (!this.dM().paperConfig().collisions.allowVehicleCollisions && this.dM().paperConfig().collisions.onlyPlayersCollide && !(entity instanceof EntityHuman)) {
            return;
        }
        if (entity instanceof EntityBoat) {
            if (entity.cH().b < this.cH().e) {
                if (!this.y(entity)) {
                    VehicleEntityCollisionEvent event = new VehicleEntityCollisionEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity());
                    this.dM().getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return;
                    }
                }
                super.g(entity);
            }
        } else if (entity.cH().b <= this.cH().b) {
            if (!this.y(entity)) {
                VehicleEntityCollisionEvent event = new VehicleEntityCollisionEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity());
                this.dM().getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
            }
            super.g(entity);
        }
    }

    @Override
    public Item ah_() {
        return switch (this.y()) {
            case EnumBoatType.b -> Items.nV;
            case EnumBoatType.c -> Items.nX;
            case EnumBoatType.d -> Items.nZ;
            case EnumBoatType.e -> Items.ob;
            case EnumBoatType.f -> Items.od;
            case EnumBoatType.g -> Items.of;
            case EnumBoatType.h -> Items.oh;
            case EnumBoatType.i -> Items.oj;
            default -> Items.nT;
        };
    }

    @Override
    public void m(float yaw) {
        this.m(-this.P());
        this.d(10);
        this.b(this.N() * 11.0f);
    }

    @Override
    public boolean bt() {
        return !this.dH();
    }

    @Override
    public void a(double x2, double y2, double z2, float yaw, float pitch, int interpolationSteps) {
        this.t = x2;
        this.u = y2;
        this.v = z2;
        this.aE = yaw;
        this.aF = pitch;
        this.s = 10;
    }

    @Override
    public double p_() {
        return this.s > 0 ? this.t : this.dr();
    }

    @Override
    public double N_() {
        return this.s > 0 ? this.u : this.dt();
    }

    @Override
    public double O_() {
        return this.s > 0 ? this.v : this.dx();
    }

    @Override
    public float f_() {
        return this.s > 0 ? (float)this.aF : this.dE();
    }

    @Override
    public float q_() {
        return this.s > 0 ? (float)this.aE : this.dC();
    }

    @Override
    public EnumDirection cF() {
        return this.cE().h();
    }

    @Override
    public void l() {
        this.aN = this.aM;
        this.aM = this.C();
        this.q = this.aM != EnumStatus.b && this.aM != EnumStatus.c ? 0.0f : (this.q += 1.0f);
        if (!this.dM().B && this.q >= 60.0f) {
            this.bB();
        }
        if (this.O() > 0) {
            this.d(this.O() - 1);
        }
        if (this.N() > 0.0f) {
            this.b(this.N() - 1.0f);
        }
        super.l();
        this.B();
        if (this.cX()) {
            if (!(this.cQ() instanceof EntityHuman)) {
                this.a(false, false);
            }
            this.G();
            if (this.dM().B) {
                this.H();
                this.dM().a(new PacketPlayInBoatMove(this.c(0), this.c(1)));
            }
            this.a(EnumMoveType.a, this.dp());
        } else {
            this.g(Vec3D.b);
        }
        CraftServer server = this.dM().getCraftServer();
        CraftWorld bworld = this.dM().getWorld();
        Location to = CraftLocation.toBukkit(this.dk(), (org.bukkit.World)bworld, this.dC(), this.dE());
        Vehicle vehicle = (Vehicle)this.getBukkitEntity();
        server.getPluginManager().callEvent((Event)new VehicleUpdateEvent(vehicle));
        if (this.lastLocation != null && !this.lastLocation.equals((Object)to)) {
            VehicleMoveEvent event = new VehicleMoveEvent(vehicle, this.lastLocation, to);
            server.getPluginManager().callEvent((Event)event);
        }
        this.lastLocation = vehicle.getLocation();
        this.A();
        for (int i2 = 0; i2 <= 1; ++i2) {
            if (this.c(i2)) {
                SoundEffect soundeffect;
                if (!this.aU() && (double)(this.o[i2] % ((float)Math.PI * 2)) <= 0.7853981852531433 && (double)((this.o[i2] + 0.3926991f) % ((float)Math.PI * 2)) >= 0.7853981852531433 && (soundeffect = this.s()) != null) {
                    Vec3D vec3d = this.f(1.0f);
                    double d0 = i2 == 1 ? -vec3d.e : vec3d.e;
                    double d1 = i2 == 1 ? vec3d.c : -vec3d.c;
                    this.dM().a((EntityHuman)null, this.dr() + d0, this.dt(), this.dx() + d1, soundeffect, this.db(), 1.0f, 0.8f + 0.4f * this.ag.i());
                }
                int n2 = i2;
                this.o[n2] = this.o[n2] + 0.3926991f;
                continue;
            }
            this.o[i2] = 0.0f;
        }
        this.aQ();
        List<Entity> list = this.dM().a((Entity)this, this.cH().c(0.2f, -0.01f, 0.2f), IEntitySelector.a(this));
        if (!list.isEmpty()) {
            boolean flag = !this.dM().B && !(this.cN() instanceof EntityHuman);
            for (Entity entity : list) {
                if (entity.x(this)) continue;
                if (flag && this.cP().size() < this.z() && !entity.bO() && this.a(entity) && entity instanceof EntityLiving && !(entity instanceof EntityWaterAnimal) && !(entity instanceof EntityHuman)) {
                    entity.n(this);
                    continue;
                }
                this.g(entity);
            }
        }
    }

    private void A() {
        if (this.dM().B) {
            int i2 = this.I();
            this.aR = i2 > 0 ? (this.aR += 0.05f) : (this.aR -= 0.1f);
            this.aR = MathHelper.a(this.aR, 0.0f, 1.0f);
            this.aT = this.aS;
            this.aS = 10.0f * (float)Math.sin(0.5f * (float)this.dM().X()) * this.aR;
        } else {
            int i3;
            if (!this.aP) {
                this.b(0);
            }
            if ((i3 = this.I()) > 0) {
                this.b(--i3);
                int j2 = 60 - i3 - 1;
                if (j2 > 0 && i3 == 0) {
                    this.b(0);
                    Vec3D vec3d = this.dp();
                    if (this.aQ) {
                        this.g(vec3d.b(0.0, -0.7, 0.0));
                        this.bB();
                    } else {
                        this.o(vec3d.c, this.a((Entity entity) -> entity instanceof EntityHuman) ? 2.7 : 0.6, vec3d.e);
                    }
                }
                this.aP = false;
            }
        }
    }

    @Nullable
    protected SoundEffect s() {
        switch (this.C()) {
            case a: 
            case b: 
            case c: {
                return SoundEffects.bX;
            }
            case d: {
                return SoundEffects.bW;
            }
        }
        return null;
    }

    private void B() {
        if (this.cX()) {
            this.s = 0;
            this.f(this.dr(), this.dt(), this.dx());
        }
        if (this.s > 0) {
            this.a(this.s, this.t, this.u, this.v, this.aE, this.aF);
            --this.s;
        }
    }

    public void a(boolean leftMoving, boolean rightMoving) {
        this.an.b(j, leftMoving);
        this.an.b(k, rightMoving);
    }

    public float a(int paddle, float tickDelta) {
        return this.c(paddle) ? MathHelper.b(this.o[paddle] - 0.3926991f, this.o[paddle], tickDelta) : 0.0f;
    }

    public EnumStatus C() {
        EnumStatus entityboat_enumstatus = this.E();
        if (entityboat_enumstatus != null) {
            this.aK = this.cH().e;
            return entityboat_enumstatus;
        }
        if (this.D()) {
            return EnumStatus.a;
        }
        float f2 = this.w();
        if (f2 > 0.0f) {
            this.aL = f2;
            if (this.dM().purpurConfig.boatEjectPlayersOnLand) {
                this.bB();
            }
            return EnumStatus.d;
        }
        return EnumStatus.e;
    }

    public float u() {
        AxisAlignedBB axisalignedbb = this.cH();
        int i2 = MathHelper.a(axisalignedbb.a);
        int j2 = MathHelper.c(axisalignedbb.d);
        int k2 = MathHelper.a(axisalignedbb.e);
        int l2 = MathHelper.c(axisalignedbb.e - this.aO);
        int i1 = MathHelper.a(axisalignedbb.c);
        int j1 = MathHelper.c(axisalignedbb.f);
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        block0: for (int k1 = k2; k1 < l2; ++k1) {
            float f2 = 0.0f;
            block1: for (int l1 = i2; l1 < j2; ++l1) {
                int i22 = i1;
                while (true) {
                    if (i22 >= j1) {
                        continue block1;
                    }
                    blockposition_mutableblockposition.d(l1, k1, i22);
                    Fluid fluid = this.dM().b_(blockposition_mutableblockposition);
                    if (fluid.a(TagsFluid.a)) {
                        f2 = Math.max(f2, fluid.a((IBlockAccess)this.dM(), (BlockPosition)blockposition_mutableblockposition));
                    }
                    if (f2 >= 1.0f) continue block0;
                    ++i22;
                }
            }
            if (!(f2 < 1.0f)) continue;
            return (float)blockposition_mutableblockposition.v() + f2;
        }
        return l2 + 1;
    }

    public float w() {
        AxisAlignedBB axisalignedbb = this.cH();
        AxisAlignedBB axisalignedbb1 = new AxisAlignedBB(axisalignedbb.a, axisalignedbb.b - 0.001, axisalignedbb.c, axisalignedbb.d, axisalignedbb.b, axisalignedbb.f);
        int i2 = MathHelper.a(axisalignedbb1.a) - 1;
        int j2 = MathHelper.c(axisalignedbb1.d) + 1;
        int k2 = MathHelper.a(axisalignedbb1.b) - 1;
        int l2 = MathHelper.c(axisalignedbb1.e) + 1;
        int i1 = MathHelper.a(axisalignedbb1.c) - 1;
        int j1 = MathHelper.c(axisalignedbb1.f) + 1;
        VoxelShape voxelshape = VoxelShapes.a(axisalignedbb1);
        float f2 = 0.0f;
        int k1 = 0;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (int l1 = i2; l1 < j2; ++l1) {
            for (int i22 = i1; i22 < j1; ++i22) {
                int j22 = (l1 != i2 && l1 != j2 - 1 ? 0 : 1) + (i22 != i1 && i22 != j1 - 1 ? 0 : 1);
                if (j22 == 2) continue;
                for (int k22 = k2; k22 < l2; ++k22) {
                    if (j22 > 0 && (k22 == k2 || k22 == l2 - 1)) continue;
                    blockposition_mutableblockposition.d(l1, k22, i22);
                    IBlockData iblockdata = this.dM().a_(blockposition_mutableblockposition);
                    if (iblockdata.b() instanceof BlockWaterLily || !VoxelShapes.c(iblockdata.k(this.dM(), blockposition_mutableblockposition).a(l1, (double)k22, (double)i22), voxelshape, OperatorBoolean.i)) continue;
                    f2 += iblockdata.b().i();
                    ++k1;
                }
            }
        }
        return f2 / (float)k1;
    }

    private boolean D() {
        AxisAlignedBB axisalignedbb = this.cH();
        int i2 = MathHelper.a(axisalignedbb.a);
        int j2 = MathHelper.c(axisalignedbb.d);
        int k2 = MathHelper.a(axisalignedbb.b);
        int l2 = MathHelper.c(axisalignedbb.b + 0.001);
        int i1 = MathHelper.a(axisalignedbb.c);
        int j1 = MathHelper.c(axisalignedbb.f);
        boolean flag = false;
        this.aK = -1.7976931348623157E308;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (int k1 = i2; k1 < j2; ++k1) {
            for (int l1 = k2; l1 < l2; ++l1) {
                for (int i22 = i1; i22 < j1; ++i22) {
                    blockposition_mutableblockposition.d(k1, l1, i22);
                    Fluid fluid = this.dM().b_(blockposition_mutableblockposition);
                    if (!fluid.a(TagsFluid.a)) continue;
                    float f2 = (float)l1 + fluid.a((IBlockAccess)this.dM(), (BlockPosition)blockposition_mutableblockposition);
                    this.aK = Math.max((double)f2, this.aK);
                    flag |= axisalignedbb.b < (double)f2;
                }
            }
        }
        return flag;
    }

    @Nullable
    private EnumStatus E() {
        AxisAlignedBB axisalignedbb = this.cH();
        double d0 = axisalignedbb.e + 0.001;
        int i2 = MathHelper.a(axisalignedbb.a);
        int j2 = MathHelper.c(axisalignedbb.d);
        int k2 = MathHelper.a(axisalignedbb.e);
        int l2 = MathHelper.c(d0);
        int i1 = MathHelper.a(axisalignedbb.c);
        int j1 = MathHelper.c(axisalignedbb.f);
        boolean flag = false;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (int k1 = i2; k1 < j2; ++k1) {
            for (int l1 = k2; l1 < l2; ++l1) {
                for (int i22 = i1; i22 < j1; ++i22) {
                    blockposition_mutableblockposition.d(k1, l1, i22);
                    Fluid fluid = this.dM().b_(blockposition_mutableblockposition);
                    if (!fluid.a(TagsFluid.a) || !(d0 < (double)((float)blockposition_mutableblockposition.v() + fluid.a((IBlockAccess)this.dM(), (BlockPosition)blockposition_mutableblockposition)))) continue;
                    if (!fluid.b()) {
                        return EnumStatus.c;
                    }
                    flag = true;
                }
            }
        }
        return flag ? EnumStatus.b : null;
    }

    private void G() {
        double d0 = -0.04f;
        double d1 = this.aV() ? 0.0 : (double)-0.04f;
        double d2 = 0.0;
        this.p = 0.05f;
        if (this.aN == EnumStatus.e && this.aM != EnumStatus.e && this.aM != EnumStatus.d) {
            this.aK = this.e(1.0);
            this.a(EnumMoveType.a, new Vec3D(0.0, (double)(this.u() - this.dh()) + 0.101 - this.dt(), 0.0));
            this.g(this.dp().d(1.0, 0.0, 1.0));
            this.aO = 0.0;
            this.aM = EnumStatus.a;
        } else {
            if (this.aM == EnumStatus.a) {
                d2 = (this.aK - this.dt()) / (double)this.dh();
                this.p = 0.9f;
            } else if (this.aM == EnumStatus.c) {
                d1 = -7.0E-4;
                this.p = 0.9f;
            } else if (this.aM == EnumStatus.b) {
                d2 = 0.01f;
                this.p = 0.45f;
            } else if (this.aM == EnumStatus.e) {
                this.p = 0.9f;
            } else if (this.aM == EnumStatus.d) {
                this.p = this.aL;
                if (this.cN() instanceof EntityHuman) {
                    this.aL /= 2.0f;
                }
            }
            Vec3D vec3d = this.dp();
            this.o(vec3d.c * (double)this.p, vec3d.d + d1, vec3d.e * (double)this.p);
            this.r *= this.p;
            if (d2 > 0.0) {
                Vec3D vec3d1 = this.dp();
                this.o(vec3d1.c, (vec3d1.d + d2 * 0.06153846016296973) * 0.75, vec3d1.e);
            }
        }
    }

    private void H() {
        if (this.bP()) {
            float f2 = 0.0f;
            if (this.aG) {
                this.r -= 1.0f;
            }
            if (this.aH) {
                this.r += 1.0f;
            }
            if (this.aH != this.aG && !this.aI && !this.aJ) {
                f2 += 0.005f;
            }
            this.r(this.dC() + this.r);
            if (this.aI) {
                f2 += 0.04f;
            }
            if (this.aJ) {
                f2 -= 0.005f;
            }
            this.g(this.dp().b(MathHelper.a(-this.dC() * ((float)Math.PI / 180)) * f2, 0.0, MathHelper.b(this.dC() * ((float)Math.PI / 180)) * f2));
            this.a(this.aH && !this.aG || this.aI, this.aG && !this.aH || this.aI);
        }
    }

    protected float x() {
        return 0.0f;
    }

    public boolean a(Entity entity) {
        return entity.dg() < this.dg();
    }

    @Override
    protected void a(Entity passenger, Entity.MoveFunction positionUpdater) {
        super.a(passenger, positionUpdater);
        if (!passenger.ai().a(TagsEntity.t)) {
            passenger.r(passenger.dC() + this.r);
            passenger.n(passenger.cp() + this.r);
            this.b(passenger);
            if (passenger instanceof EntityAnimal && this.cP().size() == this.z()) {
                int i2 = passenger.aj() % 2 == 0 ? 90 : 270;
                passenger.o(((EntityAnimal)passenger).aU + (float)i2);
                passenger.n(passenger.cp() + (float)i2);
            }
        }
    }

    @Override
    public Vec3D b(EntityLiving passenger) {
        Vec3D vec3d = EntityBoat.a(this.dg() * MathHelper.g, (double)passenger.dg(), passenger.dC());
        double d0 = this.dr() + vec3d.c;
        double d1 = this.dx() + vec3d.e;
        BlockPosition blockposition = BlockPosition.a(d0, this.cH().e, d1);
        BlockPosition blockposition1 = blockposition.d();
        if (!this.dM().z(blockposition1)) {
            double d3;
            ArrayList list = Lists.newArrayList();
            double d2 = this.dM().j(blockposition);
            if (DismountUtil.a(d2)) {
                list.add(new Vec3D(d0, (double)blockposition.v() + d2, d1));
            }
            if (DismountUtil.a(d3 = this.dM().j(blockposition1))) {
                list.add(new Vec3D(d0, (double)blockposition1.v() + d3, d1));
            }
            for (EntityPose entitypose : passenger.fA()) {
                for (Vec3D vec3d1 : list) {
                    if (!DismountUtil.a(this.dM(), vec3d1, passenger, entitypose)) continue;
                    passenger.b(entitypose);
                    return vec3d1;
                }
            }
        }
        return super.b(passenger);
    }

    protected void b(Entity passenger) {
        passenger.o(this.dC());
        float f2 = MathHelper.g(passenger.dC() - this.dC());
        float f1 = MathHelper.a(f2, -105.0f, 105.0f);
        passenger.N += f1 - f2;
        passenger.r(passenger.dC() + f1 - f2);
        passenger.n(passenger.dC());
    }

    @Override
    public void j(Entity passenger) {
        this.b(passenger);
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        nbt.a("Type", this.y().c());
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        if (nbt.b("Type", 8)) {
            this.a(EnumBoatType.a(nbt.l("Type")));
        }
    }

    @Override
    public EnumInteractionResult a(EntityHuman player, EnumHand hand) {
        return player.fI() ? EnumInteractionResult.d : (this.q < 60.0f ? (!this.dM().B ? (player.n(this) ? EnumInteractionResult.b : EnumInteractionResult.d) : EnumInteractionResult.a) : EnumInteractionResult.d);
    }

    @Override
    protected void a(double heightDifference, boolean onGround, IBlockData state, BlockPosition landedPosition) {
        this.aO = this.dp().d;
        if (!this.bO()) {
            if (onGround) {
                if (this.ab > 3.0f) {
                    if (this.aM != EnumStatus.d) {
                        this.n();
                        return;
                    }
                    this.a(this.ab, 1.0f, this.dN().k());
                    if (!this.dM().B && !this.dH()) {
                        Vehicle vehicle = (Vehicle)this.getBukkitEntity();
                        VehicleDestroyEvent destroyEvent = new VehicleDestroyEvent(vehicle, null);
                        this.dM().getCraftServer().getPluginManager().callEvent((Event)destroyEvent);
                        if (!destroyEvent.isCancelled()) {
                            this.al();
                            if (this.dM().Z().b(GameRules.i)) {
                                int i2;
                                for (i2 = 0; i2 < 3; ++i2) {
                                    this.a(this.y().b());
                                }
                                for (i2 = 0; i2 < 2; ++i2) {
                                    this.a((IMaterial)Items.pm);
                                }
                            }
                        }
                    }
                }
                this.n();
            } else if (!this.dM().b_(this.dm().d()).a(TagsFluid.a) && heightDifference < 0.0) {
                this.ab -= (float)heightDifference;
            }
        }
    }

    public boolean c(int paddle) {
        return this.an.b(paddle == 0 ? j : k) != false && this.cN() != null;
    }

    private void b(int wobbleTicks) {
        this.an.b(l, wobbleTicks);
    }

    private int I() {
        return this.an.b(l);
    }

    public float a(float tickDelta) {
        return MathHelper.i(tickDelta, this.aT, this.aS);
    }

    @Override
    public void a(EnumBoatType variant) {
        this.an.b(i, variant.ordinal());
    }

    public EnumBoatType y() {
        return EnumBoatType.a(this.an.b(i));
    }

    @Override
    protected boolean r(Entity passenger) {
        return this.cP().size() < this.z() && !this.a(TagsFluid.a);
    }

    protected int z() {
        return 2;
    }

    @Override
    @Nullable
    public EntityLiving cN() {
        EntityLiving entityliving1;
        Entity entity = this.cQ();
        EntityLiving entityliving = entity instanceof EntityLiving ? (entityliving1 = (EntityLiving)entity) : super.cN();
        return entityliving;
    }

    public void a(boolean pressingLeft, boolean pressingRight, boolean pressingForward, boolean pressingBack) {
        this.aG = pressingLeft;
        this.aH = pressingRight;
        this.aI = pressingForward;
        this.aJ = pressingBack;
    }

    @Override
    protected IChatBaseComponent co() {
        return IChatBaseComponent.c(this.ah_().a());
    }

    @Override
    public boolean be() {
        return this.aM == EnumStatus.b || this.aM == EnumStatus.c;
    }

    @Override
    public ItemStack dz() {
        ItemStack boat = new ItemStack(this.ah_());
        if (this.dM().purpurConfig.persistentDroppableEntityDisplayNames && this.ae()) {
            boat.a(this.af());
        }
        return boat;
    }

    public static enum EnumBoatType implements INamable
    {
        a(Blocks.n, "oak"),
        b(Blocks.o, "spruce"),
        c(Blocks.p, "birch"),
        d(Blocks.q, "jungle"),
        e(Blocks.r, "acacia"),
        f(Blocks.s, "cherry"),
        g(Blocks.t, "dark_oak"),
        h(Blocks.u, "mangrove"),
        i(Blocks.v, "bamboo");

        private final String k;
        private final Block l;
        public static final INamable.a<EnumBoatType> j;
        private static final IntFunction<EnumBoatType> m;

        private EnumBoatType(Block block, String s2) {
            this.k = s2;
            this.l = block;
        }

        @Override
        public String c() {
            return this.k;
        }

        public String a() {
            return this.k;
        }

        public Block b() {
            return this.l;
        }

        public String toString() {
            return this.k;
        }

        public static EnumBoatType a(int type) {
            return m.apply(type);
        }

        public static EnumBoatType a(String name) {
            return j.a(name, a);
        }

        static {
            j = INamable.a(EnumBoatType::values);
            m = ByIdMap.a(Enum::ordinal, EnumBoatType.values(), ByIdMap.a.a);
        }
    }

    public static enum EnumStatus {
        a,
        b,
        c,
        d,
        e;

    }
}

