/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.EntityVillagerTrader;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartChest;
import net.minecraft.world.entity.vehicle.EntityMinecartCommandBlock;
import net.minecraft.world.entity.vehicle.EntityMinecartFurnace;
import net.minecraft.world.entity.vehicle.EntityMinecartHopper;
import net.minecraft.world.entity.vehicle.EntityMinecartMobSpawner;
import net.minecraft.world.entity.vehicle.EntityMinecartRideable;
import net.minecraft.world.entity.vehicle.EntityMinecartTNT;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockMinecartTrackAbstract;
import net.minecraft.world.level.block.BlockPoweredRail;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyTrackPosition;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftLocation;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.event.vehicle.VehicleUpdateEvent;
import org.bukkit.util.Vector;
import org.joml.Vector3f;

public abstract class EntityMinecartAbstract
extends VehicleEntity {
    private static final float c = 0.0f;
    private static final float d = 0.1875f;
    private static final DataWatcherObject<Integer> e = DataWatcher.a(EntityMinecartAbstract.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> i = DataWatcher.a(EntityMinecartAbstract.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> j = DataWatcher.a(EntityMinecartAbstract.class, DataWatcherRegistry.k);
    private static final ImmutableMap<EntityPose, ImmutableList<Integer>> k = ImmutableMap.of((Object)((Object)EntityPose.a), (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)((Object)EntityPose.f), (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)((Object)EntityPose.d), (Object)ImmutableList.of((Object)0, (Object)1));
    protected static final float b = 0.95f;
    private boolean l;
    private boolean m;
    private int n;
    private double o;
    private double p;
    private double q;
    private double r;
    private double s;
    private Vec3D t = Vec3D.b;
    private static final Map<BlockPropertyTrackPosition, Pair<BaseBlockPosition, BaseBlockPosition>> u = SystemUtils.a(Maps.newEnumMap(BlockPropertyTrackPosition.class), enummap -> {
        BaseBlockPosition baseblockposition = EnumDirection.e.q();
        BaseBlockPosition baseblockposition1 = EnumDirection.f.q();
        BaseBlockPosition baseblockposition2 = EnumDirection.c.q();
        BaseBlockPosition baseblockposition3 = EnumDirection.d.q();
        BaseBlockPosition baseblockposition4 = baseblockposition.o();
        BaseBlockPosition baseblockposition5 = baseblockposition1.o();
        BaseBlockPosition baseblockposition6 = baseblockposition2.o();
        BaseBlockPosition baseblockposition7 = baseblockposition3.o();
        enummap.put(BlockPropertyTrackPosition.a, Pair.of((Object)baseblockposition2, (Object)baseblockposition3));
        enummap.put(BlockPropertyTrackPosition.b, Pair.of((Object)baseblockposition, (Object)baseblockposition1));
        enummap.put(BlockPropertyTrackPosition.c, Pair.of((Object)baseblockposition4, (Object)baseblockposition1));
        enummap.put(BlockPropertyTrackPosition.d, Pair.of((Object)baseblockposition, (Object)baseblockposition5));
        enummap.put(BlockPropertyTrackPosition.e, Pair.of((Object)baseblockposition2, (Object)baseblockposition7));
        enummap.put(BlockPropertyTrackPosition.f, Pair.of((Object)baseblockposition6, (Object)baseblockposition3));
        enummap.put(BlockPropertyTrackPosition.g, Pair.of((Object)baseblockposition3, (Object)baseblockposition1));
        enummap.put(BlockPropertyTrackPosition.h, Pair.of((Object)baseblockposition3, (Object)baseblockposition));
        enummap.put(BlockPropertyTrackPosition.i, Pair.of((Object)baseblockposition2, (Object)baseblockposition));
        enummap.put(BlockPropertyTrackPosition.j, Pair.of((Object)baseblockposition2, (Object)baseblockposition1));
    });
    public boolean slowWhenEmpty = true;
    private double derailedX = 0.5;
    private double derailedY = 0.5;
    private double derailedZ = 0.5;
    private double flyingX = 0.95;
    private double flyingY = 0.95;
    private double flyingZ = 0.95;
    public double maxSpeed = 0.4;
    public double storedMaxSpeed;
    private Double lastSpeed;

    protected EntityMinecartAbstract(EntityTypes<?> type, World world) {
        super(type, world);
        this.I = true;
        if (world != null) {
            this.maxSpeed = this.storedMaxSpeed = world.purpurConfig.minecartMaxSpeed;
        }
    }

    protected EntityMinecartAbstract(EntityTypes<?> type, World world, double x2, double y2, double z2) {
        this(type, world);
        this.a_(x2, y2, z2);
        this.K = x2;
        this.L = y2;
        this.M = z2;
    }

    public static EntityMinecartAbstract a(WorldServer world, double x2, double y2, double z2, EnumMinecartType type, ItemStack stack, @Nullable EntityHuman player) {
        EntityMinecartAbstract object1 = switch (type) {
            case EnumMinecartType.b -> new EntityMinecartChest(world, x2, y2, z2);
            case EnumMinecartType.c -> new EntityMinecartFurnace(world, x2, y2, z2);
            case EnumMinecartType.d -> new EntityMinecartTNT(world, x2, y2, z2);
            case EnumMinecartType.e -> new EntityMinecartMobSpawner(world, x2, y2, z2);
            case EnumMinecartType.f -> new EntityMinecartHopper(world, x2, y2, z2);
            case EnumMinecartType.g -> new EntityMinecartCommandBlock(world, x2, y2, z2);
            default -> new EntityMinecartRideable(world, x2, y2, z2);
        };
        EntityTypes.a(world, stack, player).accept(object1);
        return object1;
    }

    @Override
    protected Entity.MovementEmission aW() {
        return Entity.MovementEmission.c;
    }

    @Override
    protected void c_() {
        super.c_();
        this.an.a(e, Block.i(Blocks.a.o()));
        this.an.a(i, 6);
        this.an.a(j, false);
    }

    @Override
    public boolean h(Entity other) {
        boolean collides = EntityBoat.a(this, other);
        if (!collides) {
            return false;
        }
        VehicleEntityCollisionEvent collisionEvent = new VehicleEntityCollisionEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.Entity)other.getBukkitEntity());
        return collisionEvent.callEvent();
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return true;
    }

    @Override
    protected Vec3D a(EnumDirection.EnumAxis portalAxis, BlockUtil.Rectangle portalRect) {
        return EntityLiving.i(super.a(portalAxis, portalRect));
    }

    @Override
    protected Vector3f a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        boolean flag = passenger instanceof EntityVillager || passenger instanceof EntityVillagerTrader;
        return new Vector3f(0.0f, flag ? 0.0f : 0.1875f, 0.0f);
    }

    @Override
    public Vec3D b(EntityLiving passenger) {
        EnumDirection enumdirection = this.cF();
        if (enumdirection.o() == EnumDirection.EnumAxis.b) {
            return super.b(passenger);
        }
        int[][] aint = DismountUtil.a(enumdirection);
        BlockPosition blockposition = this.dm();
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        ImmutableList<EntityPose> immutablelist = passenger.fA();
        for (EntityPose entitypose : immutablelist) {
            EntitySize entitysize = passenger.a(entitypose);
            float f2 = Math.min(entitysize.a, 1.0f) / 2.0f;
            UnmodifiableIterator unmodifiableiterator1 = ((ImmutableList)k.get((Object)entitypose)).iterator();
            while (unmodifiableiterator1.hasNext()) {
                int i2 = (Integer)unmodifiableiterator1.next();
                int[][] aint1 = aint;
                int j2 = aint.length;
                for (int k2 = 0; k2 < j2; ++k2) {
                    int[] aint2 = aint1[k2];
                    blockposition_mutableblockposition.d(blockposition.u() + aint2[0], blockposition.v() + i2, blockposition.w() + aint2[1]);
                    double d0 = this.dM().a(DismountUtil.a((IBlockAccess)this.dM(), (BlockPosition)blockposition_mutableblockposition), () -> DismountUtil.a((IBlockAccess)this.dM(), blockposition_mutableblockposition.d()));
                    if (!DismountUtil.a(d0)) continue;
                    AxisAlignedBB axisalignedbb = new AxisAlignedBB(-f2, 0.0, -f2, f2, entitysize.b, f2);
                    Vec3D vec3d = Vec3D.a(blockposition_mutableblockposition, d0);
                    if (!DismountUtil.a(this.dM(), passenger, axisalignedbb.c(vec3d))) continue;
                    passenger.b(entitypose);
                    return vec3d;
                }
            }
        }
        double d1 = this.cH().e;
        blockposition_mutableblockposition.b((double)blockposition.u(), d1, (double)blockposition.w());
        for (EntityPose entitypose1 : immutablelist) {
            double d2 = passenger.a((EntityPose)entitypose1).b;
            int l2 = MathHelper.c(d1 - (double)blockposition_mutableblockposition.v() + d2);
            double d3 = DismountUtil.a(blockposition_mutableblockposition, l2, blockposition1 -> this.dM().a_((BlockPosition)blockposition1).k(this.dM(), (BlockPosition)blockposition1));
            if (!(d1 + d2 <= d3)) continue;
            passenger.b(entitypose1);
            break;
        }
        return super.b(passenger);
    }

    @Override
    protected float aL() {
        IBlockData iblockdata = this.dM().a_(this.dm());
        return iblockdata.a(TagsBlock.N) ? 1.0f : super.aL();
    }

    @Override
    public void m(float yaw) {
        this.m(-this.P());
        this.d(10);
        this.b(this.N() + this.N() * 10.0f);
    }

    @Override
    public boolean bt() {
        return !this.dH();
    }

    private static Pair<BaseBlockPosition, BaseBlockPosition> a(BlockPropertyTrackPosition shape) {
        return u.get(shape);
    }

    @Override
    public EnumDirection cF() {
        return this.l ? this.cE().g().h() : this.cE().h();
    }

    @Override
    public void l() {
        if (this.storedMaxSpeed != this.dM().purpurConfig.minecartMaxSpeed) {
            this.maxSpeed = this.storedMaxSpeed = this.dM().purpurConfig.minecartMaxSpeed;
        }
        double prevX = this.dr();
        double prevY = this.dt();
        double prevZ = this.dx();
        float prevYaw = this.dC();
        float prevPitch = this.dE();
        if (this.O() > 0) {
            this.d(this.O() - 1);
        }
        if (this.N() > 0.0f) {
            this.b(this.N() - 1.0f);
        }
        this.at();
        if (this.dM().B) {
            if (this.n > 0) {
                this.a(this.n, this.o, this.p, this.q, this.r, this.s);
                --this.n;
            } else {
                this.ar();
                this.a(this.dC(), this.dE());
            }
        } else {
            double d3;
            if (!this.aV()) {
                double d0 = this.aZ() ? -0.005 : -0.04;
                this.g(this.dp().b(0.0, d0, 0.0));
            }
            int i2 = MathHelper.a(this.dr());
            int j2 = MathHelper.a(this.dt());
            int k2 = MathHelper.a(this.dx());
            if (this.dM().a_(new BlockPosition(i2, j2 - 1, k2)).a(TagsBlock.N)) {
                --j2;
            }
            BlockPosition blockposition = new BlockPosition(i2, j2, k2);
            IBlockData iblockdata = this.dM().a_(blockposition);
            this.m = BlockMinecartTrackAbstract.g(iblockdata);
            if (this.m) {
                this.c(blockposition, iblockdata);
                if (iblockdata.a(Blocks.hh)) {
                    this.a(i2, j2, k2, iblockdata.c(BlockPoweredRail.f));
                }
            } else {
                this.s();
            }
            this.aQ();
            this.s(0.0f);
            double d1 = this.K - this.dr();
            double d2 = this.M - this.dx();
            if (d1 * d1 + d2 * d2 > 0.001) {
                this.r((float)(MathHelper.d(d2, d1) * 180.0 / Math.PI));
                if (this.l) {
                    this.r(this.dC() + 180.0f);
                }
            }
            if ((d3 = (double)MathHelper.g(this.dC() - this.N)) < -170.0 || d3 >= 170.0) {
                this.r(this.dC() + 180.0f);
                this.l = !this.l;
            }
            this.a(this.dC(), this.dE());
            CraftWorld bworld = this.dM().getWorld();
            Location from = new Location((org.bukkit.World)bworld, prevX, prevY, prevZ, prevYaw, prevPitch);
            Location to = CraftLocation.toBukkit(this.dk(), (org.bukkit.World)bworld, this.dC(), this.dE());
            Vehicle vehicle = (Vehicle)this.getBukkitEntity();
            this.dM().getCraftServer().getPluginManager().callEvent((Event)new VehicleUpdateEvent(vehicle));
            if (!from.equals((Object)to)) {
                this.dM().getCraftServer().getPluginManager().callEvent((Event)new VehicleMoveEvent(vehicle, from, to));
            }
            if (this.w() == EnumMinecartType.a && this.dp().i() > 0.01) {
                List<Entity> list = this.dM().a((Entity)this, this.cH().c(0.2f, 0.0, 0.2f), IEntitySelector.a(this));
                if (!list.isEmpty()) {
                    for (Entity entity : list) {
                        VehicleEntityCollisionEvent collisionEvent;
                        if (!(entity instanceof EntityHuman || entity instanceof EntityIronGolem || entity instanceof EntityMinecartAbstract || this.bP() || entity.bO())) {
                            collisionEvent = new VehicleEntityCollisionEvent(vehicle, (org.bukkit.entity.Entity)entity.getBukkitEntity());
                            this.dM().getCraftServer().getPluginManager().callEvent((Event)collisionEvent);
                            if (collisionEvent.isCancelled()) continue;
                            entity.n(this);
                            continue;
                        }
                        if (!this.y(entity)) {
                            collisionEvent = new VehicleEntityCollisionEvent(vehicle, (org.bukkit.entity.Entity)entity.getBukkitEntity());
                            this.dM().getCraftServer().getPluginManager().callEvent((Event)collisionEvent);
                            if (collisionEvent.isCancelled()) continue;
                        }
                        entity.g(this);
                    }
                }
            } else {
                for (Entity entity1 : this.dM().a_(this, this.cH().c(0.2f, 0.0, 0.2f))) {
                    if (this.x(entity1) || !entity1.bu() || !(entity1 instanceof EntityMinecartAbstract)) continue;
                    VehicleEntityCollisionEvent collisionEvent = new VehicleEntityCollisionEvent(vehicle, (org.bukkit.entity.Entity)entity1.getBukkitEntity());
                    this.dM().getCraftServer().getPluginManager().callEvent((Event)collisionEvent);
                    if (collisionEvent.isCancelled()) continue;
                    entity1.g(this);
                }
            }
            this.bg();
            if (this.bn()) {
                this.ay();
                this.ab *= 0.5f;
            }
            this.am = false;
        }
    }

    protected double q() {
        return this.aZ() ? this.maxSpeed / 2.0 : this.maxSpeed;
    }

    public void a(int x2, int y2, int z2, boolean powered) {
    }

    public double getControllableSpeed() {
        IBlockData blockState = this.dM().a_(this.dm());
        if (!blockState.e()) {
            blockState = this.dM().a_(this.dm().a(EnumDirection.a));
        }
        Double speed = this.dM().purpurConfig.minecartControllableBlockSpeeds.get(blockState.b());
        if (!blockState.e()) {
            speed = this.lastSpeed;
        }
        if (speed == null) {
            speed = this.dM().purpurConfig.minecartControllableBaseSpeed;
        }
        this.lastSpeed = speed;
        return this.lastSpeed;
    }

    protected void s() {
        double d0 = this.q();
        Vec3D vec3d = this.dp();
        this.o(MathHelper.a(vec3d.c, -d0, d0), vec3d.d, MathHelper.a(vec3d.e, -d0, d0));
        if (this.dM().purpurConfig.minecartControllable && !this.aZ() && !this.bn() && !((Entity)this).r.isEmpty()) {
            Entity passenger = (Entity)((Entity)this).r.get(0);
            if (passenger instanceof EntityHuman) {
                EntityHuman player = (EntityHuman)passenger;
                if (player.bj && this.aJ) {
                    this.g(new Vec3D(this.dp().c, this.dM().purpurConfig.minecartControllableHopBoost, this.dp().e));
                }
                if (player.bm != 0.0f) {
                    Vector velocity = player.getBukkitEntity().getEyeLocation().getDirection().normalize().multiply(this.getControllableSpeed());
                    if ((double)player.bm < 0.0) {
                        velocity.multiply(-0.5);
                    }
                    this.g(new Vec3D(velocity.getX(), this.dp().d, velocity.getZ()));
                }
                this.r(passenger.dC() - 90.0f);
                this.aM = this.dM().purpurConfig.minecartControllableStepHeight;
            } else {
                this.aM = 0.0f;
            }
        } else {
            this.aM = 0.0f;
        }
        if (this.aC()) {
            this.g(new Vec3D(this.dp().c * this.derailedX, this.dp().d * this.derailedY, this.dp().e * this.derailedZ));
        } else if (this.dM().purpurConfig.minecartControllable) {
            this.g(new Vec3D(this.dp().c * this.derailedX, this.dp().d, this.dp().e * this.derailedZ));
        }
        this.a(EnumMoveType.a, this.dp());
        if (!this.aC()) {
            this.g(new Vec3D(this.dp().c * this.flyingX, this.dp().d * this.flyingY, this.dp().e * this.flyingZ));
        }
    }

    protected void c(BlockPosition pos, IBlockData state) {
        double d18;
        Vec3D vec3d4;
        double d17;
        double d16;
        double d15;
        this.n();
        double d0 = this.dr();
        double d1 = this.dt();
        double d2 = this.dx();
        Vec3D vec3d = this.q(d0, d1, d2);
        d1 = pos.v();
        boolean flag = false;
        boolean flag1 = false;
        if (state.a(Blocks.bp)) {
            flag = state.c(BlockPoweredRail.f);
            flag1 = !flag;
        }
        double d3 = 0.0078125;
        if (this.aZ()) {
            d3 *= 0.2;
        }
        Vec3D vec3d1 = this.dp();
        BlockPropertyTrackPosition blockpropertytrackposition = state.c(((BlockMinecartTrackAbstract)state.b()).c());
        switch (blockpropertytrackposition) {
            case c: {
                this.g(vec3d1.b(-d3, 0.0, 0.0));
                d1 += 1.0;
                break;
            }
            case d: {
                this.g(vec3d1.b(d3, 0.0, 0.0));
                d1 += 1.0;
                break;
            }
            case e: {
                this.g(vec3d1.b(0.0, 0.0, d3));
                d1 += 1.0;
                break;
            }
            case f: {
                this.g(vec3d1.b(0.0, 0.0, -d3));
                d1 += 1.0;
            }
        }
        vec3d1 = this.dp();
        Pair<BaseBlockPosition, BaseBlockPosition> pair = EntityMinecartAbstract.a(blockpropertytrackposition);
        BaseBlockPosition baseblockposition = (BaseBlockPosition)pair.getFirst();
        BaseBlockPosition baseblockposition1 = (BaseBlockPosition)pair.getSecond();
        double d4 = baseblockposition1.u() - baseblockposition.u();
        double d5 = baseblockposition1.w() - baseblockposition.w();
        double d6 = Math.sqrt(d4 * d4 + d5 * d5);
        double d7 = vec3d1.c * d4 + vec3d1.e * d5;
        if (d7 < 0.0) {
            d4 = -d4;
            d5 = -d5;
        }
        double d8 = Math.min(2.0, vec3d1.h());
        vec3d1 = new Vec3D(d8 * d4 / d6, vec3d1.d, d8 * d5 / d6);
        this.g(vec3d1);
        Entity entity = this.cQ();
        if (entity instanceof EntityHuman) {
            Vec3D vec3d2 = entity.dp();
            double d9 = vec3d2.i();
            double d10 = this.dp().i();
            if (d9 > 1.0E-4 && d10 < 0.01) {
                this.g(this.dp().b(vec3d2.c * 0.1, 0.0, vec3d2.e * 0.1));
                flag1 = false;
            }
        }
        if (flag1) {
            double d11 = this.dp().h();
            if (d11 < 0.03) {
                this.g(Vec3D.b);
            } else {
                this.g(this.dp().d(0.5, 0.0, 0.5));
            }
        }
        double d11 = (double)pos.u() + 0.5 + (double)baseblockposition.u() * 0.5;
        double d12 = (double)pos.w() + 0.5 + (double)baseblockposition.w() * 0.5;
        double d13 = (double)pos.u() + 0.5 + (double)baseblockposition1.u() * 0.5;
        double d14 = (double)pos.w() + 0.5 + (double)baseblockposition1.w() * 0.5;
        d4 = d13 - d11;
        d5 = d14 - d12;
        if (d4 == 0.0) {
            d15 = d2 - (double)pos.w();
        } else if (d5 == 0.0) {
            d15 = d0 - (double)pos.u();
        } else {
            d16 = d0 - d11;
            d17 = d2 - d12;
            d15 = (d16 * d4 + d17 * d5) * 2.0;
        }
        d0 = d11 + d4 * d15;
        d2 = d12 + d5 * d15;
        this.a_(d0, d1, d2);
        d16 = this.bP() ? 0.75 : 1.0;
        d17 = this.q();
        vec3d1 = this.dp();
        this.a(EnumMoveType.a, new Vec3D(MathHelper.a(d16 * vec3d1.c, -d17, d17), 0.0, MathHelper.a(d16 * vec3d1.e, -d17, d17)));
        if (baseblockposition.v() != 0 && MathHelper.a(this.dr()) - pos.u() == baseblockposition.u() && MathHelper.a(this.dx()) - pos.w() == baseblockposition.w()) {
            this.a_(this.dr(), this.dt() + (double)baseblockposition.v(), this.dx());
        } else if (baseblockposition1.v() != 0 && MathHelper.a(this.dr()) - pos.u() == baseblockposition1.u() && MathHelper.a(this.dx()) - pos.w() == baseblockposition1.w()) {
            this.a_(this.dr(), this.dt() + (double)baseblockposition1.v(), this.dx());
        }
        this.u();
        Vec3D vec3d3 = this.q(this.dr(), this.dt(), this.dx());
        if (vec3d3 != null && vec3d != null) {
            double d19 = (vec3d.d - vec3d3.d) * 0.05;
            vec3d4 = this.dp();
            d18 = vec3d4.h();
            if (d18 > 0.0) {
                this.g(vec3d4.d((d18 + d19) / d18, 1.0, (d18 + d19) / d18));
            }
            this.a_(this.dr(), vec3d3.d, this.dx());
        }
        int i2 = MathHelper.a(this.dr());
        int j2 = MathHelper.a(this.dx());
        if (i2 != pos.u() || j2 != pos.w()) {
            vec3d4 = this.dp();
            d18 = vec3d4.h();
            this.o(d18 * (double)(i2 - pos.u()), vec3d4.d, d18 * (double)(j2 - pos.w()));
        }
        if (flag) {
            vec3d4 = this.dp();
            d18 = vec3d4.h();
            if (d18 > 0.01) {
                double d20 = 0.06;
                this.g(vec3d4.b(vec3d4.c / d18 * this.dM().purpurConfig.poweredRailBoostModifier, 0.0, vec3d4.e / d18 * this.dM().purpurConfig.poweredRailBoostModifier));
            } else {
                Vec3D vec3d5 = this.dp();
                double d21 = vec3d5.c;
                double d22 = vec3d5.e;
                if (blockpropertytrackposition == BlockPropertyTrackPosition.b) {
                    if (this.a(pos.g())) {
                        d21 = 0.02;
                    } else if (this.a(pos.h())) {
                        d21 = -0.02;
                    }
                } else {
                    if (blockpropertytrackposition != BlockPropertyTrackPosition.a) {
                        return;
                    }
                    if (this.a(pos.e())) {
                        d22 = 0.02;
                    } else if (this.a(pos.f())) {
                        d22 = -0.02;
                    }
                }
                this.o(d21, vec3d5.d, d22);
            }
        }
    }

    @Override
    public boolean cf() {
        return this.m;
    }

    private boolean a(BlockPosition pos) {
        return this.dM().a_(pos).g(this.dM(), pos);
    }

    protected void u() {
        double d0 = this.bP() || !this.slowWhenEmpty ? 0.997 : 0.96;
        Vec3D vec3d = this.dp();
        vec3d = vec3d.d(d0, 0.0, d0);
        if (this.aZ()) {
            vec3d = vec3d.a((double)0.95f);
        }
        this.g(vec3d);
    }

    @Nullable
    public Vec3D a(double x2, double y2, double z2, double offset) {
        IBlockData iblockdata;
        int i2 = MathHelper.a(x2);
        int j2 = MathHelper.a(y2);
        int k2 = MathHelper.a(z2);
        if (this.dM().a_(new BlockPosition(i2, j2 - 1, k2)).a(TagsBlock.N)) {
            --j2;
        }
        if (BlockMinecartTrackAbstract.g(iblockdata = this.dM().a_(new BlockPosition(i2, j2, k2)))) {
            BlockPropertyTrackPosition blockpropertytrackposition = iblockdata.c(((BlockMinecartTrackAbstract)iblockdata.b()).c());
            y2 = j2;
            if (blockpropertytrackposition.b()) {
                y2 = j2 + 1;
            }
            Pair<BaseBlockPosition, BaseBlockPosition> pair = EntityMinecartAbstract.a(blockpropertytrackposition);
            BaseBlockPosition baseblockposition = (BaseBlockPosition)pair.getFirst();
            BaseBlockPosition baseblockposition1 = (BaseBlockPosition)pair.getSecond();
            double d4 = baseblockposition1.u() - baseblockposition.u();
            double d5 = baseblockposition1.w() - baseblockposition.w();
            double d6 = Math.sqrt(d4 * d4 + d5 * d5);
            if (baseblockposition.v() != 0 && MathHelper.a(x2 += (d4 /= d6) * offset) - i2 == baseblockposition.u() && MathHelper.a(z2 += (d5 /= d6) * offset) - k2 == baseblockposition.w()) {
                y2 += (double)baseblockposition.v();
            } else if (baseblockposition1.v() != 0 && MathHelper.a(x2) - i2 == baseblockposition1.u() && MathHelper.a(z2) - k2 == baseblockposition1.w()) {
                y2 += (double)baseblockposition1.v();
            }
            return this.q(x2, y2, z2);
        }
        return null;
    }

    @Nullable
    public Vec3D q(double x2, double y2, double z2) {
        IBlockData iblockdata;
        int i2 = MathHelper.a(x2);
        int j2 = MathHelper.a(y2);
        int k2 = MathHelper.a(z2);
        if (this.dM().a_(new BlockPosition(i2, j2 - 1, k2)).a(TagsBlock.N)) {
            --j2;
        }
        if (BlockMinecartTrackAbstract.g(iblockdata = this.dM().a_(new BlockPosition(i2, j2, k2)))) {
            double d12;
            BlockPropertyTrackPosition blockpropertytrackposition = iblockdata.c(((BlockMinecartTrackAbstract)iblockdata.b()).c());
            Pair<BaseBlockPosition, BaseBlockPosition> pair = EntityMinecartAbstract.a(blockpropertytrackposition);
            BaseBlockPosition baseblockposition = (BaseBlockPosition)pair.getFirst();
            BaseBlockPosition baseblockposition1 = (BaseBlockPosition)pair.getSecond();
            double d3 = (double)i2 + 0.5 + (double)baseblockposition.u() * 0.5;
            double d4 = (double)j2 + 0.0625 + (double)baseblockposition.v() * 0.5;
            double d5 = (double)k2 + 0.5 + (double)baseblockposition.w() * 0.5;
            double d6 = (double)i2 + 0.5 + (double)baseblockposition1.u() * 0.5;
            double d7 = (double)j2 + 0.0625 + (double)baseblockposition1.v() * 0.5;
            double d8 = (double)k2 + 0.5 + (double)baseblockposition1.w() * 0.5;
            double d9 = d6 - d3;
            double d10 = (d7 - d4) * 2.0;
            double d11 = d8 - d5;
            if (d9 == 0.0) {
                d12 = z2 - (double)k2;
            } else if (d11 == 0.0) {
                d12 = x2 - (double)i2;
            } else {
                double d13 = x2 - d3;
                double d14 = z2 - d5;
                d12 = (d13 * d9 + d14 * d11) * 2.0;
            }
            x2 = d3 + d9 * d12;
            y2 = d4 + d10 * d12;
            z2 = d5 + d11 * d12;
            if (d10 < 0.0) {
                y2 += 1.0;
            } else if (d10 > 0.0) {
                y2 += 0.5;
            }
            return new Vec3D(x2, y2, z2);
        }
        return null;
    }

    @Override
    public AxisAlignedBB i_() {
        AxisAlignedBB axisalignedbb = this.cH();
        return this.B() ? axisalignedbb.g((double)Math.abs(this.z()) / 16.0) : axisalignedbb;
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        if (nbt.q("CustomDisplayTile")) {
            this.c(GameProfileSerializer.a(this.dM().a(Registries.f), nbt.p("DisplayState")));
            this.c(nbt.h("DisplayOffset"));
        }
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        if (this.B()) {
            nbt.a("CustomDisplayTile", true);
            nbt.a("DisplayState", GameProfileSerializer.a(this.x()));
            nbt.a("DisplayOffset", this.z());
        }
    }

    @Override
    public void g(Entity entity) {
        if (!(this.dM().B || entity.af || this.af)) {
            if (!this.dM().paperConfig().collisions.allowVehicleCollisions && this.dM().paperConfig().collisions.onlyPlayersCollide && !(entity instanceof EntityHuman)) {
                return;
            }
            if (!this.x(entity)) {
                double d1;
                VehicleEntityCollisionEvent collisionEvent = new VehicleEntityCollisionEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity());
                this.dM().getCraftServer().getPluginManager().callEvent((Event)collisionEvent);
                if (collisionEvent.isCancelled()) {
                    return;
                }
                double d0 = entity.dr() - this.dr();
                double d2 = d0 * d0 + (d1 = entity.dx() - this.dx()) * d1;
                if (d2 >= (double)1.0E-4f) {
                    d2 = Math.sqrt(d2);
                    d0 /= d2;
                    d1 /= d2;
                    double d3 = 1.0 / d2;
                    if (d3 > 1.0) {
                        d3 = 1.0;
                    }
                    d0 *= d3;
                    d1 *= d3;
                    d0 *= (double)0.1f;
                    d1 *= (double)0.1f;
                    d0 *= 0.5;
                    d1 *= 0.5;
                    if (entity instanceof EntityMinecartAbstract) {
                        Vec3D vec3d1;
                        double d5;
                        double d4 = entity.dr() - this.dr();
                        Vec3D vec3d = new Vec3D(d4, 0.0, d5 = entity.dx() - this.dx()).d();
                        double d6 = Math.abs(vec3d.b(vec3d1 = new Vec3D(MathHelper.b(this.dC() * ((float)Math.PI / 180)), 0.0, MathHelper.a(this.dC() * ((float)Math.PI / 180))).d()));
                        if (d6 < (double)0.8f) {
                            return;
                        }
                        Vec3D vec3d2 = this.dp();
                        Vec3D vec3d3 = entity.dp();
                        if (((EntityMinecartAbstract)entity).w() == EnumMinecartType.c && this.w() != EnumMinecartType.c) {
                            this.g(vec3d2.d(0.2, 1.0, 0.2));
                            this.j(vec3d3.c - d0, 0.0, vec3d3.e - d1);
                            entity.g(vec3d3.d(0.95, 1.0, 0.95));
                        } else if (((EntityMinecartAbstract)entity).w() != EnumMinecartType.c && this.w() == EnumMinecartType.c) {
                            entity.g(vec3d3.d(0.2, 1.0, 0.2));
                            entity.j(vec3d2.c + d0, 0.0, vec3d2.e + d1);
                            this.g(vec3d2.d(0.95, 1.0, 0.95));
                        } else {
                            double d7 = (vec3d3.c + vec3d2.c) / 2.0;
                            double d8 = (vec3d3.e + vec3d2.e) / 2.0;
                            this.g(vec3d2.d(0.2, 1.0, 0.2));
                            this.j(d7 - d0, 0.0, d8 - d1);
                            entity.g(vec3d3.d(0.2, 1.0, 0.2));
                            entity.j(d7 + d0, 0.0, d8 + d1);
                        }
                    } else {
                        this.j(-d0, 0.0, -d1);
                        entity.j(d0 / 4.0, 0.0, d1 / 4.0);
                    }
                }
            }
        }
    }

    @Override
    public void a(double x2, double y2, double z2, float yaw, float pitch, int interpolationSteps) {
        this.o = x2;
        this.p = y2;
        this.q = z2;
        this.r = yaw;
        this.s = pitch;
        this.n = interpolationSteps + 2;
        this.g(this.t);
    }

    @Override
    public double p_() {
        return this.n > 0 ? this.o : this.dr();
    }

    @Override
    public double N_() {
        return this.n > 0 ? this.p : this.dt();
    }

    @Override
    public double O_() {
        return this.n > 0 ? this.q : this.dx();
    }

    @Override
    public float f_() {
        return this.n > 0 ? (float)this.s : this.dE();
    }

    @Override
    public float q_() {
        return this.n > 0 ? (float)this.r : this.dC();
    }

    @Override
    public void l(double x2, double y2, double z2) {
        this.t = new Vec3D(x2, y2, z2);
        this.g(this.t);
    }

    public abstract EnumMinecartType w();

    public IBlockData x() {
        return !this.B() ? this.y() : Block.a(this.an().b(e));
    }

    public IBlockData y() {
        return Blocks.a.o();
    }

    public int z() {
        return !this.B() ? this.A() : this.an().b(i).intValue();
    }

    public int A() {
        return 6;
    }

    public void c(IBlockData state) {
        this.an().b(e, Block.i(state));
        this.a(true);
    }

    public void c(int offset) {
        this.an().b(i, offset);
        this.a(true);
    }

    public boolean B() {
        return this.an().b(j);
    }

    public void a(boolean present) {
        this.an().b(j, present);
    }

    @Override
    public ItemStack dz() {
        return new ItemStack(switch (this.w()) {
            case EnumMinecartType.b -> Items.nM;
            case EnumMinecartType.c -> Items.nN;
            case EnumMinecartType.d -> Items.nO;
            default -> Items.nL;
            case EnumMinecartType.f -> Items.nP;
            case EnumMinecartType.g -> Items.uF;
        });
    }

    public Vector getFlyingVelocityMod() {
        return new Vector(this.flyingX, this.flyingY, this.flyingZ);
    }

    public void setFlyingVelocityMod(Vector flying) {
        this.flyingX = flying.getX();
        this.flyingY = flying.getY();
        this.flyingZ = flying.getZ();
    }

    public Vector getDerailedVelocityMod() {
        return new Vector(this.derailedX, this.derailedY, this.derailedZ);
    }

    public void setDerailedVelocityMod(Vector derailed) {
        this.derailedX = derailed.getX();
        this.derailedY = derailed.getY();
        this.derailedZ = derailed.getZ();
    }

    public static enum EnumMinecartType {
        a,
        b,
        c,
        d,
        e,
        f,
        g;

    }
}

