/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Lists;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.event.entity.EntityLoadCrossbowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.monster.ICrossbow;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.EnumAnimation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArrow;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemVanishable;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R3.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.purpurmc.purpur.PurpurConfig;

public class ItemCrossbow
extends ItemProjectileWeapon
implements ItemVanishable {
    private static final String b = "Charged";
    private static final String e = "ChargedProjectiles";
    private static final int f = 25;
    public static final int a = 8;
    private boolean g = false;
    private boolean h = false;
    private static final float i = 0.2f;
    private static final float j = 0.5f;
    private static final float k = 3.15f;
    private static final float r = 1.6f;

    public ItemCrossbow(Item.Info settings) {
        super(settings);
    }

    @Override
    public Predicate<ItemStack> e() {
        return ItemProjectileWeapon.d;
    }

    @Override
    public Predicate<ItemStack> b() {
        return ItemProjectileWeapon.c;
    }

    @Override
    public InteractionResultWrapper<ItemStack> a(World world, EntityHuman user, EnumHand hand) {
        ItemStack itemstack = user.b(hand);
        if (ItemCrossbow.d(itemstack)) {
            ItemCrossbow.a(world, user, hand, itemstack, ItemCrossbow.o(itemstack), (float)world.purpurConfig.crossbowProjectileOffset);
            ItemCrossbow.a(itemstack, false);
            return InteractionResultWrapper.b(itemstack);
        }
        if (!user.g(itemstack).b()) {
            if (!ItemCrossbow.d(itemstack)) {
                this.g = false;
                this.h = false;
                user.c(hand);
            }
            return InteractionResultWrapper.b(itemstack);
        }
        return InteractionResultWrapper.d(itemstack);
    }

    private static float o(ItemStack stack) {
        return ItemCrossbow.a(stack, Items.un) ? 1.6f : 3.15f;
    }

    @Override
    public void a(ItemStack stack, World world, EntityLiving user, int remainingUseTicks) {
        int j2 = this.b(stack) - remainingUseTicks;
        float f2 = ItemCrossbow.a(j2, stack);
        if (f2 >= 1.0f && !ItemCrossbow.d(stack)) {
            EntityLoadCrossbowEvent event = new EntityLoadCrossbowEvent((LivingEntity)user.getBukkitLivingEntity(), stack.asBukkitMirror(), CraftEquipmentSlot.getHand(user.fo()));
            if (!event.callEvent() || !ItemCrossbow.tryLoadProjectiles(user, stack, event.shouldConsumeItem())) {
                if (user instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)user;
                    player.bS.b();
                }
                return;
            }
            ItemCrossbow.a(stack, true);
            SoundCategory soundcategory = user instanceof EntityHuman ? SoundCategory.h : SoundCategory.f;
            world.a((EntityHuman)null, user.dr(), user.dt(), user.dx(), SoundEffects.fL, soundcategory, 1.0f, 1.0f / (world.F_().i() * 0.5f + 1.0f) + 0.2f);
        }
    }

    @DoNotUse
    private static boolean a(EntityLiving shooter, ItemStack crossbow) {
        return ItemCrossbow.tryLoadProjectiles(shooter, crossbow, true);
    }

    private static boolean tryLoadProjectiles(EntityLiving shooter, ItemStack crossbow, boolean consume) {
        int i2 = EnchantmentManager.a(Enchantments.I, crossbow);
        int j2 = i2 == 0 ? 1 : 3;
        boolean flag = !consume || shooter instanceof EntityHuman && ((EntityHuman)shooter).fT().d || PurpurConfig.allowCrossbowInfinity && EnchantmentManager.a(Enchantments.B, crossbow) > 0;
        ItemStack itemstack1 = shooter.g(crossbow);
        ItemStack itemstack2 = itemstack1.p();
        for (int k2 = 0; k2 < j2; ++k2) {
            if (k2 > 0) {
                itemstack1 = itemstack2.p();
            }
            if (itemstack1.b() && flag) {
                itemstack1 = new ItemStack(Items.os);
                itemstack2 = itemstack1.p();
            }
            if (ItemCrossbow.a(shooter, crossbow, itemstack1, k2 > 0, flag)) continue;
            return false;
        }
        return true;
    }

    private static boolean a(EntityLiving shooter, ItemStack crossbow, ItemStack projectile, boolean simulated, boolean creative) {
        ItemStack itemstack2;
        boolean flag2;
        if (projectile.b()) {
            return false;
        }
        boolean bl = flag2 = creative && projectile.d() instanceof ItemArrow;
        if (!(flag2 || creative || simulated)) {
            itemstack2 = projectile.a(1);
            if (projectile.b() && shooter instanceof EntityHuman) {
                ((EntityHuman)shooter).fS().g(projectile);
            }
        } else {
            itemstack2 = projectile.p();
        }
        ItemCrossbow.b(crossbow, itemstack2);
        return true;
    }

    public static boolean d(ItemStack stack) {
        NBTTagCompound nbttagcompound = stack.v();
        return nbttagcompound != null && nbttagcompound.q(b);
    }

    public static void a(ItemStack stack, boolean charged) {
        NBTTagCompound nbttagcompound = stack.w();
        nbttagcompound.a(b, charged);
    }

    private static void b(ItemStack crossbow, ItemStack projectile) {
        NBTTagCompound nbttagcompound = crossbow.w();
        NBTTagList nbttaglist = nbttagcompound.b(e, 9) ? nbttagcompound.c(e, 10) : new NBTTagList();
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        projectile.b(nbttagcompound1);
        nbttaglist.add(nbttagcompound1);
        nbttagcompound.a(e, nbttaglist);
    }

    private static List<ItemStack> p(ItemStack crossbow) {
        NBTTagList nbttaglist;
        ArrayList list = Lists.newArrayList();
        NBTTagCompound nbttagcompound = crossbow.v();
        if (nbttagcompound != null && nbttagcompound.b(e, 9) && (nbttaglist = nbttagcompound.c(e, 10)) != null) {
            for (int i2 = 0; i2 < nbttaglist.size(); ++i2) {
                NBTTagCompound nbttagcompound1 = nbttaglist.a(i2);
                list.add(ItemStack.a(nbttagcompound1));
            }
        }
        return list;
    }

    private static void q(ItemStack crossbow) {
        NBTTagCompound nbttagcompound = crossbow.v();
        if (nbttagcompound != null) {
            NBTTagList nbttaglist = nbttagcompound.c(e, 9);
            nbttaglist.clear();
            nbttagcompound.a(e, nbttaglist);
        }
    }

    public static boolean a(ItemStack crossbow, Item projectile) {
        return ItemCrossbow.p(crossbow).stream().anyMatch(itemstack1 -> itemstack1.a(projectile));
    }

    private static void a(World world, EntityLiving shooter, EnumHand hand, ItemStack crossbow, ItemStack projectile, float soundPitch, boolean creative, float speed, float divergence, float simulated) {
        if (!world.B) {
            IProjectile object;
            boolean flag1 = projectile.a(Items.un);
            if (flag1) {
                object = new EntityFireworks(world, projectile, shooter, shooter.dr(), shooter.dv() - (double)0.15f, shooter.dx(), true);
                ((EntityFireworks)object).spawningEntity = shooter.cw();
            } else {
                object = ItemCrossbow.a(world, shooter, crossbow, projectile);
                if (creative || simulated != 0.0f) {
                    object.d = EntityArrow.PickupStatus.c;
                }
            }
            if (shooter instanceof ICrossbow) {
                ICrossbow icrossbow = (ICrossbow)((Object)shooter);
                icrossbow.a(icrossbow.q(), crossbow, object, simulated);
            } else {
                Vec3D vec3d = shooter.i(1.0f);
                Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(simulated * ((float)Math.PI / 180)), vec3d.c, vec3d.d, vec3d.e);
                Vec3D vec3d1 = shooter.f(1.0f);
                Vector3f vector3f = vec3d1.j().rotate((Quaternionfc)quaternionf);
                ((IProjectile)object).c(vector3f.x(), vector3f.y(), vector3f.z(), speed, divergence);
            }
            EntityShootBowEvent event = CraftEventFactory.callEntityShootBowEvent(shooter, crossbow, projectile, object, shooter.fo(), soundPitch, true);
            if (event.isCancelled()) {
                event.getProjectile().remove();
                return;
            }
            crossbow.a(flag1 ? 3 : 1, shooter, (T entityliving1) -> entityliving1.d(hand));
            if (event.getProjectile() == ((Entity)object).getBukkitEntity() && !world.b(object)) {
                if (shooter instanceof EntityPlayer) {
                    ((EntityPlayer)shooter).getBukkitEntity().updateInventory();
                }
                return;
            }
            world.a((EntityHuman)null, shooter.dr(), shooter.dt(), shooter.dx(), SoundEffects.fR, SoundCategory.h, 1.0f, soundPitch);
        }
    }

    private static EntityArrow a(World world, EntityLiving entity, ItemStack crossbow, ItemStack arrow) {
        int lootingLevel;
        ItemArrow itemarrow = (ItemArrow)(arrow.d() instanceof ItemArrow ? arrow.d() : Items.os);
        EntityArrow entityarrow = itemarrow.a(world, arrow, entity);
        if (entity instanceof EntityHuman) {
            entityarrow.a(true);
        }
        entityarrow.b(SoundEffects.fK);
        entityarrow.q(true);
        int i2 = EnchantmentManager.a(Enchantments.K, crossbow);
        if (i2 > 0) {
            entityarrow.a((byte)i2);
        }
        if ((lootingLevel = EnchantmentManager.a(Enchantments.s, crossbow)) > 0) {
            entityarrow.setLootingLevel(lootingLevel);
        }
        return entityarrow;
    }

    public static void a(World world, EntityLiving entity, EnumHand hand, ItemStack stack, float speed, float divergence) {
        List<ItemStack> list = ItemCrossbow.p(stack);
        float[] afloat = ItemCrossbow.a(entity.eg());
        for (int i2 = 0; i2 < list.size(); ++i2) {
            boolean flag;
            ItemStack itemstack1 = list.get(i2);
            boolean bl = flag = entity instanceof EntityHuman && ((EntityHuman)entity).fT().d || PurpurConfig.allowCrossbowInfinity && EnchantmentManager.a(Enchantments.B, stack) > 0;
            if (itemstack1.b()) continue;
            if (i2 == 0) {
                ItemCrossbow.a(world, entity, hand, stack, itemstack1, afloat[i2], flag, speed, divergence, 0.0f);
                continue;
            }
            if (i2 == 1) {
                ItemCrossbow.a(world, entity, hand, stack, itemstack1, afloat[i2], flag, speed, divergence, -10.0f);
                continue;
            }
            if (i2 != 2) continue;
            ItemCrossbow.a(world, entity, hand, stack, itemstack1, afloat[i2], flag, speed, divergence, 10.0f);
        }
        ItemCrossbow.a(world, entity, stack);
    }

    private static float[] a(RandomSource random) {
        boolean flag = random.h();
        return new float[]{1.0f, ItemCrossbow.a(flag, random), ItemCrossbow.a(!flag, random)};
    }

    private static float a(boolean flag, RandomSource random) {
        float f2 = flag ? 0.63f : 0.43f;
        return 1.0f / (random.i() * 0.5f + 1.8f) + f2;
    }

    private static void a(World world, EntityLiving entity, ItemStack stack) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            if (!world.B) {
                CriterionTriggers.G.a(entityplayer, stack);
            }
            entityplayer.b(StatisticList.c.b(stack.d()));
        }
        ItemCrossbow.q(stack);
    }

    @Override
    public void a(World world, EntityLiving user, ItemStack stack, int remainingUseTicks) {
        if (!world.B) {
            int j2 = EnchantmentManager.a(Enchantments.J, stack);
            SoundEffect soundeffect = this.a(j2);
            SoundEffect soundeffect1 = j2 == 0 ? SoundEffects.fM : null;
            float f2 = (float)(stack.r() - remainingUseTicks) / (float)ItemCrossbow.k(stack);
            if (f2 < 0.2f) {
                this.g = false;
                this.h = false;
            }
            if (f2 >= 0.2f && !this.g) {
                this.g = true;
                world.a((EntityHuman)null, user.dr(), user.dt(), user.dx(), soundeffect, SoundCategory.h, 0.5f, 1.0f);
            }
            if (f2 >= 0.5f && soundeffect1 != null && !this.h) {
                this.h = true;
                world.a((EntityHuman)null, user.dr(), user.dt(), user.dx(), soundeffect1, SoundCategory.h, 0.5f, 1.0f);
            }
        }
    }

    @Override
    public int b(ItemStack stack) {
        return ItemCrossbow.k(stack) + 3;
    }

    public static int k(ItemStack stack) {
        int i2 = EnchantmentManager.a(Enchantments.J, stack);
        return i2 == 0 ? 25 : 25 - 5 * i2;
    }

    @Override
    public EnumAnimation c(ItemStack stack) {
        return EnumAnimation.g;
    }

    private SoundEffect a(int stage) {
        switch (stage) {
            case 1: {
                return SoundEffects.fO;
            }
            case 2: {
                return SoundEffects.fP;
            }
            case 3: {
                return SoundEffects.fQ;
            }
        }
        return SoundEffects.fN;
    }

    private static float a(int useTicks, ItemStack stack) {
        float f2 = (float)useTicks / (float)ItemCrossbow.k(stack);
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return f2;
    }

    @Override
    public void a(ItemStack stack, @Nullable World world, List<IChatBaseComponent> tooltip, TooltipFlag context) {
        List<ItemStack> list1 = ItemCrossbow.p(stack);
        if (ItemCrossbow.d(stack) && !list1.isEmpty()) {
            ItemStack itemstack1 = list1.get(0);
            tooltip.add(IChatBaseComponent.c("item.minecraft.crossbow.projectile").b(CommonComponents.u).b(itemstack1.J()));
            if (context.a() && itemstack1.a(Items.un)) {
                ArrayList list2 = Lists.newArrayList();
                Items.un.a(itemstack1, world, list2, context);
                if (!list2.isEmpty()) {
                    for (int i2 = 0; i2 < list2.size(); ++i2) {
                        list2.set(i2, IChatBaseComponent.b("  ").b((IChatBaseComponent)list2.get(i2)).a(EnumChatFormat.h));
                    }
                    tooltip.addAll(list2);
                }
            }
        }
    }

    @Override
    public boolean l(ItemStack stack) {
        return stack.a(this);
    }

    @Override
    public int d() {
        return 8;
    }
}

