/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.alchemy;

import com.google.common.collect.Lists;
import io.papermc.paper.potion.PaperPotionMix;
import io.papermc.paper.potion.PotionMix;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.IMaterial;
import org.bukkit.NamespacedKey;

public class PotionBrewer {
    public static final int a = 20;
    private static final List<PredicatedCombination<PotionRegistry>> b = Lists.newArrayList();
    private static final List<PredicatedCombination<Item>> c = Lists.newArrayList();
    private static final Object2ObjectLinkedOpenHashMap<NamespacedKey, PaperPotionMix> CUSTOM_MIXES = new Object2ObjectLinkedOpenHashMap();
    private static final List<RecipeItemStack> d = Lists.newArrayList();
    private static final Predicate<ItemStack> e = stack -> {
        for (RecipeItemStack ingredient : d) {
            if (!ingredient.a((ItemStack)stack)) continue;
            return true;
        }
        return false;
    };

    public static boolean a(ItemStack stack) {
        return PotionBrewer.b(stack) || PotionBrewer.c(stack) || PotionBrewer.isCustomIngredient(stack);
    }

    protected static boolean b(ItemStack stack) {
        for (PredicatedCombination<Item> mix : c) {
            if (!mix.b.a(stack)) continue;
            return true;
        }
        return false;
    }

    protected static boolean c(ItemStack stack) {
        for (PredicatedCombination<PotionRegistry> mix : b) {
            if (!mix.b.a(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean a(PotionRegistry potion) {
        for (PredicatedCombination<PotionRegistry> mix : b) {
            if (mix.c != potion) continue;
            return true;
        }
        return false;
    }

    public static boolean a(ItemStack input, ItemStack ingredient) {
        if (PotionBrewer.hasCustomMix(input, ingredient)) {
            return true;
        }
        return e.test(input) && (PotionBrewer.b(input, ingredient) || PotionBrewer.c(input, ingredient));
    }

    protected static boolean b(ItemStack input, ItemStack ingredient) {
        Item item = input.d();
        for (PredicatedCombination<Item> mix : c) {
            if (mix.a != item || !mix.b.a(ingredient)) continue;
            return true;
        }
        return false;
    }

    protected static boolean c(ItemStack input, ItemStack ingredient) {
        PotionRegistry potion = PotionUtil.d(input);
        for (PredicatedCombination<PotionRegistry> mix : b) {
            if (mix.a != potion || !mix.b.a(ingredient)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack d(ItemStack ingredient, ItemStack input) {
        if (!input.b()) {
            for (PaperPotionMix mix : CUSTOM_MIXES.values()) {
                if (!mix.input().test(input) || !mix.ingredient().test(ingredient)) continue;
                return mix.result().p();
            }
            PotionRegistry potion = PotionUtil.d(input);
            Item item = input.d();
            for (PredicatedCombination<Item> predicatedCombination : c) {
                if (predicatedCombination.a != item || !predicatedCombination.b.a(ingredient)) continue;
                return PotionUtil.a(new ItemStack((IMaterial)predicatedCombination.c), potion);
            }
            for (PredicatedCombination<Object> predicatedCombination : b) {
                if (predicatedCombination.a != potion || !predicatedCombination.b.a(ingredient)) continue;
                return PotionUtil.a(new ItemStack(item), (PotionRegistry)predicatedCombination.c);
            }
        }
        return input;
    }

    public static boolean isCustomIngredient(ItemStack stack) {
        for (PaperPotionMix mix : CUSTOM_MIXES.values()) {
            if (!mix.ingredient().test(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCustomInput(ItemStack stack) {
        for (PaperPotionMix mix : CUSTOM_MIXES.values()) {
            if (!mix.input().test(stack)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasCustomMix(ItemStack input, ItemStack ingredient) {
        for (PaperPotionMix mix : CUSTOM_MIXES.values()) {
            if (!mix.input().test(input) || !mix.ingredient().test(ingredient)) continue;
            return true;
        }
        return false;
    }

    public static void addPotionMix(PotionMix mix) {
        if (CUSTOM_MIXES.containsKey((Object)mix.getKey())) {
            throw new IllegalArgumentException("Duplicate recipe ignored with ID " + mix.getKey());
        }
        CUSTOM_MIXES.putAndMoveToFirst((Object)mix.getKey(), (Object)new PaperPotionMix(mix));
    }

    public static boolean removePotionMix(NamespacedKey key) {
        return CUSTOM_MIXES.remove((Object)key) != null;
    }

    public static void reload() {
        b.clear();
        c.clear();
        d.clear();
        CUSTOM_MIXES.clear();
        PotionBrewer.a();
    }

    public static void a() {
        PotionBrewer.a(Items.sh);
        PotionBrewer.a(Items.vh);
        PotionBrewer.a(Items.vk);
        PotionBrewer.a(Items.sh, Items.pr, Items.vh);
        PotionBrewer.a(Items.vh, Items.vg, Items.vk);
        PotionBrewer.a(Potions.c, Items.sq, Potions.d);
        PotionBrewer.a(Potions.c, Items.se, Potions.d);
        PotionBrewer.a(Potions.c, Items.uw, Potions.d);
        PotionBrewer.a(Potions.c, Items.sl, Potions.d);
        PotionBrewer.a(Potions.c, Items.sj, Potions.d);
        PotionBrewer.a(Potions.c, Items.rx, Potions.d);
        PotionBrewer.a(Potions.c, Items.sm, Potions.d);
        PotionBrewer.a(Potions.c, Items.qV, Potions.e);
        PotionBrewer.a(Potions.c, Items.lG, Potions.d);
        PotionBrewer.a(Potions.c, Items.sg, Potions.f);
        PotionBrewer.a(Potions.f, Items.ud, Potions.g);
        PotionBrewer.a(Potions.g, Items.lG, Potions.h);
        PotionBrewer.a(Potions.g, Items.sk, Potions.i);
        PotionBrewer.a(Potions.h, Items.sk, Potions.j);
        PotionBrewer.a(Potions.i, Items.lG, Potions.j);
        PotionBrewer.a(Potions.f, Items.sm, Potions.n);
        PotionBrewer.a(Potions.n, Items.lG, Potions.o);
        PotionBrewer.a(Potions.f, Items.uw, Potions.k);
        PotionBrewer.a(Potions.k, Items.lG, Potions.l);
        PotionBrewer.a(Potions.k, Items.qV, Potions.m);
        PotionBrewer.a(Potions.k, Items.sk, Potions.s);
        PotionBrewer.a(Potions.l, Items.sk, Potions.t);
        PotionBrewer.a(Potions.s, Items.lG, Potions.t);
        PotionBrewer.a(Potions.s, Items.qV, Potions.u);
        PotionBrewer.a(Potions.f, Items.on, Potions.v);
        PotionBrewer.a(Potions.v, Items.lG, Potions.w);
        PotionBrewer.a(Potions.v, Items.qV, Potions.x);
        PotionBrewer.a(Potions.p, Items.sk, Potions.s);
        PotionBrewer.a(Potions.q, Items.sk, Potions.t);
        PotionBrewer.a(Potions.f, Items.rx, Potions.p);
        PotionBrewer.a(Potions.p, Items.lG, Potions.q);
        PotionBrewer.a(Potions.p, Items.qV, Potions.r);
        PotionBrewer.a(Potions.f, Items.qZ, Potions.y);
        PotionBrewer.a(Potions.y, Items.lG, Potions.z);
        PotionBrewer.a(Potions.f, Items.sq, Potions.A);
        PotionBrewer.a(Potions.A, Items.qV, Potions.B);
        PotionBrewer.a(Potions.A, Items.sk, Potions.C);
        PotionBrewer.a(Potions.B, Items.sk, Potions.D);
        PotionBrewer.a(Potions.C, Items.qV, Potions.D);
        PotionBrewer.a(Potions.E, Items.sk, Potions.C);
        PotionBrewer.a(Potions.F, Items.sk, Potions.C);
        PotionBrewer.a(Potions.G, Items.sk, Potions.D);
        PotionBrewer.a(Potions.f, Items.sj, Potions.E);
        PotionBrewer.a(Potions.E, Items.lG, Potions.F);
        PotionBrewer.a(Potions.E, Items.qV, Potions.G);
        PotionBrewer.a(Potions.f, Items.se, Potions.H);
        PotionBrewer.a(Potions.H, Items.lG, Potions.I);
        PotionBrewer.a(Potions.H, Items.qV, Potions.J);
        PotionBrewer.a(Potions.f, Items.sl, Potions.K);
        PotionBrewer.a(Potions.K, Items.lG, Potions.L);
        PotionBrewer.a(Potions.K, Items.qV, Potions.M);
        PotionBrewer.a(Potions.c, Items.sk, Potions.N);
        PotionBrewer.a(Potions.N, Items.lG, Potions.O);
        PotionBrewer.a(Potions.f, Items.vJ, Potions.Q);
        PotionBrewer.a(Potions.Q, Items.lG, Potions.R);
    }

    private static void a(Item input, Item ingredient, Item output) {
        if (!(input instanceof ItemPotion)) {
            throw new IllegalArgumentException("Expected a potion, got: " + BuiltInRegistries.h.b(input));
        }
        if (!(output instanceof ItemPotion)) {
            throw new IllegalArgumentException("Expected a potion, got: " + BuiltInRegistries.h.b(output));
        }
        c.add(new PredicatedCombination<Item>(input, RecipeItemStack.a(ingredient), output));
    }

    private static void a(Item item) {
        if (!(item instanceof ItemPotion)) {
            throw new IllegalArgumentException("Expected a potion, got: " + BuiltInRegistries.h.b(item));
        }
        d.add(RecipeItemStack.a(item));
    }

    private static void a(PotionRegistry input, Item item, PotionRegistry output) {
        b.add(new PredicatedCombination<PotionRegistry>(input, RecipeItemStack.a(item), output));
    }

    static class PredicatedCombination<T> {
        final T a;
        final RecipeItemStack b;
        final T c;

        public PredicatedCombination(T input, RecipeItemStack ingredient, T output) {
            this.a = input;
            this.b = ingredient;
            this.c = output;
        }
    }
}

