/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.alchemy;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.effect.AttributeModifierTemplate;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.Potions;

public class PotionUtil {
    public static final String a = "custom_potion_effects";
    public static final String b = "CustomPotionColor";
    public static final String c = "Potion";
    private static final int d = 0xF800F8;
    private static final IChatBaseComponent e = IChatBaseComponent.c("effect.none").a(EnumChatFormat.h);

    public static List<MobEffect> a(ItemStack stack) {
        return PotionUtil.a(stack.v());
    }

    public static List<MobEffect> a(PotionRegistry potion, Collection<MobEffect> custom) {
        ArrayList list = Lists.newArrayList();
        list.addAll(potion.a());
        list.addAll(custom);
        return list;
    }

    public static List<MobEffect> a(@Nullable NBTTagCompound nbt) {
        ArrayList list = Lists.newArrayList();
        list.addAll(PotionUtil.c(nbt).a());
        PotionUtil.a(nbt, list);
        return list;
    }

    public static List<MobEffect> b(ItemStack stack) {
        return PotionUtil.b(stack.v());
    }

    public static List<MobEffect> b(@Nullable NBTTagCompound nbt) {
        ArrayList list = Lists.newArrayList();
        PotionUtil.a(nbt, list);
        return list;
    }

    public static void a(@Nullable NBTTagCompound nbt, List<MobEffect> list) {
        if (nbt != null && nbt.b(a, 9)) {
            NBTTagList listTag = nbt.c(a, 10);
            for (int i2 = 0; i2 < listTag.size(); ++i2) {
                NBTTagCompound compoundTag = listTag.a(i2);
                MobEffect mobEffectInstance = MobEffect.b(compoundTag);
                if (mobEffectInstance == null) continue;
                list.add(mobEffectInstance);
            }
        }
    }

    public static int c(ItemStack stack) {
        NBTTagCompound compoundTag = stack.v();
        if (compoundTag != null && compoundTag.b(b, 99)) {
            return compoundTag.h(b);
        }
        return PotionUtil.d(stack) == Potions.b ? 0xF800F8 : PotionUtil.a(PotionUtil.a(stack));
    }

    public static int a(PotionRegistry potion) {
        return potion == Potions.b ? 0xF800F8 : PotionUtil.a(potion.a());
    }

    public static int a(Collection<MobEffect> effects) {
        int i2 = 3694022;
        if (effects.isEmpty()) {
            return 3694022;
        }
        float f2 = 0.0f;
        float g2 = 0.0f;
        float h2 = 0.0f;
        int j2 = 0;
        for (MobEffect mobEffectInstance : effects) {
            if (!mobEffectInstance.g()) continue;
            int k2 = mobEffectInstance.c().g();
            int l2 = mobEffectInstance.e() + 1;
            f2 += (float)(l2 * (k2 >> 16 & 0xFF)) / 255.0f;
            g2 += (float)(l2 * (k2 >> 8 & 0xFF)) / 255.0f;
            h2 += (float)(l2 * (k2 >> 0 & 0xFF)) / 255.0f;
            j2 += l2;
        }
        if (j2 == 0) {
            return 0;
        }
        f2 = f2 / (float)j2 * 255.0f;
        g2 = g2 / (float)j2 * 255.0f;
        h2 = h2 / (float)j2 * 255.0f;
        return (int)f2 << 16 | (int)g2 << 8 | (int)h2;
    }

    public static PotionRegistry d(ItemStack stack) {
        return PotionUtil.c(stack.v());
    }

    public static PotionRegistry c(@Nullable NBTTagCompound compound) {
        if (compound == null) {
            return Potions.b;
        }
        return PotionRegistry.a(compound.l(c));
    }

    public static ItemStack a(ItemStack stack, PotionRegistry potion) {
        MinecraftKey resourceLocation = BuiltInRegistries.i.b(potion);
        if (potion == Potions.b) {
            stack.c(c);
        } else {
            stack.w().a(c, resourceLocation.toString());
        }
        return stack;
    }

    public static ItemStack a(ItemStack stack, Collection<MobEffect> effects) {
        if (effects.isEmpty()) {
            return stack;
        }
        NBTTagCompound compoundTag = stack.w();
        NBTTagList listTag = compoundTag.c(a, 9);
        for (MobEffect mobEffectInstance : effects) {
            listTag.add(mobEffectInstance.a(new NBTTagCompound()));
        }
        compoundTag.a(a, listTag);
        return stack;
    }

    public static void a(ItemStack stack, List<IChatBaseComponent> list, float durationMultiplier, float tickRate) {
        PotionUtil.a(PotionUtil.a(stack), list, durationMultiplier, tickRate);
    }

    public static void a(List<MobEffect> statusEffects, List<IChatBaseComponent> list, float durationMultiplier, float tickRate) {
        ArrayList list2 = Lists.newArrayList();
        if (statusEffects.isEmpty()) {
            list.add(e);
        } else {
            for (MobEffect mobEffectInstance : statusEffects) {
                IChatMutableComponent mutableComponent = IChatBaseComponent.c(mobEffectInstance.i());
                MobEffectList mobEffect = mobEffectInstance.c();
                Map<AttributeBase, AttributeModifierTemplate> map = mobEffect.h();
                if (!map.isEmpty()) {
                    for (Map.Entry<AttributeBase, AttributeModifierTemplate> entry : map.entrySet()) {
                        list2.add(new Pair((Object)entry.getKey(), (Object)entry.getValue().a(mobEffectInstance.e())));
                    }
                }
                if (mobEffectInstance.e() > 0) {
                    mutableComponent = IChatBaseComponent.a("potion.withAmplifier", mutableComponent, IChatBaseComponent.c("potion.potency." + mobEffectInstance.e()));
                }
                if (!mobEffectInstance.a(20)) {
                    mutableComponent = IChatBaseComponent.a("potion.withDuration", mutableComponent, MobEffectUtil.a(mobEffectInstance, durationMultiplier, tickRate));
                }
                list.add(mutableComponent.a(mobEffect.f().a()));
            }
        }
        if (!list2.isEmpty()) {
            list.add(CommonComponents.a);
            list.add(IChatBaseComponent.c("potion.whenDrank").a(EnumChatFormat.f));
            for (Pair pair : list2) {
                double f2;
                AttributeModifier attributeModifier = (AttributeModifier)pair.getSecond();
                double d2 = attributeModifier.c();
                if (attributeModifier.b() == AttributeModifier.Operation.b || attributeModifier.b() == AttributeModifier.Operation.c) {
                    double e2 = attributeModifier.c() * 100.0;
                } else {
                    f2 = attributeModifier.c();
                }
                if (d2 > 0.0) {
                    list.add(IChatBaseComponent.a("attribute.modifier.plus." + attributeModifier.b().a(), new Object[]{ItemStack.g.format(f2), IChatBaseComponent.c(((AttributeBase)pair.getFirst()).c())}).a(EnumChatFormat.j));
                    continue;
                }
                if (!(d2 < 0.0)) continue;
                list.add(IChatBaseComponent.a("attribute.modifier.take." + attributeModifier.b().a(), new Object[]{ItemStack.g.format(f2 *= -1.0), IChatBaseComponent.c(((AttributeBase)pair.getFirst()).c())}).a(EnumChatFormat.m));
            }
        }
    }
}

