/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.chars.CharArraySet;
import it.unimi.dsi.fastutil.chars.CharSet;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.SystemUtils;
import net.minecraft.core.NonNullList;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.item.crafting.RecipeItemStack;

public final class ShapedRecipePattern
extends Record {
    private final int b;
    private final int c;
    private final NonNullList<RecipeItemStack> d;
    private final Optional<a> e;
    private static final int f = 3;
    public static final MapCodec<ShapedRecipePattern> a = net.minecraft.world.item.crafting.ShapedRecipePattern$a.a.flatXmap(ShapedRecipePattern::a, recipe -> recipe.d().map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Cannot encode unpacked recipe")));

    public ShapedRecipePattern(int i2, int j2, NonNullList<RecipeItemStack> nonNullList, Optional<a> optional) {
        this.b = i2;
        this.c = j2;
        this.d = nonNullList;
        this.e = optional;
    }

    public static ShapedRecipePattern a(Map<Character, RecipeItemStack> key, String ... pattern) {
        return ShapedRecipePattern.a(key, List.of(pattern));
    }

    public static ShapedRecipePattern a(Map<Character, RecipeItemStack> key, List<String> pattern) {
        a data = new a(key, pattern);
        return SystemUtils.a(ShapedRecipePattern.a(data), IllegalArgumentException::new);
    }

    private static DataResult<ShapedRecipePattern> a(a data) {
        String[] strings = ShapedRecipePattern.a(data.c);
        int i2 = strings[0].length();
        int j2 = strings.length;
        NonNullList<RecipeItemStack> nonNullList = NonNullList.a(i2 * j2, RecipeItemStack.a);
        CharArraySet charSet = new CharArraySet(data.b.keySet());
        for (int k2 = 0; k2 < strings.length; ++k2) {
            String string = strings[k2];
            for (int l2 = 0; l2 < string.length(); ++l2) {
                RecipeItemStack ingredient;
                char c2 = string.charAt(l2);
                RecipeItemStack recipeItemStack = ingredient = c2 == ' ' ? RecipeItemStack.a : data.b.get(Character.valueOf(c2));
                if (ingredient == null) {
                    return DataResult.error(() -> "Pattern references symbol '" + c2 + "' but it's not defined in the key");
                }
                charSet.remove(c2);
                nonNullList.set(l2 + i2 * k2, ingredient);
            }
        }
        if (!charSet.isEmpty()) {
            return DataResult.error(() -> ShapedRecipePattern.a((CharSet)charSet));
        }
        return DataResult.success((Object)new ShapedRecipePattern(i2, j2, nonNullList, Optional.of(data)));
    }

    @VisibleForTesting
    static String[] a(List<String> pattern) {
        int i2 = Integer.MAX_VALUE;
        int j2 = 0;
        int k2 = 0;
        int l2 = 0;
        for (int m2 = 0; m2 < pattern.size(); ++m2) {
            String string = pattern.get(m2);
            i2 = Math.min(i2, ShapedRecipePattern.a(string));
            int n2 = ShapedRecipePattern.b(string);
            j2 = Math.max(j2, n2);
            if (n2 < 0) {
                if (k2 == m2) {
                    ++k2;
                }
                ++l2;
                continue;
            }
            l2 = 0;
        }
        if (pattern.size() == l2) {
            return new String[0];
        }
        String[] strings = new String[pattern.size() - l2 - k2];
        for (int o2 = 0; o2 < strings.length; ++o2) {
            strings[o2] = pattern.get(o2 + k2).substring(i2, j2 + 1);
        }
        return strings;
    }

    private static int a(String line) {
        int i2;
        for (i2 = 0; i2 < line.length() && line.charAt(i2) == ' '; ++i2) {
        }
        return i2;
    }

    private static int b(String line) {
        int i2;
        for (i2 = line.length() - 1; i2 >= 0 && line.charAt(i2) == ' '; --i2) {
        }
        return i2;
    }

    public boolean a(InventoryCrafting inventory) {
        for (int i2 = 0; i2 <= inventory.f() - this.b; ++i2) {
            for (int j2 = 0; j2 <= inventory.g() - this.c; ++j2) {
                if (this.a(inventory, i2, j2, true)) {
                    return true;
                }
                if (!this.a(inventory, i2, j2, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean a(InventoryCrafting inventory, int offsetX, int offsetY, boolean flipped) {
        for (int i2 = 0; i2 < inventory.f(); ++i2) {
            for (int j2 = 0; j2 < inventory.g(); ++j2) {
                int k2 = i2 - offsetX;
                int l2 = j2 - offsetY;
                RecipeItemStack ingredient = RecipeItemStack.a;
                if (k2 >= 0 && l2 >= 0 && k2 < this.b && l2 < this.c) {
                    ingredient = flipped ? this.d.get(this.b - k2 - 1 + l2 * this.b) : this.d.get(k2 + l2 * this.b);
                }
                if (ingredient.a(inventory.a(i2 + j2 * inventory.f()))) continue;
                return false;
            }
        }
        return true;
    }

    public void a(PacketDataSerializer buf) {
        buf.c(this.b);
        buf.c(this.c);
        for (RecipeItemStack ingredient : this.d) {
            ingredient.a(buf);
        }
    }

    public static ShapedRecipePattern b(PacketDataSerializer buf) {
        int i2 = buf.n();
        int j2 = buf.n();
        NonNullList<RecipeItemStack> nonNullList = NonNullList.a(i2 * j2, RecipeItemStack.a);
        nonNullList.replaceAll(ingredient -> RecipeItemStack.b(buf));
        return new ShapedRecipePattern(i2, j2, nonNullList, Optional.empty());
    }

    @Override
    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{ShapedRecipePattern.class, "width;height;ingredients;data", "b", "c", "d", "e"}, this);
    }

    @Override
    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ShapedRecipePattern.class, "width;height;ingredients;data", "b", "c", "d", "e"}, this);
    }

    @Override
    @Override
    public final boolean equals(Object object) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ShapedRecipePattern.class, "width;height;ingredients;data", "b", "c", "d", "e"}, this, object);
    }

    public int a() {
        return this.b;
    }

    public int b() {
        return this.c;
    }

    public NonNullList<RecipeItemStack> c() {
        return this.d;
    }

    public Optional<a> d() {
        return this.e;
    }

    private static /* synthetic */ String a(CharSet charSet) {
        return "Key defines symbols that aren't used in pattern: " + charSet;
    }

    public static final class a
    extends Record {
        private final Map<Character, RecipeItemStack> b;
        private final List<String> c;
        private static final Codec<List<String>> d = Codec.STRING.listOf().comapFlatMap(pattern -> {
            if (pattern.size() > 3) {
                return DataResult.error(() -> "Invalid pattern: too many rows, 3 is maximum");
            }
            if (pattern.isEmpty()) {
                return DataResult.error(() -> "Invalid pattern: empty pattern not allowed");
            }
            int i2 = ((String)pattern.get(0)).length();
            for (String string : pattern) {
                if (string.length() > 3) {
                    return DataResult.error(() -> "Invalid pattern: too many columns, 3 is maximum");
                }
                if (i2 == string.length()) continue;
                return DataResult.error(() -> "Invalid pattern: each row must be the same width");
            }
            return DataResult.success((Object)pattern);
        }, Function.identity());
        private static final Codec<Character> e = Codec.STRING.comapFlatMap(keyEntry -> {
            if (keyEntry.length() != 1) {
                return DataResult.error(() -> "Invalid key entry: '" + keyEntry + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(keyEntry)) {
                return DataResult.error(() -> "Invalid key entry: ' ' is a reserved symbol.");
            }
            return DataResult.success((Object)Character.valueOf(keyEntry.charAt(0)));
        }, String::valueOf);
        public static final MapCodec<a> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.d(e, RecipeItemStack.c).fieldOf("key").forGetter(data -> data.b), (App)d.fieldOf("pattern").forGetter(data -> data.c)).apply((Applicative)instance, a::new));

        public a(Map<Character, RecipeItemStack> map, List<String> list) {
            this.b = map;
            this.c = list;
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "key;pattern", "b", "c"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "key;pattern", "b", "c"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "key;pattern", "b", "c"}, this, object);
        }

        public Map<Character, RecipeItemStack> a() {
            return this.b;
        }

        public List<String> b() {
            return this.c;
        }
    }
}

