/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;

public class ChunkCoordIntPair {
    private static final int g = 1056;
    public static final long a = ChunkCoordIntPair.c(1875066, 1875066);
    public static final ChunkCoordIntPair b = new ChunkCoordIntPair(0, 0);
    private static final long h = 32L;
    private static final long i = 0xFFFFFFFFL;
    private static final int j = 5;
    public static final int c = 32;
    private static final int k = 31;
    public static final int d = 31;
    public final int e;
    public final int f;
    public final long longKey;
    private static final int l = 1664525;
    private static final int m = 1013904223;
    private static final int n = -559038737;

    public ChunkCoordIntPair(int x2, int z2) {
        this.e = x2;
        this.f = z2;
        this.longKey = ChunkCoordIntPair.c(this.e, this.f);
    }

    public ChunkCoordIntPair(BlockPosition pos) {
        this.e = SectionPosition.a(pos.u());
        this.f = SectionPosition.a(pos.w());
        this.longKey = ChunkCoordIntPair.c(this.e, this.f);
    }

    public ChunkCoordIntPair(long pos) {
        this.e = (int)pos;
        this.f = (int)(pos >> 32);
        this.longKey = ChunkCoordIntPair.c(this.e, this.f);
    }

    public static ChunkCoordIntPair a(int x2, int z2) {
        return new ChunkCoordIntPair(x2 << 5, z2 << 5);
    }

    public static ChunkCoordIntPair b(int x2, int z2) {
        return new ChunkCoordIntPair((x2 << 5) + 31, (z2 << 5) + 31);
    }

    public long a() {
        return this.longKey;
    }

    public static long c(int chunkX, int chunkZ) {
        return (long)chunkX & 0xFFFFFFFFL | ((long)chunkZ & 0xFFFFFFFFL) << 32;
    }

    public static long a(BlockPosition pos) {
        return ChunkCoordIntPair.c(SectionPosition.a(pos.u()), SectionPosition.a(pos.w()));
    }

    public static int a(long pos) {
        return (int)(pos & 0xFFFFFFFFL);
    }

    public static int b(long pos) {
        return (int)(pos >>> 32 & 0xFFFFFFFFL);
    }

    public int hashCode() {
        return ChunkCoordIntPair.d(this.e, this.f);
    }

    public static int d(int x2, int z2) {
        int i2 = 1664525 * x2 + 1013904223;
        int j2 = 1664525 * (z2 ^ 0xDEADBEEF) + 1013904223;
        return i2 ^ j2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (this == object) return true;
        if (!(object instanceof ChunkCoordIntPair)) return false;
        ChunkCoordIntPair chunkPos = (ChunkCoordIntPair)object;
        if (this.e != chunkPos.e) return false;
        if (this.f != chunkPos.f) return false;
        return true;
    }

    public int b() {
        return this.a(8);
    }

    public int c() {
        return this.b(8);
    }

    public int d() {
        return SectionPosition.c(this.e);
    }

    public int e() {
        return SectionPosition.c(this.f);
    }

    public int f() {
        return this.a(15);
    }

    public int g() {
        return this.b(15);
    }

    public int h() {
        return this.e >> 5;
    }

    public int i() {
        return this.f >> 5;
    }

    public int j() {
        return this.e & 0x1F;
    }

    public int k() {
        return this.f & 0x1F;
    }

    public BlockPosition a(int offsetX, int y2, int offsetZ) {
        return new BlockPosition(this.a(offsetX), y2, this.b(offsetZ));
    }

    public int a(int offset) {
        return SectionPosition.a(this.e, offset);
    }

    public int b(int offset) {
        return SectionPosition.a(this.f, offset);
    }

    public BlockPosition c(int y2) {
        return new BlockPosition(this.b(), y2, this.c());
    }

    public String toString() {
        return "[" + this.e + ", " + this.f + "]";
    }

    public BlockPosition l() {
        return new BlockPosition(this.d(), 0, this.e());
    }

    public int a(ChunkCoordIntPair pos) {
        return Math.max(Math.abs(this.e - pos.e), Math.abs(this.f - pos.f));
    }

    public int b(ChunkCoordIntPair pos) {
        return this.e(pos.e, pos.f);
    }

    public int c(long pos) {
        return this.e(ChunkCoordIntPair.a(pos), ChunkCoordIntPair.b(pos));
    }

    private int e(int x2, int z2) {
        int i2 = x2 - this.e;
        int j2 = z2 - this.f;
        return i2 * i2 + j2 * j2;
    }

    public static Stream<ChunkCoordIntPair> a(ChunkCoordIntPair center, int radius) {
        return ChunkCoordIntPair.a(new ChunkCoordIntPair(center.e - radius, center.f - radius), new ChunkCoordIntPair(center.e + radius, center.f + radius));
    }

    public static Stream<ChunkCoordIntPair> a(final ChunkCoordIntPair pos1, final ChunkCoordIntPair pos2) {
        int i2 = Math.abs(pos1.e - pos2.e) + 1;
        int j2 = Math.abs(pos1.f - pos2.f) + 1;
        final int k2 = pos1.e < pos2.e ? 1 : -1;
        final int l2 = pos1.f < pos2.f ? 1 : -1;
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<ChunkCoordIntPair>((long)(i2 * j2), 64){
            @Nullable
            private ChunkCoordIntPair e;

            @Override
            public boolean tryAdvance(Consumer<? super ChunkCoordIntPair> consumer) {
                if (this.e == null) {
                    this.e = pos1;
                } else {
                    int i2 = this.e.e;
                    int j2 = this.e.f;
                    if (i2 == pos2.e) {
                        if (j2 == pos2.f) {
                            return false;
                        }
                        this.e = new ChunkCoordIntPair(pos1.e, j2 + l2);
                    } else {
                        this.e = new ChunkCoordIntPair(i2 + k2, j2);
                    }
                }
                consumer.accept(this.e);
                return true;
            }
        }, false);
    }
}

