/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.destroystokyo.paper.event.entity.EntityKnockbackByEntityEvent;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.util.CollisionUtil;
import io.papermc.paper.util.CoordinateUtils;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentProtection;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.ExplosionDamageCalculatorEntity;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDirectional;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.BlockTNT;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.piston.TileEntityPiston;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftVector;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.TNTPrimeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityKnockbackEvent;
import org.purpurmc.purpur.event.PreBlockExplodeEvent;
import org.purpurmc.purpur.event.entity.PreEntityExplodeEvent;

public class Explosion {
    private static final ExplosionDamageCalculator a = new ExplosionDamageCalculator();
    private static final int b = 16;
    private final boolean c;
    private final Effect d;
    private final RandomSource e = RandomSource.a();
    private final World f;
    private final double g;
    private final double h;
    private final double i;
    @Nullable
    public final net.minecraft.world.entity.Entity j;
    private final float k;
    private final DamageSource l;
    private final ExplosionDamageCalculator m;
    private final ParticleParam n;
    private final ParticleParam o;
    private final SoundEffect p;
    private final ObjectArrayList<BlockPosition> q = new ObjectArrayList();
    private final Map<EntityHuman, Vec3D> r = Maps.newHashMap();
    public boolean wasCanceled = false;
    public float yield;
    private static final double[] CACHED_RAYS;
    private static final int CHUNK_CACHE_SHIFT = 2;
    private static final int CHUNK_CACHE_MASK = 3;
    private static final int CHUNK_CACHE_WIDTH = 4;
    private static final int BLOCK_EXPLOSION_CACHE_SHIFT = 3;
    private static final int BLOCK_EXPLOSION_CACHE_MASK = 7;
    private static final int BLOCK_EXPLOSION_CACHE_WIDTH = 8;
    private static final Float ZERO_RESISTANCE;
    private Long2ObjectOpenHashMap<ExplosionBlockCache> blockCache = null;
    private long[] chunkPosCache = null;
    private Chunk[] chunkCache = null;

    public static DamageSource a(World world, @Nullable net.minecraft.world.entity.Entity source) {
        return world.ai().d(source, Explosion.b(source));
    }

    public Explosion(World world, @Nullable net.minecraft.world.entity.Entity entity, double x2, double y2, double z2, float power, List<BlockPosition> affectedBlocks, Effect destructionType, ParticleParam particle, ParticleParam emitterParticle, SoundEffect soundEvent) {
        this(world, entity, Explosion.a(world, entity), null, x2, y2, z2, power, false, destructionType, particle, emitterParticle, soundEvent);
        this.q.addAll(affectedBlocks);
    }

    public Explosion(World world, @Nullable net.minecraft.world.entity.Entity entity, double x2, double y2, double z2, float power, boolean createFire, Effect destructionType, List<BlockPosition> affectedBlocks) {
        this(world, entity, x2, y2, z2, power, createFire, destructionType);
        this.q.addAll(affectedBlocks);
    }

    public Explosion(World world, @Nullable net.minecraft.world.entity.Entity entity, double x2, double y2, double z2, float power, boolean createFire, Effect destructionType) {
        this(world, entity, Explosion.a(world, entity), null, x2, y2, z2, power, createFire, destructionType, Particles.x, Particles.w, SoundEffects.jA);
    }

    public Explosion(World world, @Nullable net.minecraft.world.entity.Entity entity, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator behavior, double x2, double y2, double z2, float power, boolean createFire, Effect destructionType, ParticleParam particle, ParticleParam emitterParticle, SoundEffect soundEvent) {
        this.f = world;
        this.j = entity;
        this.k = (float)(world == null || world.purpurConfig.explosionClampRadius ? Math.max((double)power, 0.0) : (double)power);
        this.g = x2;
        this.h = y2;
        this.i = z2;
        this.c = createFire;
        this.d = destructionType;
        this.l = damageSource == null ? world.ai().a(this) : damageSource;
        this.m = behavior == null ? this.a(entity) : behavior;
        this.n = particle;
        this.o = emitterParticle;
        this.p = soundEvent;
        this.yield = this.d == Effect.c ? 1.0f / this.k : 1.0f;
    }

    private ExplosionBlockCache getOrCacheExplosionBlock(int x2, int y2, int z2, long key, boolean calculateResistance) {
        ExplosionBlockCache ret = (ExplosionBlockCache)this.blockCache.get(key);
        if (ret != null) {
            return ret;
        }
        BlockPosition pos = new BlockPosition(x2, y2, z2);
        if (!this.f.k(pos)) {
            ret = new ExplosionBlockCache(key, pos, null, null, 0.0f, true);
        } else {
            Chunk chunk;
            int chunkCacheKey = x2 >> 4 & 3 | z2 >> 4 << 2 & 0xC;
            long chunkKey = CoordinateUtils.getChunkKey(x2 >> 4, z2 >> 4);
            if (this.chunkPosCache[chunkCacheKey] == chunkKey) {
                chunk = this.chunkCache[chunkCacheKey];
            } else {
                this.chunkPosCache[chunkCacheKey] = chunkKey;
                this.chunkCache[chunkCacheKey] = chunk = this.f.d(x2 >> 4, z2 >> 4);
            }
            IBlockData blockState = chunk.getBlockStateFinal(x2, y2, z2);
            Fluid fluidState = blockState.u();
            Optional<Float> resistance = !calculateResistance ? Optional.empty() : this.m.a(this, (IBlockAccess)this.f, pos, blockState, fluidState);
            ret = new ExplosionBlockCache(key, pos, blockState, fluidState, (resistance.orElse(ZERO_RESISTANCE).floatValue() + 0.3f) * 0.3f, false);
        }
        this.blockCache.put(key, (Object)ret);
        return ret;
    }

    private boolean clipsAnything(Vec3D from, Vec3D to, CollisionUtil.LazyEntityCollisionContext context, ExplosionBlockCache[] blockCache, BlockPosition.MutableBlockPosition currPos) {
        double adjX = 1.0E-7 * (from.c - to.c);
        double adjY = 1.0E-7 * (from.d - to.d);
        double adjZ = 1.0E-7 * (from.e - to.e);
        if (adjX == 0.0 && adjY == 0.0 && adjZ == 0.0) {
            return false;
        }
        double toXAdj = to.c - adjX;
        double toYAdj = to.d - adjY;
        double toZAdj = to.e - adjZ;
        double fromXAdj = from.c + adjX;
        double fromYAdj = from.d + adjY;
        double fromZAdj = from.e + adjZ;
        int currX = MathHelper.a(fromXAdj);
        int currY = MathHelper.a(fromYAdj);
        int currZ = MathHelper.a(fromZAdj);
        double diffX = toXAdj - fromXAdj;
        double diffY = toYAdj - fromYAdj;
        double diffZ = toZAdj - fromZAdj;
        double dxDouble = Math.signum(diffX);
        double dyDouble = Math.signum(diffY);
        double dzDouble = Math.signum(diffZ);
        int dx = (int)dxDouble;
        int dy = (int)dyDouble;
        int dz = (int)dzDouble;
        double normalizedDiffX = diffX == 0.0 ? Double.MAX_VALUE : dxDouble / diffX;
        double normalizedDiffY = diffY == 0.0 ? Double.MAX_VALUE : dyDouble / diffY;
        double normalizedDiffZ = diffZ == 0.0 ? Double.MAX_VALUE : dzDouble / diffZ;
        double normalizedCurrX = normalizedDiffX * (diffX > 0.0 ? 1.0 - MathHelper.e(fromXAdj) : MathHelper.e(fromXAdj));
        double normalizedCurrY = normalizedDiffY * (diffY > 0.0 ? 1.0 - MathHelper.e(fromYAdj) : MathHelper.e(fromYAdj));
        double normalizedCurrZ = normalizedDiffZ * (diffZ > 0.0 ? 1.0 - MathHelper.e(fromZAdj) : MathHelper.e(fromZAdj));
        while (true) {
            IBlockData blockState;
            currPos.d(currX, currY, currZ);
            long key = BlockPosition.a(currX, currY, currZ);
            int cacheKey = currX & 7 | (currY & 7) << 3 | (currZ & 7) << 6;
            ExplosionBlockCache cachedBlock = blockCache[cacheKey];
            if (cachedBlock == null || cachedBlock.key != key) {
                blockCache[cacheKey] = cachedBlock = this.getOrCacheExplosionBlock(currX, currY, currZ, key, false);
            }
            if ((blockState = cachedBlock.blockState) != null && !blockState.emptyCollisionShape()) {
                VoxelShape collision = cachedBlock.cachedCollisionShape;
                if (collision == null) {
                    collision = blockState.getConstantCollisionShape();
                    if (collision == null) {
                        collision = blockState.b((IBlockAccess)this.f, (BlockPosition)currPos, context);
                        if (!context.isDelegated()) {
                            cachedBlock.cachedCollisionShape = collision;
                        }
                    } else {
                        cachedBlock.cachedCollisionShape = collision;
                    }
                }
                if (!collision.c() && collision.a(from, to, currPos) != null) {
                    return true;
                }
            }
            if (normalizedCurrX > 1.0 && normalizedCurrY > 1.0 && normalizedCurrZ > 1.0) {
                return false;
            }
            if (normalizedCurrX < normalizedCurrY) {
                if (normalizedCurrX < normalizedCurrZ) {
                    currX += dx;
                    normalizedCurrX += normalizedDiffX;
                    continue;
                }
                currZ += dz;
                normalizedCurrZ += normalizedDiffZ;
                continue;
            }
            if (normalizedCurrY < normalizedCurrZ) {
                currY += dy;
                normalizedCurrY += normalizedDiffY;
                continue;
            }
            currZ += dz;
            normalizedCurrZ += normalizedDiffZ;
        }
    }

    private float getSeenFraction(Vec3D source, net.minecraft.world.entity.Entity target, ExplosionBlockCache[] blockCache, BlockPosition.MutableBlockPosition blockPos) {
        AxisAlignedBB boundingBox = target.cH();
        double diffX = boundingBox.d - boundingBox.a;
        double diffY = boundingBox.e - boundingBox.b;
        double diffZ = boundingBox.f - boundingBox.c;
        double incX = 1.0 / (diffX * 2.0 + 1.0);
        double incY = 1.0 / (diffY * 2.0 + 1.0);
        double incZ = 1.0 / (diffZ * 2.0 + 1.0);
        if (incX < 0.0 || incY < 0.0 || incZ < 0.0) {
            return 0.0f;
        }
        double offX = (1.0 - Math.floor(1.0 / incX) * incX) * 0.5 + boundingBox.a;
        double offY = boundingBox.b;
        double offZ = (1.0 - Math.floor(1.0 / incZ) * incZ) * 0.5 + boundingBox.c;
        CollisionUtil.LazyEntityCollisionContext context = new CollisionUtil.LazyEntityCollisionContext(target);
        int totalRays = 0;
        int missedRays = 0;
        for (double dx = 0.0; dx <= 1.0; dx += incX) {
            double fromX = Math.fma(dx, diffX, offX);
            for (double dy = 0.0; dy <= 1.0; dy += incY) {
                double fromY = Math.fma(dy, diffY, offY);
                for (double dz = 0.0; dz <= 1.0; dz += incZ) {
                    ++totalRays;
                    Vec3D from = new Vec3D(fromX, fromY, Math.fma(dz, diffZ, offZ));
                    if (this.clipsAnything(from, source, context, blockCache, blockPos)) continue;
                    ++missedRays;
                }
            }
        }
        return (float)missedRays / (float)totalRays;
    }

    private ExplosionDamageCalculator a(@Nullable net.minecraft.world.entity.Entity entity) {
        return entity == null ? a : new ExplosionDamageCalculatorEntity(entity);
    }

    public static float a(Vec3D source, net.minecraft.world.entity.Entity entity) {
        AxisAlignedBB axisalignedbb = entity.cH();
        double d0 = 1.0 / ((axisalignedbb.d - axisalignedbb.a) * 2.0 + 1.0);
        double d1 = 1.0 / ((axisalignedbb.e - axisalignedbb.b) * 2.0 + 1.0);
        double d2 = 1.0 / ((axisalignedbb.f - axisalignedbb.c) * 2.0 + 1.0);
        double d3 = (1.0 - Math.floor(1.0 / d0) * d0) / 2.0;
        double d4 = (1.0 - Math.floor(1.0 / d2) * d2) / 2.0;
        if (d0 >= 0.0 && d1 >= 0.0 && d2 >= 0.0) {
            int i2 = 0;
            int j2 = 0;
            for (double d5 = 0.0; d5 <= 1.0; d5 += d0) {
                for (double d6 = 0.0; d6 <= 1.0; d6 += d1) {
                    for (double d7 = 0.0; d7 <= 1.0; d7 += d2) {
                        double d8 = MathHelper.d(d5, axisalignedbb.a, axisalignedbb.d);
                        double d9 = MathHelper.d(d6, axisalignedbb.b, axisalignedbb.e);
                        double d10 = MathHelper.d(d7, axisalignedbb.c, axisalignedbb.f);
                        Vec3D vec3d1 = new Vec3D(d8 + d3, d9, d10 + d4);
                        if (entity.dM().a(new RayTrace(vec3d1, source, RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, entity)).c() == MovingObjectPosition.EnumMovingObjectType.a) {
                            ++i2;
                        }
                        ++j2;
                    }
                }
            }
            return (float)i2 / (float)j2;
        }
        return 0.0f;
    }

    public float a() {
        return this.k;
    }

    public Vec3D b() {
        return new Vec3D(this.g, this.h, this.i);
    }

    public void c() {
        if ((this.f == null || this.f.purpurConfig.explosionClampRadius) && this.k < 0.1f) {
            return;
        }
        if (this.j != null) {
            location = new Location((org.bukkit.World)this.f.getWorld(), this.g, this.h, this.i);
            if (!new PreEntityExplodeEvent((Entity)this.j.getBukkitEntity(), location, this.d == Effect.c ? 1.0f / this.k : 1.0f).callEvent()) {
                this.wasCanceled = true;
                return;
            }
        } else {
            location = new Location((org.bukkit.World)this.f.getWorld(), this.g, this.h, this.i);
            if (!new PreBlockExplodeEvent(location.getBlock(), this.d == Effect.c ? 1.0f / this.k : 1.0f, this.l.explodedBlockState).callEvent()) {
                this.wasCanceled = true;
                return;
            }
        }
        this.f.a(this.j, GameEvent.w, new Vec3D(this.g, this.h, this.i));
        HashSet set = Sets.newHashSet();
        boolean flag = true;
        this.blockCache = new Long2ObjectOpenHashMap();
        this.chunkPosCache = new long[16];
        Arrays.fill(this.chunkPosCache, ChunkCoordIntPair.a);
        this.chunkCache = new Chunk[16];
        ExplosionBlockCache[] blockCache = new ExplosionBlockCache[512];
        int blockX = MathHelper.a(this.g);
        int blockY = MathHelper.a(this.h);
        int blockZ = MathHelper.a(this.i);
        long key = BlockPosition.a(blockX, blockY, blockZ);
        ExplosionBlockCache initialCache = this.getOrCacheExplosionBlock(blockX, blockY, blockZ, key, true);
        int ray = 0;
        int len = CACHED_RAYS.length;
        block0: while (ray < len) {
            ExplosionBlockCache cachedBlock = initialCache;
            double d0 = CACHED_RAYS[ray];
            double d1 = CACHED_RAYS[ray + 1];
            double d2 = CACHED_RAYS[ray + 2];
            ray += 3;
            double d4 = this.g;
            double d5 = this.h;
            double d6 = this.i;
            float f1 = 0.3f;
            for (float f2 = this.k * (0.7f + this.f.z.i() * 0.6f); f2 > 0.0f; f2 -= 0.22500001f) {
                int cacheKey;
                int blockZ2;
                int blockY2;
                int blockX2 = MathHelper.a(d4);
                long key2 = BlockPosition.a(blockX2, blockY2 = MathHelper.a(d5), blockZ2 = MathHelper.a(d6));
                if (cachedBlock.key != key2 && ((cachedBlock = blockCache[cacheKey = blockX2 & 7 | (blockY2 & 7) << 3 | (blockZ2 & 7) << 6]) == null || cachedBlock.key != key2)) {
                    blockCache[cacheKey] = cachedBlock = this.getOrCacheExplosionBlock(blockX2, blockY2, blockZ2, key2, true);
                }
                if (cachedBlock.outOfWorld) continue block0;
                BlockPosition blockposition = cachedBlock.immutablePos;
                IBlockData iblockdata = cachedBlock.blockState;
                if (!iblockdata.isDestroyable()) continue;
                if ((f2 -= cachedBlock.resistance) > 0.0f && cachedBlock.shouldExplode == null) {
                    boolean shouldExplode = this.m.a(this, (IBlockAccess)this.f, cachedBlock.immutablePos, cachedBlock.blockState, f2);
                    Boolean bl = cachedBlock.shouldExplode = shouldExplode ? Boolean.TRUE : Boolean.FALSE;
                    if (shouldExplode && (this.c || !cachedBlock.blockState.i())) {
                        TileEntityPiston blockEntity;
                        TileEntity extension;
                        set.add(blockposition);
                        if (!GlobalConfiguration.get().unsupportedSettings.allowHeadlessPistons && iblockdata.b() == Blocks.bQ && (extension = this.f.c_(blockposition)) instanceof TileEntityPiston && (blockEntity = (TileEntityPiston)extension).f()) {
                            EnumDirection direction = iblockdata.c(BlockDirectional.a);
                            set.add(blockposition.a(direction.g()));
                        }
                    }
                }
                d4 += d0;
                d5 += d1;
                d6 += d2;
            }
        }
        this.q.addAll((Collection)set);
        float f2 = this.k * 2.0f;
        int i2 = MathHelper.a(this.g - (double)f2 - 1.0);
        int j2 = MathHelper.a(this.g + (double)f2 + 1.0);
        int l2 = MathHelper.a(this.h - (double)f2 - 1.0);
        int i1 = MathHelper.a(this.h + (double)f2 + 1.0);
        int j1 = MathHelper.a(this.i - (double)f2 - 1.0);
        int k1 = MathHelper.a(this.i + (double)f2 + 1.0);
        List<net.minecraft.world.entity.Entity> list = this.f.a(this.j, new AxisAlignedBB(i2, l2, j1, j2, i1, k1), (Predicate<? super net.minecraft.world.entity.Entity>)((com.google.common.base.Predicate)entity -> entity.bx() && !entity.P_()));
        Vec3D vec3d = new Vec3D(this.g, this.h, this.i);
        Iterator<net.minecraft.world.entity.Entity> iterator = list.iterator();
        BlockPosition.MutableBlockPosition blockPos = new BlockPosition.MutableBlockPosition();
        while (iterator.hasNext()) {
            EntityHuman entityhuman;
            double d13;
            double d10;
            double d9;
            double d8;
            double d11;
            double d7;
            net.minecraft.world.entity.Entity entity2 = iterator.next();
            if (entity2.a(this) || !((d7 = Math.sqrt(entity2.f(vec3d)) / (double)f2) <= 1.0) || (d11 = Math.sqrt((d8 = entity2.dr() - this.g) * d8 + (d9 = (entity2 instanceof EntityTNTPrimed ? entity2.dt() : entity2.dv()) - this.h) * d9 + (d10 = entity2.dx() - this.i) * d10)) == 0.0) continue;
            d8 /= d11;
            d9 /= d11;
            d10 /= d11;
            if (this.m.a(this, entity2)) {
                if (entity2 instanceof EntityComplexPart) continue;
                entity2.lastDamageCancelled = false;
                if (entity2 instanceof EntityEnderDragon) {
                    for (EntityComplexPart entityComplexPart : ((EntityEnderDragon)entity2).cf) {
                        if (!list.contains(entityComplexPart)) continue;
                        entityComplexPart.a(this.l, this.m.getEntityDamageAmount(this, entityComplexPart, this.getSeenFraction(vec3d, entityComplexPart, blockCache, blockPos)));
                    }
                } else {
                    entity2.a(this.l, this.m.getEntityDamageAmount(this, entity2, this.getSeenFraction(vec3d, entity2, blockCache, blockPos)));
                }
                if (entity2.lastDamageCancelled) continue;
            }
            double d12 = (1.0 - d7) * (double)this.getBlockDensity(vec3d, entity2, blockCache, blockPos);
            if (entity2 instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity2;
                d13 = entity2 instanceof EntityHuman && this.f.paperConfig().environment.disableExplosionKnockback ? 0.0 : EnchantmentProtection.a(entityliving, d12);
            } else {
                d13 = d12;
            }
            Vec3D vec3d1 = new Vec3D(d8 *= d13, d9 *= d13, d10 *= d13);
            if (entity2 instanceof EntityLiving) {
                Vec3D result = entity2.dp().e(vec3d1);
                EntityKnockbackEvent event = CraftEventFactory.callEntityKnockbackEvent((CraftLivingEntity)entity2.getBukkitEntity(), this.j, EntityKnockbackEvent.KnockbackCause.EXPLOSION, d13, vec3d1, result.c, result.d, result.e);
                Vec3D vec3D = vec3d1 = event.isCancelled() ? Vec3D.b : new Vec3D(event.getFinalKnockback().getX(), event.getFinalKnockback().getY(), event.getFinalKnockback().getZ()).d(entity2.dp());
                if (this.l.d() != null || this.j != null) {
                    CraftEntity hitBy = this.l.d() != null ? this.l.d().getBukkitEntity() : this.j.getBukkitEntity();
                    EntityKnockbackByEntityEvent paperEvent = new EntityKnockbackByEntityEvent((LivingEntity)((EntityLiving)entity2).getBukkitLivingEntity(), (Entity)hitBy, (float)event.getForce(), CraftVector.toBukkit(vec3d1));
                    if (!paperEvent.callEvent()) continue;
                    vec3d1 = CraftVector.toNMS(paperEvent.getAcceleration());
                }
            }
            entity2.g(entity2.dp().e(vec3d1));
            if (!(entity2 instanceof EntityHuman) || (entityhuman = (EntityHuman)entity2).P_() || entityhuman.f() && entityhuman.fT().b || this.f.paperConfig().environment.disableExplosionKnockback) continue;
            this.r.put(entityhuman, vec3d1);
        }
        this.blockCache = null;
        this.chunkPosCache = null;
        this.chunkCache = null;
    }

    public void a(boolean particles) {
        if (this.f.B) {
            this.f.a(this.g, this.h, this.i, this.p, SoundCategory.e, 4.0f, (1.0f + (this.f.z.i() - this.f.z.i()) * 0.2f) * 0.7f, false);
        }
        boolean flag1 = this.d();
        if (particles) {
            ParticleParam particleparam = this.k >= 2.0f && flag1 ? this.o : this.n;
            this.f.a(particleparam, this.g, this.h, this.i, 1.0, 0.0, 0.0);
        }
        if (flag1) {
            List bukkitBlocks;
            ArrayList list = new ArrayList();
            SystemUtils.c(this.q, this.f.z);
            ObjectListIterator objectlistiterator = this.q.iterator();
            CraftWorld bworld = this.f.getWorld();
            CraftEntity explode = this.j == null ? null : this.j.getBukkitEntity();
            Location location = new Location((org.bukkit.World)bworld, this.g, this.h, this.i);
            ObjectArrayList blockList = new ObjectArrayList();
            for (int i1 = this.q.size() - 1; i1 >= 0; --i1) {
                BlockPosition cpos = (BlockPosition)this.q.get(i1);
                org.bukkit.block.Block bblock = bworld.getBlockAt(cpos.u(), cpos.v(), cpos.w());
                if (bblock.getType().isAir()) continue;
                blockList.add(bblock);
            }
            if (explode != null) {
                event = new EntityExplodeEvent((Entity)explode, location, (List)blockList, this.yield);
                this.f.getCraftServer().getPluginManager().callEvent((Event)event);
                this.wasCanceled = event.isCancelled();
                bukkitBlocks = event.blockList();
                this.yield = event.getYield();
            } else {
                event = new BlockExplodeEvent(location.getBlock(), (List)blockList, this.yield, this.l.explodedBlockState);
                this.f.getCraftServer().getPluginManager().callEvent((Event)event);
                this.wasCanceled = event.isCancelled();
                bukkitBlocks = event.blockList();
                this.yield = event.getYield();
            }
            this.q.clear();
            for (org.bukkit.block.Block bblock : bukkitBlocks) {
                BlockPosition coords = new BlockPosition(bblock.getX(), bblock.getY(), bblock.getZ());
                this.q.add((Object)coords);
            }
            if (this.wasCanceled) {
                return;
            }
            for (BlockPosition blockposition : this.q) {
                IBlockData iblockdata = this.f.a_(blockposition);
                Block block = iblockdata.b();
                if (block instanceof BlockTNT) {
                    BlockPosition sourceBlock;
                    net.minecraft.world.entity.Entity sourceEntity = this.j == null ? null : this.j;
                    BlockPosition blockPosition = sourceBlock = sourceEntity == null ? BlockPosition.a(this.g, this.h, this.i) : null;
                    if (!CraftEventFactory.callTNTPrimeEvent(this.f, blockposition, TNTPrimeEvent.PrimeCause.EXPLOSION, sourceEntity, sourceBlock)) {
                        this.f.a(blockposition, Blocks.a.o(), iblockdata, 3);
                        continue;
                    }
                }
                this.f.a_(blockposition).a(this.f, blockposition, this, (itemstack, blockposition1) -> Explosion.a(list, itemstack, blockposition1));
            }
            for (Pair pair : list) {
                Block.a(this.f, (BlockPosition)pair.getSecond(), (ItemStack)pair.getFirst());
            }
        }
        if (this.c) {
            for (BlockPosition blockposition12 : this.q) {
                if (this.e.a(3) != 0 || !this.f.a_(blockposition12).i() || !this.f.a_(blockposition12.d()).i(this.f, blockposition12.d()) || CraftEventFactory.callBlockIgniteEvent(this.f, blockposition12, this).isCancelled()) continue;
                this.f.b(blockposition12, BlockFireAbstract.a(this.f, blockposition12));
            }
        }
    }

    private static void a(List<Pair<ItemStack, BlockPosition>> stacks, ItemStack stack, BlockPosition pos) {
        if (stack.b()) {
            return;
        }
        for (int i2 = 0; i2 < stacks.size(); ++i2) {
            Pair<ItemStack, BlockPosition> pair = stacks.get(i2);
            ItemStack itemstack1 = (ItemStack)pair.getFirst();
            if (!EntityItem.a(itemstack1, stack)) continue;
            stacks.set(i2, (Pair<ItemStack, BlockPosition>)Pair.of((Object)EntityItem.a(itemstack1, stack, 16), (Object)((BlockPosition)pair.getSecond())));
            if (!stack.b()) continue;
            return;
        }
        stacks.add((Pair<ItemStack, BlockPosition>)Pair.of((Object)stack, (Object)pos));
    }

    public boolean d() {
        return this.d != Effect.a;
    }

    public Map<EntityHuman, Vec3D> e() {
        return this.r;
    }

    @Nullable
    private static EntityLiving b(@Nullable net.minecraft.world.entity.Entity from) {
        IProjectile iprojectile;
        net.minecraft.world.entity.Entity entity1;
        if (from == null) {
            return null;
        }
        if (from instanceof EntityTNTPrimed) {
            EntityTNTPrimed entitytntprimed = (EntityTNTPrimed)from;
            return entitytntprimed.q();
        }
        if (from instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)from;
            return entityliving;
        }
        if (from instanceof IProjectile && (entity1 = (iprojectile = (IProjectile)from).w()) instanceof EntityLiving) {
            EntityLiving entityliving1 = (EntityLiving)entity1;
            return entityliving1;
        }
        return null;
    }

    @Nullable
    public EntityLiving f() {
        return Explosion.b(this.j);
    }

    @Nullable
    public net.minecraft.world.entity.Entity g() {
        return this.j;
    }

    public void h() {
        this.q.clear();
    }

    public List<BlockPosition> i() {
        return this.q;
    }

    public Effect j() {
        return this.d;
    }

    public ParticleParam k() {
        return this.n;
    }

    public ParticleParam l() {
        return this.o;
    }

    public SoundEffect m() {
        return this.p;
    }

    private float getBlockDensity(Vec3D vec3d, net.minecraft.world.entity.Entity entity, ExplosionBlockCache[] blockCache, BlockPosition.MutableBlockPosition blockPos) {
        if (!this.f.paperConfig().environment.optimizeExplosions) {
            return this.getSeenFraction(vec3d, entity, blockCache, blockPos);
        }
        CacheKey key = new CacheKey(this, entity.cH());
        Float blockDensity = this.f.explosionDensityCache.get(key);
        if (blockDensity == null) {
            blockDensity = Float.valueOf(this.getSeenFraction(vec3d, entity, blockCache, blockPos));
            this.f.explosionDensityCache.put(key, blockDensity);
        }
        return blockDensity.floatValue();
    }

    static {
        DoubleArrayList rayCoords = new DoubleArrayList();
        for (int x2 = 0; x2 <= 15; ++x2) {
            for (int y2 = 0; y2 <= 15; ++y2) {
                for (int z2 = 0; z2 <= 15; ++z2) {
                    if (x2 != 0 && x2 != 15 && y2 != 0 && y2 != 15 && z2 != 0 && z2 != 15) continue;
                    double xDir = (float)x2 / 15.0f * 2.0f - 1.0f;
                    double yDir = (float)y2 / 15.0f * 2.0f - 1.0f;
                    double zDir = (float)z2 / 15.0f * 2.0f - 1.0f;
                    double mag = Math.sqrt(xDir * xDir + yDir * yDir + zDir * zDir);
                    rayCoords.add(xDir / mag * (double)0.3f);
                    rayCoords.add(yDir / mag * (double)0.3f);
                    rayCoords.add(zDir / mag * (double)0.3f);
                }
            }
        }
        CACHED_RAYS = rayCoords.toDoubleArray();
        ZERO_RESISTANCE = Float.valueOf(-0.3f);
    }

    public static enum Effect {
        a,
        b,
        c,
        d;

    }

    public static final class ExplosionBlockCache {
        public final long key;
        public final BlockPosition immutablePos;
        public final IBlockData blockState;
        public final Fluid fluidState;
        public final float resistance;
        public final boolean outOfWorld;
        public Boolean shouldExplode;
        public VoxelShape cachedCollisionShape;

        public ExplosionBlockCache(long key, BlockPosition immutablePos, IBlockData blockState, Fluid fluidState, float resistance, boolean outOfWorld) {
            this.key = key;
            this.immutablePos = immutablePos;
            this.blockState = blockState;
            this.fluidState = fluidState;
            this.resistance = resistance;
            this.outOfWorld = outOfWorld;
        }
    }

    static class CacheKey {
        private final World world;
        private final double posX;
        private final double posY;
        private final double posZ;
        private final double minX;
        private final double minY;
        private final double minZ;
        private final double maxX;
        private final double maxY;
        private final double maxZ;

        public CacheKey(Explosion explosion, AxisAlignedBB aabb) {
            this.world = explosion.f;
            this.posX = explosion.g;
            this.posY = explosion.h;
            this.posZ = explosion.i;
            this.minX = aabb.a;
            this.minY = aabb.b;
            this.minZ = aabb.c;
            this.maxX = aabb.d;
            this.maxY = aabb.e;
            this.maxZ = aabb.f;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o2;
            if (Double.compare(cacheKey.posX, this.posX) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.posY, this.posY) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.posZ, this.posZ) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.minX, this.minX) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.minY, this.minY) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.minZ, this.minZ) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.maxX, this.maxX) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.maxY, this.maxY) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.maxZ, this.maxZ) != 0) {
                return false;
            }
            return this.world.equals(cacheKey.world);
        }

        public int hashCode() {
            int result = this.world.hashCode();
            long temp = Double.doubleToLongBits(this.posX);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.posY);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.posZ);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.minX);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.minY);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.minZ);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.maxX);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.maxY);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.maxZ);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }
    }
}

