/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import alternate.current.wire.WireHandler;
import co.aikar.timings.TimingHistory;
import co.aikar.timings.WorldTimingsHandler;
import com.destroystokyo.paper.antixray.ChunkPacketBlockController;
import com.destroystokyo.paper.antixray.ChunkPacketBlockControllerAntiXray;
import com.destroystokyo.paper.event.block.BlockDestroyEvent;
import com.destroystokyo.paper.event.server.ServerExceptionEvent;
import com.destroystokyo.paper.exception.ServerException;
import com.destroystokyo.paper.exception.ServerInternalException;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import io.papermc.paper.configuration.WorldConfiguration;
import io.papermc.paper.util.CollisionUtil;
import io.papermc.paper.util.TickThread;
import io.papermc.paper.util.WorldUtil;
import io.papermc.paper.world.ChunkEntitySlices;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderLerpSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDelayPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerDisabled;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.BlockRedstoneTorch;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.IWorldBorderListener;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.redstone.CollectingNeighborUpdater;
import net.minecraft.world.level.redstone.NeighborUpdater;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.WorldDataMutable;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import net.minecraft.world.scores.Scoreboard;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_20_R3.CraftServer;
import org.bukkit.craftbukkit.v1_20_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R3.block.CapturedBlockState;
import org.bukkit.craftbukkit.v1_20_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R3.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_20_R3.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftSpawnCategory;
import org.bukkit.entity.Entity;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.purpurmc.purpur.PurpurWorldConfig;
import org.spigotmc.SpigotWorldConfig;
import org.spigotmc.TickLimiter;

public abstract class World
implements GeneratorAccess,
AutoCloseable {
    public static final Codec<ResourceKey<World>> g = ResourceKey.a(Registries.aM);
    public static final ResourceKey<World> h = ResourceKey.a(Registries.aM, new MinecraftKey("overworld"));
    public static final ResourceKey<World> i = ResourceKey.a(Registries.aM, new MinecraftKey("the_nether"));
    public static final ResourceKey<World> j = ResourceKey.a(Registries.aM, new MinecraftKey("the_end"));
    public static final int k = 30000000;
    public static final int l = 512;
    public static final int m = 32;
    public static final int n = 15;
    public static final int o = 24000;
    public static final int p = 20000000;
    public static final int q = -20000000;
    public final List<TickingBlockEntity> r = Lists.newArrayList();
    protected final NeighborUpdater s;
    private final List<TickingBlockEntity> a = Lists.newArrayList();
    private boolean b;
    public final Thread c;
    private final boolean d;
    private int e;
    protected int t = RandomSource.a().f();
    protected final int u = 1013904223;
    protected float v;
    public float w;
    protected float x;
    public float y;
    public final RandomSource z = RandomSource.a();
    @Deprecated
    private final RandomSource f = RandomSource.b();
    private final ResourceKey<DimensionManager> D;
    private final Holder<DimensionManager> E;
    public final WorldDataMutable A;
    private final Supplier<GameProfilerFiller> F;
    public final boolean B;
    private final WorldBorder G;
    private final BiomeManager H;
    private final ResourceKey<World> I;
    private final IRegistryCustom J;
    private final DamageSources K;
    private long L;
    private final CraftWorld world;
    public boolean pvpMode;
    public boolean keepSpawnInMemory = true;
    public ChunkGenerator generator;
    public boolean preventPoiUpdated = false;
    public boolean captureBlockStates = false;
    public boolean captureTreeGeneration = false;
    public Map<BlockPosition, CraftBlockState> capturedBlockStates = new LinkedHashMap<BlockPosition, CraftBlockState>();
    public Map<BlockPosition, TileEntity> capturedTileEntities = new LinkedHashMap<BlockPosition, TileEntity>();
    public List<EntityItem> captureDrops;
    public final Object2LongOpenHashMap<SpawnCategory> ticksPerSpawnCategory = new Object2LongOpenHashMap();
    public int wakeupInactiveRemainingAnimals;
    public int wakeupInactiveRemainingFlying;
    public int wakeupInactiveRemainingMonsters;
    public int wakeupInactiveRemainingVillagers;
    public boolean populating;
    public final SpigotWorldConfig spigotConfig;
    private final WorldConfiguration paperConfig;
    public final ChunkPacketBlockController chunkPacketBlockController;
    public final PurpurWorldConfig purpurConfig;
    public final WorldTimingsHandler timings;
    public static BlockPosition lastPhysicsProblem;
    private TickLimiter entityLimiter;
    private TickLimiter tileLimiter;
    private int tileTickPosition;
    public final Map<Explosion.CacheKey, Float> explosionDensityCache = new HashMap<Explosion.CacheKey, Float>();
    public ArrayDeque<BlockRedstoneTorch.RedstoneUpdateInfo> redstoneUpdateInfos;
    private Cache<BreedingCooldownPair, Object> playerBreedingCooldowns;
    public final int minSection;
    public final int maxSection;
    private static final Fluid AIR_FLUIDSTATE;

    public WorldConfiguration paperConfig() {
        return this.paperConfig;
    }

    public static ResourceKey<DimensionManager> getDimensionKey(DimensionManager manager) {
        return ((CraftServer)Bukkit.getServer()).getHandle().b().aZ().d(Registries.ay).c(manager).orElseThrow(() -> new IllegalStateException("Unregistered dimension type: " + manager));
    }

    private Cache<BreedingCooldownPair, Object> getNewBreedingCooldownCache() {
        return CacheBuilder.newBuilder().expireAfterWrite((long)this.purpurConfig.animalBreedingCooldownSeconds, TimeUnit.SECONDS).build();
    }

    public void resetBreedingCooldowns() {
        this.playerBreedingCooldowns = this.getNewBreedingCooldownCache();
    }

    public boolean hasBreedingCooldown(UUID player, Class<? extends EntityAnimal> animalType) {
        return this.playerBreedingCooldowns.getIfPresent((Object)new BreedingCooldownPair(player, animalType)) != null;
    }

    public void addBreedingCooldown(UUID player, Class<? extends EntityAnimal> animalType) {
        this.playerBreedingCooldowns.put((Object)new BreedingCooldownPair(player, animalType), new Object());
    }

    public CraftWorld getWorld() {
        return this.world;
    }

    public CraftServer getCraftServer() {
        return (CraftServer)Bukkit.getServer();
    }

    @Override
    public boolean b(int chunkX, int chunkZ) {
        return this.getChunkIfLoaded(chunkX, chunkZ) != null;
    }

    private int getTicksPerSpawn(SpawnCategory spawnCategory) {
        int perWorld = this.paperConfig().entities.spawning.ticksPerSpawn.getInt((Object)CraftSpawnCategory.toNMS(spawnCategory));
        if (perWorld >= 0) {
            return perWorld;
        }
        return this.getCraftServer().getTicksPerSpawns(spawnCategory);
    }

    public abstract ResourceKey<WorldDimension> getTypeKey();

    protected World(WorldDataMutable worlddatamutable, ResourceKey<World> resourcekey, IRegistryCustom iregistrycustom, Holder<DimensionManager> holder, Supplier<GameProfilerFiller> supplier, boolean flag, boolean flag1, long i2, int j2, ChunkGenerator gen, BiomeProvider biomeProvider, World.Environment env, Function<SpigotWorldConfig, WorldConfiguration> paperWorldConfigCreator, Executor executor) {
        this.spigotConfig = new SpigotWorldConfig(((WorldDataServer)worlddatamutable).g());
        this.paperConfig = paperWorldConfigCreator.apply(this.spigotConfig);
        this.purpurConfig = new PurpurWorldConfig(((WorldDataServer)worlddatamutable).g(), env);
        this.playerBreedingCooldowns = this.getNewBreedingCooldownCache();
        this.generator = gen;
        this.world = new CraftWorld((WorldServer)this, gen, biomeProvider, env);
        for (SpawnCategory spawnCategory : SpawnCategory.values()) {
            if (!CraftSpawnCategory.isValidForLimits(spawnCategory)) continue;
            this.ticksPerSpawnCategory.put((Object)spawnCategory, (long)this.getTicksPerSpawn(spawnCategory));
        }
        this.F = supplier;
        this.A = worlddatamutable;
        this.E = holder;
        this.D = holder.e().orElseThrow(() -> new IllegalArgumentException("Dimension must be registered, got " + holder));
        DimensionManager dimensionmanager = holder.a();
        this.I = resourcekey;
        this.B = flag;
        this.G = dimensionmanager.k() != 1.0 ? new WorldBorder(){

            @Override
            public double a() {
                return super.a();
            }

            @Override
            public double b() {
                return super.b();
            }
        } : new WorldBorder();
        this.c = Thread.currentThread();
        this.H = new BiomeManager(this, i2);
        this.d = flag1;
        this.s = new CollectingNeighborUpdater(this, j2);
        this.J = iregistrycustom;
        this.K = new DamageSources(iregistrycustom);
        this.D_().world = (WorldServer)this;
        this.D_().a(new IWorldBorderListener(){

            @Override
            public void a(WorldBorder border, double size) {
                World.this.getCraftServer().getHandle().broadcastAll((Packet)new ClientboundSetBorderSizePacket(border), border.world);
            }

            @Override
            public void a(WorldBorder border, double fromSize, double toSize, long time) {
                World.this.getCraftServer().getHandle().broadcastAll((Packet)new ClientboundSetBorderLerpSizePacket(border), border.world);
            }

            @Override
            public void a(WorldBorder border, double centerX, double centerZ) {
                World.this.getCraftServer().getHandle().broadcastAll((Packet)new ClientboundSetBorderCenterPacket(border), border.world);
            }

            @Override
            public void a(WorldBorder border, int warningTime) {
                World.this.getCraftServer().getHandle().broadcastAll((Packet)new ClientboundSetBorderWarningDelayPacket(border), border.world);
            }

            @Override
            public void b(WorldBorder border, int warningBlockDistance) {
                World.this.getCraftServer().getHandle().broadcastAll((Packet)new ClientboundSetBorderWarningDistancePacket(border), border.world);
            }

            @Override
            public void b(WorldBorder border, double damagePerBlock) {
            }

            @Override
            public void c(WorldBorder border, double safeZoneRadius) {
            }
        });
        this.timings = new WorldTimingsHandler(this);
        this.keepSpawnInMemory = this.paperConfig().spawn.keepSpawnLoaded;
        this.entityLimiter = new TickLimiter(this.spigotConfig.entityMaxTickTime);
        this.tileLimiter = new TickLimiter(this.spigotConfig.tileMaxTickTime);
        this.chunkPacketBlockController = this.paperConfig().anticheat.antiXray.enabled ? new ChunkPacketBlockControllerAntiXray(this, executor) : ChunkPacketBlockController.NO_OPERATION_INSTANCE;
        this.minSection = WorldUtil.getMinSection(this);
        this.maxSection = WorldUtil.getMaxSection(this);
    }

    public final boolean checkEntityCollision(IBlockData data, net.minecraft.world.entity.Entity source, VoxelShapeCollision voxelshapedcollision, BlockPosition position, boolean checkCanSee) {
        VoxelShape voxelshape = data.b((IBlockAccess)this, position, voxelshapedcollision);
        if (voxelshape.c()) {
            return true;
        }
        if ((voxelshape = voxelshape.a(position.u(), (double)position.v(), (double)position.w())).c()) {
            return true;
        }
        List<net.minecraft.world.entity.Entity> entities = this.a_(null, voxelshape.a());
        int len = entities.size();
        for (int i2 = 0; i2 < len; ++i2) {
            net.minecraft.world.entity.Entity entity = entities.get(i2);
            if (checkCanSee && source instanceof EntityPlayer && entity instanceof EntityPlayer && !((EntityPlayer)source).getBukkitEntity().canSee(((EntityPlayer)entity).getBukkitEntity()) || entity.dH() || !entity.I || !VoxelShapes.c(voxelshape, VoxelShapes.a(entity.cH()), OperatorBoolean.i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean f(net.minecraft.world.entity.Entity entity) {
        AxisAlignedBB boundingBox = entity.cH();
        if (CollisionUtil.isEmpty(boundingBox)) {
            return false;
        }
        List<net.minecraft.world.entity.Entity> entities = this.a(entity, boundingBox.c(-1.0E-7, -1.0E-7, -1.0E-7), null);
        int len = entities.size();
        for (int i2 = 0; i2 < len; ++i2) {
            net.minecraft.world.entity.Entity otherEntity = entities.get(i2);
            if (otherEntity.P_() || otherEntity.dH() || !otherEntity.I || otherEntity.y(entity)) continue;
            return false;
        }
        return true;
    }

    private static MovingObjectPositionBlock miss(RayTrace clipContext) {
        Vec3D to = clipContext.a();
        Vec3D from = clipContext.b();
        return MovingObjectPositionBlock.a(to, EnumDirection.a(from.c - to.c, from.d - to.d, from.e - to.e), BlockPosition.a(to.c, to.d, to.e));
    }

    private static MovingObjectPositionBlock fastClip(Vec3D from, Vec3D to, World level, RayTrace clipContext) {
        double adjX = 1.0E-7 * (from.c - to.c);
        double adjY = 1.0E-7 * (from.d - to.d);
        double adjZ = 1.0E-7 * (from.e - to.e);
        if (adjX == 0.0 && adjY == 0.0 && adjZ == 0.0) {
            return World.miss(clipContext);
        }
        double toXAdj = to.c - adjX;
        double toYAdj = to.d - adjY;
        double toZAdj = to.e - adjZ;
        double fromXAdj = from.c + adjX;
        double fromYAdj = from.d + adjY;
        double fromZAdj = from.e + adjZ;
        int currX = MathHelper.a(fromXAdj);
        int currY = MathHelper.a(fromYAdj);
        int currZ = MathHelper.a(fromZAdj);
        BlockPosition.MutableBlockPosition currPos = new BlockPosition.MutableBlockPosition();
        double diffX = toXAdj - fromXAdj;
        double diffY = toYAdj - fromYAdj;
        double diffZ = toZAdj - fromZAdj;
        double dxDouble = Math.signum(diffX);
        double dyDouble = Math.signum(diffY);
        double dzDouble = Math.signum(diffZ);
        int dx = (int)dxDouble;
        int dy = (int)dyDouble;
        int dz = (int)dzDouble;
        double normalizedDiffX = diffX == 0.0 ? Double.MAX_VALUE : dxDouble / diffX;
        double normalizedDiffY = diffY == 0.0 ? Double.MAX_VALUE : dyDouble / diffY;
        double normalizedDiffZ = diffZ == 0.0 ? Double.MAX_VALUE : dzDouble / diffZ;
        double normalizedCurrX = normalizedDiffX * (diffX > 0.0 ? 1.0 - MathHelper.e(fromXAdj) : MathHelper.e(fromXAdj));
        double normalizedCurrY = normalizedDiffY * (diffY > 0.0 ? 1.0 - MathHelper.e(fromYAdj) : MathHelper.e(fromYAdj));
        double normalizedCurrZ = normalizedDiffZ * (diffZ > 0.0 ? 1.0 - MathHelper.e(fromZAdj) : MathHelper.e(fromZAdj));
        ChunkSection[] lastChunk = null;
        DataPaletteBlock<IBlockData> lastSection = null;
        int lastChunkX = Integer.MIN_VALUE;
        int lastChunkY = Integer.MIN_VALUE;
        int lastChunkZ = Integer.MIN_VALUE;
        int minSection = level.minSection;
        ChunkProviderServer chunkProvider = (ChunkProviderServer)level.L();
        while (true) {
            IBlockData blockState;
            currPos.d(currX, currY, currZ);
            int newChunkX = currX >> 4;
            int newChunkY = currY >> 4;
            int newChunkZ = currZ >> 4;
            int chunkDiff = newChunkX ^ lastChunkX | newChunkZ ^ lastChunkZ;
            int chunkYDiff = newChunkY ^ lastChunkY;
            if ((chunkDiff | chunkYDiff) != 0) {
                if (chunkDiff != 0) {
                    Chunk chunk = chunkProvider.getChunkAtIfLoadedImmediately(newChunkX, newChunkZ);
                    lastChunk = chunk == null ? null : chunk.d();
                }
                int sectionY = newChunkY - minSection;
                lastSection = lastChunk != null && sectionY >= 0 && sectionY < lastChunk.length ? lastChunk[sectionY].h : null;
                lastChunkX = newChunkX;
                lastChunkY = newChunkY;
                lastChunkZ = newChunkZ;
            }
            if (lastSection != null && !(blockState = lastSection.a(currX & 0xF | (currZ & 0xF) << 4 | (currY & 0xF) << 8)).i()) {
                VoxelShape fluidCollision;
                MovingObjectPositionBlock fluidHit;
                Fluid fluidState;
                MovingObjectPositionBlock blockHit;
                VoxelShape blockCollision = clipContext.a(blockState, (IBlockAccess)level, (BlockPosition)currPos);
                MovingObjectPositionBlock movingObjectPositionBlock = blockHit = blockCollision.c() ? null : level.a(from, to, currPos, blockCollision, blockState);
                if (clipContext.d != RayTrace.FluidCollisionOption.a && (fluidState = blockState.u()) != AIR_FLUIDSTATE && (fluidHit = (fluidCollision = clipContext.a(fluidState, (IBlockAccess)level, (BlockPosition)currPos)).a(from, to, currPos)) != null) {
                    if (blockHit == null) {
                        return fluidHit;
                    }
                    return from.g(blockHit.e()) <= from.g(fluidHit.e()) ? blockHit : fluidHit;
                }
                if (blockHit != null) {
                    return blockHit;
                }
            }
            if (normalizedCurrX > 1.0 && normalizedCurrY > 1.0 && normalizedCurrZ > 1.0) {
                return World.miss(clipContext);
            }
            if (normalizedCurrX < normalizedCurrY) {
                if (normalizedCurrX < normalizedCurrZ) {
                    currX += dx;
                    normalizedCurrX += normalizedDiffX;
                    continue;
                }
                currZ += dz;
                normalizedCurrZ += normalizedDiffZ;
                continue;
            }
            if (normalizedCurrY < normalizedCurrZ) {
                currY += dy;
                normalizedCurrY += normalizedDiffY;
                continue;
            }
            currZ += dz;
            normalizedCurrZ += normalizedDiffZ;
        }
    }

    @Override
    public final MovingObjectPositionBlock a(RayTrace clipContext) {
        return World.fastClip(clipContext.b(), clipContext.a(), this, clipContext);
    }

    @Override
    public final boolean noCollision(net.minecraft.world.entity.Entity entity, AxisAlignedBB box, boolean loadChunks) {
        int flags = 8;
        if (entity != null) {
            flags |= 4;
        }
        if (loadChunks) {
            flags |= 1;
        }
        if (CollisionUtil.getCollisionsForBlocksOrWorldBorder(this, entity, box, null, null, flags, null)) {
            return false;
        }
        return !CollisionUtil.getEntityHardCollisions(this, entity, box, null, flags, null);
    }

    @Override
    public final boolean f(net.minecraft.world.entity.Entity entity, AxisAlignedBB box) {
        return CollisionUtil.getCollisionsForBlocksOrWorldBorder(this, entity, box, null, null, 8, (state, pos) -> state.o(this, (BlockPosition)pos));
    }

    private static VoxelShape inflateAABBToVoxel(AxisAlignedBB aabb, double x2, double y2, double z2) {
        return VoxelShapes.b(aabb.a - x2, aabb.b - y2, aabb.c - z2, aabb.d + x2, aabb.e + y2, aabb.f + z2);
    }

    @Override
    public final Optional<Vec3D> a(net.minecraft.world.entity.Entity entity, VoxelShape boundsShape, Vec3D fromPosition, double rangeX, double rangeY, double rangeZ) {
        if (boundsShape.c()) {
            return Optional.empty();
        }
        double expandByX = rangeX * 0.5;
        double expandByY = rangeY * 0.5;
        double expandByZ = rangeZ * 0.5;
        AxisAlignedBB collectionVolume = boundsShape.a().c(expandByX, expandByY, expandByZ);
        ArrayList<AxisAlignedBB> aabbs = new ArrayList<AxisAlignedBB>();
        ArrayList<VoxelShape> voxels = new ArrayList<VoxelShape>();
        CollisionUtil.getCollisionsForBlocksOrWorldBorder(this, entity, collectionVolume, voxels, aabbs, 4, null);
        int len = voxels.size();
        for (int i2 = 0; i2 < len; ++i2) {
            aabbs.addAll(((VoxelShape)voxels.get(i2)).e());
        }
        VoxelShape first = aabbs.isEmpty() ? VoxelShapes.a() : World.inflateAABBToVoxel((AxisAlignedBB)aabbs.get(0), expandByX, expandByY, expandByZ);
        VoxelShape[] rest = new VoxelShape[Math.max(0, aabbs.size() - 1)];
        int len2 = aabbs.size();
        for (int i3 = 1; i3 < len2; ++i3) {
            rest[i3 - 1] = World.inflateAABBToVoxel((AxisAlignedBB)aabbs.get(i3), expandByX, expandByY, expandByZ);
        }
        VoxelShape joined = VoxelShapes.a(first, rest);
        VoxelShape freeSpace = VoxelShapes.b(boundsShape, joined, OperatorBoolean.e);
        return freeSpace.a(fromPosition);
    }

    @Override
    public final Optional<BlockPosition> g(net.minecraft.world.entity.Entity entity, AxisAlignedBB aabb) {
        int minBlockX = MathHelper.a(aabb.a - 1.0E-7) - 1;
        int maxBlockX = MathHelper.a(aabb.d + 1.0E-7) + 1;
        int minBlockY = MathHelper.a(aabb.b - 1.0E-7) - 1;
        int maxBlockY = MathHelper.a(aabb.e + 1.0E-7) + 1;
        int minBlockZ = MathHelper.a(aabb.c - 1.0E-7) - 1;
        int maxBlockZ = MathHelper.a(aabb.f + 1.0E-7) + 1;
        CollisionUtil.LazyEntityCollisionContext collisionContext = null;
        BlockPosition.MutableBlockPosition pos = new BlockPosition.MutableBlockPosition();
        BaseBlockPosition selected = null;
        double selectedDistance = Double.MAX_VALUE;
        Vec3D entityPos = entity.dk();
        Chunk lastChunk = null;
        int lastChunkX = Integer.MIN_VALUE;
        int lastChunkZ = Integer.MIN_VALUE;
        ChunkProviderServer chunkProvider = (ChunkProviderServer)this.L();
        for (int currZ = minBlockZ; currZ <= maxBlockZ; ++currZ) {
            pos.r(currZ);
            for (int currX = minBlockX; currX <= maxBlockX; ++currX) {
                pos.p(currX);
                int newChunkX = currX >> 4;
                int newChunkZ = currZ >> 4;
                int chunkDiff = newChunkX ^ lastChunkX | newChunkZ ^ lastChunkZ;
                if (chunkDiff != 0) {
                    lastChunk = chunkProvider.getChunkAtIfLoadedImmediately(newChunkX, newChunkZ);
                }
                if (lastChunk == null) continue;
                for (int currY = minBlockY; currY <= maxBlockY; ++currY) {
                    VoxelShape blockCollision;
                    IBlockData state;
                    int edgeCount = (currX == minBlockX || currX == maxBlockX ? 1 : 0) + (currY == minBlockY || currY == maxBlockY ? 1 : 0) + (currZ == minBlockZ || currZ == maxBlockZ ? 1 : 0);
                    if (edgeCount == 3) continue;
                    pos.q(currY);
                    double distance = pos.b(entityPos);
                    if (distance > selectedDistance || distance == selectedDistance && selected.i(pos) >= 0 || (state = lastChunk.getBlockState(currX, currY, currZ)).emptyCollisionShape() || edgeCount == 1 && !state.f() || edgeCount == 2 && state.b() != Blocks.bQ) continue;
                    if (collisionContext == null) {
                        collisionContext = new CollisionUtil.LazyEntityCollisionContext(entity);
                    }
                    if ((blockCollision = state.b((IBlockAccess)lastChunk, (BlockPosition)pos, collisionContext)).c()) continue;
                    AxisAlignedBB shiftedAABB = aabb.d(-((double)currX), -((double)currY), -((double)currZ));
                    AxisAlignedBB singleAABB = blockCollision.getSingleAABBRepresentation();
                    if (singleAABB != null) {
                        if (!CollisionUtil.voxelShapeIntersect(singleAABB, shiftedAABB)) continue;
                        selected = pos.i();
                        selectedDistance = distance;
                        continue;
                    }
                    if (!CollisionUtil.voxelShapeIntersectNoEmpty(blockCollision, shiftedAABB)) continue;
                    selected = pos.i();
                    selectedDistance = distance;
                }
            }
        }
        return Optional.ofNullable(selected);
    }

    @Override
    public boolean y_() {
        return this.B;
    }

    @Override
    @Nullable
    public MinecraftServer o() {
        return null;
    }

    public MovingObjectPosition.EnumMovingObjectType clipDirect(Vec3D start, Vec3D end, VoxelShapeCollision context) {
        MovingObjectPosition.EnumMovingObjectType result;
        int currentZ;
        int currentY;
        if (start.equals(end)) {
            return MovingObjectPosition.EnumMovingObjectType.a;
        }
        double endX = MathHelper.d(-1.0E-7, end.c, start.c);
        double endY = MathHelper.d(-1.0E-7, end.d, start.d);
        double endZ = MathHelper.d(-1.0E-7, end.e, start.e);
        double startX = MathHelper.d(-1.0E-7, start.c, end.c);
        double startY = MathHelper.d(-1.0E-7, start.d, end.d);
        double startZ = MathHelper.d(-1.0E-7, start.e, end.e);
        int currentX = MathHelper.a(startX);
        BlockPosition.MutableBlockPosition currentBlock = new BlockPosition.MutableBlockPosition(currentX, currentY = MathHelper.a(startY), currentZ = MathHelper.a(startZ));
        Chunk chunk = this.getChunkIfLoaded(currentBlock);
        if (chunk == null) {
            return MovingObjectPosition.EnumMovingObjectType.a;
        }
        MovingObjectPosition.EnumMovingObjectType initialCheck = this.clipDirect(start, end, currentBlock, chunk.a_(currentBlock), context);
        if (initialCheck != null) {
            return initialCheck;
        }
        double diffX = endX - startX;
        double diffY = endY - startY;
        double diffZ = endZ - startZ;
        int xDirection = MathHelper.j(diffX);
        int yDirection = MathHelper.j(diffY);
        int zDirection = MathHelper.j(diffZ);
        double normalizedX = xDirection == 0 ? Double.MAX_VALUE : (double)xDirection / diffX;
        double normalizedY = yDirection == 0 ? Double.MAX_VALUE : (double)yDirection / diffY;
        double normalizedZ = zDirection == 0 ? Double.MAX_VALUE : (double)zDirection / diffZ;
        double normalizedXDirection = normalizedX * (xDirection > 0 ? 1.0 - MathHelper.e(startX) : MathHelper.e(startX));
        double normalizedYDirection = normalizedY * (yDirection > 0 ? 1.0 - MathHelper.e(startY) : MathHelper.e(startY));
        double normalizedZDirection = normalizedZ * (zDirection > 0 ? 1.0 - MathHelper.e(startZ) : MathHelper.e(startZ));
        do {
            if (normalizedXDirection > 1.0 && normalizedYDirection > 1.0 && normalizedZDirection > 1.0) {
                return MovingObjectPosition.EnumMovingObjectType.a;
            }
            if (normalizedXDirection < normalizedYDirection) {
                if (normalizedXDirection < normalizedZDirection) {
                    currentX += xDirection;
                    normalizedXDirection += normalizedX;
                } else {
                    currentZ += zDirection;
                    normalizedZDirection += normalizedZ;
                }
            } else if (normalizedYDirection < normalizedZDirection) {
                currentY += yDirection;
                normalizedYDirection += normalizedY;
            } else {
                currentZ += zDirection;
                normalizedZDirection += normalizedZ;
            }
            currentBlock.d(currentX, currentY, currentZ);
            if (chunk.f().e == currentBlock.u() >> 4 && chunk.f().f == currentBlock.w() >> 4 || (chunk = this.getChunkIfLoaded(currentBlock)) != null) continue;
            return MovingObjectPosition.EnumMovingObjectType.a;
        } while ((result = this.clipDirect(start, end, currentBlock, chunk.a_(currentBlock), context)) == null);
        return result;
    }

    public boolean k(BlockPosition pos) {
        return pos.isInsideBuildHeightAndWorldBoundsHorizontal(this);
    }

    public static boolean l(BlockPosition pos) {
        return !World.b(pos.v()) && World.g(pos);
    }

    private static boolean g(BlockPosition pos) {
        return pos.u() >= -30000000 && pos.w() >= -30000000 && pos.u() < 30000000 && pos.w() < 30000000;
    }

    private static boolean b(int y2) {
        return y2 < -20000000 || y2 >= 20000000;
    }

    public final Chunk m(BlockPosition pos) {
        return this.d(SectionPosition.a(pos.u()), SectionPosition.a(pos.w()));
    }

    public final Chunk d(int chunkX, int chunkZ) {
        Chunk ifLoaded;
        ChunkProviderServer cps = ((WorldServer)this).l();
        if (cps.e == Thread.currentThread() && (ifLoaded = cps.getChunkAtIfLoadedMainThread(chunkX, chunkZ)) != null) {
            return ifLoaded;
        }
        return (Chunk)this.a(chunkX, chunkZ, ChunkStatus.n, true);
    }

    @Override
    @Nullable
    public final IChunkAccess getChunkIfLoadedImmediately(int x2, int z2) {
        return ((WorldServer)this).I.getChunkAtIfLoadedImmediately(x2, z2);
    }

    @Override
    @Nullable
    public final IBlockData getBlockStateIfLoaded(BlockPosition pos) {
        CraftBlockState previous;
        if (this.captureTreeGeneration && (previous = this.capturedBlockStates.get(pos)) != null) {
            return previous.getHandle();
        }
        if (this.s(pos)) {
            return Blocks.nb.o();
        }
        IChunkAccess chunk = this.getChunkIfLoadedImmediately(pos.u() >> 4, pos.w() >> 4);
        return chunk == null ? null : chunk.a_(pos);
    }

    @Override
    public final Fluid getFluidIfLoaded(BlockPosition blockposition) {
        IChunkAccess chunk = this.getChunkIfLoadedImmediately(blockposition.u() >> 4, blockposition.w() >> 4);
        return chunk == null ? null : chunk.b_(blockposition);
    }

    @Override
    public final boolean B(BlockPosition pos) {
        return this.getChunkIfLoaded(pos.u() >> 4, pos.w() >> 4) != null;
    }

    public final boolean isLoadedAndInBounds(BlockPosition blockposition) {
        return this.D_().a(blockposition) && this.getChunkIfLoadedImmediately(blockposition.u() >> 4, blockposition.w() >> 4) != null;
    }

    @Nullable
    public Chunk getChunkIfLoaded(int x2, int z2) {
        return ((WorldServer)this).l().getChunkAtIfLoadedImmediately(x2, z2);
    }

    @Nullable
    public final Chunk getChunkIfLoaded(BlockPosition blockposition) {
        return ((WorldServer)this).l().getChunkAtIfLoadedImmediately(blockposition.u() >> 4, blockposition.w() >> 4);
    }

    @Nullable
    public final IBlockData getBlockStateIfLoadedAndInBounds(BlockPosition blockposition) {
        return this.D_().a(blockposition) ? this.getBlockStateIfLoaded(blockposition) : null;
    }

    @Override
    public final IChunkAccess a(int chunkX, int chunkZ, ChunkStatus leastStatus, boolean create) {
        IChunkAccess ichunkaccess = this.L().a(chunkX, chunkZ, leastStatus, create);
        if (ichunkaccess == null && create) {
            throw new IllegalStateException("Should always be able to create a chunk!");
        }
        return ichunkaccess;
    }

    @Override
    public final boolean a(BlockPosition pos, IBlockData state, int flags) {
        return this.a(pos, state, flags, 512);
    }

    @Override
    public boolean a(BlockPosition pos, IBlockData state, int flags, int maxUpdateDepth) {
        if (this.captureTreeGeneration) {
            IBlockData type = this.a_(pos);
            if (!type.isDestroyable()) {
                return false;
            }
            CraftBlockState blockstate = this.capturedBlockStates.get(pos);
            if (blockstate == null) {
                blockstate = CapturedBlockState.getTreeBlockState(this, pos, flags);
                this.capturedBlockStates.put(pos.i(), blockstate);
            }
            blockstate.setData(state);
            blockstate.setFlag(flags);
            return true;
        }
        if (this.s(pos)) {
            return false;
        }
        if (!this.B && this.ah()) {
            return false;
        }
        Chunk chunk = this.m(pos);
        Block block = state.b();
        boolean captured = false;
        if (this.captureBlockStates && !this.capturedBlockStates.containsKey(pos)) {
            CraftBlockState blockstate = (CraftBlockState)this.world.getBlockAt(pos.u(), pos.v(), pos.w()).getState();
            blockstate.setFlag(flags);
            this.capturedBlockStates.put(pos.i(), blockstate);
            captured = true;
        }
        IBlockData iblockdata1 = chunk.setBlockState(pos, state, (flags & 0x40) != 0, (flags & 0x400) == 0);
        this.chunkPacketBlockController.onBlockChange(this, pos, state, iblockdata1, flags, maxUpdateDepth);
        if (iblockdata1 == null) {
            if (this.captureBlockStates && captured) {
                this.capturedBlockStates.remove(pos);
            }
            return false;
        }
        IBlockData iblockdata2 = this.a_(pos);
        if (!this.captureBlockStates) {
            try {
                this.notifyAndUpdatePhysics(pos, chunk, iblockdata1, state, iblockdata2, flags, maxUpdateDepth);
            }
            catch (StackOverflowError ex) {
                lastPhysicsProblem = new BlockPosition(pos);
            }
        }
        return true;
    }

    public void notifyAndUpdatePhysics(BlockPosition blockposition, Chunk chunk, IBlockData oldBlock, IBlockData newBlock, IBlockData actualBlock, int i2, int j2) {
        IBlockData iblockdata = newBlock;
        IBlockData iblockdata1 = oldBlock;
        IBlockData iblockdata2 = actualBlock;
        if (iblockdata2 == iblockdata) {
            if (iblockdata1 != iblockdata2) {
                this.b(blockposition, iblockdata1, iblockdata2);
            }
            if ((i2 & 2) != 0 && (!this.B || (i2 & 4) == 0) && (this.B || chunk == null || chunk.D() != null && chunk.D().a(FullChunkStatus.c))) {
                this.a(blockposition, iblockdata1, iblockdata, i2);
            } else if (!((i2 & 2) == 0 || this.B && (i2 & 4) != 0)) {
                ((WorldServer)this).l().a(blockposition);
            }
            if ((i2 & 1) != 0) {
                this.b(blockposition, iblockdata1.b());
                if (!this.B && iblockdata.n()) {
                    this.c(blockposition, newBlock.b());
                }
            }
            if ((i2 & 0x10) == 0 && j2 > 0) {
                int k2 = i2 & 0xFFFFFFDE;
                iblockdata1.b((GeneratorAccess)this, blockposition, k2, j2 - 1);
                CraftWorld world = ((WorldServer)this).getWorld();
                boolean cancelledUpdates = false;
                if (world != null && ((WorldServer)this).hasPhysicsEvent) {
                    BlockPhysicsEvent event = new BlockPhysicsEvent(world.getBlockAt(blockposition.u(), blockposition.v(), blockposition.w()), (BlockData)CraftBlockData.fromData(iblockdata));
                    this.getCraftServer().getPluginManager().callEvent((Event)event);
                    cancelledUpdates = event.isCancelled();
                }
                if (!cancelledUpdates) {
                    iblockdata.a((GeneratorAccess)this, blockposition, k2, j2 - 1);
                    iblockdata.b((GeneratorAccess)this, blockposition, k2, j2 - 1);
                }
            }
            if (!this.preventPoiUpdated) {
                this.a(blockposition, iblockdata1, iblockdata2);
            }
        }
    }

    public void a(BlockPosition pos, IBlockData oldBlock, IBlockData newBlock) {
    }

    @Override
    public boolean a(BlockPosition pos, boolean move) {
        Fluid fluid = this.b_(pos);
        return this.a(pos, fluid.g(), 3 | (move ? 64 : 0));
    }

    @Override
    public boolean a(BlockPosition pos, boolean drop, @Nullable net.minecraft.world.entity.Entity breakingEntity, int maxUpdateDepth) {
        boolean flag1;
        IBlockData iblockdata = this.a_(pos);
        if (iblockdata.i()) {
            return false;
        }
        Fluid fluid = this.b_(pos);
        boolean playEffect = true;
        IBlockData effectType = iblockdata;
        int xp = iblockdata.b().getExpDrop(iblockdata, (WorldServer)this, pos, ItemStack.f, true);
        if (BlockDestroyEvent.getHandlerList().getRegisteredListeners().length > 0) {
            BlockDestroyEvent event = new BlockDestroyEvent((org.bukkit.block.Block)CraftBlock.at(this, pos), (BlockData)fluid.g().createCraftBlockData(), (BlockData)effectType.createCraftBlockData(), xp, drop);
            if (!event.callEvent()) {
                return false;
            }
            effectType = ((CraftBlockData)event.getEffectBlock()).getState();
            playEffect = event.playEffect();
            drop = event.willDrop();
            xp = event.getExpToDrop();
        }
        if (playEffect && !(effectType.b() instanceof BlockFireAbstract)) {
            this.c(2001, pos, Block.i(effectType));
        }
        if (drop) {
            TileEntity tileentity = iblockdata.t() ? this.c_(pos) : null;
            Block.dropResources(iblockdata, this, pos, tileentity, breakingEntity, ItemStack.f, false);
            iblockdata.b().popExperience((WorldServer)this, pos, xp, breakingEntity);
        }
        if (flag1 = this.a(pos, fluid.g(), 3, maxUpdateDepth)) {
            this.a(GameEvent.f, pos, GameEvent.a.a(breakingEntity, iblockdata));
        }
        return flag1;
    }

    public void a(BlockPosition pos, IBlockData state) {
    }

    public boolean b(BlockPosition pos, IBlockData state) {
        return this.a(pos, state, 3);
    }

    public abstract void a(BlockPosition var1, IBlockData var2, IBlockData var3, int var4);

    public void b(BlockPosition pos, IBlockData old, IBlockData updated) {
    }

    public void a(BlockPosition pos, Block sourceBlock) {
    }

    public void a(BlockPosition pos, Block sourceBlock, EnumDirection direction) {
    }

    public void a(BlockPosition pos, Block sourceBlock, BlockPosition sourcePos) {
    }

    public void a(IBlockData state, BlockPosition pos, Block sourceBlock, BlockPosition sourcePos, boolean notify) {
    }

    @Override
    public void a(EnumDirection direction, IBlockData neighborState, BlockPosition pos, BlockPosition neighborPos, int flags, int maxUpdateDepth) {
        this.s.a(direction, neighborState, pos, neighborPos, flags, maxUpdateDepth);
    }

    @Override
    public int a(HeightMap.Type heightmap, int x2, int z2) {
        int k2 = x2 >= -30000000 && z2 >= -30000000 && x2 < 30000000 && z2 < 30000000 ? (this.b(SectionPosition.a(x2), SectionPosition.a(z2)) ? this.d(SectionPosition.a(x2), SectionPosition.a(z2)).a(heightmap, x2 & 0xF, z2 & 0xF) + 1 : this.J_()) : this.A_() + 1;
        return k2;
    }

    @Override
    public LevelLightEngine z_() {
        return this.L().p();
    }

    @Override
    public IBlockData a_(BlockPosition pos) {
        CraftBlockState previous;
        if (this.captureTreeGeneration && (previous = this.capturedBlockStates.get(pos)) != null) {
            return previous.getHandle();
        }
        if (this.s(pos)) {
            return Blocks.nb.o();
        }
        IChunkAccess chunk = this.a(pos.u() >> 4, pos.w() >> 4, ChunkStatus.n, true);
        return chunk.a_(pos);
    }

    @Override
    public Fluid b_(BlockPosition pos) {
        if (this.s(pos)) {
            return FluidTypes.a.g();
        }
        Chunk chunk = this.m(pos);
        return chunk.b_(pos);
    }

    public boolean P() {
        return !this.E_().a() && this.e < 4;
    }

    public boolean Q() {
        return !this.E_().a() && !this.P();
    }

    public void a(@Nullable net.minecraft.world.entity.Entity source, BlockPosition pos, SoundEffect sound, SoundCategory category, float volume, float pitch) {
        EntityHuman entityhuman1;
        EntityHuman entityhuman = source instanceof EntityHuman ? (entityhuman1 = (EntityHuman)source) : null;
        this.a(entityhuman, pos, sound, category, volume, pitch);
    }

    @Override
    public void a(@Nullable EntityHuman source, BlockPosition pos, SoundEffect sound, SoundCategory category, float volume, float pitch) {
        this.a(source, (double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, sound, category, volume, pitch);
    }

    public abstract void a(@Nullable EntityHuman var1, double var2, double var4, double var6, Holder<SoundEffect> var8, SoundCategory var9, float var10, float var11, long var12);

    public void a(@Nullable EntityHuman source, double x2, double y2, double z2, SoundEffect sound, SoundCategory category, float volume, float pitch, long seed) {
        this.a(source, x2, y2, z2, BuiltInRegistries.b.d(sound), category, volume, pitch, seed);
    }

    public abstract void a(@Nullable EntityHuman var1, net.minecraft.world.entity.Entity var2, Holder<SoundEffect> var3, SoundCategory var4, float var5, float var6, long var7);

    public void a(@Nullable EntityHuman source, double x2, double y2, double z2, SoundEffect sound, SoundCategory category) {
        this.a(source, x2, y2, z2, sound, category, 1.0f, 1.0f);
    }

    public void a(@Nullable EntityHuman source, double x2, double y2, double z2, SoundEffect sound, SoundCategory category, float volume, float pitch) {
        this.a(source, x2, y2, z2, sound, category, volume, pitch, this.f.g());
    }

    public void a(@Nullable EntityHuman source, net.minecraft.world.entity.Entity entity, SoundEffect sound, SoundCategory category, float volume, float pitch) {
        this.a(source, entity, BuiltInRegistries.b.d(sound), category, volume, pitch, this.f.g());
    }

    public void a(BlockPosition pos, SoundEffect sound, SoundCategory category, float volume, float pitch, boolean useDistance) {
        this.a((double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, sound, category, volume, pitch, useDistance);
    }

    public void a(net.minecraft.world.entity.Entity entity, SoundEffect sound, SoundCategory category, float volume, float pitch) {
    }

    public void a(double x2, double y2, double z2, SoundEffect sound, SoundCategory category, float volume, float pitch, boolean useDistance) {
    }

    @Override
    public void a(ParticleParam parameters, double x2, double y2, double z2, double velocityX, double velocityY, double velocityZ) {
    }

    public void a(ParticleParam parameters, boolean alwaysSpawn, double x2, double y2, double z2, double velocityX, double velocityY, double velocityZ) {
    }

    public void b(ParticleParam parameters, double x2, double y2, double z2, double velocityX, double velocityY, double velocityZ) {
    }

    public void b(ParticleParam parameters, boolean alwaysSpawn, double x2, double y2, double z2, double velocityX, double velocityY, double velocityZ) {
    }

    public float a(float tickDelta) {
        float f1 = this.f(tickDelta);
        return f1 * ((float)Math.PI * 2);
    }

    public void a(TickingBlockEntity ticker) {
        (this.b ? this.a : this.r).add(ticker);
    }

    protected void R() {
        this.b = true;
        if (!this.a.isEmpty()) {
            this.r.addAll(this.a);
            this.a.clear();
        }
        boolean flag = this.s().i();
        int tilesThisCycle = 0;
        ReferenceOpenHashSet toRemove = new ReferenceOpenHashSet();
        toRemove.add(null);
        this.tileTickPosition = 0;
        while (this.tileTickPosition < this.r.size()) {
            this.tileTickPosition = this.tileTickPosition < this.r.size() ? this.tileTickPosition : 0;
            TickingBlockEntity tickingblockentity = this.r.get(this.tileTickPosition);
            if (tickingblockentity.b()) {
                --tilesThisCycle;
                toRemove.add((Object)tickingblockentity);
            } else if (flag && this.n(tickingblockentity.c())) {
                tickingblockentity.a();
                if ((this.tileTickPosition & 7) == 0) {
                    MinecraftServer.getServer().executeMidTickTasks();
                }
            }
            ++this.tileTickPosition;
        }
        this.r.removeAll((Collection<?>)toRemove);
        this.b = false;
        TimingHistory.tileEntityTicks += (long)this.r.size();
        this.spigotConfig.currentPrimedTnt = 0;
    }

    public <T extends net.minecraft.world.entity.Entity> void a(Consumer<T> tickConsumer, T entity) {
        try {
            tickConsumer.accept(entity);
            MinecraftServer.getServer().executeMidTickTasks();
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw throwable;
            }
            String msg = String.format("Entity threw exception at %s:%s,%s,%s", entity.dM().getWorld().getName(), entity.dr(), entity.dt(), entity.dx());
            MinecraftServer.l.error(msg, throwable);
            this.getCraftServer().getPluginManager().callEvent((Event)new ServerExceptionEvent((ServerException)new ServerInternalException(msg, throwable)));
            entity.discard(EntityRemoveEvent.Cause.DISCARD);
        }
    }

    @Override
    public boolean a(@Nullable net.minecraft.world.entity.Entity entity, AxisAlignedBB box) {
        if (entity instanceof EntityArmorStand && !entity.dM().paperConfig().entities.armorStands.doCollisionEntityLookups) {
            return false;
        }
        int flags = 8;
        if (entity != null) {
            flags |= 4;
        }
        if (CollisionUtil.getCollisionsForBlocksOrWorldBorder(this, entity, box, null, null, flags, null)) {
            return false;
        }
        return !CollisionUtil.getEntityHardCollisions(this, entity, box, null, flags, null);
    }

    public boolean h(net.minecraft.world.entity.Entity entity) {
        return true;
    }

    public boolean a(long chunkPos) {
        return true;
    }

    public boolean n(BlockPosition pos) {
        return this.a(ChunkCoordIntPair.a(pos));
    }

    public Explosion a(@Nullable net.minecraft.world.entity.Entity entity, double x2, double y2, double z2, float power, a explosionSourceType) {
        return this.a(entity, Explosion.a(this, entity), null, x2, y2, z2, power, false, explosionSourceType, Particles.x, Particles.w, SoundEffects.jA);
    }

    public Explosion a(@Nullable net.minecraft.world.entity.Entity entity, double x2, double y2, double z2, float power, boolean createFire, a explosionSourceType) {
        return this.a(entity, Explosion.a(this, entity), null, x2, y2, z2, power, createFire, explosionSourceType, Particles.x, Particles.w, SoundEffects.jA);
    }

    public Explosion a(@Nullable net.minecraft.world.entity.Entity entity, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator behavior, Vec3D pos, float power, boolean createFire, a explosionSourceType) {
        return this.a(entity, damageSource, behavior, pos.a(), pos.b(), pos.c(), power, createFire, explosionSourceType, Particles.x, Particles.w, SoundEffects.jA);
    }

    public Explosion a(@Nullable net.minecraft.world.entity.Entity entity, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator behavior, double x2, double y2, double z2, float power, boolean createFire, a explosionSourceType) {
        return this.a(entity, damageSource, behavior, x2, y2, z2, power, createFire, explosionSourceType, Particles.x, Particles.w, SoundEffects.jA);
    }

    public Explosion a(@Nullable net.minecraft.world.entity.Entity entity, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator behavior, double x2, double y2, double z2, float power, boolean createFire, a explosionSourceType, ParticleParam particle, ParticleParam emitterParticle, SoundEffect soundEvent) {
        return this.a(entity, damageSource, behavior, x2, y2, z2, power, createFire, explosionSourceType, true, particle, emitterParticle, soundEvent);
    }

    public Explosion a(@Nullable net.minecraft.world.entity.Entity entity, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator behavior, double x2, double y2, double z2, float power, boolean createFire, a explosionSourceType, boolean particles, ParticleParam particle, ParticleParam emitterParticle, SoundEffect soundEvent) {
        Explosion.Effect explosion_effect1 = switch (explosionSourceType) {
            case net.minecraft.world.level.World$a.a -> Explosion.Effect.a;
            case net.minecraft.world.level.World$a.b -> this.a(GameRules.Q);
            case net.minecraft.world.level.World$a.c -> this.Z().b(GameRules.c) ? this.a(GameRules.R) : Explosion.Effect.a;
            case net.minecraft.world.level.World$a.d -> this.a(GameRules.S);
            case net.minecraft.world.level.World$a.e -> Explosion.Effect.d;
            default -> throw new IncompatibleClassChangeError();
        };
        Explosion explosion = new Explosion(this, entity, damageSource, behavior, x2, y2, z2, power, createFire, explosion_effect1, particle, emitterParticle, soundEvent);
        explosion.c();
        explosion.a(particles);
        return explosion;
    }

    private Explosion.Effect a(GameRules.GameRuleKey<GameRules.GameRuleBoolean> gameRuleKey) {
        return this.Z().b(gameRuleKey) ? Explosion.Effect.c : Explosion.Effect.b;
    }

    public abstract String H();

    @Override
    @Nullable
    public TileEntity c_(BlockPosition pos) {
        return this.getBlockEntity(pos, true);
    }

    @Nullable
    public TileEntity getBlockEntity(BlockPosition blockposition, boolean validate) {
        TileEntity blockEntity;
        if (!this.capturedTileEntities.isEmpty() && (blockEntity = this.capturedTileEntities.get(blockposition)) != null) {
            return blockEntity;
        }
        return this.s(blockposition) ? null : (!this.B && !TickThread.isTickThread() ? null : this.m(blockposition).a(blockposition, Chunk.EnumTileEntityState.a));
    }

    public void a(TileEntity blockEntity) {
        BlockPosition blockposition = blockEntity.aB_();
        if (!this.s(blockposition)) {
            if (this.captureBlockStates) {
                this.capturedTileEntities.put(blockposition.i(), blockEntity);
                return;
            }
            this.m(blockposition).b(blockEntity);
        }
    }

    public void o(BlockPosition pos) {
        if (!this.s(pos)) {
            this.m(pos).d(pos);
        }
    }

    public boolean p(BlockPosition pos) {
        return this.s(pos) ? false : this.L().b(SectionPosition.a(pos.u()), SectionPosition.a(pos.w()));
    }

    public boolean a(BlockPosition pos, net.minecraft.world.entity.Entity entity, EnumDirection direction) {
        if (this.s(pos)) {
            return false;
        }
        IChunkAccess ichunkaccess = this.a(SectionPosition.a(pos.u()), SectionPosition.a(pos.w()), ChunkStatus.n, false);
        return ichunkaccess == null ? false : ichunkaccess.a_(pos).a((IBlockAccess)this, pos, entity, direction);
    }

    public boolean a(BlockPosition pos, net.minecraft.world.entity.Entity entity) {
        return this.a(pos, entity, EnumDirection.b);
    }

    public void S() {
        double d0 = 1.0 - (double)(this.d(1.0f) * 5.0f) / 16.0;
        double d1 = 1.0 - (double)(this.b(1.0f) * 5.0f) / 16.0;
        double d2 = 0.5 + 2.0 * MathHelper.a((double)MathHelper.b(this.f(1.0f) * ((float)Math.PI * 2)), -0.25, 0.25);
        this.e = (int)((1.0 - d2 * d0 * d1) * 11.0);
    }

    public void b(boolean spawnMonsters, boolean spawnAnimals) {
        this.L().a(spawnMonsters, spawnAnimals);
    }

    public BlockPosition T() {
        BlockPosition blockposition = new BlockPosition(this.A.a(), this.A.b(), this.A.c());
        if (!this.D_().a(blockposition)) {
            blockposition = this.a(HeightMap.Type.e, BlockPosition.a(this.D_().a(), 0.0, this.D_().b()));
        }
        return blockposition;
    }

    public float U() {
        return this.A.d();
    }

    protected void V() {
        if (this.A.k()) {
            this.w = 1.0f;
            if (this.A.i()) {
                this.y = 1.0f;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.L().close();
    }

    @Override
    @Nullable
    public IBlockAccess c(int chunkX, int chunkZ) {
        return this.a(chunkX, chunkZ, ChunkStatus.n, false);
    }

    @Override
    public List<net.minecraft.world.entity.Entity> a(@Nullable net.minecraft.world.entity.Entity except, AxisAlignedBB box, Predicate<? super net.minecraft.world.entity.Entity> predicate) {
        ArrayList list = Lists.newArrayList();
        ((WorldServer)this).getEntityLookup().getEntities(except, box, list, predicate);
        return list;
    }

    @Override
    public <T extends net.minecraft.world.entity.Entity> List<T> a(EntityTypeTest<net.minecraft.world.entity.Entity, T> filter, AxisAlignedBB box, Predicate<? super T> predicate) {
        ArrayList list = Lists.newArrayList();
        this.a(filter, box, predicate, list);
        return list;
    }

    public <T extends net.minecraft.world.entity.Entity> void a(EntityTypeTest<net.minecraft.world.entity.Entity, T> filter, AxisAlignedBB box, Predicate<? super T> predicate, List<? super T> result) {
        this.a(filter, box, predicate, result, Integer.MAX_VALUE);
    }

    public <T extends net.minecraft.world.entity.Entity> void a(EntityTypeTest<net.minecraft.world.entity.Entity, T> filter, AxisAlignedBB box, Predicate<? super T> predicate, List<? super T> result, int limit) {
        if (filter instanceof EntityTypes) {
            EntityTypes entityTypeTest = (EntityTypes)filter;
            ((WorldServer)this).getEntityLookup().getEntities(entityTypeTest, box, result, predicate);
        } else {
            Class<net.minecraft.world.entity.Entity> base;
            Predicate<net.minecraft.world.entity.Entity> test = obj -> filter.a((net.minecraft.world.entity.Entity)obj) != null;
            Predicate<net.minecraft.world.entity.Entity> predicate2 = predicate = predicate == null ? test : test.and(predicate);
            if (filter == null || (base = filter.a()) == null || base == net.minecraft.world.entity.Entity.class) {
                ((WorldServer)this).getEntityLookup().getEntities((net.minecraft.world.entity.Entity)null, box, result, predicate);
            } else {
                ((WorldServer)this).getEntityLookup().getEntities(base, null, box, result, predicate);
            }
        }
    }

    @Nullable
    public abstract net.minecraft.world.entity.Entity a(int var1);

    public void q(BlockPosition pos) {
        if (this.B(pos)) {
            this.m(pos).a(true);
        }
    }

    @Override
    public int A_() {
        return 63;
    }

    public void W() {
    }

    public long X() {
        return this.A.e();
    }

    public long Y() {
        return this.A.f();
    }

    public boolean a(EntityHuman player, BlockPosition pos) {
        return true;
    }

    public void a(net.minecraft.world.entity.Entity entity, byte status) {
    }

    public void a(net.minecraft.world.entity.Entity entity, DamageSource damageSource) {
    }

    public void a(BlockPosition pos, Block block, int type, int data) {
        this.a_(pos).a(this, pos, type, data);
    }

    @Override
    public WorldData B_() {
        return this.A;
    }

    public GameRules Z() {
        return this.A.q();
    }

    public abstract TickRateManager s();

    public float b(float delta) {
        return MathHelper.i(delta, this.x, this.y) * this.d(delta);
    }

    public void c(float thunderGradient) {
        float f1;
        this.x = f1 = MathHelper.a(thunderGradient, 0.0f, 1.0f);
        this.y = f1;
    }

    public float d(float delta) {
        return MathHelper.i(delta, this.v, this.w);
    }

    public void e(float rainGradient) {
        float f1;
        this.v = f1 = MathHelper.a(rainGradient, 0.0f, 1.0f);
        this.w = f1;
    }

    public boolean aa() {
        return this.E_().g() && !this.E_().h() ? (double)this.b(1.0f) > 0.9 : false;
    }

    public boolean ab() {
        return (double)this.d(1.0f) > 0.2;
    }

    public boolean r(BlockPosition pos) {
        if (!this.ab()) {
            return false;
        }
        if (!this.h(pos)) {
            return false;
        }
        if (this.a(HeightMap.Type.e, pos).v() > pos.v()) {
            return false;
        }
        BiomeBase biomebase = this.t(pos).a();
        return biomebase.a(pos) == BiomeBase.Precipitation.b;
    }

    @Nullable
    public abstract WorldMap a(String var1);

    public abstract void a(String var1, WorldMap var2);

    public abstract int v();

    public void b(int eventId, BlockPosition pos, int data) {
    }

    public CrashReportSystemDetails a(CrashReport report) {
        CrashReportSystemDetails crashreportsystemdetails = report.a("Affected level", 1);
        crashreportsystemdetails.a("All players", () -> {
            int i2 = this.x().size();
            return i2 + " total; " + this.x();
        });
        IChunkProvider ichunkprovider = this.L();
        Objects.requireNonNull(ichunkprovider);
        crashreportsystemdetails.a("Chunk stats", ichunkprovider::e);
        crashreportsystemdetails.a("Level dimension", () -> this.ae().a().toString());
        try {
            this.A.a(crashreportsystemdetails, this);
        }
        catch (Throwable throwable) {
            crashreportsystemdetails.a("Level Data Unobtainable", throwable);
        }
        return crashreportsystemdetails;
    }

    public abstract void a(int var1, BlockPosition var2, int var3);

    public void a(double x2, double y2, double z2, double velocityX, double velocityY, double velocityZ, @Nullable NBTTagCompound nbt) {
    }

    public abstract Scoreboard K();

    public void c(BlockPosition pos, Block block) {
        for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.a) {
            BlockPosition blockposition1 = pos.a(enumdirection);
            if (!this.B(blockposition1)) continue;
            IBlockData iblockdata = this.a_(blockposition1);
            if (iblockdata.a(Blocks.gY)) {
                this.a(iblockdata, blockposition1, block, pos, false);
                continue;
            }
            if (!iblockdata.g(this, blockposition1) || !(iblockdata = this.a_(blockposition1 = blockposition1.a(enumdirection))).a(Blocks.gY)) continue;
            this.a(iblockdata, blockposition1, block, pos, false);
        }
    }

    @Override
    public DifficultyDamageScaler d_(BlockPosition pos) {
        long i2 = 0L;
        float f2 = 0.0f;
        if (this.B(pos)) {
            f2 = this.ap();
            i2 = this.m(pos).u();
        }
        return new DifficultyDamageScaler(this.ak(), this.Y(), i2, f2);
    }

    @Override
    public int C_() {
        return this.e;
    }

    public void c(int lightningTicksLeft) {
    }

    @Override
    public WorldBorder D_() {
        return this.G;
    }

    public void a(Packet<?> packet) {
        throw new UnsupportedOperationException("Can't send packets to server unless you're on the client.");
    }

    @Override
    public DimensionManager E_() {
        return this.E.a();
    }

    public ResourceKey<DimensionManager> ac() {
        return this.D;
    }

    public Holder<DimensionManager> ad() {
        return this.E;
    }

    public ResourceKey<World> ae() {
        return this.I;
    }

    @Override
    public RandomSource F_() {
        return this.z;
    }

    @Override
    public boolean a(BlockPosition pos, Predicate<IBlockData> state) {
        return state.test(this.a_(pos));
    }

    @Override
    public boolean b(BlockPosition pos, Predicate<Fluid> state) {
        return state.test(this.b_(pos));
    }

    public abstract CraftingManager r();

    public BlockPosition a(int x2, int y2, int z2, int l2) {
        BlockPosition.MutableBlockPosition ret = new BlockPosition.MutableBlockPosition();
        this.getRandomBlockPosition(x2, y2, z2, l2, ret);
        return ret.i();
    }

    public final BlockPosition.MutableBlockPosition getRandomBlockPosition(int x2, int y2, int z2, int l2, BlockPosition.MutableBlockPosition out) {
        this.t = this.t * 3 + 1013904223;
        int i1 = this.t >> 2;
        out.d(x2 + (i1 & 0xF), y2 + (i1 >> 16 & l2), z2 + (i1 >> 8 & 0xF));
        return out;
    }

    public boolean t() {
        return false;
    }

    public GameProfilerFiller af() {
        return GameProfilerDisabled.a;
    }

    public Supplier<GameProfilerFiller> ag() {
        return this.F;
    }

    @Override
    public BiomeManager G_() {
        return this.H;
    }

    public final boolean ah() {
        return this.d;
    }

    public abstract LevelEntityGetter<net.minecraft.world.entity.Entity> G();

    @Override
    public long H_() {
        return this.L++;
    }

    @Override
    public IRegistryCustom I_() {
        return this.J;
    }

    public DamageSources ai() {
        return this.K;
    }

    public List<EntityPlayer> getPlayersForGlobalSoundGamerule() {
        return this.Z().b(GameRules.W) ? ((WorldServer)this).o().ae().l : ((WorldServer)this).x();
    }

    public double getGlobalSoundRangeSquared(Function<SpigotWorldConfig, Integer> rangeFunction) {
        double range = rangeFunction.apply(this.spigotConfig).intValue();
        return range <= 0.0 ? 4096.0 : range * range;
    }

    public void checkCapturedTreeStateForObserverNotify(BlockPosition pos, CraftBlockState craftBlockState) {
        if (craftBlockState.getPosition().v() == pos.v() && this.a_(craftBlockState.getPosition()) == craftBlockState.getHandle()) {
            this.notifyAndUpdatePhysics(craftBlockState.getPosition(), null, craftBlockState.getHandle(), craftBlockState.getHandle(), craftBlockState.getHandle(), craftBlockState.getFlag(), 512);
        }
    }

    public Entity[] getChunkEntities(int chunkX, int chunkZ) {
        ChunkEntitySlices slices = ((WorldServer)this).getEntityLookup().getChunk(chunkX, chunkZ);
        if (slices == null) {
            return new Entity[0];
        }
        return slices.getChunkEntities();
    }

    @Override
    public List<net.minecraft.world.entity.Entity> getHardCollidingEntities(net.minecraft.world.entity.Entity except, AxisAlignedBB box, Predicate<? super net.minecraft.world.entity.Entity> predicate) {
        ArrayList<net.minecraft.world.entity.Entity> ret = new ArrayList<net.minecraft.world.entity.Entity>();
        ((WorldServer)this).getEntityLookup().getHardCollidingEntities(except, box, ret, predicate);
        return ret;
    }

    @Override
    public void getEntities(net.minecraft.world.entity.Entity except, AxisAlignedBB box, Predicate<? super net.minecraft.world.entity.Entity> predicate, List<net.minecraft.world.entity.Entity> into) {
        ((WorldServer)this).getEntityLookup().getEntities(except, box, into, predicate);
    }

    @Override
    public void getHardCollidingEntities(net.minecraft.world.entity.Entity except, AxisAlignedBB box, Predicate<? super net.minecraft.world.entity.Entity> predicate, List<net.minecraft.world.entity.Entity> into) {
        ((WorldServer)this).getEntityLookup().getHardCollidingEntities(except, box, into, predicate);
    }

    @Override
    public <T> void getEntitiesByClass(Class<? extends T> clazz, net.minecraft.world.entity.Entity except, AxisAlignedBB box, List<? super T> into, Predicate<? super T> predicate) {
        ((WorldServer)this).getEntityLookup().getEntities(clazz, except, box, into, predicate);
    }

    @Override
    public <T extends net.minecraft.world.entity.Entity> List<T> a(Class<T> entityClass, AxisAlignedBB box, Predicate<? super T> predicate) {
        ArrayList ret = new ArrayList();
        ((WorldServer)this).getEntityLookup().getEntities(entityClass, null, box, ret, predicate);
        return ret;
    }

    public WireHandler getWireHandler() {
        return null;
    }

    public boolean isNether() {
        return this.getWorld().getEnvironment() == World.Environment.NETHER;
    }

    public boolean isTheEnd() {
        return this.getWorld().getEnvironment() == World.Environment.THE_END;
    }

    static {
        AIR_FLUIDSTATE = FluidTypes.a.g();
    }

    private static final class BreedingCooldownPair {
        private final UUID playerUUID;
        private final Class<? extends EntityAnimal> animalType;

        public BreedingCooldownPair(UUID playerUUID, Class<? extends EntityAnimal> animalType) {
            this.playerUUID = playerUUID;
            this.animalType = animalType;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            BreedingCooldownPair that = (BreedingCooldownPair)o2;
            return this.playerUUID.equals(that.playerUUID) && this.animalType.equals(that.animalType);
        }

        public int hashCode() {
            return Objects.hash(this.playerUUID, this.animalType);
        }
    }

    public static enum a {
        a,
        b,
        c,
        d,
        e;

    }
}

