/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockAttachable;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBell;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyBellAttach;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;

public class BlockBell
extends BlockTileEntity {
    public static final MapCodec<BlockBell> a = BlockBell.b(BlockBell::new);
    public static final BlockStateDirection b = BlockFacingHorizontal.aE;
    public static final BlockStateEnum<BlockPropertyBellAttach> c = BlockProperties.V;
    public static final BlockStateBoolean d = BlockProperties.w;
    private static final VoxelShape f = Block.a(0.0, 0.0, 4.0, 16.0, 16.0, 12.0);
    private static final VoxelShape g = Block.a(4.0, 0.0, 0.0, 12.0, 16.0, 16.0);
    private static final VoxelShape h = Block.a(5.0, 6.0, 5.0, 11.0, 13.0, 11.0);
    private static final VoxelShape i = Block.a(4.0, 4.0, 4.0, 12.0, 6.0, 12.0);
    private static final VoxelShape j = VoxelShapes.a(i, h);
    private static final VoxelShape k = VoxelShapes.a(j, Block.a(7.0, 13.0, 0.0, 9.0, 15.0, 16.0));
    private static final VoxelShape l = VoxelShapes.a(j, Block.a(0.0, 13.0, 7.0, 16.0, 15.0, 9.0));
    private static final VoxelShape m = VoxelShapes.a(j, Block.a(0.0, 13.0, 7.0, 13.0, 15.0, 9.0));
    private static final VoxelShape n = VoxelShapes.a(j, Block.a(3.0, 13.0, 7.0, 16.0, 15.0, 9.0));
    private static final VoxelShape o = VoxelShapes.a(j, Block.a(7.0, 13.0, 0.0, 9.0, 15.0, 13.0));
    private static final VoxelShape F = VoxelShapes.a(j, Block.a(7.0, 13.0, 3.0, 9.0, 15.0, 16.0));
    private static final VoxelShape G = VoxelShapes.a(j, Block.a(7.0, 13.0, 7.0, 9.0, 16.0, 9.0));
    public static final int e = 1;

    public MapCodec<BlockBell> a() {
        return a;
    }

    public BlockBell(BlockBase.Info settings) {
        super(settings);
        this.k((IBlockData)((IBlockData)((IBlockData)this.E.b().a(b, EnumDirection.c)).a(c, BlockPropertyBellAttach.a)).a(d, false));
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, Block sourceBlock, BlockPosition sourcePos, boolean notify) {
        boolean flag1 = world.C(pos);
        if (flag1 != state.c(d)) {
            if (flag1) {
                this.a(world, pos, (EnumDirection)null);
            }
            world.a(pos, (IBlockData)state.a(d, flag1), 3);
        }
    }

    @Override
    public void a(World world, IBlockData state, MovingObjectPositionBlock hit, IProjectile projectile) {
        Entity entity = projectile.w();
        EntityHuman entityhuman = entity instanceof EntityHuman ? (EntityHuman)entity : null;
        this.a(world, state, hit, entityhuman, true);
    }

    @Override
    public EnumInteractionResult a(IBlockData state, World world, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hit) {
        return this.a(world, state, hit, player, true) ? EnumInteractionResult.a(world.B) : EnumInteractionResult.d;
    }

    public boolean a(World world, IBlockData state, MovingObjectPositionBlock hitResult, @Nullable EntityHuman player, boolean checkHitPos) {
        boolean flag1;
        EnumDirection enumdirection = hitResult.b();
        BlockPosition blockposition = hitResult.a();
        boolean bl = flag1 = !checkHitPos || this.a(state, enumdirection, hitResult.e().d - (double)blockposition.v());
        if (flag1) {
            boolean flag2 = this.a(player, world, blockposition, enumdirection);
            if (flag2 && player != null) {
                player.a(StatisticList.az);
            }
            return true;
        }
        return false;
    }

    private boolean a(IBlockData state, EnumDirection side, double y2) {
        if (side.o() != EnumDirection.EnumAxis.b && y2 <= (double)0.8124f) {
            EnumDirection enumdirection1 = state.c(b);
            BlockPropertyBellAttach blockpropertybellattach = state.c(c);
            switch (blockpropertybellattach) {
                case a: {
                    return enumdirection1.o() == side.o();
                }
                case c: 
                case d: {
                    return enumdirection1.o() != side.o();
                }
                case b: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean a(World world, BlockPosition pos, @Nullable EnumDirection direction) {
        return this.a((Entity)null, world, pos, direction);
    }

    public boolean a(@Nullable Entity entity, World world, BlockPosition pos, @Nullable EnumDirection direction) {
        TileEntity tileentity = world.c_(pos);
        if (!world.B && tileentity instanceof TileEntityBell) {
            if (direction == null) {
                direction = world.a_(pos).c(b);
            }
            if (!CraftEventFactory.handleBellRingEvent(world, pos, direction, entity)) {
                return false;
            }
            ((TileEntityBell)tileentity).a(direction);
            world.a((EntityHuman)null, pos, SoundEffects.bK, SoundCategory.e, 2.0f, 1.0f);
            world.a(entity, GameEvent.c, pos);
            return true;
        }
        return false;
    }

    private VoxelShape h(IBlockData state) {
        EnumDirection enumdirection = state.c(b);
        BlockPropertyBellAttach blockpropertybellattach = state.c(c);
        return blockpropertybellattach == BlockPropertyBellAttach.a ? (enumdirection != EnumDirection.c && enumdirection != EnumDirection.d ? g : f) : (blockpropertybellattach == BlockPropertyBellAttach.b ? G : (blockpropertybellattach == BlockPropertyBellAttach.d ? (enumdirection != EnumDirection.c && enumdirection != EnumDirection.d ? l : k) : (enumdirection == EnumDirection.c ? o : (enumdirection == EnumDirection.d ? F : (enumdirection == EnumDirection.f ? n : m)))));
    }

    @Override
    public VoxelShape b(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return this.h(state);
    }

    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return this.h(state);
    }

    @Override
    public EnumRenderType b_(IBlockData state) {
        return EnumRenderType.c;
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext ctx) {
        EnumDirection enumdirection = ctx.k();
        BlockPosition blockposition = ctx.a();
        World world = ctx.q();
        EnumDirection.EnumAxis enumdirection_enumaxis = enumdirection.o();
        if (enumdirection_enumaxis == EnumDirection.EnumAxis.b) {
            IBlockData iblockdata = (IBlockData)((IBlockData)this.o().a(c, enumdirection == EnumDirection.a ? BlockPropertyBellAttach.b : BlockPropertyBellAttach.a)).a(b, ctx.g());
            if (iblockdata.a((IWorldReader)ctx.q(), blockposition)) {
                return iblockdata;
            }
        } else {
            boolean flag = enumdirection_enumaxis == EnumDirection.EnumAxis.a && world.a_(blockposition.g()).d(world, blockposition.g(), EnumDirection.f) && world.a_(blockposition.h()).d(world, blockposition.h(), EnumDirection.e) || enumdirection_enumaxis == EnumDirection.EnumAxis.c && world.a_(blockposition.e()).d(world, blockposition.e(), EnumDirection.d) && world.a_(blockposition.f()).d(world, blockposition.f(), EnumDirection.c);
            IBlockData iblockdata = (IBlockData)((IBlockData)this.o().a(b, enumdirection.g())).a(c, flag ? BlockPropertyBellAttach.d : BlockPropertyBellAttach.c);
            if (iblockdata.a((IWorldReader)ctx.q(), ctx.a())) {
                return iblockdata;
            }
            boolean flag1 = world.a_(blockposition.d()).d(world, blockposition.d(), EnumDirection.b);
            if ((iblockdata = (IBlockData)iblockdata.a(c, flag1 ? BlockPropertyBellAttach.a : BlockPropertyBellAttach.b)).a((IWorldReader)ctx.q(), ctx.a())) {
                return iblockdata;
            }
        }
        return null;
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, Explosion explosion, BiConsumer<ItemStack, BlockPosition> stackMerger) {
        if (explosion.j() == Explosion.Effect.d && !world.y_()) {
            this.a(world, pos, (EnumDirection)null);
        }
        super.a(state, world, pos, explosion, stackMerger);
    }

    @Override
    public IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        BlockPropertyBellAttach blockpropertybellattach = state.c(c);
        EnumDirection enumdirection1 = BlockBell.n(state).g();
        if (enumdirection1 == direction && !state.a(world, pos) && blockpropertybellattach != BlockPropertyBellAttach.d) {
            return Blocks.a.o();
        }
        if (direction.o() == state.c(b).o()) {
            if (blockpropertybellattach == BlockPropertyBellAttach.d && !neighborState.d(world, neighborPos, direction)) {
                return (IBlockData)((IBlockData)state.a(c, BlockPropertyBellAttach.c)).a(b, direction.g());
            }
            if (blockpropertybellattach == BlockPropertyBellAttach.c && enumdirection1.g() == direction && neighborState.d(world, neighborPos, state.c(b))) {
                return (IBlockData)state.a(c, BlockPropertyBellAttach.d);
            }
        }
        return super.a(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public boolean a(IBlockData state, IWorldReader world, BlockPosition pos) {
        EnumDirection enumdirection = BlockBell.n(state).g();
        return enumdirection == EnumDirection.b ? Block.a(world, pos.c(), EnumDirection.a) : BlockAttachable.b(world, pos, enumdirection);
    }

    private static EnumDirection n(IBlockData state) {
        switch (state.c(c)) {
            case a: {
                return EnumDirection.b;
            }
            case b: {
                return EnumDirection.a;
            }
        }
        return state.c(b).g();
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, c, d);
    }

    @Override
    @Nullable
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityBell(pos, state);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> a(World world, IBlockData state, TileEntityTypes<T> type) {
        return BlockBell.a(type, TileEntityTypes.E, world.B ? TileEntityBell::a : TileEntityBell::b);
    }

    @Override
    public boolean a(IBlockData state, IBlockAccess world, BlockPosition pos, PathMode type) {
        return false;
    }

    @Override
    public IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.a(b, rotation.a(state.c(b)));
    }

    @Override
    public IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(b)));
    }
}

