/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockAttachable;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyAttachPosition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_20_R3.block.CraftBlock;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.entity.EntityInteractEvent;

public class BlockButtonAbstract
extends BlockAttachable {
    public static final MapCodec<BlockButtonAbstract> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockSetType.a.fieldOf("block_set_type").forGetter(blockbuttonabstract -> blockbuttonabstract.N), (App)Codec.intRange((int)1, (int)1024).fieldOf("ticks_to_stay_pressed").forGetter(blockbuttonabstract -> blockbuttonabstract.O), BlockButtonAbstract.u()).apply((Applicative)instance, BlockButtonAbstract::new));
    public static final BlockStateBoolean b = BlockProperties.w;
    private static final int L = 1;
    private static final int M = 2;
    protected static final int c = 2;
    protected static final int d = 3;
    protected static final VoxelShape e = Block.a(6.0, 14.0, 5.0, 10.0, 16.0, 11.0);
    protected static final VoxelShape f = Block.a(5.0, 14.0, 6.0, 11.0, 16.0, 10.0);
    protected static final VoxelShape g = Block.a(6.0, 0.0, 5.0, 10.0, 2.0, 11.0);
    protected static final VoxelShape h = Block.a(5.0, 0.0, 6.0, 11.0, 2.0, 10.0);
    protected static final VoxelShape i = Block.a(5.0, 6.0, 14.0, 11.0, 10.0, 16.0);
    protected static final VoxelShape j = Block.a(5.0, 6.0, 0.0, 11.0, 10.0, 2.0);
    protected static final VoxelShape k = Block.a(14.0, 6.0, 5.0, 16.0, 10.0, 11.0);
    protected static final VoxelShape l = Block.a(0.0, 6.0, 5.0, 2.0, 10.0, 11.0);
    protected static final VoxelShape m = Block.a(6.0, 15.0, 5.0, 10.0, 16.0, 11.0);
    protected static final VoxelShape n = Block.a(5.0, 15.0, 6.0, 11.0, 16.0, 10.0);
    protected static final VoxelShape o = Block.a(6.0, 0.0, 5.0, 10.0, 1.0, 11.0);
    protected static final VoxelShape F = Block.a(5.0, 0.0, 6.0, 11.0, 1.0, 10.0);
    protected static final VoxelShape G = Block.a(5.0, 6.0, 15.0, 11.0, 10.0, 16.0);
    protected static final VoxelShape H = Block.a(5.0, 6.0, 0.0, 11.0, 10.0, 1.0);
    protected static final VoxelShape I = Block.a(15.0, 6.0, 5.0, 16.0, 10.0, 11.0);
    protected static final VoxelShape J = Block.a(0.0, 6.0, 5.0, 1.0, 10.0, 11.0);
    private final BlockSetType N;
    private final int O;

    public MapCodec<BlockButtonAbstract> a() {
        return a;
    }

    protected BlockButtonAbstract(BlockSetType blockSetType, int pressTicks, BlockBase.Info settings) {
        super(settings.a(blockSetType.g()));
        this.N = blockSetType;
        this.k((IBlockData)((IBlockData)((IBlockData)this.E.b().a(BlockFacingHorizontal.aE, EnumDirection.c)).a(b, false)).a(BlockAttachable.K, BlockPropertyAttachPosition.b));
        this.O = pressTicks;
    }

    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        EnumDirection enumdirection = state.c(BlockFacingHorizontal.aE);
        boolean flag = state.c(b);
        switch (state.c(BlockAttachable.K)) {
            case a: {
                if (enumdirection.o() == EnumDirection.EnumAxis.a) {
                    return flag ? o : g;
                }
                return flag ? F : h;
            }
            case b: {
                return switch (enumdirection) {
                    case EnumDirection.f -> flag ? J : l;
                    case EnumDirection.e -> flag ? I : k;
                    case EnumDirection.d -> flag ? H : j;
                    case EnumDirection.c, EnumDirection.b, EnumDirection.a -> flag ? G : i;
                    default -> throw new IncompatibleClassChangeError();
                };
            }
        }
        return enumdirection.o() == EnumDirection.EnumAxis.a ? (flag ? m : e) : (flag ? n : f);
    }

    @Override
    public EnumInteractionResult a(IBlockData state, World world, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hit) {
        if (state.c(b).booleanValue()) {
            return EnumInteractionResult.b;
        }
        boolean powered = state.c(b);
        org.bukkit.block.Block block = world.getWorld().getBlockAt(pos.u(), pos.v(), pos.w());
        int old = powered ? 15 : 0;
        int current = !powered ? 15 : 0;
        BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent(block, old, current);
        world.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
        if (eventRedstone.getNewCurrent() > 0 != !powered) {
            return EnumInteractionResult.a;
        }
        this.d(state, world, pos);
        this.a(player, (GeneratorAccess)world, pos, true);
        world.a((net.minecraft.world.entity.Entity)player, GameEvent.a, pos);
        return EnumInteractionResult.a(world.B);
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, Explosion explosion, BiConsumer<ItemStack, BlockPosition> stackMerger) {
        if (explosion.j() == Explosion.Effect.d && !world.y_() && !state.c(b).booleanValue()) {
            this.d(state, world, pos);
        }
        super.a(state, world, pos, explosion, stackMerger);
    }

    public void d(IBlockData state, World world, BlockPosition pos) {
        world.a(pos, (IBlockData)state.a(b, true), 3);
        this.f(state, world, pos);
        world.a(pos, (Block)this, this.O);
    }

    protected void a(@Nullable EntityHuman player, GeneratorAccess world, BlockPosition pos, boolean powered) {
        world.a(powered ? player : null, pos, this.a(powered), SoundCategory.e);
    }

    protected SoundEffect a(boolean powered) {
        return powered ? this.N.o() : this.N.n();
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, IBlockData newState, boolean moved) {
        if (!moved && !state.a(newState.b())) {
            if (state.c(b).booleanValue()) {
                this.f(state, world, pos);
            }
            super.a(state, world, pos, newState, moved);
        }
    }

    @Override
    public int a(IBlockData state, IBlockAccess world, BlockPosition pos, EnumDirection direction) {
        return state.c(b) != false ? 15 : 0;
    }

    @Override
    public int b(IBlockData state, IBlockAccess world, BlockPosition pos, EnumDirection direction) {
        return state.c(b) != false && BlockButtonAbstract.h(state) == direction ? 15 : 0;
    }

    @Override
    public boolean f_(IBlockData state) {
        return true;
    }

    @Override
    public void a(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        if (state.c(b).booleanValue()) {
            this.e(state, world, pos);
        }
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, net.minecraft.world.entity.Entity entity) {
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(world, pos)).callEvent()) {
            return;
        }
        if (!world.B && this.N.e() && !state.c(b).booleanValue()) {
            this.e(state, world, pos);
        }
    }

    protected void e(IBlockData state, World world, BlockPosition pos) {
        EntityArrow entityarrow = this.N.e() ? (EntityArrow)world.a(EntityArrow.class, state.j(world, pos).a().a(pos)).stream().findFirst().orElse(null) : null;
        boolean flag = entityarrow != null;
        boolean flag1 = state.c(b);
        if (flag1 != flag && flag) {
            org.bukkit.block.Block block = world.getWorld().getBlockAt(pos.u(), pos.v(), pos.w());
            EntityInteractEvent event = new EntityInteractEvent((Entity)entityarrow.getBukkitEntity(), block);
            world.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
        }
        if (flag != flag1) {
            boolean powered = flag1;
            org.bukkit.block.Block block = world.getWorld().getBlockAt(pos.u(), pos.v(), pos.w());
            int old = powered ? 15 : 0;
            int current = !powered ? 15 : 0;
            BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent(block, old, current);
            world.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
            if (flag && eventRedstone.getNewCurrent() <= 0 || !flag && eventRedstone.getNewCurrent() > 0) {
                return;
            }
            world.a(pos, (IBlockData)state.a(b, flag), 3);
            this.f(state, world, pos);
            this.a((EntityHuman)null, (GeneratorAccess)world, pos, flag);
            world.a((net.minecraft.world.entity.Entity)entityarrow, flag ? GameEvent.a : GameEvent.e, pos);
        }
        if (flag) {
            world.a(new BlockPosition(pos), (Block)this, this.O);
        }
    }

    private void f(IBlockData state, World world, BlockPosition pos) {
        world.a(pos, this);
        world.a(pos.a(BlockButtonAbstract.h(state).g()), this);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(BlockFacingHorizontal.aE, b, BlockAttachable.K);
    }
}

