/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.UtilColor;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.CommandBlockListenerAbstract;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDirectional;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.slf4j.Logger;

public class BlockCommand
extends BlockTileEntity
implements GameMasterBlock {
    public static final MapCodec<BlockCommand> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("automatic").forGetter(blockcommand -> blockcommand.e), BlockCommand.u()).apply((Applicative)instance, BlockCommand::new));
    private static final Logger d = LogUtils.getLogger();
    public static final BlockStateDirection b = BlockDirectional.a;
    public static final BlockStateBoolean c = BlockProperties.c;
    private final boolean e;

    public MapCodec<BlockCommand> a() {
        return a;
    }

    public BlockCommand(boolean auto, BlockBase.Info settings) {
        super(settings);
        this.k((IBlockData)((IBlockData)this.E.b().a(b, EnumDirection.c)).a(c, false));
        this.e = auto;
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        TileEntityCommand tileentitycommand = new TileEntityCommand(pos, state);
        tileentitycommand.b(this.e);
        return tileentitycommand;
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, Block sourceBlock, BlockPosition sourcePos, boolean notify) {
        TileEntity tileentity;
        if (!world.B && (tileentity = world.c_(pos)) instanceof TileEntityCommand) {
            TileEntityCommand tileentitycommand = (TileEntityCommand)tileentity;
            boolean flag1 = world.C(pos);
            boolean flag2 = tileentitycommand.d();
            org.bukkit.block.Block bukkitBlock = world.getWorld().getBlockAt(pos.u(), pos.v(), pos.w());
            int old = flag2 ? 15 : 0;
            int current = flag1 ? 15 : 0;
            BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent(bukkitBlock, old, current);
            world.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
            flag1 = eventRedstone.getNewCurrent() > 0;
            tileentitycommand.a(flag1);
            if (!flag2 && !tileentitycommand.f() && tileentitycommand.m() != TileEntityCommand.Type.a && flag1) {
                tileentitycommand.l();
                world.a(pos, (Block)this, 1);
            }
        }
    }

    @Override
    public void a(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        TileEntity tileentity = world.c_(pos);
        if (tileentity instanceof TileEntityCommand) {
            TileEntityCommand tileentitycommand = (TileEntityCommand)tileentity;
            CommandBlockListenerAbstract commandblocklistenerabstract = tileentitycommand.c();
            boolean flag = !UtilColor.b(commandblocklistenerabstract.m());
            TileEntityCommand.Type tileentitycommand_type = tileentitycommand.m();
            boolean flag1 = tileentitycommand.k();
            if (tileentitycommand_type == TileEntityCommand.Type.b) {
                tileentitycommand.l();
                if (flag1) {
                    this.a(state, (World)world, pos, commandblocklistenerabstract, flag);
                } else if (tileentitycommand.w()) {
                    commandblocklistenerabstract.a(0);
                }
                if (tileentitycommand.d() || tileentitycommand.f()) {
                    world.a(pos, (Block)this, 1);
                }
            } else if (tileentitycommand_type == TileEntityCommand.Type.c) {
                if (flag1) {
                    this.a(state, (World)world, pos, commandblocklistenerabstract, flag);
                } else if (tileentitycommand.w()) {
                    commandblocklistenerabstract.a(0);
                }
            }
            world.c(pos, this);
        }
    }

    private void a(IBlockData state, World world, BlockPosition pos, CommandBlockListenerAbstract executor, boolean hasCommand) {
        if (hasCommand) {
            executor.a(world);
        } else {
            executor.a(0);
        }
        BlockCommand.a(world, pos, state.c(b));
    }

    @Override
    public EnumInteractionResult a(IBlockData state, World world, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hit) {
        TileEntity tileentity = world.c_(pos);
        if (tileentity instanceof TileEntityCommand && (player.gp() || player.f() && player.getBukkitEntity().hasPermission("minecraft.commandblock"))) {
            player.a((TileEntityCommand)tileentity);
            return EnumInteractionResult.a(world.B);
        }
        return EnumInteractionResult.d;
    }

    @Override
    public boolean d_(IBlockData state) {
        return true;
    }

    @Override
    public int a(IBlockData state, World world, BlockPosition pos) {
        TileEntity tileentity = world.c_(pos);
        return tileentity instanceof TileEntityCommand ? ((TileEntityCommand)tileentity).c().k() : 0;
    }

    @Override
    public void a(World world, BlockPosition pos, IBlockData state, EntityLiving placer, ItemStack itemStack) {
        TileEntity tileentity = world.c_(pos);
        if (tileentity instanceof TileEntityCommand) {
            TileEntityCommand tileentitycommand = (TileEntityCommand)tileentity;
            CommandBlockListenerAbstract commandblocklistenerabstract = tileentitycommand.c();
            if (itemStack.A()) {
                commandblocklistenerabstract.b(itemStack.y());
            }
            if (!world.B) {
                if (ItemBlock.a(itemStack) == null) {
                    commandblocklistenerabstract.a(world.Z().b(GameRules.p));
                    tileentitycommand.b(this.e);
                }
                if (tileentitycommand.m() == TileEntityCommand.Type.a) {
                    boolean flag = world.C(pos);
                    tileentitycommand.a(flag);
                }
            }
        }
    }

    @Override
    public EnumRenderType b_(IBlockData state) {
        return EnumRenderType.c;
    }

    @Override
    public IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.a(b, rotation.a(state.c(b)));
    }

    @Override
    public IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(b)));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, c);
    }

    @Override
    public IBlockData a(BlockActionContext ctx) {
        return (IBlockData)this.o().a(b, ctx.d().g());
    }

    private static void a(World world, BlockPosition pos, EnumDirection facing) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = pos.j();
        GameRules gamerules = world.Z();
        int i2 = gamerules.c(GameRules.x);
        while (i2-- > 0) {
            TileEntityCommand tileentitycommand;
            TileEntity tileentity;
            blockposition_mutableblockposition.c(facing);
            IBlockData iblockdata = world.a_(blockposition_mutableblockposition);
            Block block = iblockdata.b();
            if (!iblockdata.a(Blocks.kH) || !((tileentity = world.c_(blockposition_mutableblockposition)) instanceof TileEntityCommand) || (tileentitycommand = (TileEntityCommand)tileentity).m() != TileEntityCommand.Type.a) break;
            if (tileentitycommand.d() || tileentitycommand.f()) {
                CommandBlockListenerAbstract commandblocklistenerabstract = tileentitycommand.c();
                if (tileentitycommand.l()) {
                    if (!commandblocklistenerabstract.a(world)) break;
                    world.c((BlockPosition)blockposition_mutableblockposition, block);
                } else if (tileentitycommand.w()) {
                    commandblocklistenerabstract.a(0);
                }
            }
            facing = iblockdata.c(b);
        }
        if (i2 <= 0) {
            int j2 = Math.max(gamerules.c(GameRules.x), 0);
            d.warn("Command Block chain tried to execute more than {} steps!", (Object)j2);
        }
    }
}

