/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.block.CompostItemEvent;
import io.papermc.paper.event.entity.EntityCompostItemEvent;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventoryHolder;
import net.minecraft.world.IWorldInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_20_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftBlockInventoryHolder;
import org.bukkit.craftbukkit.v1_20_R3.util.DummyGeneratorAccess;
import org.bukkit.entity.Entity;

public class BlockComposter
extends Block
implements IInventoryHolder {
    public static final MapCodec<BlockComposter> a = BlockComposter.b(BlockComposter::new);
    public static final int b = 8;
    public static final int c = 0;
    public static final int d = 7;
    public static final BlockStateInteger e = BlockProperties.aL;
    public static final Object2FloatMap<IMaterial> f = new Object2FloatOpenHashMap();
    private static final int g = 2;
    private static final VoxelShape h = VoxelShapes.b();
    private static final VoxelShape[] i = SystemUtils.a(new VoxelShape[9], (? super T avoxelshape) -> {
        for (int i2 = 0; i2 < 8; ++i2) {
            avoxelshape[i2] = VoxelShapes.a(h, Block.a(2.0, Math.max(2, 1 + i2 * 2), 2.0, 14.0, 16.0, 14.0), OperatorBoolean.e);
        }
        avoxelshape[8] = avoxelshape[7];
    });

    public MapCodec<BlockComposter> a() {
        return a;
    }

    public static void b() {
        f.defaultReturnValue(-1.0f);
        float f2 = 0.3f;
        float f1 = 0.5f;
        float f22 = 0.65f;
        float f3 = 0.85f;
        float f4 = 1.0f;
        BlockComposter.a(0.3f, Items.cw);
        BlockComposter.a(0.3f, Items.ct);
        BlockComposter.a(0.3f, Items.cu);
        BlockComposter.a(0.3f, Items.cz);
        BlockComposter.a(0.3f, Items.cx);
        BlockComposter.a(0.3f, Items.cy);
        BlockComposter.a(0.3f, Items.cv);
        BlockComposter.a(0.3f, Items.cB);
        BlockComposter.a(0.3f, Items.cA);
        BlockComposter.a(0.3f, Items.W);
        BlockComposter.a(0.3f, Items.X);
        BlockComposter.a(0.3f, Items.Y);
        BlockComposter.a(0.3f, Items.Z);
        BlockComposter.a(0.3f, Items.aa);
        BlockComposter.a(0.3f, Items.ab);
        BlockComposter.a(0.3f, Items.ac);
        BlockComposter.a(0.3f, Items.ad);
        BlockComposter.a(0.3f, Items.ve);
        BlockComposter.a(0.3f, Items.rU);
        BlockComposter.a(0.3f, Items.cM);
        BlockComposter.a(0.3f, Items.dJ);
        BlockComposter.a(0.3f, Items.rW);
        BlockComposter.a(0.3f, Items.rV);
        BlockComposter.a(0.3f, Items.cR);
        BlockComposter.a(0.3f, Items.wi);
        BlockComposter.a(0.3f, Items.wj);
        BlockComposter.a(0.3f, Items.ps);
        BlockComposter.a(0.3f, Items.dK);
        BlockComposter.a(0.3f, Items.dL);
        BlockComposter.a(0.3f, Items.dP);
        BlockComposter.a(0.3f, Items.dN);
        BlockComposter.a(0.3f, Items.bJ);
        BlockComposter.a(0.3f, Items.vb);
        BlockComposter.a(0.3f, Items.vc);
        BlockComposter.a(0.5f, Items.qK);
        BlockComposter.a(0.5f, Items.ia);
        BlockComposter.a(0.5f, Items.cC);
        BlockComposter.a(0.5f, Items.eV);
        BlockComposter.a(0.5f, Items.dI);
        BlockComposter.a(0.5f, Items.fU);
        BlockComposter.a(0.5f, Items.dF);
        BlockComposter.a(0.5f, Items.dG);
        BlockComposter.a(0.5f, Items.dH);
        BlockComposter.a(0.5f, Items.rT);
        BlockComposter.a(0.5f, Items.fV);
        BlockComposter.a(0.65f, Items.cS);
        BlockComposter.a(0.65f, Items.ga);
        BlockComposter.a(0.65f, Items.fj);
        BlockComposter.a(0.65f, Items.fk);
        BlockComposter.a(0.65f, Items.fT);
        BlockComposter.a(0.65f, Items.oq);
        BlockComposter.a(0.65f, Items.vd);
        BlockComposter.a(0.65f, Items.tY);
        BlockComposter.a(0.65f, Items.re);
        BlockComposter.a(0.65f, Items.tZ);
        BlockComposter.a(0.65f, Items.pt);
        BlockComposter.a(0.65f, Items.dz);
        BlockComposter.a(0.65f, Items.dA);
        BlockComposter.a(0.65f, Items.fP);
        BlockComposter.a(0.65f, Items.dB);
        BlockComposter.a(0.65f, Items.dC);
        BlockComposter.a(0.65f, Items.sg);
        BlockComposter.a(0.65f, Items.dD);
        BlockComposter.a(0.65f, Items.dE);
        BlockComposter.a(0.65f, Items.wm);
        BlockComposter.a(0.65f, Items.dj);
        BlockComposter.a(0.65f, Items.dk);
        BlockComposter.a(0.65f, Items.dl);
        BlockComposter.a(0.65f, Items.dm);
        BlockComposter.a(0.65f, Items.dn);
        BlockComposter.a(0.65f, Items.do);
        BlockComposter.a(0.65f, Items.dp);
        BlockComposter.a(0.65f, Items.dq);
        BlockComposter.a(0.65f, Items.dr);
        BlockComposter.a(0.65f, Items.ds);
        BlockComposter.a(0.65f, Items.dt);
        BlockComposter.a(0.65f, Items.du);
        BlockComposter.a(0.65f, Items.dv);
        BlockComposter.a(0.65f, Items.cN);
        BlockComposter.a(0.65f, Items.hW);
        BlockComposter.a(0.65f, Items.hX);
        BlockComposter.a(0.65f, Items.hY);
        BlockComposter.a(0.65f, Items.hZ);
        BlockComposter.a(0.65f, Items.ib);
        BlockComposter.a(0.65f, Items.dy);
        BlockComposter.a(0.65f, Items.cO);
        BlockComposter.a(0.65f, Items.dM);
        BlockComposter.a(0.65f, Items.dO);
        BlockComposter.a(0.85f, Items.hC);
        BlockComposter.a(0.85f, Items.fN);
        BlockComposter.a(0.85f, Items.fO);
        BlockComposter.a(0.85f, Items.iW);
        BlockComposter.a(0.85f, Items.iX);
        BlockComposter.a(0.85f, Items.cP);
        BlockComposter.a(0.85f, Items.pu);
        BlockComposter.a(0.85f, Items.ua);
        BlockComposter.a(0.85f, Items.rP);
        BlockComposter.a(0.85f, Items.dw);
        BlockComposter.a(0.85f, Items.dx);
        BlockComposter.a(1.0f, Items.ry);
        BlockComposter.a(1.0f, Items.um);
    }

    private static void a(float levelIncreaseChance, IMaterial item) {
        f.put((Object)item.k(), levelIncreaseChance);
    }

    public BlockComposter(BlockBase.Info settings) {
        super(settings);
        this.k((IBlockData)this.E.b().a(e, 0));
    }

    public static void a(World world, BlockPosition pos, boolean fill) {
        IBlockData iblockdata = world.a_(pos);
        world.a(pos, fill ? SoundEffects.eR : SoundEffects.eQ, SoundCategory.e, 1.0f, 1.0f, false);
        double d0 = iblockdata.j(world, pos).b(EnumDirection.EnumAxis.b, 0.5, 0.5) + 0.03125;
        double d1 = 0.13125f;
        double d2 = 0.7375f;
        RandomSource randomsource = world.F_();
        for (int i2 = 0; i2 < 10; ++i2) {
            double d3 = randomsource.k() * 0.02;
            double d4 = randomsource.k() * 0.02;
            double d5 = randomsource.k() * 0.02;
            world.a(Particles.N, (double)pos.u() + (double)0.13125f + (double)0.7375f * (double)randomsource.i(), (double)pos.v() + d0 + (double)randomsource.i() * (1.0 - d0), (double)pos.w() + (double)0.13125f + (double)0.7375f * (double)randomsource.i(), d3, d4, d5);
        }
    }

    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return i[state.c(e)];
    }

    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos) {
        return h;
    }

    @Override
    public VoxelShape b(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return i[0];
    }

    @Override
    public void b(IBlockData state, World world, BlockPosition pos, IBlockData oldState, boolean notify) {
        if (state.c(e) == 7) {
            world.a(pos, state.b(), 20);
        }
    }

    @Override
    public EnumInteractionResult a(IBlockData state, World world, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hit) {
        int i2 = state.c(e);
        ItemStack itemstack = player.b(hand);
        if (i2 < 8 && f.containsKey((Object)itemstack.d())) {
            IBlockData newState = BlockComposter.process(i2, state, world, itemstack, pos, player);
            if (newState == null) {
                return EnumInteractionResult.d;
            }
            if (world.purpurConfig.composterBulkProcess && player.bS() && newState != state) {
                IBlockData oldState;
                int oldLevel;
                int newLevel;
                int oldCount;
                int newCount;
                do {
                    oldState = newState;
                    oldCount = itemstack.L();
                    oldLevel = oldState.c(e);
                    newState = BlockComposter.process(oldLevel, oldState, world, itemstack, pos, player);
                    if (newState == null) {
                        return EnumInteractionResult.d;
                    }
                    newCount = itemstack.L();
                    newLevel = newState.c(e);
                } while (newCount > 0 && (newCount != oldCount || newLevel != oldLevel || newState != oldState));
            }
            return EnumInteractionResult.a(world.B);
        }
        if (i2 == 8) {
            BlockComposter.a((net.minecraft.world.entity.Entity)player, state, world, pos);
            return EnumInteractionResult.a(world.B);
        }
        return EnumInteractionResult.d;
    }

    private static IBlockData process(int level, IBlockData state, World world, ItemStack itemstack, BlockPosition pos, EntityHuman player) {
        if (level < 7 && !world.B) {
            IBlockData iblockdata1 = BlockComposter.a((net.minecraft.world.entity.Entity)player, state, (GeneratorAccess)world, pos, itemstack);
            if (iblockdata1 == null) {
                return iblockdata1;
            }
            world.c(1500, pos, state != iblockdata1 ? 1 : 0);
            player.b(StatisticList.c.b(itemstack.d()));
            if (!player.fT().d) {
                itemstack.h(1);
            }
            return iblockdata1;
        }
        return state;
    }

    public static IBlockData a(net.minecraft.world.entity.Entity user, IBlockData state, WorldServer world, ItemStack stack, BlockPosition pos) {
        int i2 = state.c(e);
        if (i2 < 7 && f.containsKey((Object)stack.d())) {
            double rand = world.F_().j();
            IBlockData iblockdata1 = null;
            iblockdata1 = BlockComposter.addItem(user, state, world, pos, stack, rand);
            if (iblockdata1 == null) {
                return state;
            }
            stack.h(1);
            return iblockdata1;
        }
        return state;
    }

    public static IBlockData a(net.minecraft.world.entity.Entity user, IBlockData state, World world, BlockPosition pos) {
        IBlockData iblockdata1;
        if (user != null && !(user instanceof EntityHuman) && !CraftEventFactory.callEntityChangeBlockEvent(user, pos, iblockdata1 = BlockComposter.a(user, state, (GeneratorAccess)DummyGeneratorAccess.INSTANCE, pos))) {
            return state;
        }
        if (!world.B) {
            Vec3D vec3d = Vec3D.a(pos, 0.5, 1.01, 0.5).a(world.z, 0.7f);
            EntityItem entityitem = new EntityItem(world, vec3d.a(), vec3d.b(), vec3d.c(), new ItemStack(Items.rv));
            entityitem.u();
            world.b(entityitem);
        }
        iblockdata1 = BlockComposter.a(user, state, (GeneratorAccess)world, pos);
        world.a((EntityHuman)null, pos, SoundEffects.eP, SoundCategory.e, 1.0f, 1.0f);
        return iblockdata1;
    }

    static IBlockData a(@Nullable net.minecraft.world.entity.Entity user, IBlockData state, GeneratorAccess world, BlockPosition pos) {
        IBlockData iblockdata1 = (IBlockData)state.a(e, 0);
        world.a(pos, iblockdata1, 3);
        world.a(GameEvent.c, pos, GameEvent.a.a(user, iblockdata1));
        return iblockdata1;
    }

    @Nullable
    static IBlockData a(@Nullable net.minecraft.world.entity.Entity user, IBlockData state, GeneratorAccess world, BlockPosition pos, ItemStack stack) {
        return BlockComposter.addItem(user, state, world, pos, stack, world.F_().j());
    }

    @Nullable
    static IBlockData addItem(@Nullable net.minecraft.world.entity.Entity entity, IBlockData iblockdata, GeneratorAccess generatoraccess, BlockPosition blockposition, ItemStack itemstack, double rand) {
        int i2 = iblockdata.c(e);
        float f2 = f.getFloat((Object)itemstack.d());
        boolean willRaiseLevel = i2 == 0 && !(f2 <= 0.0f) || !(rand >= (double)f2);
        Object event = entity == null ? new CompostItemEvent((org.bukkit.block.Block)CraftBlock.at(generatoraccess, blockposition), itemstack.getBukkitStack(), willRaiseLevel) : new EntityCompostItemEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(generatoraccess, blockposition), itemstack.getBukkitStack(), willRaiseLevel);
        if (!event.callEvent()) {
            return null;
        }
        willRaiseLevel = event.willRaiseLevel();
        if (!willRaiseLevel) {
            return iblockdata;
        }
        int j2 = i2 + 1;
        IBlockData iblockdata1 = (IBlockData)iblockdata.a(e, j2);
        if (entity != null && !CraftEventFactory.callEntityChangeBlockEvent(entity, blockposition, iblockdata1)) {
            return null;
        }
        generatoraccess.a(blockposition, iblockdata1, 3);
        generatoraccess.a(GameEvent.c, blockposition, GameEvent.a.a(entity, iblockdata1));
        if (j2 == 7) {
            generatoraccess.a(blockposition, iblockdata.b(), 20);
        }
        return iblockdata1;
    }

    @Override
    public void a(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        if (state.c(e) == 7) {
            world.a(pos, (IBlockData)state.a(e), 3);
            world.a((EntityHuman)null, pos, SoundEffects.eS, SoundCategory.e, 1.0f, 1.0f);
        }
    }

    @Override
    public boolean d_(IBlockData state) {
        return true;
    }

    @Override
    public int a(IBlockData state, World world, BlockPosition pos) {
        return state.c(e);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{e});
    }

    @Override
    public boolean a(IBlockData state, IBlockAccess world, BlockPosition pos, PathMode type) {
        return false;
    }

    @Override
    public IWorldInventory a(IBlockData state, GeneratorAccess world, BlockPosition pos) {
        int i2 = state.c(e);
        return (IWorldInventory)((Object)(i2 == 8 ? new ContainerOutput(state, world, pos, new ItemStack(Items.rv)) : (i2 < 7 ? new ContainerInput(state, world, pos) : new ContainerEmpty(world, pos))));
    }

    public static class ContainerOutput
    extends InventorySubcontainer
    implements IWorldInventory {
        private final IBlockData c;
        private final GeneratorAccess d;
        private final BlockPosition e;
        private boolean f;

        public ContainerOutput(IBlockData state, GeneratorAccess world, BlockPosition pos, ItemStack outputItem) {
            super(outputItem);
            this.c = state;
            this.d = world;
            this.e = pos;
            this.bukkitOwner = new CraftBlockInventoryHolder(world, pos, this);
        }

        @Override
        public int ak_() {
            return 1;
        }

        @Override
        public int[] a(EnumDirection side) {
            int[] nArray;
            if (side == EnumDirection.a) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            } else {
                nArray = new int[]{};
            }
            return nArray;
        }

        @Override
        public boolean a(int slot, ItemStack stack, @Nullable EnumDirection dir) {
            return false;
        }

        @Override
        public boolean b(int slot, ItemStack stack, EnumDirection dir) {
            return !this.f && dir == EnumDirection.a && stack.a(Items.rv);
        }

        @Override
        public void e() {
            if (this.ai_()) {
                BlockComposter.a((net.minecraft.world.entity.Entity)null, this.c, this.d, this.e);
                this.f = true;
            } else {
                this.d.a(this.e, this.c, 3);
                this.f = false;
            }
        }
    }

    public static class ContainerInput
    extends InventorySubcontainer
    implements IWorldInventory {
        private final IBlockData c;
        private final GeneratorAccess d;
        private final BlockPosition e;
        private boolean f;

        public ContainerInput(IBlockData state, GeneratorAccess world, BlockPosition pos) {
            super(1);
            this.bukkitOwner = new CraftBlockInventoryHolder(world, pos, this);
            this.c = state;
            this.d = world;
            this.e = pos;
        }

        @Override
        public int ak_() {
            return 1;
        }

        @Override
        public int[] a(EnumDirection side) {
            int[] nArray;
            if (side == EnumDirection.b) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            } else {
                nArray = new int[]{};
            }
            return nArray;
        }

        @Override
        public boolean a(int slot, ItemStack stack, @Nullable EnumDirection dir) {
            return !this.f && dir == EnumDirection.b && f.containsKey((Object)stack.d());
        }

        @Override
        public boolean b(int slot, ItemStack stack, EnumDirection dir) {
            return false;
        }

        @Override
        public void e() {
            ItemStack itemstack = this.a(0);
            if (!itemstack.b()) {
                this.f = true;
                IBlockData iblockdata = BlockComposter.a((net.minecraft.world.entity.Entity)null, this.c, this.d, this.e, itemstack);
                if (iblockdata == null) {
                    return;
                }
                this.d.c(1500, this.e, iblockdata != this.c ? 1 : 0);
                this.b(0);
            }
        }
    }

    public static class ContainerEmpty
    extends InventorySubcontainer
    implements IWorldInventory {
        public ContainerEmpty(GeneratorAccess generatoraccess, BlockPosition blockposition) {
            super(0);
            this.bukkitOwner = new CraftBlockInventoryHolder(generatoraccess, blockposition, this);
        }

        @Override
        public int[] a(EnumDirection side) {
            return new int[0];
        }

        @Override
        public boolean a(int slot, ItemStack stack, @Nullable EnumDirection dir) {
            return false;
        }

        @Override
        public boolean b(int slot, ItemStack stack, EnumDirection dir) {
            return false;
        }
    }
}

