/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public abstract class BlockCoralBase
extends Block
implements IBlockWaterlogged {
    public static final BlockStateBoolean d = BlockProperties.C;
    private static final VoxelShape a = Block.a(2.0, 0.0, 2.0, 14.0, 4.0, 14.0);

    protected BlockCoralBase(BlockBase.Info settings) {
        super(settings);
        this.k((IBlockData)this.E.b().a(d, true));
    }

    protected abstract MapCodec<? extends BlockCoralBase> a();

    protected void a(IBlockData state, GeneratorAccess world, BlockPosition pos) {
        if (!BlockCoralBase.e(state, world, pos)) {
            world.a(pos, this, 60 + world.F_().a(40));
        }
    }

    protected static boolean e(IBlockData state, IBlockAccess world, BlockPosition pos) {
        if (!((GeneratorAccess)world).getMinecraftWorld().purpurConfig.coralDieOutsideWater) {
            return true;
        }
        if (state.c(d).booleanValue()) {
            return true;
        }
        for (EnumDirection direction : EnumDirection.values()) {
            if (!world.b_(pos.a(direction)).a(TagsFluid.a)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext ctx) {
        Fluid fluidState = ctx.q().b_(ctx.a());
        return (IBlockData)this.o().a(d, fluidState.a(TagsFluid.a) && fluidState.e() == 8);
    }

    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return a;
    }

    @Override
    public IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        if (state.c(d).booleanValue()) {
            world.a(pos, FluidTypes.c, FluidTypes.c.a(world));
        }
        return direction == EnumDirection.a && !this.a(state, (IWorldReader)world, pos) ? Blocks.a.o() : super.a(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public boolean a(IBlockData state, IWorldReader world, BlockPosition pos) {
        BlockPosition blockPos = pos.d();
        return world.a_(blockPos).d(world, blockPos, EnumDirection.b);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{d});
    }

    @Override
    public Fluid c_(IBlockData state) {
        return state.c(d) != false ? FluidTypes.c.a(false) : super.c_(state);
    }
}

