/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockGrowingAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;

public abstract class BlockGrowingTop
extends BlockGrowingAbstract
implements IBlockFragilePlantElement {
    public static final BlockStateInteger e = BlockProperties.ax;
    public static final int f = 25;
    private final double c;

    protected BlockGrowingTop(BlockBase.Info settings, EnumDirection growthDirection, VoxelShape outlineShape, boolean tickWater, double growthChance) {
        super(settings, growthDirection, outlineShape, tickWater);
        this.c = growthChance;
        this.k((IBlockData)this.E.b().a(e, 0));
    }

    protected abstract MapCodec<? extends BlockGrowingTop> a();

    @Override
    public IBlockData a(GeneratorAccess world) {
        return (IBlockData)this.o().a(e, world.F_().a(this.getMaxGrowthAge()));
    }

    @Override
    public boolean e_(IBlockData state) {
        return state.c(e) < this.getMaxGrowthAge();
    }

    @Override
    public void b(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        BlockPosition blockposition1;
        int modifier = this == Blocks.mc ? world.spigotConfig.kelpModifier : (this == Blocks.oB ? world.spigotConfig.twistingVinesModifier : (this == Blocks.oz ? world.spigotConfig.weepingVinesModifier : world.spigotConfig.caveVinesModifier));
        if (state.c(e) < this.getMaxGrowthAge() && random.j() < (double)modifier / 100.0 * this.c && this.g(world.a_(blockposition1 = pos.a(this.a)))) {
            CraftEventFactory.handleBlockSpreadEvent(world, pos, blockposition1, this.getGrowIntoState(state, world.z, world));
        }
    }

    protected IBlockData getGrowIntoState(IBlockData state, RandomSource random, @Nullable World level) {
        return this.a(state, random);
    }

    protected IBlockData a(IBlockData state, RandomSource random) {
        return (IBlockData)state.a(e);
    }

    public IBlockData n(IBlockData state) {
        return (IBlockData)state.a(e, this.getMaxGrowthAge());
    }

    public boolean o(IBlockData state) {
        return state.c(e) >= this.getMaxGrowthAge();
    }

    protected IBlockData a(IBlockData from, IBlockData to) {
        return to;
    }

    @Override
    public IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        if (direction == this.a.g() && !state.a(world, pos)) {
            world.a(pos, this, 1);
        }
        if (direction == this.a && (neighborState.a(this) || neighborState.a(this.b()))) {
            return this.a(state, this.b().o());
        }
        if (this.b) {
            world.a(pos, FluidTypes.c, FluidTypes.c.a(world));
        }
        return super.a(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{e});
    }

    @Override
    public boolean b(IWorldReader world, BlockPosition pos, IBlockData state) {
        return this.g(world.a_(pos.a(this.a)));
    }

    @Override
    public boolean a(World world, RandomSource random, BlockPosition pos, IBlockData state) {
        return true;
    }

    @Override
    public void a(WorldServer world, RandomSource random, BlockPosition pos, IBlockData state) {
        BlockPosition blockposition1 = pos.a(this.a);
        int i2 = Math.min(state.c(e) + 1, this.getMaxGrowthAge());
        int j2 = this.a(random);
        for (int k2 = 0; k2 < j2 && this.g(world.a_(blockposition1)); ++k2) {
            world.b(blockposition1, (IBlockData)state.a(e, i2));
            blockposition1 = blockposition1.a(this.a);
            i2 = Math.min(i2 + 1, this.getMaxGrowthAge());
        }
    }

    protected abstract int a(RandomSource var1);

    protected abstract boolean g(IBlockData var1);

    @Override
    protected BlockGrowingTop c() {
        return this;
    }

    public abstract int getMaxGrowthAge();
}

