/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.Spawner;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityMobSpawner;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;

public class BlockMobSpawner
extends BlockTileEntity {
    public static final MapCodec<BlockMobSpawner> a = BlockMobSpawner.b(BlockMobSpawner::new);

    public MapCodec<BlockMobSpawner> a() {
        return a;
    }

    protected BlockMobSpawner(BlockBase.Info settings) {
        super(settings);
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityMobSpawner(pos, state);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> a(World world, IBlockData state, TileEntityTypes<T> type) {
        return BlockMobSpawner.a(type, TileEntityTypes.j, world.B ? TileEntityMobSpawner::a : TileEntityMobSpawner::b);
    }

    @Override
    public void playerDestroy(World level, EntityHuman player, BlockPosition pos, IBlockData state, @Nullable TileEntity blockEntity, ItemStack stack, boolean includeDrops, boolean dropExp) {
        if (level.purpurConfig.silkTouchEnabled && player.getBukkitEntity().hasPermission("purpur.drop.spawners") && this.isSilkTouch(level, stack)) {
            List<String> lore;
            Optional<EntityTypes<?>> type = EntityTypes.a(((TileEntityMobSpawner)blockEntity).d().f.a());
            EntityTypes entityType = type.orElse(null);
            Component mobName = PaperAdventure.asAdventure(entityType == null ? IChatBaseComponent.i() : entityType.h());
            NBTTagCompound display = new NBTTagCompound();
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagCompound blockEntityTag = blockEntity.ax_();
            blockEntityTag.r("Delay");
            tag.a("BlockEntityTag", blockEntityTag);
            String name = level.purpurConfig.silkTouchSpawnerName;
            if (name != null && !name.isEmpty() && !name.equals("Monster Spawner")) {
                Component displayName = MiniMessage.miniMessage().deserialize(name, (TagResolver)Placeholder.component((String)"mob", (ComponentLike)mobName));
                if (name.startsWith("<reset>")) {
                    displayName = displayName.decoration(TextDecoration.ITALIC, false);
                }
                display.a("Name", NBTTagString.a(PaperAdventure.asJsonString(displayName, Locale.ROOT)));
                tag.a("display", display);
            }
            if ((lore = level.purpurConfig.silkTouchSpawnerLore) != null && !lore.isEmpty()) {
                NBTTagList list = new NBTTagList();
                for (String line : lore) {
                    Component lineComponent = MiniMessage.miniMessage().deserialize(line, (TagResolver)Placeholder.component((String)"mob", (ComponentLike)mobName));
                    if (line.startsWith("<reset>")) {
                        lineComponent = lineComponent.decoration(TextDecoration.ITALIC, false);
                    }
                    list.add(NBTTagString.a(PaperAdventure.asJsonString(lineComponent, Locale.ROOT)));
                }
                display.a("Lore", list);
                tag.a("display", display);
            }
            ItemStack item = new ItemStack(Blocks.ct.k());
            if (entityType != null) {
                tag.a("HideFlags", (double)ItemStack.HideFlags.f.a());
                item.c(tag);
            }
            BlockMobSpawner.a(level, pos, item);
        }
        super.playerDestroy(level, player, pos, state, blockEntity, stack, includeDrops, dropExp);
    }

    private boolean isSilkTouch(World level, ItemStack stack) {
        return stack != null && level.purpurConfig.silkTouchTools.contains(stack.d()) && EnchantmentManager.a(Enchantments.v, stack) >= level.purpurConfig.minimumSilkTouchSpawnerRequire;
    }

    @Override
    public void a(IBlockData state, WorldServer world, BlockPosition pos, ItemStack tool, boolean dropExperience) {
        super.a(state, world, pos, tool, dropExperience);
    }

    @Override
    public int getExpDrop(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, ItemStack itemstack, boolean flag) {
        if (this.isSilkTouch(worldserver, itemstack)) {
            return 0;
        }
        if (flag) {
            int i2 = 15 + worldserver.z.a(15) + worldserver.z.a(15);
            return i2;
        }
        return 0;
    }

    @Override
    public EnumRenderType b_(IBlockData state) {
        return EnumRenderType.c;
    }

    @Override
    public void a(ItemStack stack, @Nullable IBlockAccess world, List<IChatBaseComponent> tooltip, TooltipFlag options) {
        super.a(stack, world, tooltip, options);
        Spawner.a(stack, tooltip, "SpawnData");
    }
}

