/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathMode;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.event.entity.EntityExhaustionEvent;

public abstract class BlockPlant
extends Block {
    protected BlockPlant(BlockBase.Info settings) {
        super(settings);
    }

    protected abstract MapCodec<? extends BlockPlant> a();

    protected boolean b(IBlockData floor, IBlockAccess world, BlockPosition pos) {
        return floor.a(TagsBlock.af) || floor.a(Blocks.cC);
    }

    @Override
    public IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        if (!(state.a(world, pos) || world instanceof WorldServer && ((WorldServer)world).hasPhysicsEvent && CraftEventFactory.callBlockPhysicsEvent(world, pos).isCancelled())) {
            return Blocks.a.o();
        }
        return super.a(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public boolean a(IBlockData state, IWorldReader world, BlockPosition pos) {
        BlockPosition blockposition1 = pos.d();
        return this.b(world.a_(blockposition1), world, blockposition1);
    }

    @Override
    public boolean a_(IBlockData state, IBlockAccess world, BlockPosition pos) {
        return state.u().c();
    }

    @Override
    public boolean a(IBlockData state, IBlockAccess world, BlockPosition pos, PathMode type) {
        return type == PathMode.c && !this.aG ? true : super.a(state, world, pos, type);
    }

    public void playerDestroyAndReplant(World world, EntityHuman player, BlockPosition pos, IBlockData state, @Nullable TileEntity blockEntity, ItemStack itemInHand, IMaterial itemToReplant) {
        player.b(StatisticList.a.b(this));
        player.causeFoodExhaustion(0.005f, EntityExhaustionEvent.ExhaustionReason.BLOCK_MINED);
        List<ItemStack> dropList = Block.a(state, (WorldServer)world, pos, blockEntity, (Entity)player, itemInHand);
        boolean planted = false;
        for (ItemStack itemToDrop : dropList) {
            if (!planted && itemToDrop.d() == itemToReplant) {
                world.a(pos, this.o(), 3);
                itemToDrop.f(itemToDrop.L() - 1);
                planted = true;
            }
            Block.a(world, pos, itemToDrop);
        }
        state.a((WorldServer)world, pos, itemInHand, true);
    }
}

