/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;

public class BlockReed
extends Block
implements IBlockFragilePlantElement {
    public static final MapCodec<BlockReed> a = BlockReed.b(BlockReed::new);
    public static final BlockStateInteger b = BlockProperties.aw;
    protected static final float c = 6.0f;
    protected static final VoxelShape d = Block.a(2.0, 0.0, 2.0, 14.0, 16.0, 14.0);

    public MapCodec<BlockReed> a() {
        return a;
    }

    protected BlockReed(BlockBase.Info settings) {
        super(settings);
        this.k((IBlockData)this.E.b().a(b, 0));
    }

    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return d;
    }

    @Override
    public void a(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        if (!state.a((IWorldReader)world, pos)) {
            world.b(pos, true);
        }
    }

    @Override
    public void b(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        if (world.u(pos.c())) {
            int i2 = 1;
            while (world.a_(pos.c(i2)).a(this)) {
                ++i2;
            }
            if (i2 < world.paperConfig().maxGrowthHeight.reeds) {
                int j2 = state.c(b);
                int modifier = world.spigotConfig.caneModifier;
                if (j2 >= 15 || modifier != 100 && random.i() < (float)modifier / 1600.0f) {
                    CraftEventFactory.handleBlockGrowEvent(world, pos.c(), this.o());
                    world.a(pos, (IBlockData)state.a(b, 0), 4);
                } else if (modifier == 100 || random.i() < (float)modifier / 1600.0f) {
                    world.a(pos, (IBlockData)state.a(b, j2 + 1), 4);
                }
            }
        }
    }

    @Override
    public IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        if (!state.a(world, pos)) {
            world.a(pos, this, 1);
        }
        return super.a(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public boolean a(IBlockData state, IWorldReader world, BlockPosition pos) {
        IBlockData iblockdata1 = world.a_(pos.d());
        if (iblockdata1.a(this)) {
            return true;
        }
        if (iblockdata1.a(TagsBlock.af) || iblockdata1.a(TagsBlock.H)) {
            BlockPosition blockposition1 = pos.d();
            for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.a) {
                IBlockData iblockdata2 = world.a_(blockposition1.a(enumdirection));
                Fluid fluid = world.b_(blockposition1.a(enumdirection));
                if (!fluid.a(TagsFluid.a) && !iblockdata2.a(Blocks.kI)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{b});
    }

    @Override
    public boolean b(IWorldReader world, BlockPosition pos, IBlockData state) {
        if (!((World)world).purpurConfig.sugarCanAffectedByBonemeal || !world.u(pos.c())) {
            return false;
        }
        int reedHeight = 0;
        while (world.a_(pos.c(reedHeight)).a(this)) {
            ++reedHeight;
        }
        return reedHeight < ((World)world).paperConfig().maxGrowthHeight.reeds;
    }

    @Override
    public boolean a(World world, RandomSource random, BlockPosition pos, IBlockData state) {
        return true;
    }

    @Override
    public void a(WorldServer world, RandomSource random, BlockPosition pos, IBlockData state) {
        int reedHeight = 0;
        while (world.a_(pos.c(reedHeight)).a(this)) {
            ++reedHeight;
        }
        for (int i2 = 0; i2 <= world.paperConfig().maxGrowthHeight.reeds - reedHeight; ++i2) {
            world.b(pos.b(i2), (IBlockData)state.a(b, 0));
        }
    }
}

