/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCobbleWall;
import net.minecraft.world.level.block.BlockFence;
import net.minecraft.world.level.block.BlockFenceGate;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.piston.BlockPistonMoving;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class BlockSoil
extends Block {
    public static final MapCodec<BlockSoil> a = BlockSoil.b(BlockSoil::new);
    public static final BlockStateInteger b = BlockProperties.aQ;
    protected static final VoxelShape c = Block.a(0.0, 0.0, 0.0, 16.0, 15.0, 16.0);
    public static final int d = 7;

    public MapCodec<BlockSoil> a() {
        return a;
    }

    protected BlockSoil(BlockBase.Info settings) {
        super(settings);
        this.k((IBlockData)this.E.b().a(b, 0));
    }

    @Override
    public IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        if (direction == EnumDirection.b && !state.a(world, pos)) {
            world.a(pos, this, 1);
        }
        return super.a(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public boolean a(IBlockData state, IWorldReader world, BlockPosition pos) {
        IBlockData iblockdata1 = world.a_(pos.c());
        return !iblockdata1.e() || iblockdata1.b() instanceof BlockFenceGate || iblockdata1.b() instanceof BlockPistonMoving;
    }

    @Override
    public IBlockData a(BlockActionContext ctx) {
        return !this.o().a((IWorldReader)ctx.q(), ctx.a()) ? Blocks.j.o() : super.a(ctx);
    }

    @Override
    public boolean g_(IBlockData state) {
        return true;
    }

    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return c;
    }

    @Override
    public void a(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        if (!state.a((IWorldReader)world, pos)) {
            BlockSoil.a((net.minecraft.world.entity.Entity)null, state, world, pos);
        }
    }

    @Override
    public void b(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        int i2 = state.c(b);
        if (i2 > 0 && world.paperConfig().tickRates.wetFarmland != 1 && (world.paperConfig().tickRates.wetFarmland < 1 || (MinecraftServer.currentTick + pos.hashCode()) % world.paperConfig().tickRates.wetFarmland != 0)) {
            return;
        }
        if (i2 == 0 && world.paperConfig().tickRates.dryFarmland != 1 && (world.paperConfig().tickRates.dryFarmland < 1 || (MinecraftServer.currentTick + pos.hashCode()) % world.paperConfig().tickRates.dryFarmland != 0)) {
            return;
        }
        if (!BlockSoil.a(world, pos) && !world.r(pos.c())) {
            if (i2 > 0) {
                CraftEventFactory.handleMoistureChangeEvent(world, pos, (IBlockData)state.a(b, i2 - 1), 2);
            } else if (!BlockSoil.a((IBlockAccess)world, pos)) {
                BlockSoil.a((net.minecraft.world.entity.Entity)null, state, world, pos);
            }
        } else if (i2 < 7) {
            CraftEventFactory.handleMoistureChangeEvent(world, pos, (IBlockData)state.a(b, 7), 2);
        }
    }

    @Override
    public void a(World world, IBlockData state, BlockPosition pos, net.minecraft.world.entity.Entity entity, float fallDistance) {
        super.a(world, state, pos, entity, fallDistance);
        if (!world.B && (world.purpurConfig.farmlandTrampleHeight >= 0.0 ? (double)fallDistance >= world.purpurConfig.farmlandTrampleHeight : world.z.i() < fallDistance - 0.5f) && entity instanceof EntityLiving && (entity instanceof EntityHuman || world.purpurConfig.farmlandBypassMobGriefing || world.Z().b(GameRules.c)) && entity.dg() * entity.dg() * entity.dh() > 0.512f) {
            Iterator<ItemStack> armor;
            Block block;
            PlayerInteractEvent cancellable;
            if (entity instanceof EntityHuman) {
                cancellable = CraftEventFactory.callPlayerInteractEvent((EntityHuman)entity, Action.PHYSICAL, pos, null, null, null);
            } else {
                cancellable = new EntityInteractEvent((Entity)entity.getBukkitEntity(), world.getWorld().getBlockAt(pos.u(), pos.v(), pos.w()));
                world.getCraftServer().getPluginManager().callEvent((Event)((EntityInteractEvent)cancellable));
            }
            if (cancellable.isCancelled()) {
                return;
            }
            if (world.purpurConfig.farmlandTramplingDisabled) {
                return;
            }
            if (world.purpurConfig.farmlandTramplingOnlyPlayers && !(entity instanceof EntityHuman)) {
                return;
            }
            if (world.purpurConfig.farmlandAlpha && ((block = world.a_(pos.d()).b()) instanceof BlockFence || block instanceof BlockCobbleWall)) {
                return;
            }
            if (world.purpurConfig.farmlandTramplingFeatherFalling && (armor = entity.bL().iterator()).hasNext() && EnchantmentManager.a(Enchantments.c, armor.next()) >= (int)entity.ab) {
                return;
            }
            if (!CraftEventFactory.callEntityChangeBlockEvent(entity, pos, Blocks.j.o())) {
                return;
            }
            BlockSoil.a(entity, state, world, pos);
        }
    }

    public static void a(@Nullable net.minecraft.world.entity.Entity entity, IBlockData state, World world, BlockPosition pos) {
        if (CraftEventFactory.callBlockFadeEvent(world, pos, Blocks.j.o()).isCancelled()) {
            return;
        }
        IBlockData iblockdata1 = BlockSoil.a(state, Blocks.j.o(), world, pos);
        world.b(pos, iblockdata1);
        world.a(GameEvent.c, pos, GameEvent.a.a(entity, iblockdata1));
    }

    private static boolean a(IBlockAccess world, BlockPosition pos) {
        return world.a_(pos.c()).a(TagsBlock.cp);
    }

    private static boolean a(IWorldReader world, BlockPosition pos) {
        int xOff = pos.u();
        int yOff = pos.v();
        int zOff = pos.w();
        for (int dz = -4; dz <= 4; ++dz) {
            int z2 = dz + zOff;
            for (int dx = -4; dx <= 4; ++dx) {
                int x2 = xOff + dx;
                for (int dy = 0; dy <= 1; ++dy) {
                    int y2 = dy + yOff;
                    Chunk chunk = (Chunk)world.a(x2 >> 4, z2 >> 4);
                    Fluid fluid = chunk.getBlockStateFinal(x2, y2, z2).u();
                    if (!fluid.a(TagsFluid.a)) continue;
                    return true;
                }
            }
        }
        return ((WorldServer)world).purpurConfig.farmlandGetsMoistFromBelow && world.b_(pos.a(EnumDirection.a)).a(TagsFluid.a);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{b});
    }

    @Override
    public boolean a(IBlockData state, IBlockAccess world, BlockPosition pos, PathMode type) {
        return false;
    }
}

