/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public abstract class BlockSprawling
extends Block {
    private static final EnumDirection[] a = EnumDirection.values();
    public static final BlockStateBoolean b = BlockProperties.L;
    public static final BlockStateBoolean c = BlockProperties.M;
    public static final BlockStateBoolean d = BlockProperties.N;
    public static final BlockStateBoolean e = BlockProperties.O;
    public static final BlockStateBoolean f = BlockProperties.J;
    public static final BlockStateBoolean g = BlockProperties.K;
    public static final Map<EnumDirection, BlockStateBoolean> h = ImmutableMap.copyOf((Map)SystemUtils.a(Maps.newEnumMap(EnumDirection.class), (? super T directions) -> {
        directions.put(EnumDirection.c, b);
        directions.put(EnumDirection.f, c);
        directions.put(EnumDirection.d, d);
        directions.put(EnumDirection.e, e);
        directions.put(EnumDirection.b, f);
        directions.put(EnumDirection.a, g);
    }));
    protected final VoxelShape[] i;

    protected BlockSprawling(float radius, BlockBase.Info settings) {
        super(settings);
        this.i = this.a(radius);
    }

    @Override
    protected abstract MapCodec<? extends BlockSprawling> a();

    private VoxelShape[] a(float radius) {
        float f2 = 0.5f - radius;
        float g2 = 0.5f + radius;
        VoxelShape voxelShape = Block.a(f2 * 16.0f, f2 * 16.0f, f2 * 16.0f, g2 * 16.0f, g2 * 16.0f, g2 * 16.0f);
        VoxelShape[] voxelShapes = new VoxelShape[a.length];
        for (int i2 = 0; i2 < a.length; ++i2) {
            EnumDirection direction = a[i2];
            voxelShapes[i2] = VoxelShapes.a(0.5 + Math.min((double)(-radius), (double)direction.j() * 0.5), 0.5 + Math.min((double)(-radius), (double)direction.k() * 0.5), 0.5 + Math.min((double)(-radius), (double)direction.l() * 0.5), 0.5 + Math.max((double)radius, (double)direction.j() * 0.5), 0.5 + Math.max((double)radius, (double)direction.k() * 0.5), 0.5 + Math.max((double)radius, (double)direction.l() * 0.5));
        }
        VoxelShape[] voxelShapes2 = new VoxelShape[64];
        for (int j2 = 0; j2 < 64; ++j2) {
            VoxelShape voxelShape2 = voxelShape;
            for (int k2 = 0; k2 < a.length; ++k2) {
                if ((j2 & 1 << k2) == 0) continue;
                voxelShape2 = VoxelShapes.a(voxelShape2, voxelShapes[k2]);
            }
            voxelShapes2[j2] = voxelShape2;
        }
        return voxelShapes2;
    }

    @Override
    @Override
    public boolean a_(IBlockData state, IBlockAccess world, BlockPosition pos) {
        return false;
    }

    @Override
    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return this.i[this.h(state)];
    }

    protected int h(IBlockData state) {
        int i2 = 0;
        for (int j2 = 0; j2 < a.length; ++j2) {
            if (!((Boolean)state.c(h.get(a[j2]))).booleanValue()) continue;
            i2 |= 1 << j2;
        }
        return i2;
    }
}

