/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertySlabType;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.util.NumberConversions;

public class BlockStepAbstract
extends Block
implements IBlockWaterlogged {
    public static final MapCodec<BlockStepAbstract> a = BlockStepAbstract.b(BlockStepAbstract::new);
    public static final BlockStateEnum<BlockPropertySlabType> b = BlockProperties.bh;
    public static final BlockStateBoolean c = BlockProperties.C;
    protected static final VoxelShape d = Block.a(0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
    protected static final VoxelShape e = Block.a(0.0, 8.0, 0.0, 16.0, 16.0, 16.0);

    public MapCodec<? extends BlockStepAbstract> a() {
        return a;
    }

    public BlockStepAbstract(BlockBase.Info settings) {
        super(settings);
        this.k((IBlockData)((IBlockData)this.o().a(b, BlockPropertySlabType.b)).a(c, false));
    }

    @Override
    public boolean g_(IBlockData state) {
        return state.c(b) != BlockPropertySlabType.c;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, c);
    }

    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        BlockPropertySlabType slabType = state.c(b);
        switch (slabType) {
            case c: {
                return VoxelShapes.b();
            }
            case a: {
                return e;
            }
        }
        return d;
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext ctx) {
        BlockPosition blockPos = ctx.a();
        IBlockData blockState = ctx.q().a_(blockPos);
        if (blockState.a(this)) {
            return (IBlockData)((IBlockData)blockState.a(b, BlockPropertySlabType.c)).a(c, false);
        }
        Fluid fluidState = ctx.q().b_(blockPos);
        IBlockData blockState2 = (IBlockData)((IBlockData)this.o().a(b, BlockPropertySlabType.b)).a(c, fluidState.a() == FluidTypes.c);
        EnumDirection direction = ctx.k();
        return !(direction == EnumDirection.a || direction != EnumDirection.b && ctx.l().d - (double)blockPos.v() > 0.5) ? blockState2 : (IBlockData)blockState2.a(b, BlockPropertySlabType.a);
    }

    @Override
    public boolean a(IBlockData state, BlockActionContext context) {
        ItemStack itemStack = context.n();
        BlockPropertySlabType slabType = state.c(b);
        if (slabType == BlockPropertySlabType.c || !itemStack.a(this.k())) {
            return false;
        }
        if (context.c()) {
            boolean bl = context.l().d - (double)context.a().v() > 0.5;
            EnumDirection direction = context.k();
            return slabType == BlockPropertySlabType.b ? direction == EnumDirection.b || bl && direction.o().d() : direction == EnumDirection.a || !bl && direction.o().d();
        }
        return true;
    }

    @Override
    public Fluid c_(IBlockData state) {
        return state.c(c) != false ? FluidTypes.c.a(false) : super.c_(state);
    }

    @Override
    public boolean a(GeneratorAccess world, BlockPosition pos, IBlockData state, Fluid fluidState) {
        return state.c(b) != BlockPropertySlabType.c && IBlockWaterlogged.super.a(world, pos, state, fluidState);
    }

    @Override
    public boolean a(@Nullable EntityHuman player, IBlockAccess world, BlockPosition pos, IBlockData state, FluidType fluid) {
        return state.c(b) != BlockPropertySlabType.c && IBlockWaterlogged.super.a(player, world, pos, state, fluid);
    }

    @Override
    public IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        if (state.c(c).booleanValue()) {
            world.a(pos, FluidTypes.c, FluidTypes.c.a(world));
        }
        return super.a(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public boolean a(IBlockData state, IBlockAccess world, BlockPosition pos, PathMode type) {
        switch (type) {
            case a: {
                return false;
            }
            case b: {
                return world.b_(pos).a(TagsFluid.a);
            }
            case c: {
                return false;
            }
        }
        return false;
    }

    public boolean halfBreak(IBlockData state, BlockPosition pos, EntityPlayer player) {
        if (state.c(b) != BlockPropertySlabType.c) {
            return false;
        }
        MovingObjectPosition result = player.getRayTrace(16, RayTrace.FluidCollisionOption.a);
        if (result.c() != MovingObjectPosition.EnumMovingObjectType.b) {
            return false;
        }
        double hitY = result.e().b();
        int blockY = NumberConversions.floor((double)hitY);
        player.dM().a(pos, (IBlockData)state.a(b, hitY - (double)blockY > 0.5 || blockY - pos.v() == 1 ? BlockPropertySlabType.b : BlockPropertySlabType.a), 3);
        if (!player.fT().d) {
            EntityItem item = new EntityItem(player.dM(), pos.u(), pos.v(), pos.w(), new ItemStack(this.k()));
            item.u();
            player.dM().b(item);
        }
        return true;
    }
}

