/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockNote;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.SculkSensorBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.SculkSensorPhase;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_20_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class SculkSensorBlock
extends BlockTileEntity
implements IBlockWaterlogged {
    public static final MapCodec<SculkSensorBlock> c = SculkSensorBlock.b(SculkSensorBlock::new);
    public static final int d = 30;
    public static final int e = 10;
    public static final BlockStateEnum<SculkSensorPhase> f = BlockProperties.bo;
    public static final BlockStateInteger g = BlockProperties.aT;
    public static final BlockStateBoolean h = BlockProperties.C;
    protected static final VoxelShape i = Block.a(0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
    private static final float[] a = SystemUtils.a(new float[16], (? super T afloat) -> {
        int[] aint = new int[]{0, 0, 2, 4, 6, 7, 9, 10, 12, 14, 15, 18, 19, 21, 22, 24};
        for (int i2 = 0; i2 < 16; ++i2) {
            afloat[i2] = BlockNote.b(aint[i2]);
        }
    });

    public MapCodec<? extends SculkSensorBlock> a() {
        return c;
    }

    public SculkSensorBlock(BlockBase.Info settings) {
        super(settings);
        this.k((IBlockData)((IBlockData)((IBlockData)this.E.b().a(f, SculkSensorPhase.a)).a(g, 0)).a(h, false));
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext ctx) {
        BlockPosition blockposition = ctx.a();
        Fluid fluid = ctx.q().b_(blockposition);
        return (IBlockData)this.o().a(h, fluid.a() == FluidTypes.c);
    }

    @Override
    public Fluid c_(IBlockData state) {
        return state.c(h) != false ? FluidTypes.c.a(false) : super.c_(state);
    }

    @Override
    public void a(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        if (SculkSensorBlock.h(state) != SculkSensorPhase.b) {
            if (SculkSensorBlock.h(state) == SculkSensorPhase.c) {
                world.a(pos, (IBlockData)state.a(f, SculkSensorPhase.a), 3);
                if (!state.c(h).booleanValue()) {
                    world.a((EntityHuman)null, pos, SoundEffects.vk, SoundCategory.e, 1.0f, world.z.i() * 0.2f + 0.8f);
                }
            }
        } else {
            SculkSensorBlock.a((World)world, pos, state);
        }
    }

    @Override
    public void a(World world, BlockPosition pos, IBlockData state, net.minecraft.world.entity.Entity entity) {
        if (!world.y_() && SculkSensorBlock.n(state) && entity.ai() != EntityTypes.bj) {
            PlayerInteractEvent cancellable;
            if (entity instanceof EntityHuman) {
                cancellable = CraftEventFactory.callPlayerInteractEvent((EntityHuman)entity, Action.PHYSICAL, pos, null, null, null);
            } else {
                cancellable = new EntityInteractEvent((Entity)entity.getBukkitEntity(), world.getWorld().getBlockAt(pos.u(), pos.v(), pos.w()));
                world.getCraftServer().getPluginManager().callEvent((Event)((EntityInteractEvent)cancellable));
            }
            if (cancellable.isCancelled()) {
                return;
            }
            TileEntity tileentity = world.c_(pos);
            if (tileentity instanceof SculkSensorBlockEntity) {
                SculkSensorBlockEntity sculksensorblockentity = (SculkSensorBlockEntity)tileentity;
                if (world instanceof WorldServer) {
                    WorldServer worldserver = (WorldServer)world;
                    if (sculksensorblockentity.gh().a(worldserver, pos, GameEvent.P, GameEvent.a.a(state))) {
                        sculksensorblockentity.g().b(worldserver, GameEvent.P, GameEvent.a.a(entity), entity.dk());
                    }
                }
            }
        }
        super.a(world, pos, state, entity);
    }

    @Override
    public void b(IBlockData state, World world, BlockPosition pos, IBlockData oldState, boolean notify) {
        if (!(world.y_() || state.a(oldState.b()) || state.c(g) <= 0 || world.N().a(pos, this))) {
            world.a(pos, (IBlockData)state.a(g, 0), 18);
        }
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, IBlockData newState, boolean moved) {
        if (!state.a(newState.b())) {
            if (SculkSensorBlock.h(state) == SculkSensorPhase.b) {
                SculkSensorBlock.b(world, pos, state);
            }
            super.a(state, world, pos, newState, moved);
        }
    }

    @Override
    public IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        if (state.c(h).booleanValue()) {
            world.a(pos, FluidTypes.c, FluidTypes.c.a(world));
        }
        return super.a(state, direction, neighborState, world, pos, neighborPos);
    }

    private static void b(World world, BlockPosition pos, IBlockData state) {
        Block block = state.b();
        world.a(pos, block);
        world.a(pos.d(), block);
    }

    @Override
    @Nullable
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new SculkSensorBlockEntity(pos, state);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> a(World world, IBlockData state, TileEntityTypes<T> type) {
        return !world.B ? SculkSensorBlock.a(type, TileEntityTypes.I, (World world1, BlockPosition blockposition, IBlockData iblockdata1, ? super E sculksensorblockentity) -> VibrationSystem.c.a(world1, sculksensorblockentity.gg(), sculksensorblockentity.gh())) : null;
    }

    @Override
    public EnumRenderType b_(IBlockData state) {
        return EnumRenderType.c;
    }

    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return i;
    }

    @Override
    public boolean f_(IBlockData state) {
        return true;
    }

    @Override
    public int a(IBlockData state, IBlockAccess world, BlockPosition pos, EnumDirection direction) {
        return state.c(g);
    }

    @Override
    public int b(IBlockData state, IBlockAccess world, BlockPosition pos, EnumDirection direction) {
        return direction == EnumDirection.b ? state.b(world, pos, direction) : 0;
    }

    public static SculkSensorPhase h(IBlockData state) {
        return state.c(f);
    }

    public static boolean n(IBlockData state) {
        return SculkSensorBlock.h(state) == SculkSensorPhase.a;
    }

    public static void a(World world, BlockPosition pos, IBlockData state) {
        BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent((org.bukkit.block.Block)CraftBlock.at(world, pos), state.c(g).intValue(), 0);
        world.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
        if (eventRedstone.getNewCurrent() > 0) {
            world.a(pos, (IBlockData)state.a(g, eventRedstone.getNewCurrent()), 3);
            return;
        }
        world.a(pos, (IBlockData)((IBlockData)state.a(f, SculkSensorPhase.c)).a(g, 0), 3);
        world.a(pos, state.b(), 10);
        SculkSensorBlock.b(world, pos, state);
    }

    @VisibleForTesting
    public int c() {
        return 30;
    }

    public void a(@Nullable net.minecraft.world.entity.Entity sourceEntity, World world, BlockPosition pos, IBlockData state, int power, int frequency) {
        BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent((org.bukkit.block.Block)CraftBlock.at(world, pos), state.c(g).intValue(), power);
        world.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
        if (eventRedstone.getNewCurrent() <= 0) {
            return;
        }
        power = eventRedstone.getNewCurrent();
        world.a(pos, (IBlockData)((IBlockData)state.a(f, SculkSensorPhase.b)).a(g, power), 3);
        world.a(pos, state.b(), this.c());
        SculkSensorBlock.b(world, pos, state);
        SculkSensorBlock.a(sourceEntity, world, pos, frequency);
        world.a(sourceEntity, GameEvent.L, pos);
        if (!state.c(h).booleanValue()) {
            world.a((EntityHuman)null, (double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, SoundEffects.vj, SoundCategory.e, 1.0f, world.z.i() * 0.2f + 0.8f);
        }
    }

    public static void a(@Nullable net.minecraft.world.entity.Entity sourceEntity, World world, BlockPosition pos, int frequency) {
        for (EnumDirection enumdirection : EnumDirection.values()) {
            BlockPosition blockposition1 = pos.a(enumdirection);
            IBlockData iblockdata = world.a_(blockposition1);
            if (!iblockdata.a(TagsBlock.bO)) continue;
            world.a(VibrationSystem.b(frequency), blockposition1, GameEvent.a.a(sourceEntity, iblockdata));
            float f2 = a[frequency];
            world.a((EntityHuman)null, blockposition1, SoundEffects.I, SoundCategory.e, 1.0f, f2);
        }
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, RandomSource random) {
        EnumDirection enumdirection;
        if (SculkSensorBlock.h(state) == SculkSensorPhase.b && (enumdirection = EnumDirection.b(random)) != EnumDirection.b && enumdirection != EnumDirection.a) {
            double d0 = (double)pos.u() + 0.5 + (enumdirection.j() == 0 ? 0.5 - random.j() : (double)enumdirection.j() * 0.6);
            double d1 = (double)pos.v() + 0.25;
            double d2 = (double)pos.w() + 0.5 + (enumdirection.l() == 0 ? 0.5 - random.j() : (double)enumdirection.l() * 0.6);
            double d3 = (double)random.i() * 0.04;
            world.a(DustColorTransitionOptions.b, d0, d1, d2, 0.0, d3, 0.0);
        }
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(f, g, h);
    }

    @Override
    public boolean d_(IBlockData state) {
        return true;
    }

    @Override
    public int a(IBlockData state, World world, BlockPosition pos) {
        TileEntity tileentity = world.c_(pos);
        if (tileentity instanceof SculkSensorBlockEntity) {
            SculkSensorBlockEntity sculksensorblockentity = (SculkSensorBlockEntity)tileentity;
            return SculkSensorBlock.h(state) == SculkSensorPhase.b ? sculksensorblockentity.f() : 0;
        }
        return 0;
    }

    @Override
    public boolean a(IBlockData state, IBlockAccess world, BlockPosition pos, PathMode type) {
        return false;
    }

    @Override
    public boolean g_(IBlockData state) {
        return true;
    }

    @Override
    public void a(IBlockData state, WorldServer world, BlockPosition pos, ItemStack tool, boolean dropExperience) {
        super.a(state, world, pos, tool, dropExperience);
    }

    @Override
    public int getExpDrop(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, ItemStack itemstack, boolean flag) {
        if (flag) {
            return this.tryDropExperience(worldserver, blockposition, itemstack, ConstantInt.a(5));
        }
        return 0;
    }
}

