/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.SculkBehaviour;
import net.minecraft.world.level.block.SculkVeinBlock;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_20_R3.block.CraftBlock;
import org.bukkit.event.Event;
import org.bukkit.event.block.SculkBloomEvent;
import org.slf4j.Logger;

public class SculkSpreader {
    public static final int a = 24;
    public static final int b = 1000;
    public static final float c = 0.5f;
    private static final int e = 32;
    public static final int d = 11;
    final boolean f;
    private final TagKey<Block> g;
    private final int h;
    private final int i;
    private final int j;
    private final int k;
    private List<a> l = new ArrayList<a>();
    private static final Logger m = LogUtils.getLogger();
    public World level;

    public SculkSpreader(boolean worldGen, TagKey<Block> replaceableTag, int extraBlockChance, int maxDistance, int spreadChance, int decayChance) {
        this.f = worldGen;
        this.g = replaceableTag;
        this.h = extraBlockChance;
        this.i = maxDistance;
        this.j = spreadChance;
        this.k = decayChance;
    }

    public static SculkSpreader a() {
        return new SculkSpreader(false, TagsBlock.bL, 10, 4, 10, 5);
    }

    public static SculkSpreader b() {
        return new SculkSpreader(true, TagsBlock.bM, 50, 1, 5, 10);
    }

    public TagKey<Block> c() {
        return this.g;
    }

    public int d() {
        return this.h;
    }

    public int e() {
        return this.i;
    }

    public int f() {
        return this.j;
    }

    public int g() {
        return this.k;
    }

    public boolean h() {
        return this.f;
    }

    @VisibleForTesting
    public List<a> i() {
        return this.l;
    }

    public void j() {
        this.l.clear();
    }

    public void a(NBTTagCompound nbt) {
        if (nbt.b("cursors", 9)) {
            this.l.clear();
            DataResult dataresult = net.minecraft.world.level.block.SculkSpreader$a.b.listOf().parse(new Dynamic<NBTTagList>(DynamicOpsNBT.a, nbt.c("cursors", 10)));
            Logger logger = m;
            Objects.requireNonNull(logger);
            List list = dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).orElseGet(ArrayList::new);
            int i2 = Math.min(list.size(), 32);
            for (int j2 = 0; j2 < i2; ++j2) {
                this.a((a)list.get(j2));
            }
        }
    }

    public void b(NBTTagCompound nbt) {
        DataResult dataresult = net.minecraft.world.level.block.SculkSpreader$a.b.listOf().encodeStart((DynamicOps)DynamicOpsNBT.a, this.l);
        Logger logger = m;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.a("cursors", (NBTBase)nbtbase));
    }

    public void a(BlockPosition pos, int charge) {
        while (charge > 0) {
            int j2 = Math.min(charge, 1000);
            this.a(new a(pos, j2));
            charge -= j2;
        }
    }

    private void a(a cursor) {
        if (this.l.size() < 32) {
            if (!this.h()) {
                CraftBlock bukkitBlock = CraftBlock.at(this.level, cursor.d);
                SculkBloomEvent event = new SculkBloomEvent((org.bukkit.block.Block)bukkitBlock, cursor.b());
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                cursor.e = event.getCharge();
            }
            this.l.add(cursor);
        }
    }

    public void a(GeneratorAccess world, BlockPosition pos, RandomSource random, boolean shouldConvertToBlock) {
        if (!this.l.isEmpty()) {
            BlockPosition blockposition1;
            ArrayList<a> list = new ArrayList<a>();
            HashMap<BlockPosition, a> map = new HashMap<BlockPosition, a>();
            Object2IntOpenHashMap object2intmap = new Object2IntOpenHashMap();
            for (a sculkspreader_a : this.l) {
                sculkspreader_a.a(world, pos, random, this, shouldConvertToBlock);
                if (sculkspreader_a.e <= 0) {
                    world.c(3006, sculkspreader_a.a(), 0);
                    continue;
                }
                blockposition1 = sculkspreader_a.a();
                object2intmap.computeInt((Object)blockposition1, (blockposition2, integer) -> (integer == null ? 0 : integer) + sculkspreader_a.e);
                a sculkspreader_a1 = (a)map.get(blockposition1);
                if (sculkspreader_a1 == null) {
                    map.put(blockposition1, sculkspreader_a);
                    list.add(sculkspreader_a);
                    continue;
                }
                if (!this.h() && sculkspreader_a.e + sculkspreader_a1.e <= 1000) {
                    sculkspreader_a1.a(sculkspreader_a);
                    continue;
                }
                list.add(sculkspreader_a);
                if (sculkspreader_a.e >= sculkspreader_a1.e) continue;
                map.put(blockposition1, sculkspreader_a);
            }
            for (Object2IntMap.Entry entry : object2intmap.object2IntEntrySet()) {
                Set<EnumDirection> collection;
                blockposition1 = (BlockPosition)entry.getKey();
                int i2 = entry.getIntValue();
                a sculkspreader_a2 = (a)map.get(blockposition1);
                Set<EnumDirection> set = collection = sculkspreader_a2 == null ? null : sculkspreader_a2.d();
                if (i2 <= 0 || collection == null) continue;
                int j2 = (int)(Math.log1p(i2) / (double)2.3f) + 1;
                int k2 = (j2 << 6) + MultifaceBlock.a(collection);
                world.c(3006, blockposition1, k2);
            }
            this.l = list;
        }
    }

    public static class a {
        private static final ObjectArrayList<BaseBlockPosition> c = SystemUtils.a(new ObjectArrayList(18), objectarraylist -> {
            Stream<BlockPosition> stream = BlockPosition.b(new BlockPosition(-1, -1, -1), new BlockPosition(1, 1, 1)).filter(blockposition -> (blockposition.u() == 0 || blockposition.v() == 0 || blockposition.w() == 0) && !blockposition.equals(BlockPosition.b)).map(BlockPosition::i);
            Objects.requireNonNull(objectarraylist);
            stream.forEach(arg_0 -> ((ObjectArrayList)objectarraylist).add(arg_0));
        });
        public static final int a = 1;
        private BlockPosition d;
        int e;
        private int f;
        private int g;
        @Nullable
        private Set<EnumDirection> h;
        private static final Codec<Set<EnumDirection>> i = EnumDirection.g.listOf().xmap(list -> Sets.newEnumSet((Iterable)list, EnumDirection.class), Lists::newArrayList);
        public static final Codec<a> b = RecordCodecBuilder.create(instance -> instance.group((App)BlockPosition.a.fieldOf("pos").forGetter(a::a), (App)Codec.intRange((int)0, (int)1000).fieldOf("charge").orElse((Object)0).forGetter(a::b), (App)Codec.intRange((int)0, (int)1).fieldOf("decay_delay").orElse((Object)1).forGetter(a::c), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("update_delay").orElse((Object)0).forGetter(sculkspreader_a -> sculkspreader_a.f), (App)i.optionalFieldOf("facings").forGetter(sculkspreader_a -> Optional.ofNullable(sculkspreader_a.d()))).apply((Applicative)instance, a::new));

        private a(BlockPosition pos, int charge, int decay, int update, Optional<Set<EnumDirection>> faces) {
            this.d = pos;
            this.e = charge;
            this.g = decay;
            this.f = update;
            this.h = faces.orElse(null);
        }

        public a(BlockPosition pos, int charge) {
            this(pos, charge, 1, 0, Optional.empty());
        }

        public BlockPosition a() {
            return this.d;
        }

        public int b() {
            return this.e;
        }

        public int c() {
            return this.g;
        }

        @Nullable
        public Set<EnumDirection> d() {
            return this.h;
        }

        private boolean a(GeneratorAccess world, BlockPosition pos, boolean worldGen) {
            if (this.e <= 0) {
                return false;
            }
            if (worldGen) {
                return true;
            }
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                return worldserver.n(pos);
            }
            return false;
        }

        public void a(GeneratorAccess world, BlockPosition pos, RandomSource random, SculkSpreader spreadManager, boolean shouldConvertToBlock) {
            if (this.a(world, pos, spreadManager.f)) {
                if (this.f > 0) {
                    --this.f;
                } else {
                    IBlockData iblockdata = world.a_(this.d);
                    SculkBehaviour sculkbehaviour = net.minecraft.world.level.block.SculkSpreader$a.a(iblockdata);
                    if (shouldConvertToBlock && sculkbehaviour.a(world, this.d, iblockdata, this.h, spreadManager.h())) {
                        if (sculkbehaviour.d()) {
                            iblockdata = world.a_(this.d);
                            sculkbehaviour = net.minecraft.world.level.block.SculkSpreader$a.a(iblockdata);
                        }
                        world.a((EntityHuman)null, this.d, SoundEffects.uW, SoundCategory.e, 1.0f, 1.0f);
                    }
                    this.e = sculkbehaviour.a(this, world, pos, random, spreadManager, shouldConvertToBlock);
                    if (this.e <= 0) {
                        sculkbehaviour.a(world, iblockdata, this.d, random);
                    } else {
                        BlockPosition blockposition1 = net.minecraft.world.level.block.SculkSpreader$a.a(world, this.d, random);
                        if (blockposition1 != null) {
                            sculkbehaviour.a(world, iblockdata, this.d, random);
                            this.d = blockposition1.i();
                            if (spreadManager.h() && !this.d.a(new BaseBlockPosition(pos.u(), this.d.v(), pos.w()), 15.0)) {
                                this.e = 0;
                                return;
                            }
                            iblockdata = world.a_(blockposition1);
                        }
                        if (iblockdata.b() instanceof SculkBehaviour) {
                            this.h = MultifaceBlock.h(iblockdata);
                        }
                        this.g = sculkbehaviour.i_(this.g);
                        this.f = sculkbehaviour.b();
                    }
                }
            }
        }

        void a(a cursor) {
            this.e += cursor.e;
            cursor.e = 0;
            this.f = Math.min(this.f, cursor.f);
        }

        private static SculkBehaviour a(IBlockData state) {
            SculkBehaviour sculkbehaviour1;
            Block block = state.b();
            SculkBehaviour sculkbehaviour = block instanceof SculkBehaviour ? (sculkbehaviour1 = (SculkBehaviour)((Object)block)) : SculkBehaviour.u_;
            return sculkbehaviour;
        }

        private static List<BaseBlockPosition> a(RandomSource random) {
            return SystemUtils.a(c, random);
        }

        @Nullable
        private static BlockPosition a(GeneratorAccess world, BlockPosition pos, RandomSource random) {
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = pos.j();
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition1 = pos.j();
            for (BaseBlockPosition baseblockposition : net.minecraft.world.level.block.SculkSpreader$a.a(random)) {
                blockposition_mutableblockposition1.a((BaseBlockPosition)pos, baseblockposition);
                IBlockData iblockdata = world.a_(blockposition_mutableblockposition1);
                if (!(iblockdata.b() instanceof SculkBehaviour) || !net.minecraft.world.level.block.SculkSpreader$a.a(world, pos, blockposition_mutableblockposition1)) continue;
                blockposition_mutableblockposition.g(blockposition_mutableblockposition1);
                if (!SculkVeinBlock.a(world, iblockdata, blockposition_mutableblockposition1)) continue;
                break;
            }
            return blockposition_mutableblockposition.equals(pos) ? null : blockposition_mutableblockposition;
        }

        private static boolean a(GeneratorAccess world, BlockPosition sourcePos, BlockPosition targetPos) {
            if (sourcePos.k(targetPos) == 1) {
                return true;
            }
            BlockPosition blockposition2 = targetPos.b(sourcePos);
            EnumDirection enumdirection = EnumDirection.a(EnumDirection.EnumAxis.a, blockposition2.u() < 0 ? EnumDirection.EnumAxisDirection.b : EnumDirection.EnumAxisDirection.a);
            EnumDirection enumdirection1 = EnumDirection.a(EnumDirection.EnumAxis.b, blockposition2.v() < 0 ? EnumDirection.EnumAxisDirection.b : EnumDirection.EnumAxisDirection.a);
            EnumDirection enumdirection2 = EnumDirection.a(EnumDirection.EnumAxis.c, blockposition2.w() < 0 ? EnumDirection.EnumAxisDirection.b : EnumDirection.EnumAxisDirection.a);
            return blockposition2.u() == 0 ? net.minecraft.world.level.block.SculkSpreader$a.a(world, sourcePos, enumdirection1) || net.minecraft.world.level.block.SculkSpreader$a.a(world, sourcePos, enumdirection2) : (blockposition2.v() == 0 ? net.minecraft.world.level.block.SculkSpreader$a.a(world, sourcePos, enumdirection) || net.minecraft.world.level.block.SculkSpreader$a.a(world, sourcePos, enumdirection2) : net.minecraft.world.level.block.SculkSpreader$a.a(world, sourcePos, enumdirection) || net.minecraft.world.level.block.SculkSpreader$a.a(world, sourcePos, enumdirection1));
        }

        private static boolean a(GeneratorAccess world, BlockPosition pos, EnumDirection direction) {
            BlockPosition blockposition1 = pos.a(direction);
            return !world.a_(blockposition1).d(world, blockposition1, direction.g());
        }
    }
}

