/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import co.aikar.timings.MinecraftTimings;
import co.aikar.timings.Timing;
import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_20_R3.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_20_R3.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.inventory.InventoryHolder;
import org.slf4j.Logger;

public abstract class TileEntity {
    static boolean ignoreTileUpdates;
    public Timing tickTimer = MinecraftTimings.getTileEntityTimings(this);
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY;
    public CraftPersistentDataContainer persistentDataContainer;
    private static final Logger e;
    private final TileEntityTypes<?> f;
    @Nullable
    protected World o;
    protected final BlockPosition p;
    protected boolean q;
    private IBlockData g;
    private String persistentDisplayName = null;
    private NBTTagList persistentLore = null;

    public TileEntity(TileEntityTypes<?> type, BlockPosition pos, IBlockData state) {
        this.f = type;
        this.p = pos.i();
        this.g = state;
        this.persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    }

    public static BlockPosition c(NBTTagCompound nbt) {
        return new BlockPosition(nbt.h("x"), nbt.h("y"), nbt.h("z"));
    }

    @Nullable
    public World i() {
        return this.o;
    }

    public void a(World world) {
        this.o = world;
    }

    public boolean n() {
        return this.o != null;
    }

    public void a(NBTTagCompound nbt) {
        this.persistentDataContainer.clear();
        NBTBase persistentDataTag = nbt.c("PublicBukkitValues");
        if (persistentDataTag instanceof NBTTagCompound) {
            this.persistentDataContainer.putAll((NBTTagCompound)persistentDataTag);
        }
        if (nbt.e("Purpur.persistentDisplayName")) {
            this.persistentDisplayName = nbt.l("Purpur.persistentDisplayName");
        }
        if (nbt.e("Purpur.persistentLore")) {
            this.persistentLore = nbt.c("Purpur.persistentLore", 8);
        }
    }

    protected void b(NBTTagCompound nbt) {
        if (this.persistentDisplayName != null) {
            nbt.a("Purpur.persistentDisplayName", NBTTagString.a(this.persistentDisplayName));
        }
        if (this.persistentLore != null) {
            nbt.a("Purpur.persistentLore", this.persistentLore);
        }
    }

    public final NBTTagCompound o() {
        NBTTagCompound nbttagcompound = this.q();
        this.e(nbttagcompound);
        return nbttagcompound;
    }

    public final NBTTagCompound p() {
        NBTTagCompound nbttagcompound = this.q();
        this.d(nbttagcompound);
        return nbttagcompound;
    }

    public final NBTTagCompound q() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.b(nbttagcompound);
        if (this.persistentDataContainer != null && !this.persistentDataContainer.isEmpty()) {
            nbttagcompound.a("PublicBukkitValues", this.persistentDataContainer.toTagCompound());
        }
        return nbttagcompound;
    }

    private void d(NBTTagCompound nbt) {
        MinecraftKey minecraftkey = TileEntityTypes.a(this.v());
        if (minecraftkey == null) {
            throw new RuntimeException(this.getClass() + " is missing a mapping! This is a bug!");
        }
        nbt.a("id", minecraftkey.toString());
    }

    public static void a(NBTTagCompound nbt, TileEntityTypes<?> type) {
        nbt.a("id", TileEntityTypes.a(type).toString());
    }

    public void e(ItemStack stack) {
        ItemBlock.a(stack, this.v(), this.q());
    }

    private void e(NBTTagCompound nbt) {
        this.d(nbt);
        nbt.a("x", this.p.u());
        nbt.a("y", this.p.v());
        nbt.a("z", this.p.w());
    }

    @Nullable
    public static TileEntity a(BlockPosition pos, IBlockData state, NBTTagCompound nbt) {
        String s2 = nbt.l("id");
        MinecraftKey minecraftkey = MinecraftKey.a(s2);
        if (minecraftkey == null) {
            e.error("Block entity has invalid type: {}", (Object)s2);
            return null;
        }
        return BuiltInRegistries.k.b(minecraftkey).map(tileentitytypes -> {
            try {
                return tileentitytypes.a(pos, state);
            }
            catch (Throwable throwable) {
                e.error("Failed to create block entity {}", (Object)s2, (Object)throwable);
                return null;
            }
        }).map(tileentity -> {
            try {
                tileentity.a(nbt);
                return tileentity;
            }
            catch (Throwable throwable) {
                e.error("Failed to load data for block entity {}", (Object)s2, (Object)throwable);
                return null;
            }
        }).orElseGet(() -> {
            e.warn("Skipping BlockEntity with id {}", (Object)s2);
            return null;
        });
    }

    public void e() {
        if (this.o != null) {
            if (ignoreTileUpdates) {
                return;
            }
            TileEntity.a(this.o, this.p, this.g);
        }
    }

    protected static void a(World world, BlockPosition pos, IBlockData state) {
        world.q(pos);
        if (!state.i()) {
            world.c(pos, state.b());
        }
    }

    public BlockPosition aB_() {
        return this.p;
    }

    public IBlockData r() {
        return this.g;
    }

    @Nullable
    public Packet<PacketListenerPlayOut> j() {
        INamableTileEntity nameable;
        TileEntity tileEntity = this;
        if (tileEntity instanceof INamableTileEntity && (nameable = (INamableTileEntity)((Object)tileEntity)).ae()) {
            NBTTagCompound nbt = this.q();
            nbt.r("Items");
            return PacketPlayOutTileEntityData.a(this, (TileEntity $) -> nbt);
        }
        return null;
    }

    public NBTTagCompound ax_() {
        INamableTileEntity nameable;
        TileEntity tileEntity = this;
        if (tileEntity instanceof INamableTileEntity && (nameable = (INamableTileEntity)((Object)tileEntity)).ae()) {
            NBTTagCompound nbt = this.q();
            nbt.r("Items");
            return nbt;
        }
        return new NBTTagCompound();
    }

    public boolean s() {
        return this.q;
    }

    public void ay_() {
        this.q = true;
    }

    public void t() {
        this.q = false;
    }

    public boolean a_(int type, int data) {
        return false;
    }

    public void a(CrashReportSystemDetails crashReportSection) {
        crashReportSection.a("Name", () -> {
            MinecraftKey minecraftkey = BuiltInRegistries.k.b(this.v());
            return minecraftkey + " // " + this.getClass().getCanonicalName();
        });
        if (this.o != null) {
            IBlockData block = this.r();
            if (block != null) {
                CrashReportSystemDetails.a(crashReportSection, this.o, this.p, block);
            }
            CrashReportSystemDetails.a(crashReportSection, this.o, this.p, this.o.a_(this.p));
        }
    }

    public boolean u() {
        return false;
    }

    public TileEntityTypes<?> v() {
        return this.f;
    }

    @Deprecated
    public void b(IBlockData state) {
        this.g = state;
    }

    public InventoryHolder getOwner() {
        return this.getOwner(true);
    }

    public InventoryHolder getOwner(boolean useSnapshot) {
        if (this.o == null) {
            return null;
        }
        Block block = this.o.getWorld().getBlockAt(this.p.u(), this.p.v(), this.p.w());
        BlockState state = block.getState(useSnapshot);
        if (state instanceof InventoryHolder) {
            return (InventoryHolder)state;
        }
        return null;
    }

    public NBTTagCompound sanitizeSentNbt(NBTTagCompound tag) {
        tag.r("PublicBukkitValues");
        return tag;
    }

    public void setPersistentDisplayName(String json) {
        this.persistentDisplayName = json;
    }

    public void setPersistentLore(NBTTagList lore) {
        this.persistentLore = lore;
    }

    public String getPersistentDisplayName() {
        return this.persistentDisplayName;
    }

    public NBTTagList getPersistentLore() {
        return this.persistentLore;
    }

    static {
        DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
        e = LogUtils.getLogger();
    }
}

