/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.destroystokyo.paper.event.block.BeaconEffectEvent;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.papermc.paper.event.block.BeaconActivatedEvent;
import io.papermc.paper.event.block.BeaconDeactivatedEvent;
import io.papermc.paper.util.MCUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.ChestLock;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerBeacon;
import net.minecraft.world.inventory.IContainerProperties;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBeaconBeam;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityContainer;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.craftbukkit.v1_20_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R3.potion.CraftPotionUtil;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.potion.PotionEffect;

public class TileEntityBeacon
extends TileEntity
implements ITileInventory,
INamableTileEntity {
    private static final int f = 4;
    public static final MobEffectList[][] a = new MobEffectList[][]{{MobEffects.a, MobEffects.c}, {MobEffects.k, MobEffects.h}, {MobEffects.e}, {MobEffects.j}};
    private static final Set<MobEffectList> g = Arrays.stream(a).flatMap(Arrays::stream).collect(Collectors.toSet());
    public static final int b = 0;
    public static final int c = 1;
    public static final int d = 2;
    public static final int e = 3;
    private static final int h = 10;
    private static final IChatBaseComponent i = IChatBaseComponent.c("container.beacon");
    private static final String j = "primary_effect";
    private static final String k = "secondary_effect";
    List<BeaconColorTracker> l = Lists.newArrayList();
    private List<BeaconColorTracker> m = Lists.newArrayList();
    public int n;
    private int r;
    @Nullable
    public MobEffectList s;
    @Nullable
    public MobEffectList t;
    @Nullable
    public IChatBaseComponent u;
    public ChestLock v = ChestLock.a;
    private final IContainerProperties w = new IContainerProperties(){

        @Override
        public int a(int index) {
            return switch (index) {
                case 0 -> TileEntityBeacon.this.n;
                case 1 -> ContainerBeacon.a(TileEntityBeacon.this.s);
                case 2 -> ContainerBeacon.a(TileEntityBeacon.this.t);
                default -> 0;
            };
        }

        @Override
        public void a(int index, int value) {
            switch (index) {
                case 0: {
                    TileEntityBeacon.this.n = value;
                    break;
                }
                case 1: {
                    if (!TileEntityBeacon.this.o.B && !TileEntityBeacon.this.l.isEmpty()) {
                        TileEntityBeacon.a(TileEntityBeacon.this.o, TileEntityBeacon.this.p, SoundEffects.by);
                    }
                    TileEntityBeacon.this.s = TileEntityBeacon.a(ContainerBeacon.e(value));
                    break;
                }
                case 2: {
                    TileEntityBeacon.this.t = TileEntityBeacon.a(ContainerBeacon.e(value));
                }
            }
        }

        @Override
        public int a() {
            return 3;
        }
    };
    private final String PAPER_RANGE_TAG = "Paper.Range";
    private double effectRange = -1.0;

    public PotionEffect getPrimaryEffect() {
        return this.s != null ? CraftPotionUtil.toBukkit(new MobEffect(this.s, TileEntityBeacon.getLevel(this.n), TileEntityBeacon.getAmplification(this.n, this.s, this.t), true, true)) : null;
    }

    public PotionEffect getSecondaryEffect() {
        return TileEntityBeacon.hasSecondaryEffect(this.n, this.s, this.t) ? CraftPotionUtil.toBukkit(new MobEffect(this.t, TileEntityBeacon.getLevel(this.n), TileEntityBeacon.getAmplification(this.n, this.s, this.t), true, true)) : null;
    }

    public double getEffectRange() {
        if (this.effectRange < 0.0) {
            if (this.o != null) {
                switch (this.n) {
                    case 1: {
                        return this.o.purpurConfig.beaconLevelOne;
                    }
                    case 2: {
                        return this.o.purpurConfig.beaconLevelTwo;
                    }
                    case 3: {
                        return this.o.purpurConfig.beaconLevelThree;
                    }
                    case 4: {
                        return this.o.purpurConfig.beaconLevelFour;
                    }
                }
            }
            return this.n * 10 + 10;
        }
        return this.effectRange;
    }

    public void setEffectRange(double range) {
        this.effectRange = range;
    }

    public void resetEffectRange() {
        this.effectRange = -1.0;
    }

    @Nullable
    static MobEffectList a(@Nullable MobEffectList effect) {
        return g.contains(effect) ? effect : null;
    }

    public TileEntityBeacon(BlockPosition pos, IBlockData state) {
        super(TileEntityTypes.o, pos, state);
    }

    public static void a(World world, BlockPosition pos, IBlockData state, TileEntityBeacon blockEntity) {
        int i1;
        BlockPosition blockposition1;
        int i2 = pos.u();
        int j2 = pos.v();
        int k2 = pos.w();
        boolean isTintedGlass = false;
        if (blockEntity.r < j2) {
            blockposition1 = pos;
            blockEntity.m = Lists.newArrayList();
            blockEntity.r = pos.v() - 1;
        } else {
            blockposition1 = new BlockPosition(i2, blockEntity.r + 1, k2);
        }
        BeaconColorTracker tileentitybeacon_beaconcolortracker = blockEntity.m.isEmpty() ? null : blockEntity.m.get(blockEntity.m.size() - 1);
        int l2 = world.a(HeightMap.Type.b, i2, k2);
        for (i1 = 0; i1 < 10 && blockposition1.v() <= l2; ++i1) {
            IBlockData iblockdata1 = world.a_(blockposition1);
            Block block = iblockdata1.b();
            if (block instanceof IBeaconBeam) {
                float[] afloat = ((IBeaconBeam)((Object)block)).b().d();
                if (blockEntity.m.size() <= 1) {
                    tileentitybeacon_beaconcolortracker = new BeaconColorTracker(afloat);
                    blockEntity.m.add(tileentitybeacon_beaconcolortracker);
                } else if (tileentitybeacon_beaconcolortracker != null) {
                    if (Arrays.equals(afloat, tileentitybeacon_beaconcolortracker.a)) {
                        tileentitybeacon_beaconcolortracker.a();
                    } else {
                        tileentitybeacon_beaconcolortracker = new BeaconColorTracker(new float[]{(tileentitybeacon_beaconcolortracker.a[0] + afloat[0]) / 2.0f, (tileentitybeacon_beaconcolortracker.a[1] + afloat[1]) / 2.0f, (tileentitybeacon_beaconcolortracker.a[2] + afloat[2]) / 2.0f});
                        blockEntity.m.add(tileentitybeacon_beaconcolortracker);
                    }
                }
            } else {
                if (world.purpurConfig.beaconAllowEffectsWithTintedGlass && block.equals(Blocks.qO)) {
                    isTintedGlass = true;
                }
                if (tileentitybeacon_beaconcolortracker == null || iblockdata1.b((IBlockAccess)world, blockposition1) >= 15 && !iblockdata1.a(Blocks.F)) {
                    blockEntity.m.clear();
                    blockEntity.r = l2;
                    break;
                }
                tileentitybeacon_beaconcolortracker.a();
            }
            blockposition1 = blockposition1.c();
            ++blockEntity.r;
        }
        i1 = blockEntity.n;
        if (world.X() % 80L == 0L) {
            if (!blockEntity.l.isEmpty()) {
                blockEntity.n = TileEntityBeacon.a(world, i2, j2, k2);
            }
            if (blockEntity.n > 0 && (!blockEntity.l.isEmpty() || world.purpurConfig.beaconAllowEffectsWithTintedGlass && isTintedGlass)) {
                TileEntityBeacon.applyEffects(world, pos, blockEntity.n, blockEntity.s, blockEntity.t, blockEntity);
                TileEntityBeacon.a(world, pos, SoundEffects.bw);
            }
        }
        if (i1 <= 0 && blockEntity.n > 0) {
            block = CraftBlock.at(world, pos);
            new BeaconActivatedEvent((org.bukkit.block.Block)block).callEvent();
        } else if (i1 > 0 && blockEntity.n <= 0) {
            block = CraftBlock.at(world, pos);
            new BeaconDeactivatedEvent((org.bukkit.block.Block)block).callEvent();
        }
        if (blockEntity.r >= l2) {
            blockEntity.r = world.J_() - 1;
            boolean flag = i1 > 0;
            blockEntity.l = blockEntity.m;
            if (!world.B) {
                boolean flag1;
                boolean bl = flag1 = blockEntity.n > 0;
                if (!flag && flag1) {
                    TileEntityBeacon.a(world, pos, SoundEffects.bv);
                    for (EntityPlayer entityplayer : world.a(EntityPlayer.class, new AxisAlignedBB(i2, j2, k2, i2, j2 - 4, k2).c(10.0, 5.0, 10.0))) {
                        CriterionTriggers.m.a(entityplayer, blockEntity.n);
                    }
                } else if (flag && !flag1) {
                    TileEntityBeacon.a(world, pos, SoundEffects.bx);
                }
            }
        }
    }

    private static int a(World world, int x2, int y2, int z2) {
        int j1;
        int l2 = 0;
        int i1 = 1;
        while (i1 <= 4 && (j1 = y2 - i1) >= world.J_()) {
            boolean flag = true;
            block1: for (int k1 = x2 - i1; k1 <= x2 + i1 && flag; ++k1) {
                for (int l1 = z2 - i1; l1 <= z2 + i1; ++l1) {
                    if (world.a_(new BlockPosition(k1, j1, l1)).a(TagsBlock.aL)) continue;
                    flag = false;
                    continue block1;
                }
            }
            if (!flag) break;
            l2 = i1++;
        }
        return l2;
    }

    @Override
    public void ay_() {
        CraftBlock block = CraftBlock.at(this.o, this.p);
        new BeaconDeactivatedEvent((org.bukkit.block.Block)block).callEvent();
        if (this.n > 0 && !this.l.isEmpty()) {
            TileEntityBeacon.a(this.o, this.p, SoundEffects.bx);
        }
        super.ay_();
    }

    private static byte getAmplification(int i2, @Nullable MobEffectList mobeffectlist, @Nullable MobEffectList mobeffectlist1) {
        byte b0 = 0;
        if (i2 >= 4 && mobeffectlist == mobeffectlist1) {
            b0 = 1;
        }
        return b0;
    }

    private static int getLevel(int i2) {
        int j2 = (9 + i2 * 2) * 20;
        return j2;
    }

    public static List getHumansInRange(World world, BlockPosition blockposition, int i2) {
        return TileEntityBeacon.getHumansInRange(world, blockposition, i2, null);
    }

    public static List getHumansInRange(World world, BlockPosition blockposition, int i2, @Nullable TileEntityBeacon blockEntity) {
        List<Object> list;
        double d0 = blockEntity != null ? blockEntity.getEffectRange() : (double)(i2 * 10 + 10);
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(blockposition).g(d0).b(0.0, world.K_(), 0.0);
        if (d0 <= 128.0) {
            list = world.a(EntityHuman.class, axisalignedbb);
        } else {
            list = new ArrayList();
            for (EntityHuman entityHuman : world.x()) {
                if (entityHuman.P_() || !entityHuman.cH().c(axisalignedbb)) continue;
                list.add(entityHuman);
            }
        }
        return list;
    }

    private static void applyEffect(List list, MobEffectList effects, int i2, int b0, boolean isPrimary, BlockPosition worldPosition) {
        if (!list.isEmpty()) {
            Iterator iterator = list.iterator();
            CraftBlock block = CraftBlock.at(((EntityHuman)list.get(0)).dM(), worldPosition);
            PotionEffect effect = CraftPotionUtil.toBukkit(new MobEffect(effects, i2, b0, true, true));
            while (iterator.hasNext()) {
                EntityPlayer entityhuman = (EntityPlayer)iterator.next();
                BeaconEffectEvent event = new BeaconEffectEvent((org.bukkit.block.Block)block, effect, (Player)((EntityHuman)entityhuman).getBukkitEntity(), isPrimary);
                if (CraftEventFactory.callEvent(event).isCancelled()) continue;
                entityhuman.addEffect(new MobEffect(CraftPotionUtil.fromBukkit(event.getEffect())), EntityPotionEffectEvent.Cause.BEACON);
            }
        }
    }

    private static boolean hasSecondaryEffect(int i2, @Nullable MobEffectList mobeffectlist, @Nullable MobEffectList mobeffectlist1) {
        return i2 >= 4 && mobeffectlist != mobeffectlist1 && mobeffectlist1 != null;
    }

    private static void a(World world, BlockPosition pos, int beaconLevel, @Nullable MobEffectList primaryEffect, @Nullable MobEffectList secondaryEffect) {
        TileEntityBeacon.applyEffects(world, pos, beaconLevel, primaryEffect, secondaryEffect, null);
    }

    private static void applyEffects(World world, BlockPosition pos, int beaconLevel, @Nullable MobEffectList primaryEffect, @Nullable MobEffectList secondaryEffect, @Nullable TileEntityBeacon blockEntity) {
        if (!world.B && primaryEffect != null) {
            double d0 = beaconLevel * 10 + 10;
            byte b0 = TileEntityBeacon.getAmplification(beaconLevel, primaryEffect, secondaryEffect);
            int j2 = TileEntityBeacon.getLevel(beaconLevel);
            List list = TileEntityBeacon.getHumansInRange(world, pos, beaconLevel, blockEntity);
            TileEntityBeacon.applyEffect(list, primaryEffect, j2, b0, true, pos);
            if (TileEntityBeacon.hasSecondaryEffect(beaconLevel, primaryEffect, secondaryEffect)) {
                TileEntityBeacon.applyEffect(list, secondaryEffect, j2, 0, false, pos);
            }
        }
    }

    public static void a(World world, BlockPosition pos, SoundEffect sound) {
        world.a((EntityHuman)null, pos, sound, SoundCategory.e, 1.0f, 1.0f);
    }

    public List<BeaconColorTracker> c() {
        return this.n == 0 ? ImmutableList.of() : this.l;
    }

    public PacketPlayOutTileEntityData f() {
        return PacketPlayOutTileEntityData.a(this);
    }

    @Override
    public NBTTagCompound ax_() {
        return this.q();
    }

    private static void a(NBTTagCompound nbt, String key, @Nullable MobEffectList effect) {
        MinecraftKey minecraftkey;
        if (effect != null && (minecraftkey = BuiltInRegistries.d.b(effect)) != null) {
            nbt.a(key, minecraftkey.toString());
        }
    }

    @Nullable
    private static MobEffectList a(NBTTagCompound nbt, String key) {
        if (nbt.b(key, 8)) {
            MinecraftKey minecraftkey = MinecraftKey.a(nbt.l(key));
            return BuiltInRegistries.d.a(minecraftkey);
        }
        return null;
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.s = TileEntityBeacon.a(nbt, j);
        this.t = TileEntityBeacon.a(nbt, k);
        this.n = nbt.h("Levels");
        if (nbt.b("CustomName", 8)) {
            this.u = MCUtil.getBaseComponentFromNbt("CustomName", nbt);
        }
        this.v = ChestLock.b(nbt);
        this.effectRange = nbt.b("Paper.Range", 6) ? nbt.k("Paper.Range") : -1.0;
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        super.b(nbt);
        TileEntityBeacon.a(nbt, j, this.s);
        TileEntityBeacon.a(nbt, k, this.t);
        nbt.a("Levels", this.n);
        if (this.u != null) {
            nbt.a("CustomName", IChatBaseComponent.ChatSerializer.a(this.u));
        }
        this.v.a(nbt);
        nbt.a("Paper.Range", this.effectRange);
    }

    public void a(@Nullable IChatBaseComponent customName) {
        this.u = customName;
    }

    @Override
    @Nullable
    public IChatBaseComponent af() {
        return this.u;
    }

    @Override
    @Nullable
    public Container createMenu(int syncId, PlayerInventory playerInventory, EntityHuman player) {
        return TileEntityContainer.canUnlock(player, this.v, this.Q_(), this) ? new ContainerBeacon(syncId, playerInventory, this.w, ContainerAccess.a(this.o, this.aB_())) : null;
    }

    @Override
    public IChatBaseComponent Q_() {
        return this.ad();
    }

    @Override
    public IChatBaseComponent ad() {
        return this.u != null ? this.u : i;
    }

    @Override
    public void a(World world) {
        super.a(world);
        this.r = world.J_() - 1;
    }

    public static class BeaconColorTracker {
        final float[] a;
        private int b;

        public BeaconColorTracker(float[] color) {
            this.a = color;
            this.b = 1;
        }

        protected void a() {
            ++this.b;
        }

        public float[] b() {
            return this.a;
        }

        public int c() {
            return this.b;
        }
    }
}

